/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.SetMultimap;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.execution.DynamicFilterConfig;
import io.prestosql.execution.ExplainAnalyzeContext;
import io.prestosql.execution.Lifespan;
import io.prestosql.execution.StageId;
import io.prestosql.execution.TaskId;
import io.prestosql.execution.TaskManagerConfig;
import io.prestosql.execution.buffer.OutputBuffer;
import io.prestosql.execution.buffer.PagesSerdeFactory;
import io.prestosql.index.IndexManager;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.TableHandle;
import io.prestosql.operator.AggregationOperator;
import io.prestosql.operator.AssignUniqueIdOperator;
import io.prestosql.operator.DeleteOperator;
import io.prestosql.operator.DevNullOperator;
import io.prestosql.operator.DistinctLimitOperator;
import io.prestosql.operator.DriverFactory;
import io.prestosql.operator.DynamicFilterSourceOperator;
import io.prestosql.operator.EnforceSingleRowOperator;
import io.prestosql.operator.ExchangeClientSupplier;
import io.prestosql.operator.ExchangeOperator;
import io.prestosql.operator.ExplainAnalyzeOperator;
import io.prestosql.operator.FilterAndProjectOperator;
import io.prestosql.operator.GroupIdOperator;
import io.prestosql.operator.HashAggregationOperator;
import io.prestosql.operator.HashBuilderOperator;
import io.prestosql.operator.HashSemiJoinOperator;
import io.prestosql.operator.JoinBridgeManager;
import io.prestosql.operator.JoinOperatorFactory;
import io.prestosql.operator.JoinUtils;
import io.prestosql.operator.LimitOperator;
import io.prestosql.operator.LocalPlannerAware;
import io.prestosql.operator.LookupJoinOperators;
import io.prestosql.operator.LookupOuterOperator;
import io.prestosql.operator.LookupSourceFactory;
import io.prestosql.operator.MarkDistinctOperator;
import io.prestosql.operator.MergeOperator;
import io.prestosql.operator.NestedLoopBuildOperator;
import io.prestosql.operator.NestedLoopJoinBridge;
import io.prestosql.operator.NestedLoopJoinOperator;
import io.prestosql.operator.NestedLoopJoinPagesSupplier;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.OrderByOperator;
import io.prestosql.operator.OutputFactory;
import io.prestosql.operator.PagesIndex;
import io.prestosql.operator.PagesSpatialIndexFactory;
import io.prestosql.operator.PartitionFunction;
import io.prestosql.operator.PartitionedLookupSourceFactory;
import io.prestosql.operator.PartitionedOutputOperator;
import io.prestosql.operator.PipelineExecutionStrategy;
import io.prestosql.operator.RowNumberOperator;
import io.prestosql.operator.ScanFilterAndProjectOperator;
import io.prestosql.operator.SetBuilderOperator;
import io.prestosql.operator.SpatialIndexBuilderOperator;
import io.prestosql.operator.SpatialJoinOperator;
import io.prestosql.operator.StageExecutionDescriptor;
import io.prestosql.operator.StatisticsWriterOperator;
import io.prestosql.operator.StreamingAggregationOperator;
import io.prestosql.operator.TableDeleteOperator;
import io.prestosql.operator.TableFinishOperator;
import io.prestosql.operator.TableScanOperator;
import io.prestosql.operator.TableWriterOperator;
import io.prestosql.operator.TaskContext;
import io.prestosql.operator.TaskOutputOperator;
import io.prestosql.operator.TopNOperator;
import io.prestosql.operator.TopNRowNumberOperator;
import io.prestosql.operator.ValuesOperator;
import io.prestosql.operator.WindowFunctionDefinition;
import io.prestosql.operator.WindowOperator;
import io.prestosql.operator.WorkProcessorPipelineSourceOperator;
import io.prestosql.operator.aggregation.AccumulatorFactory;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.LambdaProvider;
import io.prestosql.operator.exchange.LocalExchange;
import io.prestosql.operator.exchange.LocalExchangeSinkOperator;
import io.prestosql.operator.exchange.LocalExchangeSourceOperator;
import io.prestosql.operator.exchange.LocalMergeSourceOperator;
import io.prestosql.operator.exchange.PageChannelSelector;
import io.prestosql.operator.index.DynamicTupleFilterFactory;
import io.prestosql.operator.index.FieldSetFilteringRecordSet;
import io.prestosql.operator.index.IndexBuildDriverFactoryProvider;
import io.prestosql.operator.index.IndexJoinLookupStats;
import io.prestosql.operator.index.IndexLookupSourceFactory;
import io.prestosql.operator.index.IndexSourceOperator;
import io.prestosql.operator.project.CursorProcessor;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.operator.unnest.UnnestOperator;
import io.prestosql.operator.window.FrameInfo;
import io.prestosql.operator.window.WindowFunctionSupplier;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorIndex;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.DynamicFilter;
import io.prestosql.spi.connector.RecordSet;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.spiller.PartitioningSpillerFactory;
import io.prestosql.spiller.SingleStreamSpillerFactory;
import io.prestosql.spiller.SpillerFactory;
import io.prestosql.split.MappedRecordSet;
import io.prestosql.split.PageSinkManager;
import io.prestosql.split.PageSourceProvider;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.gen.ExpressionCompiler;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.sql.gen.JoinFilterFunctionCompiler;
import io.prestosql.sql.gen.LambdaBytecodeGenerator;
import io.prestosql.sql.gen.OrderingCompiler;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.planner.ExpressionExtractor;
import io.prestosql.sql.planner.ExpressionInterpreter;
import io.prestosql.sql.planner.ExpressionNodeInliner;
import io.prestosql.sql.planner.LocalDynamicFilterConsumer;
import io.prestosql.sql.planner.LocalDynamicFiltersCollector;
import io.prestosql.sql.planner.NodePartitioningManager;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.PartitioningHandle;
import io.prestosql.sql.planner.PartitioningScheme;
import io.prestosql.sql.planner.SortExpressionContext;
import io.prestosql.sql.planner.SortExpressionExtractor;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SystemPartitioningHandle;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.optimizations.IndexJoinOptimizer;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.AssignUniqueId;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.DeleteNode;
import io.prestosql.sql.planner.plan.DistinctLimitNode;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.EnforceSingleRowNode;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.ExplainAnalyzeNode;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.GroupIdNode;
import io.prestosql.sql.planner.plan.IndexJoinNode;
import io.prestosql.sql.planner.plan.IndexSourceNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.MarkDistinctNode;
import io.prestosql.sql.planner.plan.OutputNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.RemoteSourceNode;
import io.prestosql.sql.planner.plan.RowNumberNode;
import io.prestosql.sql.planner.plan.SampleNode;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import io.prestosql.sql.planner.plan.SortNode;
import io.prestosql.sql.planner.plan.SpatialJoinNode;
import io.prestosql.sql.planner.plan.StatisticAggregationsDescriptor;
import io.prestosql.sql.planner.plan.StatisticsWriterNode;
import io.prestosql.sql.planner.plan.TableDeleteNode;
import io.prestosql.sql.planner.plan.TableFinishNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.plan.TableWriterNode;
import io.prestosql.sql.planner.plan.TopNNode;
import io.prestosql.sql.planner.plan.TopNRowNumberNode;
import io.prestosql.sql.planner.plan.UnionNode;
import io.prestosql.sql.planner.plan.UnnestNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.relational.LambdaDefinitionExpression;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.SqlToRowExpressionTranslator;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.LambdaArgumentDeclaration;
import io.prestosql.sql.tree.LambdaExpression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.type.FunctionType;
import io.prestosql.util.Reflection;
import io.prestosql.util.SpatialJoinUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;

public class LocalExecutionPlanner {
    private static final Logger log = Logger.get(LocalExecutionPlanner.class);
    private final Metadata metadata;
    private final TypeAnalyzer typeAnalyzer;
    private final Optional<ExplainAnalyzeContext> explainAnalyzeContext;
    private final PageSourceProvider pageSourceProvider;
    private final IndexManager indexManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final PageSinkManager pageSinkManager;
    private final ExchangeClientSupplier exchangeClientSupplier;
    private final ExpressionCompiler expressionCompiler;
    private final PageFunctionCompiler pageFunctionCompiler;
    private final JoinFilterFunctionCompiler joinFilterFunctionCompiler;
    private final DataSize maxIndexMemorySize;
    private final IndexJoinLookupStats indexJoinLookupStats;
    private final DataSize maxPartialAggregationMemorySize;
    private final DataSize maxPagePartitioningBufferSize;
    private final DataSize maxLocalExchangeBufferSize;
    private final SpillerFactory spillerFactory;
    private final SingleStreamSpillerFactory singleStreamSpillerFactory;
    private final PartitioningSpillerFactory partitioningSpillerFactory;
    private final PagesIndex.Factory pagesIndexFactory;
    private final JoinCompiler joinCompiler;
    private final LookupJoinOperators lookupJoinOperators;
    private final OrderingCompiler orderingCompiler;
    private final DynamicFilterConfig dynamicFilterConfig;

    @Inject
    public LocalExecutionPlanner(Metadata metadata, TypeAnalyzer typeAnalyzer, Optional<ExplainAnalyzeContext> explainAnalyzeContext, PageSourceProvider pageSourceProvider, IndexManager indexManager, NodePartitioningManager nodePartitioningManager, PageSinkManager pageSinkManager, ExchangeClientSupplier exchangeClientSupplier, ExpressionCompiler expressionCompiler, PageFunctionCompiler pageFunctionCompiler, JoinFilterFunctionCompiler joinFilterFunctionCompiler, IndexJoinLookupStats indexJoinLookupStats, TaskManagerConfig taskManagerConfig, SpillerFactory spillerFactory, SingleStreamSpillerFactory singleStreamSpillerFactory, PartitioningSpillerFactory partitioningSpillerFactory, PagesIndex.Factory pagesIndexFactory, JoinCompiler joinCompiler, LookupJoinOperators lookupJoinOperators, OrderingCompiler orderingCompiler, DynamicFilterConfig dynamicFilterConfig) {
        this.explainAnalyzeContext = Objects.requireNonNull(explainAnalyzeContext, "explainAnalyzeContext is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.indexManager = Objects.requireNonNull(indexManager, "indexManager is null");
        this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
        this.exchangeClientSupplier = exchangeClientSupplier;
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        this.pageSinkManager = Objects.requireNonNull(pageSinkManager, "pageSinkManager is null");
        this.expressionCompiler = Objects.requireNonNull(expressionCompiler, "compiler is null");
        this.pageFunctionCompiler = Objects.requireNonNull(pageFunctionCompiler, "pageFunctionCompiler is null");
        this.joinFilterFunctionCompiler = Objects.requireNonNull(joinFilterFunctionCompiler, "compiler is null");
        this.indexJoinLookupStats = Objects.requireNonNull(indexJoinLookupStats, "indexJoinLookupStats is null");
        this.maxIndexMemorySize = Objects.requireNonNull(taskManagerConfig, "taskManagerConfig is null").getMaxIndexMemoryUsage();
        this.spillerFactory = Objects.requireNonNull(spillerFactory, "spillerFactory is null");
        this.singleStreamSpillerFactory = Objects.requireNonNull(singleStreamSpillerFactory, "singleStreamSpillerFactory is null");
        this.partitioningSpillerFactory = Objects.requireNonNull(partitioningSpillerFactory, "partitioningSpillerFactory is null");
        this.maxPartialAggregationMemorySize = taskManagerConfig.getMaxPartialAggregationMemoryUsage();
        this.maxPagePartitioningBufferSize = taskManagerConfig.getMaxPagePartitioningBufferSize();
        this.maxLocalExchangeBufferSize = taskManagerConfig.getMaxLocalExchangeBufferSize();
        this.pagesIndexFactory = Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
        this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        this.lookupJoinOperators = Objects.requireNonNull(lookupJoinOperators, "lookupJoinOperators is null");
        this.orderingCompiler = Objects.requireNonNull(orderingCompiler, "orderingCompiler is null");
        this.dynamicFilterConfig = Objects.requireNonNull(dynamicFilterConfig, "dynamicFilterConfig is null");
    }

    public LocalExecutionPlan plan(TaskContext taskContext, PlanNode plan, TypeProvider types, PartitioningScheme partitioningScheme, StageExecutionDescriptor stageExecutionDescriptor, List<PlanNodeId> partitionedSourceOrder, OutputBuffer outputBuffer) {
        Object partitionChannelTypes;
        Object partitionConstants;
        Object partitionChannels;
        List<Symbol> outputLayout = partitioningScheme.getOutputLayout();
        if (partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION)) {
            return this.plan(taskContext, stageExecutionDescriptor, plan, outputLayout, types, partitionedSourceOrder, new TaskOutputOperator.TaskOutputFactory(outputBuffer));
        }
        if (partitioningScheme.getHashColumn().isPresent()) {
            partitionChannels = ImmutableList.of((Object)outputLayout.indexOf(partitioningScheme.getHashColumn().get()));
            partitionConstants = ImmutableList.of(Optional.empty());
            partitionChannelTypes = ImmutableList.of((Object)BigintType.BIGINT);
        } else {
            partitionChannels = (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> {
                if (argument.isConstant()) {
                    return -1;
                }
                return outputLayout.indexOf(argument.getColumn());
            }).collect(ImmutableList.toImmutableList());
            partitionConstants = (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> {
                if (argument.isConstant()) {
                    return Optional.of(argument.getConstant());
                }
                return Optional.empty();
            }).collect(ImmutableList.toImmutableList());
            partitionChannelTypes = (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> {
                if (argument.isConstant()) {
                    return argument.getConstant().getType();
                }
                return types.get(argument.getColumn());
            }).collect(ImmutableList.toImmutableList());
        }
        PartitionFunction partitionFunction = this.nodePartitioningManager.getPartitionFunction(taskContext.getSession(), partitioningScheme, (List<Type>)partitionChannelTypes);
        OptionalInt nullChannel = OptionalInt.empty();
        Set<Symbol> partitioningColumns = partitioningScheme.getPartitioning().getColumns();
        Preconditions.checkArgument((!partitioningScheme.isReplicateNullsAndAny() || partitioningColumns.size() <= 1 ? 1 : 0) != 0);
        if (partitioningScheme.isReplicateNullsAndAny() && partitioningColumns.size() == 1) {
            nullChannel = OptionalInt.of(outputLayout.indexOf(Iterables.getOnlyElement(partitioningColumns)));
        }
        return this.plan(taskContext, stageExecutionDescriptor, plan, outputLayout, types, partitionedSourceOrder, new PartitionedOutputOperator.PartitionedOutputFactory(partitionFunction, (List<Integer>)partitionChannels, (List<Optional<NullableValue>>)partitionConstants, partitioningScheme.isReplicateNullsAndAny(), nullChannel, outputBuffer, this.maxPagePartitioningBufferSize));
    }

    public LocalExecutionPlan plan(TaskContext taskContext, StageExecutionDescriptor stageExecutionDescriptor, PlanNode plan, List<Symbol> outputLayout, TypeProvider types, List<PlanNodeId> partitionedSourceOrder, OutputFactory outputOperatorFactory) {
        Session session = taskContext.getSession();
        LocalExecutionPlanContext context = new LocalExecutionPlanContext(taskContext, types);
        PhysicalOperation physicalOperation = plan.accept(new Visitor(session, stageExecutionDescriptor), context);
        Function<Page, Page> pagePreprocessor = LocalExecutionPlanner.enforceLayoutProcessor(outputLayout, physicalOperation.getLayout());
        List outputTypes = (List)outputLayout.stream().map(types::get).collect(ImmutableList.toImmutableList());
        context.addDriverFactory(context.isInputDriver(), true, (List<OperatorFactory>)ImmutableList.builder().addAll(physicalOperation.getOperatorFactories()).add((Object)outputOperatorFactory.createOutputOperator(context.getNextOperatorId(), plan.getId(), outputTypes, pagePreprocessor, new PagesSerdeFactory(this.metadata.getBlockEncodingSerde(), SystemSessionProperties.isExchangeCompressionEnabled(session)))).build(), context.getDriverInstanceCount(), physicalOperation.getPipelineExecutionStrategy());
        LocalExecutionPlanner.addLookupOuterDrivers(context);
        context.getDriverFactories().stream().map(DriverFactory::getOperatorFactories).flatMap(Collection::stream).filter(LocalPlannerAware.class::isInstance).map(LocalPlannerAware.class::cast).forEach(LocalPlannerAware::localPlannerComplete);
        return new LocalExecutionPlan(context.getDriverFactories(), partitionedSourceOrder, stageExecutionDescriptor);
    }

    private static void addLookupOuterDrivers(LocalExecutionPlanContext context) {
        for (DriverFactory factory : context.getDriverFactories()) {
            List<OperatorFactory> operatorFactories = factory.getOperatorFactories();
            for (int i = 0; i < operatorFactories.size(); ++i) {
                JoinOperatorFactory lookupJoin;
                Optional<JoinOperatorFactory.OuterOperatorFactoryResult> outerOperatorFactoryResult;
                OperatorFactory operatorFactory = operatorFactories.get(i);
                if (!(operatorFactory instanceof JoinOperatorFactory) || !(outerOperatorFactoryResult = (lookupJoin = (JoinOperatorFactory)operatorFactory).createOuterOperatorFactory()).isPresent()) continue;
                ImmutableList.Builder newOperators = ImmutableList.builder();
                newOperators.add((Object)outerOperatorFactoryResult.get().getOuterOperatorFactory());
                operatorFactories.subList(i + 1, operatorFactories.size()).stream().map(OperatorFactory::duplicate).forEach(arg_0 -> ((ImmutableList.Builder)newOperators).add(arg_0));
                context.addDriverFactory(false, factory.isOutputDriver(), (List<OperatorFactory>)newOperators.build(), OptionalInt.of(1), outerOperatorFactoryResult.get().getBuildExecutionStrategy());
            }
        }
    }

    private int getDynamicFilteringMaxDistinctValuesPerDriver(Session session, boolean isReplicatedJoin) {
        if (SystemSessionProperties.isEnableLargeDynamicFilters(session)) {
            if (isReplicatedJoin) {
                return this.dynamicFilterConfig.getLargeBroadcastMaxDistinctValuesPerDriver();
            }
            return this.dynamicFilterConfig.getLargePartitionedMaxDistinctValuesPerDriver();
        }
        if (isReplicatedJoin) {
            return this.dynamicFilterConfig.getSmallBroadcastMaxDistinctValuesPerDriver();
        }
        return this.dynamicFilterConfig.getSmallPartitionedMaxDistinctValuesPerDriver();
    }

    private DataSize getDynamicFilteringMaxSizePerDriver(Session session, boolean isReplicatedJoin) {
        if (SystemSessionProperties.isEnableLargeDynamicFilters(session)) {
            if (isReplicatedJoin) {
                return this.dynamicFilterConfig.getLargeBroadcastMaxSizePerDriver();
            }
            return this.dynamicFilterConfig.getLargePartitionedMaxSizePerDriver();
        }
        if (isReplicatedJoin) {
            return this.dynamicFilterConfig.getSmallBroadcastMaxSizePerDriver();
        }
        return this.dynamicFilterConfig.getSmallPartitionedMaxSizePerDriver();
    }

    private int getDynamicFilteringRangeRowLimitPerDriver(Session session, boolean isReplicatedJoin) {
        if (SystemSessionProperties.isEnableLargeDynamicFilters(session)) {
            if (isReplicatedJoin) {
                return this.dynamicFilterConfig.getLargeBroadcastRangeRowLimitPerDriver();
            }
            return this.dynamicFilterConfig.getLargePartitionedRangeRowLimitPerDriver();
        }
        if (isReplicatedJoin) {
            return this.dynamicFilterConfig.getSmallBroadcastRangeRowLimitPerDriver();
        }
        return this.dynamicFilterConfig.getSmallPartitionedRangeRowLimitPerDriver();
    }

    private static List<Type> getTypes(List<Expression> expressions, Map<NodeRef<Expression>, Type> expressionTypes) {
        return (List)expressions.stream().map(NodeRef::of).map(expressionTypes::get).collect(ImmutableList.toImmutableList());
    }

    private static TableFinishOperator.TableFinisher createTableFinisher(Session session, TableFinishNode node, Metadata metadata) {
        TableWriterNode.WriterTarget target = node.getTarget();
        return (fragments, statistics) -> {
            if (target instanceof TableWriterNode.CreateTarget) {
                return metadata.finishCreateTable(session, ((TableWriterNode.CreateTarget)target).getHandle(), fragments, statistics);
            }
            if (target instanceof TableWriterNode.InsertTarget) {
                return metadata.finishInsert(session, ((TableWriterNode.InsertTarget)target).getHandle(), fragments, statistics);
            }
            if (target instanceof TableWriterNode.RefreshMaterializedViewTarget) {
                TableWriterNode.RefreshMaterializedViewTarget refreshTarget = (TableWriterNode.RefreshMaterializedViewTarget)target;
                return metadata.finishRefreshMaterializedView(session, refreshTarget.getHandle(), fragments, statistics, refreshTarget.getSourceTableHandles());
            }
            if (target instanceof TableWriterNode.DeleteTarget) {
                metadata.finishDelete(session, ((TableWriterNode.DeleteTarget)target).getHandle(), fragments);
                return Optional.empty();
            }
            throw new AssertionError((Object)("Unhandled target type: " + target.getClass().getName()));
        };
    }

    private static Function<Page, Page> enforceLayoutProcessor(List<Symbol> expectedLayout, Map<Symbol, Integer> inputLayout) {
        int[] channels = expectedLayout.stream().peek(symbol -> Preconditions.checkArgument((boolean)inputLayout.containsKey(symbol), (String)"channel not found for symbol: %s", (Object)symbol)).mapToInt(inputLayout::get).toArray();
        if (Arrays.equals(channels, IntStream.range(0, inputLayout.size()).toArray())) {
            return Function.identity();
        }
        return new PageChannelSelector(channels);
    }

    private static List<Integer> getChannelsForSymbols(List<Symbol> symbols, Map<Symbol, Integer> layout) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Symbol symbol : symbols) {
            builder.add((Object)layout.get(symbol));
        }
        return builder.build();
    }

    private static Function<Symbol, Integer> channelGetter(PhysicalOperation source) {
        return input -> {
            Preconditions.checkArgument((boolean)source.getLayout().containsKey(input));
            return source.getLayout().get(input);
        };
    }

    private static Set<DynamicFilterId> getConsumedDynamicFilterIds(PlanNode node) {
        return (Set)ExpressionExtractor.extractExpressions(node).stream().flatMap(expression -> DynamicFilters.extractDynamicFilters(expression).getDynamicConjuncts().stream()).map(DynamicFilters.Descriptor::getId).collect(ImmutableSet.toImmutableSet());
    }

    private static class DriverFactoryParameters {
        private final LocalExecutionPlanContext subContext;
        private final PhysicalOperation source;

        public DriverFactoryParameters(LocalExecutionPlanContext subContext, PhysicalOperation source) {
            this.subContext = subContext;
            this.source = source;
        }

        public LocalExecutionPlanContext getSubContext() {
            return this.subContext;
        }

        public PhysicalOperation getSource() {
            return this.source;
        }
    }

    private static class PhysicalOperation {
        private final List<OperatorFactory> operatorFactories;
        private final Map<Symbol, Integer> layout;
        private final List<Type> types;
        private final PipelineExecutionStrategy pipelineExecutionStrategy;

        public PhysicalOperation(OperatorFactory operatorFactory, Map<Symbol, Integer> layout, LocalExecutionPlanContext context, PipelineExecutionStrategy pipelineExecutionStrategy) {
            this(operatorFactory, layout, context, Optional.empty(), pipelineExecutionStrategy);
        }

        public PhysicalOperation(OperatorFactory operatorFactory, Map<Symbol, Integer> layout, LocalExecutionPlanContext context, PhysicalOperation source) {
            this(operatorFactory, layout, context, Optional.of(Objects.requireNonNull(source, "source is null")), source.getPipelineExecutionStrategy());
        }

        private PhysicalOperation(OperatorFactory operatorFactory, Map<Symbol, Integer> layout, LocalExecutionPlanContext context, Optional<PhysicalOperation> source, PipelineExecutionStrategy pipelineExecutionStrategy) {
            Objects.requireNonNull(operatorFactory, "operatorFactory is null");
            Objects.requireNonNull(layout, "layout is null");
            Objects.requireNonNull(context, "context is null");
            Objects.requireNonNull(source, "source is null");
            Objects.requireNonNull(pipelineExecutionStrategy, "pipelineExecutionStrategy is null");
            this.operatorFactories = ImmutableList.builder().addAll((Iterable)source.map(PhysicalOperation::getOperatorFactories).orElse((List)ImmutableList.of())).add((Object)operatorFactory).build();
            this.layout = ImmutableMap.copyOf(layout);
            this.types = PhysicalOperation.toTypes(layout, context);
            this.pipelineExecutionStrategy = pipelineExecutionStrategy;
        }

        private static List<Type> toTypes(Map<Symbol, Integer> layout, LocalExecutionPlanContext context) {
            int channelCount = layout.values().stream().mapToInt(Integer::intValue).max().orElse(-1) + 1;
            Preconditions.checkArgument((layout.size() == channelCount && ImmutableSet.copyOf(layout.values()).containsAll((Collection)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(channelCount)), (DiscreteDomain)DiscreteDomain.integers())) ? 1 : 0) != 0, (String)"Layout does not have a symbol for every output channel: %s", layout);
            ImmutableBiMap channelLayout = ImmutableBiMap.copyOf(layout).inverse();
            return (List)IntStream.range(0, channelCount).mapToObj(((Map)channelLayout)::get).map(context.getTypes()::get).collect(ImmutableList.toImmutableList());
        }

        public int symbolToChannel(Symbol input) {
            Preconditions.checkArgument((boolean)this.layout.containsKey(input));
            return this.layout.get(input);
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public Map<Symbol, Integer> getLayout() {
            return this.layout;
        }

        private List<OperatorFactory> getOperatorFactories() {
            return this.operatorFactories;
        }

        public PipelineExecutionStrategy getPipelineExecutionStrategy() {
            return this.pipelineExecutionStrategy;
        }
    }

    private class Visitor
    extends PlanVisitor<PhysicalOperation, LocalExecutionPlanContext> {
        private final Session session;
        private final StageExecutionDescriptor stageExecutionDescriptor;

        private Visitor(Session session, StageExecutionDescriptor stageExecutionDescriptor) {
            this.session = session;
            this.stageExecutionDescriptor = stageExecutionDescriptor;
        }

        @Override
        public PhysicalOperation visitRemoteSource(RemoteSourceNode node, LocalExecutionPlanContext context) {
            if (node.getOrderingScheme().isPresent()) {
                return this.createMergeSource(node, context);
            }
            return this.createRemoteSource(node, context);
        }

        private PhysicalOperation createMergeSource(RemoteSourceNode node, LocalExecutionPlanContext context) {
            Preconditions.checkArgument((boolean)node.getOrderingScheme().isPresent(), (Object)"orderingScheme is absent");
            context.setDriverInstanceCount(1);
            OrderingScheme orderingScheme = node.getOrderingScheme().get();
            ImmutableMap<Symbol, Integer> layout = this.makeLayout(node);
            List<Integer> sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderingScheme.getOrderBy(), layout);
            List<SortOrder> sortOrder = orderingScheme.getOrderingList();
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            ImmutableList outputChannels = (ImmutableList)IntStream.range(0, types.size()).boxed().collect(ImmutableList.toImmutableList());
            MergeOperator.MergeOperatorFactory operatorFactory = new MergeOperator.MergeOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.exchangeClientSupplier, new PagesSerdeFactory(LocalExecutionPlanner.this.metadata.getBlockEncodingSerde(), SystemSessionProperties.isExchangeCompressionEnabled(this.session)), LocalExecutionPlanner.this.orderingCompiler, types, (List<Integer>)outputChannels, sortChannels, sortOrder);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        private PhysicalOperation createRemoteSource(RemoteSourceNode node, LocalExecutionPlanContext context) {
            if (context.getDriverInstanceCount().isEmpty()) {
                context.setDriverInstanceCount(SystemSessionProperties.getTaskConcurrency(this.session));
            }
            ExchangeOperator.ExchangeOperatorFactory operatorFactory = new ExchangeOperator.ExchangeOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.exchangeClientSupplier, new PagesSerdeFactory(LocalExecutionPlanner.this.metadata.getBlockEncodingSerde(), SystemSessionProperties.isExchangeCompressionEnabled(this.session)));
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        @Override
        public PhysicalOperation visitExplainAnalyze(ExplainAnalyzeNode node, LocalExecutionPlanContext context) {
            ExplainAnalyzeContext analyzeContext = LocalExecutionPlanner.this.explainAnalyzeContext.orElseThrow(() -> new IllegalStateException("ExplainAnalyze can only run on coordinator"));
            PhysicalOperation source = node.getSource().accept(this, context);
            ExplainAnalyzeOperator.ExplainAnalyzeOperatorFactory operatorFactory = new ExplainAnalyzeOperator.ExplainAnalyzeOperatorFactory(context.getNextOperatorId(), node.getId(), analyzeContext.getQueryPerformanceFetcher(), LocalExecutionPlanner.this.metadata, node.isVerbose());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, source);
        }

        @Override
        public PhysicalOperation visitOutput(OutputNode node, LocalExecutionPlanContext context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public PhysicalOperation visitRowNumber(RowNumberNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            List<Integer> partitionChannels = LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout());
            List partitionTypes = (List)partitionChannels.stream().map(channel -> source.getTypes().get((int)channel)).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(source.getLayout());
            int channel2 = source.getTypes().size();
            outputMappings.put((Object)node.getRowNumberSymbol(), (Object)channel2);
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), partitionChannels, partitionTypes, node.getMaxRowCountPerPartition(), hashChannel, 10000, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), context, source);
        }

        @Override
        public PhysicalOperation visitTopNRowNumber(TopNRowNumberNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            List<Integer> partitionChannels = LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout());
            List partitionTypes = (List)partitionChannels.stream().map(channel -> source.getTypes().get((int)channel)).collect(ImmutableList.toImmutableList());
            List<Symbol> orderBySymbols = node.getOrderingScheme().getOrderBy();
            List<Integer> sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderBySymbols, source.getLayout());
            List sortOrder = (List)orderBySymbols.stream().map(symbol -> node.getOrderingScheme().getOrdering((Symbol)symbol)).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(source.getLayout());
            if (!node.isPartial() || !partitionChannels.isEmpty()) {
                int channel2 = source.getTypes().size();
                outputMappings.put((Object)node.getRowNumberSymbol(), (Object)channel2);
            }
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            TopNRowNumberOperator.TopNRowNumberOperatorFactory operatorFactory = new TopNRowNumberOperator.TopNRowNumberOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), partitionChannels, partitionTypes, sortChannels, sortOrder, node.getMaxRowCountPerPartition(), node.isPartial(), hashChannel, 1000, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, source);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PhysicalOperation visitWindow(WindowNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            ImmutableList partitionChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout()));
            ImmutableList preGroupedChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols((List<Symbol>)ImmutableList.copyOf(node.getPrePartitionedInputs()), source.getLayout()));
            Object sortChannels = ImmutableList.of();
            Object sortOrder = ImmutableList.of();
            if (node.getOrderingScheme().isPresent()) {
                OrderingScheme orderingScheme = node.getOrderingScheme().get();
                sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderingScheme.getOrderBy(), source.getLayout());
                sortOrder = orderingScheme.getOrderingList();
            }
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableList.Builder windowFunctionsBuilder = ImmutableList.builder();
            ImmutableList.Builder windowFunctionOutputSymbolsBuilder = ImmutableList.builder();
            for (Map.Entry<Symbol, WindowNode.Function> entry : node.getWindowFunctions().entrySet()) {
                void var15_17;
                Optional<Integer> frameStartChannel = Optional.empty();
                Optional optional = Optional.empty();
                WindowNode.Frame frame = entry.getValue().getFrame();
                if (frame.getStartValue().isPresent()) {
                    frameStartChannel = Optional.of(source.getLayout().get(frame.getStartValue().get()));
                }
                if (frame.getEndValue().isPresent()) {
                    Optional<Integer> optional2 = Optional.of(source.getLayout().get(frame.getEndValue().get()));
                }
                FrameInfo frameInfo = new FrameInfo(frame.getType(), frame.getStartType(), frameStartChannel, frame.getEndType(), (Optional<Integer>)var15_17);
                WindowNode.Function function = entry.getValue();
                ResolvedFunction resolvedFunction = entry.getValue().getResolvedFunction();
                ImmutableList.Builder arguments = ImmutableList.builder();
                for (Expression argument : function.getArguments()) {
                    if (argument instanceof LambdaExpression) continue;
                    Symbol argumentSymbol = Symbol.from(argument);
                    arguments.add((Object)source.getLayout().get(argumentSymbol));
                }
                Symbol symbol = entry.getKey();
                WindowFunctionSupplier windowFunctionSupplier = LocalExecutionPlanner.this.metadata.getWindowFunctionImplementation(resolvedFunction);
                Type type = resolvedFunction.getSignature().getReturnType();
                List lambdaExpressions = (List)function.getArguments().stream().filter(LambdaExpression.class::isInstance).map(LambdaExpression.class::cast).collect(ImmutableList.toImmutableList());
                List functionTypes = (List)resolvedFunction.getSignature().getArgumentTypes().stream().filter(FunctionType.class::isInstance).map(FunctionType.class::cast).collect(ImmutableList.toImmutableList());
                List<LambdaProvider> lambdaProviders = this.makeLambdaProviders(lambdaExpressions, windowFunctionSupplier.getLambdaInterfaces(), functionTypes);
                windowFunctionsBuilder.add((Object)WindowFunctionDefinition.window(windowFunctionSupplier, type, frameInfo, function.isIgnoreNulls(), lambdaProviders, (List<Integer>)arguments.build()));
                windowFunctionOutputSymbolsBuilder.add((Object)symbol);
            }
            ImmutableList windowFunctionOutputSymbols = windowFunctionOutputSymbolsBuilder.build();
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            for (Symbol symbol : node.getSource().getOutputSymbols()) {
                outputMappings.put((Object)symbol, (Object)source.getLayout().get(symbol));
            }
            int channel = source.getTypes().size();
            for (Symbol symbol : windowFunctionOutputSymbols) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            WindowOperator.WindowOperatorFactory windowOperatorFactory = new WindowOperator.WindowOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), (List<WindowFunctionDefinition>)windowFunctionsBuilder.build(), (List<Integer>)partitionChannels, (List<Integer>)preGroupedChannels, (List<Integer>)sortChannels, (List<SortOrder>)sortOrder, node.getPreSortedOrderPrefix(), 10000, LocalExecutionPlanner.this.pagesIndexFactory, SystemSessionProperties.isSpillEnabled(this.session) && SystemSessionProperties.isSpillWindowOperator(this.session), LocalExecutionPlanner.this.spillerFactory, LocalExecutionPlanner.this.orderingCompiler);
            return new PhysicalOperation((OperatorFactory)windowOperatorFactory, (Map<Symbol, Integer>)outputMappings.build(), context, source);
        }

        @Override
        public PhysicalOperation visitTopN(TopNNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> orderBySymbols = node.getOrderingScheme().getOrderBy();
            ArrayList<Integer> sortChannels = new ArrayList<Integer>();
            ArrayList<SortOrder> sortOrders = new ArrayList<SortOrder>();
            for (Symbol symbol : orderBySymbols) {
                sortChannels.add(source.getLayout().get(symbol));
                sortOrders.add(node.getOrderingScheme().getOrdering(symbol));
            }
            OperatorFactory operator = TopNOperator.createOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (int)node.getCount(), sortChannels, sortOrders);
            return new PhysicalOperation(operator, source.getLayout(), context, source);
        }

        @Override
        public PhysicalOperation visitSort(SortNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> orderBySymbols = node.getOrderingScheme().getOrderBy();
            List<Integer> orderByChannels = LocalExecutionPlanner.getChannelsForSymbols(orderBySymbols, source.getLayout());
            ImmutableList.Builder sortOrder = ImmutableList.builder();
            for (Symbol symbol : orderBySymbols) {
                sortOrder.add((Object)node.getOrderingScheme().getOrdering(symbol));
            }
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            boolean spillEnabled = SystemSessionProperties.isSpillEnabled(context.getSession()) && SystemSessionProperties.isSpillOrderBy(context.getSession());
            OrderByOperator.OrderByOperatorFactory operator = new OrderByOperator.OrderByOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), 10000, orderByChannels, (List<SortOrder>)sortOrder.build(), LocalExecutionPlanner.this.pagesIndexFactory, spillEnabled, Optional.of(LocalExecutionPlanner.this.spillerFactory), LocalExecutionPlanner.this.orderingCompiler);
            return new PhysicalOperation((OperatorFactory)operator, source.getLayout(), context, source);
        }

        @Override
        public PhysicalOperation visitLimit(LimitNode node, LocalExecutionPlanContext context) {
            Preconditions.checkState((boolean)node.getTiesResolvingScheme().isEmpty(), (Object)"Limit with ties not supported");
            PhysicalOperation source = node.getSource().accept(this, context);
            LimitOperator.LimitOperatorFactory operatorFactory = new LimitOperator.LimitOperatorFactory(context.getNextOperatorId(), node.getId(), node.getCount());
            return new PhysicalOperation((OperatorFactory)operatorFactory, source.getLayout(), context, source);
        }

        @Override
        public PhysicalOperation visitDistinctLimit(DistinctLimitNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            List<Integer> distinctChannels = LocalExecutionPlanner.getChannelsForSymbols(node.getDistinctSymbols(), source.getLayout());
            DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), distinctChannels, node.getLimit(), hashChannel, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, source);
        }

        @Override
        public PhysicalOperation visitGroupId(GroupIdNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            HashMap<Symbol, Integer> newLayout = new HashMap<Symbol, Integer>();
            ImmutableList.Builder outputTypes = ImmutableList.builder();
            int outputChannel = 0;
            for (Object output : node.getGroupingSets().stream().flatMap(Collection::stream).collect(Collectors.toSet())) {
                newLayout.put((Symbol)output, outputChannel++);
                outputTypes.add((Object)source.getTypes().get(source.getLayout().get(node.getGroupingColumns().get(output))));
            }
            HashMap<Symbol, Integer> argumentMappings = new HashMap<Symbol, Integer>();
            for (Symbol symbol : node.getAggregationArguments()) {
                int n = source.getLayout().get(symbol);
                newLayout.put(symbol, outputChannel++);
                outputTypes.add((Object)source.getTypes().get(n));
                argumentMappings.put(symbol, n);
            }
            ImmutableList.Builder mappings = ImmutableList.builder();
            for (List<Symbol> list : node.getGroupingSets()) {
                ImmutableMap.Builder setMapping = ImmutableMap.builder();
                for (Symbol output : list) {
                    setMapping.put((Object)((Integer)newLayout.get(output)), (Object)source.getLayout().get(node.getGroupingColumns().get(output)));
                }
                for (Symbol output : argumentMappings.keySet()) {
                    setMapping.put((Object)((Integer)newLayout.get(output)), (Object)((Integer)argumentMappings.get(output)));
                }
                mappings.add((Object)setMapping.build());
            }
            newLayout.put(node.getGroupIdSymbol(), outputChannel);
            outputTypes.add((Object)BigintType.BIGINT);
            GroupIdOperator.GroupIdOperatorFactory groupIdOperatorFactory = new GroupIdOperator.GroupIdOperatorFactory(context.getNextOperatorId(), node.getId(), (List<? extends Type>)outputTypes.build(), (List<Map<Integer, Integer>>)mappings.build());
            return new PhysicalOperation((OperatorFactory)groupIdOperatorFactory, newLayout, context, source);
        }

        @Override
        public PhysicalOperation visitAggregation(AggregationNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            if (node.getGroupingKeys().isEmpty()) {
                return this.planGlobalAggregation(node, source, context);
            }
            boolean spillEnabled = SystemSessionProperties.isSpillEnabled(context.getSession());
            DataSize unspillMemoryLimit = SystemSessionProperties.getAggregationOperatorUnspillMemoryLimit(context.getSession());
            return this.planGroupByAggregation(node, source, spillEnabled, unspillMemoryLimit, context);
        }

        @Override
        public PhysicalOperation visitMarkDistinct(MarkDistinctNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Integer> channels = LocalExecutionPlanner.getChannelsForSymbols(node.getDistinctSymbols(), source.getLayout());
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            MarkDistinctOperator.MarkDistinctOperatorFactory operator = new MarkDistinctOperator.MarkDistinctOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), channels, hashChannel, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation((OperatorFactory)operator, (Map<Symbol, Integer>)this.makeLayout(node), context, source);
        }

        @Override
        public PhysicalOperation visitSample(SampleNode node, LocalExecutionPlanContext context) {
            if (node.getSampleType() == SampleNode.Type.SYSTEM) {
                return node.getSource().accept(this, context);
            }
            throw new UnsupportedOperationException("not yet implemented: " + node);
        }

        @Override
        public PhysicalOperation visitFilter(FilterNode node, LocalExecutionPlanContext context) {
            PlanNode sourceNode = node.getSource();
            if (node.getSource() instanceof TableScanNode && this.getStaticFilter(node.getPredicate()).isEmpty()) {
                return this.visitTableScan((TableScanNode)node.getSource(), node.getPredicate(), context);
            }
            Expression filterExpression = node.getPredicate();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            return this.visitScanFilterAndProject(context, node.getId(), sourceNode, Optional.of(filterExpression), Assignments.identity(outputSymbols), outputSymbols);
        }

        @Override
        public PhysicalOperation visitProject(ProjectNode node, LocalExecutionPlanContext context) {
            PlanNode sourceNode;
            Optional<Expression> filterExpression = Optional.empty();
            if (node.getSource() instanceof FilterNode) {
                FilterNode filterNode = (FilterNode)node.getSource();
                sourceNode = filterNode.getSource();
                filterExpression = Optional.of(filterNode.getPredicate());
            } else {
                sourceNode = node.getSource();
            }
            List<Symbol> outputSymbols = node.getOutputSymbols();
            return this.visitScanFilterAndProject(context, node.getId(), sourceNode, filterExpression, node.getAssignments(), outputSymbols);
        }

        private PhysicalOperation visitScanFilterAndProject(LocalExecutionPlanContext context, PlanNodeId planNodeId, PlanNode sourceNode, Optional<Expression> filterExpression, Assignments assignments, List<Symbol> outputSymbols) {
            Map<Object, Object> sourceLayout;
            TableHandle table = null;
            ArrayList<ColumnHandle> columns = null;
            PhysicalOperation source = null;
            if (sourceNode instanceof TableScanNode) {
                TableScanNode tableScanNode = (TableScanNode)sourceNode;
                table = tableScanNode.getTable();
                sourceLayout = new LinkedHashMap();
                columns = new ArrayList<ColumnHandle>();
                int channel = 0;
                for (Symbol symbol : tableScanNode.getOutputSymbols()) {
                    columns.add(tableScanNode.getAssignments().get(symbol));
                    Integer input = channel;
                    sourceLayout.put(symbol, input);
                    ++channel;
                }
            } else {
                if (sourceNode instanceof SampleNode) {
                    SampleNode sampleNode = (SampleNode)sourceNode;
                    Preconditions.checkArgument((sampleNode.getSampleType() == SampleNode.Type.SYSTEM ? 1 : 0) != 0, (String)"%s sampling is not supported", (Object)((Object)sampleNode.getSampleType()));
                    return this.visitScanFilterAndProject(context, planNodeId, sampleNode.getSource(), filterExpression, assignments, outputSymbols);
                }
                source = sourceNode.accept(this, context);
                sourceLayout = source.getLayout();
            }
            ImmutableMap.Builder outputMappingsBuilder = ImmutableMap.builder();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappingsBuilder.put((Object)symbol, (Object)i);
            }
            ImmutableMap outputMappings = outputMappingsBuilder.build();
            Optional<Object> staticFilters = filterExpression.flatMap(this::getStaticFilter);
            DynamicFilter dynamicFilter = filterExpression.filter(expression -> sourceNode instanceof TableScanNode).map(expression -> this.getDynamicFilter((TableScanNode)sourceNode, (Expression)expression, context)).orElse(DynamicFilter.EMPTY);
            ArrayList<Expression> projections = new ArrayList<Expression>();
            for (Symbol symbol : outputSymbols) {
                projections.add(assignments.get(symbol));
            }
            Map<NodeRef<Expression>, Type> expressionTypes = LocalExecutionPlanner.this.typeAnalyzer.getTypes(context.getSession(), context.getTypes(), Iterables.concat((Iterable)((Iterable)staticFilters.map(ImmutableList::of).orElse(ImmutableList.of())), assignments.getExpressions()));
            Optional<RowExpression> translatedFilter = staticFilters.map(filter -> this.toRowExpression((Expression)filter, expressionTypes, (Map<Symbol, Integer>)sourceLayout));
            List translatedProjections = (List)projections.stream().map(expression -> this.toRowExpression((Expression)expression, expressionTypes, (Map<Symbol, Integer>)sourceLayout)).collect(ImmutableList.toImmutableList());
            try {
                if (columns != null) {
                    Supplier<CursorProcessor> cursorProcessor = LocalExecutionPlanner.this.expressionCompiler.compileCursorProcessor(translatedFilter, translatedProjections, sourceNode.getId());
                    Supplier<PageProcessor> pageProcessor = LocalExecutionPlanner.this.expressionCompiler.compilePageProcessor(translatedFilter, (List<? extends RowExpression>)translatedProjections, Optional.of(context.getStageId() + "_" + planNodeId));
                    ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory operatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(context.getNextOperatorId(), planNodeId, sourceNode.getId(), LocalExecutionPlanner.this.pageSourceProvider, cursorProcessor, pageProcessor, table, columns, dynamicFilter, LocalExecutionPlanner.getTypes(projections, expressionTypes), SystemSessionProperties.getFilterAndProjectMinOutputPageSize(this.session), SystemSessionProperties.getFilterAndProjectMinOutputPageRowCount(this.session));
                    return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings, context, this.stageExecutionDescriptor.isScanGroupedExecution(sourceNode.getId()) ? PipelineExecutionStrategy.GROUPED_EXECUTION : PipelineExecutionStrategy.UNGROUPED_EXECUTION);
                }
                Supplier<PageProcessor> pageProcessor = LocalExecutionPlanner.this.expressionCompiler.compilePageProcessor(translatedFilter, (List<? extends RowExpression>)translatedProjections, Optional.of(context.getStageId() + "_" + planNodeId));
                OperatorFactory operatorFactory = FilterAndProjectOperator.createOperatorFactory(context.getNextOperatorId(), planNodeId, pageProcessor, LocalExecutionPlanner.getTypes(projections, expressionTypes), SystemSessionProperties.getFilterAndProjectMinOutputPageSize(this.session), SystemSessionProperties.getFilterAndProjectMinOutputPageRowCount(this.session));
                return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings, context, source);
            }
            catch (PrestoException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, "Compiler failed", (Throwable)e);
            }
        }

        private RowExpression toRowExpression(Expression expression, Map<NodeRef<Expression>, Type> types, Map<Symbol, Integer> layout) {
            return SqlToRowExpressionTranslator.translate(expression, types, layout, LocalExecutionPlanner.this.metadata, this.session, true);
        }

        @Override
        public PhysicalOperation visitTableScan(TableScanNode node, LocalExecutionPlanContext context) {
            return this.visitTableScan(node, (Expression)BooleanLiteral.TRUE_LITERAL, context);
        }

        private PhysicalOperation visitTableScan(TableScanNode node, Expression filterExpression, LocalExecutionPlanContext context) {
            ArrayList<ColumnHandle> columns = new ArrayList<ColumnHandle>();
            for (Symbol symbol : node.getOutputSymbols()) {
                columns.add(node.getAssignments().get(symbol));
            }
            DynamicFilter dynamicFilter = this.getDynamicFilter(node, filterExpression, context);
            TableScanOperator.TableScanOperatorFactory operatorFactory = new TableScanOperator.TableScanOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.pageSourceProvider, node.getTable(), columns, dynamicFilter);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, this.stageExecutionDescriptor.isScanGroupedExecution(node.getId()) ? PipelineExecutionStrategy.GROUPED_EXECUTION : PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        private Optional<Expression> getStaticFilter(Expression filterExpression) {
            DynamicFilters.ExtractResult extractDynamicFilterResult = DynamicFilters.extractDynamicFilters(filterExpression);
            Expression staticFilter = ExpressionUtils.combineConjuncts(LocalExecutionPlanner.this.metadata, extractDynamicFilterResult.getStaticConjuncts());
            if (staticFilter.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                return Optional.empty();
            }
            return Optional.of(staticFilter);
        }

        private DynamicFilter getDynamicFilter(TableScanNode tableScanNode, Expression filterExpression, LocalExecutionPlanContext context) {
            DynamicFilters.ExtractResult extractDynamicFilterResult = DynamicFilters.extractDynamicFilters(filterExpression);
            List<DynamicFilters.Descriptor> dynamicFilters = extractDynamicFilterResult.getDynamicConjuncts();
            if (dynamicFilters.isEmpty()) {
                return DynamicFilter.EMPTY;
            }
            log.debug("[TableScan] Dynamic filters: %s", new Object[]{dynamicFilters});
            return context.getDynamicFiltersCollector().createDynamicFilter(dynamicFilters, tableScanNode.getAssignments());
        }

        @Override
        public PhysicalOperation visitValues(ValuesNode node, LocalExecutionPlanContext context) {
            context.setDriverInstanceCount(1);
            if (node.getRows().isEmpty()) {
                ValuesOperator.ValuesOperatorFactory operatorFactory = new ValuesOperator.ValuesOperatorFactory(context.getNextOperatorId(), node.getId(), (List<Page>)ImmutableList.of());
                return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
            }
            List<Type> outputTypes = this.getSymbolTypes(node.getOutputSymbols(), context.getTypes());
            PageBuilder pageBuilder = new PageBuilder(node.getRows().size(), outputTypes);
            for (List<Expression> row : node.getRows()) {
                pageBuilder.declarePosition();
                Map<NodeRef<Expression>, Type> expressionTypes = LocalExecutionPlanner.this.typeAnalyzer.getTypes(context.getSession(), TypeProvider.empty(), (Iterable<Expression>)ImmutableList.copyOf(row));
                for (int i = 0; i < row.size(); ++i) {
                    Object result = ExpressionInterpreter.expressionInterpreter(row.get(i), LocalExecutionPlanner.this.metadata, context.getSession(), expressionTypes).evaluate();
                    TypeUtils.writeNativeValue((Type)outputTypes.get(i), (BlockBuilder)pageBuilder.getBlockBuilder(i), (Object)result);
                }
            }
            ValuesOperator.ValuesOperatorFactory operatorFactory = new ValuesOperator.ValuesOperatorFactory(context.getNextOperatorId(), node.getId(), (List<Page>)ImmutableList.of((Object)pageBuilder.build()));
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        @Override
        public PhysicalOperation visitUnnest(UnnestNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            ImmutableList.Builder replicateTypes = ImmutableList.builder();
            for (Symbol symbol : node.getReplicateSymbols()) {
                replicateTypes.add((Object)context.getTypes().get(symbol));
            }
            List unnestSymbols = (List)node.getMappings().stream().map(UnnestNode.Mapping::getInput).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder unnestTypes = ImmutableList.builder();
            for (Symbol symbol : unnestSymbols) {
                unnestTypes.add((Object)context.getTypes().get(symbol));
            }
            Optional<Symbol> ordinalitySymbol = node.getOrdinalitySymbol();
            Optional<Type> ordinalityType = ordinalitySymbol.map(context.getTypes()::get);
            ordinalityType.ifPresent(type -> Preconditions.checkState((boolean)type.equals(BigintType.BIGINT), (Object)"Type of ordinalitySymbol must always be BIGINT."));
            List<Integer> replicateChannels = LocalExecutionPlanner.getChannelsForSymbols(node.getReplicateSymbols(), source.getLayout());
            List<Integer> unnestChannels = LocalExecutionPlanner.getChannelsForSymbols(unnestSymbols, source.getLayout());
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : node.getReplicateSymbols()) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            for (UnnestNode.Mapping mapping : node.getMappings()) {
                for (Symbol unnestedSymbol : mapping.getOutputs()) {
                    outputMappings.put((Object)unnestedSymbol, (Object)channel);
                    ++channel;
                }
            }
            if (ordinalitySymbol.isPresent()) {
                outputMappings.put((Object)ordinalitySymbol.get(), (Object)channel);
                ++channel;
            }
            boolean outer = node.getJoinType() == JoinNode.Type.LEFT || node.getJoinType() == JoinNode.Type.FULL;
            UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(context.getNextOperatorId(), node.getId(), replicateChannels, (List<Type>)replicateTypes.build(), unnestChannels, (List<Type>)unnestTypes.build(), ordinalityType.isPresent(), outer);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), context, source);
        }

        private ImmutableMap<Symbol, Integer> makeLayout(PlanNode node) {
            return this.makeLayoutFromOutputSymbols(node.getOutputSymbols());
        }

        private ImmutableMap<Symbol, Integer> makeLayoutFromOutputSymbols(List<Symbol> outputSymbols) {
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : outputSymbols) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            return outputMappings.build();
        }

        @Override
        public PhysicalOperation visitIndexSource(IndexSourceNode node, LocalExecutionPlanContext context) {
            Preconditions.checkState((boolean)context.getIndexSourceContext().isPresent(), (Object)"Must be in an index source context");
            IndexSourceContext indexSourceContext = context.getIndexSourceContext().get();
            SetMultimap<Symbol, Integer> indexLookupToProbeInput = indexSourceContext.getIndexLookupToProbeInput();
            Preconditions.checkState((boolean)indexLookupToProbeInput.keySet().equals(node.getLookupSymbols()));
            ImmutableList lookupSymbolSchema = ImmutableList.copyOf(node.getLookupSymbols());
            ImmutableList.Builder remappedProbeKeyChannelsBuilder = ImmutableList.builder();
            ImmutableList.Builder overlappingFieldSetsBuilder = ImmutableList.builder();
            for (Symbol lookupSymbol : lookupSymbolSchema) {
                Set potentialProbeInputs = indexLookupToProbeInput.get((Object)lookupSymbol);
                Preconditions.checkState((!potentialProbeInputs.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one source from the probe input");
                if (potentialProbeInputs.size() > 1) {
                    overlappingFieldSetsBuilder.add((Object)((Set)potentialProbeInputs.stream().collect(ImmutableSet.toImmutableSet())));
                }
                remappedProbeKeyChannelsBuilder.add((Object)((Integer)Iterables.getFirst((Iterable)potentialProbeInputs, null)));
            }
            ImmutableList overlappingFieldSets = overlappingFieldSetsBuilder.build();
            ImmutableList remappedProbeKeyChannels = remappedProbeKeyChannelsBuilder.build();
            Function<RecordSet, RecordSet> probeKeyNormalizer = arg_0 -> this.lambda$visitIndexSource$9((List)overlappingFieldSets, (List)remappedProbeKeyChannels, arg_0);
            List lookupSchema = Lists.transform((List)lookupSymbolSchema, (com.google.common.base.Function)Functions.forMap(node.getAssignments()));
            List outputSchema = Lists.transform(node.getOutputSymbols(), (com.google.common.base.Function)Functions.forMap(node.getAssignments()));
            ConnectorIndex index = LocalExecutionPlanner.this.indexManager.getIndex(this.session, node.getIndexHandle(), lookupSchema, outputSchema);
            IndexSourceOperator.IndexSourceOperatorFactory operatorFactory = new IndexSourceOperator.IndexSourceOperatorFactory(context.getNextOperatorId(), node.getId(), index, probeKeyNormalizer);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        private SetMultimap<Symbol, Integer> mapIndexSourceLookupSymbolToProbeKeyInput(IndexJoinNode node, Map<Symbol, Integer> probeKeyLayout) {
            Set indexJoinSymbols = (Set)node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getIndex).collect(ImmutableSet.toImmutableSet());
            Map<Symbol, Symbol> indexKeyTrace = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), indexJoinSymbols);
            HashMultimap indexToProbeKeyInput = HashMultimap.create();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                indexToProbeKeyInput.put((Object)clause.getIndex(), (Object)probeKeyLayout.get(clause.getProbe()));
            }
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (Map.Entry<Symbol, Symbol> entry : indexKeyTrace.entrySet()) {
                Symbol indexJoinSymbol = entry.getKey();
                Symbol indexLookupSymbol = entry.getValue();
                builder.putAll((Object)indexLookupSymbol, (Iterable)indexToProbeKeyInput.get((Object)indexJoinSymbol));
            }
            return builder.build();
        }

        @Override
        public PhysicalOperation visitIndexJoin(IndexJoinNode node, LocalExecutionPlanContext context) {
            OperatorFactory lookupJoinOperatorFactory;
            List<IndexJoinNode.EquiJoinClause> clauses = node.getCriteria();
            List probeSymbols = Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getProbe);
            List indexSymbols = Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getIndex);
            PhysicalOperation probeSource = node.getProbeSource().accept(this, context);
            List<Integer> probeChannels = LocalExecutionPlanner.getChannelsForSymbols(probeSymbols, probeSource.getLayout());
            OptionalInt probeHashChannel = node.getProbeHashSymbol().map(LocalExecutionPlanner.channelGetter(probeSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            HashMap<Symbol, Integer> probeKeyLayout = new HashMap<Symbol, Integer>();
            for (int i = 0; i < probeSymbols.size(); ++i) {
                probeKeyLayout.put((Symbol)probeSymbols.get(i), i);
            }
            SetMultimap<Symbol, Integer> indexLookupToProbeInput = this.mapIndexSourceLookupSymbolToProbeKeyInput(node, probeKeyLayout);
            LocalExecutionPlanContext indexContext = context.createIndexSourceSubContext(new IndexSourceContext(indexLookupToProbeInput));
            PhysicalOperation indexSource = node.getIndexSource().accept(this, indexContext);
            List<Integer> indexOutputChannels = LocalExecutionPlanner.getChannelsForSymbols(indexSymbols, indexSource.getLayout());
            OptionalInt indexHashChannel = node.getIndexHashSymbol().map(LocalExecutionPlanner.channelGetter(indexSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            Set<Symbol> indexSymbolsNeededBySource = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), (Set<Symbol>)ImmutableSet.copyOf((Collection)indexSymbols)).keySet();
            Set lookupSourceInputChannels = (Set)node.getCriteria().stream().filter(equiJoinClause -> indexSymbolsNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getProbe).map(probeKeyLayout::get).collect(ImmutableSet.toImmutableSet());
            Optional<DynamicTupleFilterFactory> dynamicTupleFilterFactory = Optional.empty();
            if (lookupSourceInputChannels.size() < probeKeyLayout.values().size()) {
                int[] nonLookupInputChannels = Ints.toArray((Collection)((Collection)node.getCriteria().stream().filter(equiJoinClause -> !indexSymbolsNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getProbe).map(probeKeyLayout::get).collect(ImmutableList.toImmutableList())));
                int[] nonLookupOutputChannels = Ints.toArray((Collection)((Collection)node.getCriteria().stream().filter(equiJoinClause -> !indexSymbolsNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getIndex).map(indexSource.getLayout()::get).collect(ImmutableList.toImmutableList())));
                int filterOperatorId = indexContext.getNextOperatorId();
                dynamicTupleFilterFactory = Optional.of(new DynamicTupleFilterFactory(filterOperatorId, node.getId(), nonLookupInputChannels, nonLookupOutputChannels, indexSource.getTypes(), LocalExecutionPlanner.this.pageFunctionCompiler));
            }
            IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider = new IndexBuildDriverFactoryProvider(indexContext.getNextPipelineId(), indexContext.getNextOperatorId(), node.getId(), indexContext.isInputDriver(), indexSource.getTypes(), indexSource.getOperatorFactories(), dynamicTupleFilterFactory);
            IndexLookupSourceFactory indexLookupSourceFactory = new IndexLookupSourceFactory(lookupSourceInputChannels, indexOutputChannels, indexHashChannel, indexSource.getTypes(), indexBuildDriverFactoryProvider, LocalExecutionPlanner.this.maxIndexMemorySize, LocalExecutionPlanner.this.indexJoinLookupStats, SystemSessionProperties.isShareIndexLoading(this.session), LocalExecutionPlanner.this.pagesIndexFactory, LocalExecutionPlanner.this.joinCompiler);
            Verify.verify((probeSource.getPipelineExecutionStrategy() == PipelineExecutionStrategy.UNGROUPED_EXECUTION ? 1 : 0) != 0);
            Verify.verify((indexSource.getPipelineExecutionStrategy() == PipelineExecutionStrategy.UNGROUPED_EXECUTION ? 1 : 0) != 0);
            JoinBridgeManager<LookupSourceFactory> lookupSourceFactoryManager = new JoinBridgeManager<LookupSourceFactory>(false, PipelineExecutionStrategy.UNGROUPED_EXECUTION, PipelineExecutionStrategy.UNGROUPED_EXECUTION, lifespan -> {
                indexLookupSourceFactory.setTaskContext(context.taskContext);
                return indexLookupSourceFactory;
            }, indexLookupSourceFactory.getOutputTypes());
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(probeSource.getLayout());
            int offset = probeSource.getTypes().size();
            for (Map.Entry<Symbol, Integer> entry : indexSource.getLayout().entrySet()) {
                Integer input = entry.getValue();
                outputMappings.put((Object)entry.getKey(), (Object)(offset + input));
            }
            OptionalInt totalOperatorsCount = context.getDriverInstanceCount();
            switch (node.getType()) {
                case INNER: {
                    lookupJoinOperatorFactory = LocalExecutionPlanner.this.lookupJoinOperators.innerJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, probeSource.getTypes(), probeChannels, probeHashChannel, Optional.empty(), totalOperatorsCount, PartitioningSpillerFactory.unsupportedPartitioningSpillerFactory());
                    break;
                }
                case SOURCE_OUTER: {
                    lookupJoinOperatorFactory = LocalExecutionPlanner.this.lookupJoinOperators.probeOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, probeSource.getTypes(), probeChannels, probeHashChannel, Optional.empty(), totalOperatorsCount, PartitioningSpillerFactory.unsupportedPartitioningSpillerFactory());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown type: " + node.getType()));
                }
            }
            return new PhysicalOperation(lookupJoinOperatorFactory, (Map<Symbol, Integer>)outputMappings.build(), context, probeSource);
        }

        @Override
        public PhysicalOperation visitJoin(JoinNode node, LocalExecutionPlanContext context) {
            if (node.isCrossJoin()) {
                return this.createNestedLoopJoin(node, context);
            }
            List<JoinNode.EquiJoinClause> clauses = node.getCriteria();
            List leftSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause::getLeft);
            List rightSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause::getRight);
            switch (node.getType()) {
                case INNER: 
                case LEFT: 
                case RIGHT: 
                case FULL: {
                    return this.createLookupJoin(node, node.getLeft(), leftSymbols, node.getLeftHashSymbol(), node.getRight(), rightSymbols, node.getRightHashSymbol(), context);
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + node.getType());
        }

        @Override
        public PhysicalOperation visitSpatialJoin(SpatialJoinNode node, LocalExecutionPlanContext context) {
            Expression filterExpression = node.getFilter();
            List<FunctionCall> spatialFunctions = SpatialJoinUtils.extractSupportedSpatialFunctions(filterExpression);
            for (FunctionCall spatialFunction : spatialFunctions) {
                Optional<PhysicalOperation> operation = this.tryCreateSpatialJoin(context, node, this.removeExpressionFromFilter(filterExpression, (Expression)spatialFunction), spatialFunction, Optional.empty(), Optional.empty());
                if (!operation.isPresent()) continue;
                return operation.get();
            }
            List<ComparisonExpression> spatialComparisons = SpatialJoinUtils.extractSupportedSpatialComparisons(filterExpression);
            for (ComparisonExpression spatialComparison : spatialComparisons) {
                Expression radius;
                if (spatialComparison.getOperator() != ComparisonExpression.Operator.LESS_THAN && spatialComparison.getOperator() != ComparisonExpression.Operator.LESS_THAN_OR_EQUAL || !((radius = spatialComparison.getRight()) instanceof SymbolReference) || !this.getSymbolReferences(node.getRight().getOutputSymbols()).contains(radius)) continue;
                FunctionCall spatialFunction = (FunctionCall)spatialComparison.getLeft();
                Optional<PhysicalOperation> operation = this.tryCreateSpatialJoin(context, node, this.removeExpressionFromFilter(filterExpression, (Expression)spatialComparison), spatialFunction, Optional.of(radius), Optional.of(spatialComparison.getOperator()));
                if (!operation.isPresent()) continue;
                return operation.get();
            }
            throw new VerifyException("No valid spatial relationship found for spatial join");
        }

        private Optional<PhysicalOperation> tryCreateSpatialJoin(LocalExecutionPlanContext context, SpatialJoinNode node, Optional<Expression> filterExpression, FunctionCall spatialFunction, Optional<Expression> radius, Optional<ComparisonExpression.Operator> comparisonOperator) {
            List arguments = spatialFunction.getArguments();
            Verify.verify((arguments.size() == 2 ? 1 : 0) != 0);
            if (!(arguments.get(0) instanceof SymbolReference) || !(arguments.get(1) instanceof SymbolReference)) {
                return Optional.empty();
            }
            SymbolReference firstSymbol = (SymbolReference)arguments.get(0);
            SymbolReference secondSymbol = (SymbolReference)arguments.get(1);
            PlanNode probeNode = node.getLeft();
            Set<SymbolReference> probeSymbols = this.getSymbolReferences(probeNode.getOutputSymbols());
            PlanNode buildNode = node.getRight();
            Set<SymbolReference> buildSymbols = this.getSymbolReferences(buildNode.getOutputSymbols());
            if (probeSymbols.contains(firstSymbol) && buildSymbols.contains(secondSymbol)) {
                return Optional.of(this.createSpatialLookupJoin(node, probeNode, Symbol.from((Expression)firstSymbol), buildNode, Symbol.from((Expression)secondSymbol), radius.map(Symbol::from), this.spatialTest(spatialFunction, true, comparisonOperator), filterExpression, context));
            }
            if (probeSymbols.contains(secondSymbol) && buildSymbols.contains(firstSymbol)) {
                return Optional.of(this.createSpatialLookupJoin(node, probeNode, Symbol.from((Expression)secondSymbol), buildNode, Symbol.from((Expression)firstSymbol), radius.map(Symbol::from), this.spatialTest(spatialFunction, false, comparisonOperator), filterExpression, context));
            }
            return Optional.empty();
        }

        private Optional<Expression> removeExpressionFromFilter(Expression filter, Expression expression) {
            Expression updatedJoinFilter = ExpressionNodeInliner.replaceExpression(filter, (Map<? extends Expression, ? extends Expression>)ImmutableMap.of((Object)expression, (Object)BooleanLiteral.TRUE_LITERAL));
            return updatedJoinFilter == BooleanLiteral.TRUE_LITERAL ? Optional.empty() : Optional.of(updatedJoinFilter);
        }

        private SpatialIndexBuilderOperator.SpatialPredicate spatialTest(FunctionCall functionCall, boolean probeFirst, Optional<ComparisonExpression.Operator> comparisonOperator) {
            String functionName;
            switch (functionName = LocalExecutionPlanner.this.metadata.resolveFunction(functionCall.getName(), (List<TypeSignatureProvider>)ImmutableList.of()).getSignature().getName().toLowerCase(Locale.ENGLISH)) {
                case "st_contains": {
                    if (probeFirst) {
                        return (buildGeometry, probeGeometry, radius) -> probeGeometry.contains(buildGeometry);
                    }
                    return (buildGeometry, probeGeometry, radius) -> buildGeometry.contains(probeGeometry);
                }
                case "st_within": {
                    if (probeFirst) {
                        return (buildGeometry, probeGeometry, radius) -> probeGeometry.within(buildGeometry);
                    }
                    return (buildGeometry, probeGeometry, radius) -> buildGeometry.within(probeGeometry);
                }
                case "st_intersects": {
                    return (buildGeometry, probeGeometry, radius) -> buildGeometry.intersects(probeGeometry);
                }
                case "st_distance": {
                    if (comparisonOperator.get() == ComparisonExpression.Operator.LESS_THAN) {
                        return (buildGeometry, probeGeometry, radius) -> buildGeometry.distance(probeGeometry) < radius.getAsDouble();
                    }
                    if (comparisonOperator.get() == ComparisonExpression.Operator.LESS_THAN_OR_EQUAL) {
                        return (buildGeometry, probeGeometry, radius) -> buildGeometry.distance(probeGeometry) <= radius.getAsDouble();
                    }
                    throw new UnsupportedOperationException("Unsupported comparison operator: " + comparisonOperator.get());
                }
            }
            throw new UnsupportedOperationException("Unsupported spatial function: " + functionName);
        }

        private Set<SymbolReference> getSymbolReferences(Collection<Symbol> symbols) {
            return (Set)symbols.stream().map(Symbol::toSymbolReference).collect(ImmutableSet.toImmutableSet());
        }

        private PhysicalOperation createNestedLoopJoin(JoinNode node, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = node.getLeft().accept(this, context);
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = node.getRight().accept(this, buildContext);
            Preconditions.checkState((buildSource.getPipelineExecutionStrategy() == PipelineExecutionStrategy.UNGROUPED_EXECUTION ? 1 : 0) != 0, (Object)"Build source of a nested loop join is expected to be UNGROUPED_EXECUTION.");
            Preconditions.checkArgument((node.getType() == JoinNode.Type.INNER ? 1 : 0) != 0, (Object)"NestedLoopJoin is only used for inner join");
            JoinBridgeManager<NestedLoopJoinBridge> nestedLoopJoinBridgeManager = new JoinBridgeManager<NestedLoopJoinBridge>(false, probeSource.getPipelineExecutionStrategy(), buildSource.getPipelineExecutionStrategy(), lifespan -> new NestedLoopJoinPagesSupplier(), buildSource.getTypes());
            NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(buildContext.getNextOperatorId(), node.getId(), nestedLoopJoinBridgeManager);
            Preconditions.checkArgument((buildContext.getDriverInstanceCount().orElse(1) == 1 ? 1 : 0) != 0, (Object)"Expected local execution to not be parallel");
            context.addDriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll(buildSource.getOperatorFactories()).add((Object)nestedLoopBuildOperatorFactory).build(), buildContext.getDriverInstanceCount(), buildSource.getPipelineExecutionStrategy());
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappings.put((Object)symbol, (Object)i);
            }
            List<Integer> probeChannels = LocalExecutionPlanner.getChannelsForSymbols(node.getLeftOutputSymbols(), probeSource.getLayout());
            List<Integer> buildChannels = LocalExecutionPlanner.getChannelsForSymbols(node.getRightOutputSymbols(), buildSource.getLayout());
            NestedLoopJoinOperator.NestedLoopJoinOperatorFactory operatorFactory = new NestedLoopJoinOperator.NestedLoopJoinOperatorFactory(context.getNextOperatorId(), node.getId(), nestedLoopJoinBridgeManager, probeChannels, buildChannels);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), context, probeSource);
        }

        private PhysicalOperation createSpatialLookupJoin(SpatialJoinNode node, PlanNode probeNode, Symbol probeSymbol, PlanNode buildNode, Symbol buildSymbol, Optional<Symbol> radiusSymbol, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<Expression> joinFilter, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = probeNode.accept(this, context);
            PagesSpatialIndexFactory pagesSpatialIndexFactory = this.createPagesSpatialIndexFactory(node, buildNode, buildSymbol, radiusSymbol, probeSource.getLayout(), spatialRelationshipTest, joinFilter, context);
            OperatorFactory operator = this.createSpatialLookupJoin(node, probeNode, probeSource, probeSymbol, pagesSpatialIndexFactory, context);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappings.put((Object)symbol, (Object)i);
            }
            return new PhysicalOperation(operator, (Map<Symbol, Integer>)outputMappings.build(), context, probeSource);
        }

        private OperatorFactory createSpatialLookupJoin(SpatialJoinNode node, PlanNode probeNode, PhysicalOperation probeSource, Symbol probeSymbol, PagesSpatialIndexFactory pagesSpatialIndexFactory, LocalExecutionPlanContext context) {
            List<Type> probeTypes = probeSource.getTypes();
            List probeOutputSymbols = (List)node.getOutputSymbols().stream().filter(symbol -> probeNode.getOutputSymbols().contains(symbol)).collect(ImmutableList.toImmutableList());
            ImmutableList probeOutputChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols(probeOutputSymbols, probeSource.getLayout()));
            Function<Symbol, Integer> probeChannelGetter = LocalExecutionPlanner.channelGetter(probeSource);
            int probeChannel = probeChannelGetter.apply(probeSymbol);
            Optional<Integer> partitionChannel = node.getLeftPartitionSymbol().map(probeChannelGetter::apply);
            return new SpatialJoinOperator.SpatialJoinOperatorFactory(context.getNextOperatorId(), node.getId(), node.getType(), probeTypes, (List<Integer>)probeOutputChannels, probeChannel, partitionChannel, pagesSpatialIndexFactory);
        }

        private PagesSpatialIndexFactory createPagesSpatialIndexFactory(SpatialJoinNode node, PlanNode buildNode, Symbol buildSymbol, Optional<Symbol> radiusSymbol, Map<Symbol, Integer> probeLayout, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<Expression> joinFilter, LocalExecutionPlanContext context) {
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = buildNode.accept(this, buildContext);
            List buildOutputSymbols = (List)node.getOutputSymbols().stream().filter(symbol -> buildNode.getOutputSymbols().contains(symbol)).collect(ImmutableList.toImmutableList());
            Map<Symbol, Integer> buildLayout = buildSource.getLayout();
            ImmutableList buildOutputChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols(buildOutputSymbols, buildLayout));
            Function<Symbol, Integer> buildChannelGetter = LocalExecutionPlanner.channelGetter(buildSource);
            Integer buildChannel = buildChannelGetter.apply(buildSymbol);
            Optional<Integer> radiusChannel = radiusSymbol.map(buildChannelGetter::apply);
            Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory = joinFilter.map(filterExpression -> this.compileJoinFilterFunction((Expression)filterExpression, probeLayout, buildLayout, context.getTypes(), context.getSession()));
            Optional<Integer> partitionChannel = node.getRightPartitionSymbol().map(buildChannelGetter::apply);
            SpatialIndexBuilderOperator.SpatialIndexBuilderOperatorFactory builderOperatorFactory = new SpatialIndexBuilderOperator.SpatialIndexBuilderOperatorFactory(buildContext.getNextOperatorId(), node.getId(), buildSource.getTypes(), (List<Integer>)buildOutputChannels, buildChannel, radiusChannel, partitionChannel, spatialRelationshipTest, node.getKdbTree(), filterFunctionFactory, 10000, LocalExecutionPlanner.this.pagesIndexFactory);
            context.addDriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll(buildSource.getOperatorFactories()).add((Object)builderOperatorFactory).build(), buildContext.getDriverInstanceCount(), buildSource.getPipelineExecutionStrategy());
            return builderOperatorFactory.getPagesSpatialIndexFactory();
        }

        private PhysicalOperation createLookupJoin(JoinNode node, PlanNode probeNode, List<Symbol> probeSymbols, Optional<Symbol> probeHashSymbol, PlanNode buildNode, List<Symbol> buildSymbols, Optional<Symbol> buildHashSymbol, LocalExecutionPlanContext context) {
            Set localDynamicFilters = (Set)node.getDynamicFilters().keySet().stream().filter(LocalExecutionPlanner.getConsumedDynamicFilterIds(probeNode)::contains).collect(ImmutableSet.toImmutableSet());
            context.getDynamicFiltersCollector().register(localDynamicFilters);
            PhysicalOperation probeSource = probeNode.accept(this, context);
            boolean spillEnabled = SystemSessionProperties.isSpillEnabled(this.session) && node.isSpillable().orElseThrow(() -> new IllegalArgumentException("spillable not yet set")) != false;
            JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = this.createLookupSourceFactory(node, buildNode, buildSymbols, buildHashSymbol, probeSource, context, spillEnabled, localDynamicFilters);
            OperatorFactory operator = this.createLookupJoin(node, probeSource, probeSymbols, probeHashSymbol, lookupSourceFactory, context, spillEnabled);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappings.put((Object)symbol, (Object)i);
            }
            return new PhysicalOperation(operator, (Map<Symbol, Integer>)outputMappings.build(), context, probeSource);
        }

        private JoinBridgeManager<PartitionedLookupSourceFactory> createLookupSourceFactory(JoinNode node, PlanNode buildNode, List<Symbol> buildSymbols, Optional<Symbol> buildHashSymbol, PhysicalOperation probeSource, LocalExecutionPlanContext context, boolean spillEnabled, Set<DynamicFilterId> localDynamicFilters) {
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = buildNode.accept(this, buildContext);
            if (buildSource.getPipelineExecutionStrategy() == PipelineExecutionStrategy.GROUPED_EXECUTION) {
                Preconditions.checkState((probeSource.getPipelineExecutionStrategy() == PipelineExecutionStrategy.GROUPED_EXECUTION ? 1 : 0) != 0, (Object)"Build execution is GROUPED_EXECUTION. Probe execution is expected be GROUPED_EXECUTION, but is UNGROUPED_EXECUTION.");
            }
            ImmutableList buildOutputChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols(node.getRightOutputSymbols(), buildSource.getLayout()));
            ImmutableList buildChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols(buildSymbols, buildSource.getLayout()));
            OptionalInt buildHashChannel = buildHashSymbol.map(LocalExecutionPlanner.channelGetter(buildSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            boolean buildOuter = node.getType() == JoinNode.Type.RIGHT || node.getType() == JoinNode.Type.FULL;
            int partitionCount = buildContext.getDriverInstanceCount().orElse(1);
            Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory = node.getFilter().map(filterExpression -> this.compileJoinFilterFunction((Expression)filterExpression, probeSource.getLayout(), buildSource.getLayout(), context.getTypes(), context.getSession()));
            Optional<Object> sortExpressionContext = node.getFilter().flatMap(filter -> SortExpressionExtractor.extractSortExpression(LocalExecutionPlanner.this.metadata, (Set<Symbol>)ImmutableSet.copyOf(node.getRight().getOutputSymbols()), filter));
            Optional<Integer> sortChannel = sortExpressionContext.map(SortExpressionContext::getSortExpression).map(Symbol::from).map(sortSymbol -> this.createJoinSourcesLayout(buildSource.getLayout(), probeSource.getLayout()).get(sortSymbol));
            List searchFunctionFactories = (List)sortExpressionContext.map(SortExpressionContext::getSearchExpressions).map(searchExpressions -> (ImmutableList)searchExpressions.stream().map(searchExpression -> this.compileJoinFilterFunction((Expression)searchExpression, probeSource.getLayout(), buildSource.getLayout(), context.getTypes(), context.getSession())).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
            ImmutableList buildOutputTypes = (ImmutableList)buildOutputChannels.stream().map(buildSource.getTypes()::get).collect(ImmutableList.toImmutableList());
            JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = new JoinBridgeManager<PartitionedLookupSourceFactory>(buildOuter, probeSource.getPipelineExecutionStrategy(), buildSource.getPipelineExecutionStrategy(), arg_0 -> Visitor.lambda$createLookupSourceFactory$31(buildSource, buildOutputTypes, (List)buildChannels, partitionCount, buildOuter, arg_0), (List<Type>)buildOutputTypes);
            ImmutableList.Builder factoriesBuilder = new ImmutableList.Builder();
            factoriesBuilder.addAll(buildSource.getOperatorFactories());
            this.createDynamicFilter(buildSource, node, context, partitionCount, localDynamicFilters).ifPresent(filter -> factoriesBuilder.add((Object)this.createDynamicFilterSourceOperatorFactory((LocalDynamicFilterConsumer)filter, node, buildSource, buildContext)));
            HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(buildContext.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, (List<Integer>)buildOutputChannels, (List<Integer>)buildChannels, buildHashChannel, filterFunctionFactory, sortChannel, searchFunctionFactories, 10000, LocalExecutionPlanner.this.pagesIndexFactory, spillEnabled && !buildOuter && partitionCount > 1, LocalExecutionPlanner.this.singleStreamSpillerFactory);
            factoriesBuilder.add((Object)hashBuilderOperatorFactory);
            context.addDriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)factoriesBuilder.build(), buildContext.getDriverInstanceCount(), buildSource.getPipelineExecutionStrategy());
            return lookupSourceFactoryManager;
        }

        private DynamicFilterSourceOperator.DynamicFilterSourceOperatorFactory createDynamicFilterSourceOperatorFactory(LocalDynamicFilterConsumer dynamicFilter, JoinNode node, PhysicalOperation buildSource, LocalExecutionPlanContext context) {
            List<DynamicFilterSourceOperator.Channel> filterBuildChannels = dynamicFilter.getBuildChannels().entrySet().stream().map(entry -> {
                DynamicFilterId filterId = (DynamicFilterId)entry.getKey();
                int index = (Integer)entry.getValue();
                Type type = buildSource.getTypes().get(index);
                return new DynamicFilterSourceOperator.Channel(filterId, type, index);
            }).collect(Collectors.toList());
            boolean isReplicatedJoin = JoinUtils.isBuildSideReplicated(node);
            return new DynamicFilterSourceOperator.DynamicFilterSourceOperatorFactory(context.getNextOperatorId(), node.getId(), dynamicFilter.getTupleDomainConsumer(), filterBuildChannels, LocalExecutionPlanner.this.getDynamicFilteringMaxDistinctValuesPerDriver(context.getSession(), isReplicatedJoin), LocalExecutionPlanner.this.getDynamicFilteringMaxSizePerDriver(context.getSession(), isReplicatedJoin), LocalExecutionPlanner.this.getDynamicFilteringRangeRowLimitPerDriver(context.getSession(), isReplicatedJoin));
        }

        private Optional<LocalDynamicFilterConsumer> createDynamicFilter(PhysicalOperation buildSource, JoinNode node, LocalExecutionPlanContext context, int partitionCount, Set<DynamicFilterId> localDynamicFilters) {
            Set<DynamicFilterId> coordinatorDynamicFilters = this.getCoordinatorDynamicFilters(node.getDynamicFilters().keySet(), node, context.getTaskId());
            ImmutableSet collectedDynamicFilters = ImmutableSet.builder().addAll(localDynamicFilters).addAll(coordinatorDynamicFilters).build();
            if (collectedDynamicFilters.isEmpty()) {
                return Optional.empty();
            }
            Preconditions.checkState((buildSource.getPipelineExecutionStrategy() != PipelineExecutionStrategy.GROUPED_EXECUTION ? 1 : 0) != 0, (Object)"Dynamic filtering cannot be used with grouped execution");
            log.debug("[Join] Dynamic filters: %s", new Object[]{node.getDynamicFilters()});
            LocalDynamicFilterConsumer filterConsumer = LocalDynamicFilterConsumer.create(node, buildSource.getTypes(), partitionCount, (Set<DynamicFilterId>)collectedDynamicFilters);
            ListenableFuture<Map<DynamicFilterId, Domain>> domainsFuture = filterConsumer.getDynamicFilterDomains();
            if (!localDynamicFilters.isEmpty()) {
                MoreFutures.addSuccessCallback(domainsFuture, x$0 -> context.addLocalDynamicFilters((Map<DynamicFilterId, Domain>)x$0));
            }
            if (!coordinatorDynamicFilters.isEmpty()) {
                MoreFutures.addSuccessCallback(domainsFuture, domains -> context.addCoordinatorDynamicFilters((Map)domains.entrySet().stream().filter(entry -> coordinatorDynamicFilters.contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue))));
            }
            return Optional.of(filterConsumer);
        }

        private JoinFilterFunctionCompiler.JoinFilterFunctionFactory compileJoinFilterFunction(Expression filterExpression, Map<Symbol, Integer> probeLayout, Map<Symbol, Integer> buildLayout, TypeProvider types, Session session) {
            Map<Symbol, Integer> joinSourcesLayout = this.createJoinSourcesLayout(buildLayout, probeLayout);
            RowExpression translatedFilter = this.toRowExpression(filterExpression, LocalExecutionPlanner.this.typeAnalyzer.getTypes(session, types, filterExpression), joinSourcesLayout);
            return LocalExecutionPlanner.this.joinFilterFunctionCompiler.compileJoinFilterFunction(translatedFilter, buildLayout.size());
        }

        private OperatorFactory createLookupJoin(JoinNode node, PhysicalOperation probeSource, List<Symbol> probeSymbols, Optional<Symbol> probeHashSymbol, JoinBridgeManager<? extends LookupSourceFactory> lookupSourceFactoryManager, LocalExecutionPlanContext context, boolean spillEnabled) {
            List<Type> probeTypes = probeSource.getTypes();
            ImmutableList probeOutputChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols(node.getLeftOutputSymbols(), probeSource.getLayout()));
            ImmutableList probeJoinChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols(probeSymbols, probeSource.getLayout()));
            OptionalInt probeHashChannel = probeHashSymbol.map(LocalExecutionPlanner.channelGetter(probeSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            OptionalInt totalOperatorsCount = context.getDriverInstanceCount();
            Preconditions.checkState((!spillEnabled || totalOperatorsCount.isPresent() ? 1 : 0) != 0, (Object)"A fixed distribution is required for JOIN when spilling is enabled");
            switch (node.getType()) {
                case INNER: {
                    return LocalExecutionPlanner.this.lookupJoinOperators.innerJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                }
                case LEFT: {
                    return LocalExecutionPlanner.this.lookupJoinOperators.probeOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                }
                case RIGHT: {
                    return LocalExecutionPlanner.this.lookupJoinOperators.lookupOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                }
                case FULL: {
                    return LocalExecutionPlanner.this.lookupJoinOperators.fullOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + node.getType());
        }

        private Map<Symbol, Integer> createJoinSourcesLayout(Map<Symbol, Integer> lookupSourceLayout, Map<Symbol, Integer> probeSourceLayout) {
            ImmutableMap.Builder joinSourcesLayout = ImmutableMap.builder();
            joinSourcesLayout.putAll(lookupSourceLayout);
            for (Map.Entry<Symbol, Integer> probeLayoutEntry : probeSourceLayout.entrySet()) {
                joinSourcesLayout.put((Object)probeLayoutEntry.getKey(), (Object)(probeLayoutEntry.getValue() + lookupSourceLayout.size()));
            }
            return joinSourcesLayout.build();
        }

        @Override
        public PhysicalOperation visitSemiJoin(SemiJoinNode node, LocalExecutionPlanContext context) {
            boolean isLocalDynamicFilter = node.getDynamicFilterId().map(filterId -> LocalExecutionPlanner.getConsumedDynamicFilterIds(node.getSource()).contains(filterId)).orElse(false);
            boolean isCoordinatorDynamicFilter = node.getDynamicFilterId().map(filterId -> !this.getCoordinatorDynamicFilters((Set<DynamicFilterId>)ImmutableSet.of((Object)filterId), node, context.getTaskId()).isEmpty()).orElse(false);
            if (isLocalDynamicFilter) {
                context.getDynamicFiltersCollector().register((Set<DynamicFilterId>)ImmutableSet.of((Object)node.getDynamicFilterId().get()));
            }
            PhysicalOperation probeSource = node.getSource().accept(this, context);
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = node.getFilteringSource().accept(this, buildContext);
            Preconditions.checkState((buildSource.getPipelineExecutionStrategy() == probeSource.getPipelineExecutionStrategy() ? 1 : 0) != 0, (Object)"build and probe have different pipelineExecutionStrategy");
            int partitionCount = buildContext.getDriverInstanceCount().orElse(1);
            Preconditions.checkArgument((partitionCount == 1 ? 1 : 0) != 0, (Object)"Expected local execution to not be parallel");
            int probeChannel = probeSource.getLayout().get(node.getSourceJoinSymbol());
            int buildChannel = buildSource.getLayout().get(node.getFilteringSourceJoinSymbol());
            ImmutableList.Builder buildOperatorFactories = new ImmutableList.Builder();
            buildOperatorFactories.addAll(buildSource.getOperatorFactories());
            if (isLocalDynamicFilter || isCoordinatorDynamicFilter) {
                DynamicFilterId filterId2 = node.getDynamicFilterId().get();
                log.debug("[Semi-join] Dynamic filter: %s", new Object[]{filterId2});
                LocalDynamicFilterConsumer filterConsumer = new LocalDynamicFilterConsumer((Map<DynamicFilterId, Integer>)ImmutableMap.of((Object)filterId2, (Object)buildChannel), (Map<DynamicFilterId, Type>)ImmutableMap.of((Object)filterId2, (Object)buildSource.getTypes().get(buildChannel)), partitionCount);
                ListenableFuture<Map<DynamicFilterId, Domain>> domainsFuture = filterConsumer.getDynamicFilterDomains();
                if (isLocalDynamicFilter) {
                    MoreFutures.addSuccessCallback(domainsFuture, x$0 -> context.addLocalDynamicFilters((Map<DynamicFilterId, Domain>)x$0));
                }
                if (isCoordinatorDynamicFilter) {
                    MoreFutures.addSuccessCallback(domainsFuture, x$0 -> context.addCoordinatorDynamicFilters((Map<DynamicFilterId, Domain>)x$0));
                }
                boolean isReplicatedJoin = JoinUtils.isBuildSideReplicated(node);
                buildOperatorFactories.add((Object)new DynamicFilterSourceOperator.DynamicFilterSourceOperatorFactory(buildContext.getNextOperatorId(), node.getId(), filterConsumer.getTupleDomainConsumer(), (List<DynamicFilterSourceOperator.Channel>)ImmutableList.of((Object)new DynamicFilterSourceOperator.Channel(filterId2, buildSource.getTypes().get(buildChannel), buildChannel)), LocalExecutionPlanner.this.getDynamicFilteringMaxDistinctValuesPerDriver(context.getSession(), isReplicatedJoin), LocalExecutionPlanner.this.getDynamicFilteringMaxSizePerDriver(context.getSession(), isReplicatedJoin), LocalExecutionPlanner.this.getDynamicFilteringRangeRowLimitPerDriver(context.getSession(), isReplicatedJoin)));
            }
            Optional<Integer> buildHashChannel = node.getFilteringSourceHashSymbol().map(LocalExecutionPlanner.channelGetter(buildSource));
            Optional<Integer> probeHashChannel = node.getSourceHashSymbol().map(LocalExecutionPlanner.channelGetter(probeSource));
            SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(buildContext.getNextOperatorId(), node.getId(), buildSource.getTypes().get(buildChannel), buildChannel, buildHashChannel, 10000, LocalExecutionPlanner.this.joinCompiler);
            buildOperatorFactories.add((Object)setBuilderOperatorFactory);
            SetBuilderOperator.SetSupplier setProvider = setBuilderOperatorFactory.getSetProvider();
            context.addDriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)buildOperatorFactories.build(), buildContext.getDriverInstanceCount(), buildSource.getPipelineExecutionStrategy());
            ImmutableMap outputMappings = ImmutableMap.builder().putAll(probeSource.getLayout()).put((Object)node.getSemiJoinOutput(), (Object)probeSource.getLayout().size()).build();
            OperatorFactory operator = HashSemiJoinOperator.createOperatorFactory(context.getNextOperatorId(), node.getId(), setProvider, probeSource.getTypes(), probeChannel, probeHashChannel);
            return new PhysicalOperation(operator, (Map<Symbol, Integer>)outputMappings, context, probeSource);
        }

        private Set<DynamicFilterId> getCoordinatorDynamicFilters(Set<DynamicFilterId> dynamicFilters, PlanNode node, TaskId taskId) {
            if (!JoinUtils.isBuildSideReplicated(node) || taskId.getId() == 0) {
                return dynamicFilters;
            }
            return ImmutableSet.of();
        }

        @Override
        public PhysicalOperation visitTableWriter(TableWriterNode node, LocalExecutionPlanContext context) {
            if (node.getPartitioningScheme().isPresent()) {
                PartitioningHandle partitioningHandle = node.getPartitioningScheme().get().getPartitioning().getHandle();
                if (partitioningHandle.equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION)) {
                    context.setDriverInstanceCount(SystemSessionProperties.getTaskWriterCount(this.session));
                } else {
                    context.setDriverInstanceCount(1);
                }
            } else {
                context.setDriverInstanceCount(SystemSessionProperties.getTaskWriterCount(this.session));
            }
            PhysicalOperation source = node.getSource().accept(this, context);
            ImmutableMap.Builder outputMapping = ImmutableMap.builder();
            outputMapping.put((Object)node.getOutputSymbols().get(0), (Object)0);
            outputMapping.put((Object)node.getOutputSymbols().get(1), (Object)1);
            OperatorFactory statisticsAggregation = node.getStatisticsAggregation().map(aggregation -> {
                List<Symbol> groupingSymbols = aggregation.getGroupingSymbols();
                if (groupingSymbols.isEmpty()) {
                    return this.createAggregationOperatorFactory(node.getId(), aggregation.getAggregations(), AggregationNode.Step.PARTIAL, 2, (ImmutableMap.Builder<Symbol, Integer>)outputMapping, source, context, true);
                }
                return this.createHashAggregationOperatorFactory(node.getId(), aggregation.getAggregations(), (Set<Integer>)ImmutableSet.of(), groupingSymbols, AggregationNode.Step.PARTIAL, Optional.empty(), Optional.empty(), source, false, false, false, DataSize.ofBytes((long)0L), context, 2, (ImmutableMap.Builder<Symbol, Integer>)outputMapping, 200, Optional.empty(), true);
            }).orElse(new DevNullOperator.DevNullOperatorFactory(context.getNextOperatorId(), node.getId()));
            List inputChannels = (List)node.getColumns().stream().map(source::symbolToChannel).collect(ImmutableList.toImmutableList());
            List<String> notNullChannelColumnNames = node.getColumns().stream().map(symbol -> node.getNotNullColumnSymbols().contains(symbol) ? node.getColumnNames().get(source.symbolToChannel((Symbol)symbol)) : null).collect(Collectors.toList());
            TableWriterOperator.TableWriterOperatorFactory operatorFactory = new TableWriterOperator.TableWriterOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.pageSinkManager, node.getTarget(), inputChannels, notNullChannelColumnNames, this.session, statisticsAggregation, this.getSymbolTypes(node.getOutputSymbols(), context.getTypes()));
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMapping.build(), context, source);
        }

        @Override
        public PhysicalOperation visitStatisticsWriterNode(StatisticsWriterNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            StatisticAggregationsDescriptor<Integer> descriptor = node.getDescriptor().map(symbol -> source.getLayout().get(symbol));
            StatisticsWriterOperator.StatisticsWriterOperatorFactory operatorFactory = new StatisticsWriterOperator.StatisticsWriterOperatorFactory(context.getNextOperatorId(), node.getId(), computedStatistics -> LocalExecutionPlanner.this.metadata.finishStatisticsCollection(this.session, ((StatisticsWriterNode.WriteStatisticsHandle)node.getTarget()).getHandle(), computedStatistics), node.isRowCountEnabled(), descriptor);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, source);
        }

        @Override
        public PhysicalOperation visitTableFinish(TableFinishNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            ImmutableMap.Builder outputMapping = ImmutableMap.builder();
            OperatorFactory statisticsAggregation = node.getStatisticsAggregation().map(aggregation -> {
                List<Symbol> groupingSymbols = aggregation.getGroupingSymbols();
                if (groupingSymbols.isEmpty()) {
                    return this.createAggregationOperatorFactory(node.getId(), aggregation.getAggregations(), AggregationNode.Step.FINAL, 0, (ImmutableMap.Builder<Symbol, Integer>)outputMapping, source, context, true);
                }
                return this.createHashAggregationOperatorFactory(node.getId(), aggregation.getAggregations(), (Set<Integer>)ImmutableSet.of(), groupingSymbols, AggregationNode.Step.FINAL, Optional.empty(), Optional.empty(), source, false, false, false, DataSize.ofBytes((long)0L), context, 0, (ImmutableMap.Builder<Symbol, Integer>)outputMapping, 200, Optional.empty(), true);
            }).orElse(new DevNullOperator.DevNullOperatorFactory(context.getNextOperatorId(), node.getId()));
            ImmutableMap aggregationOutput = outputMapping.build();
            StatisticAggregationsDescriptor<Integer> descriptor = node.getStatisticsAggregationDescriptor().map(arg_0 -> Visitor.lambda$visitTableFinish$46((Map)aggregationOutput, arg_0)).orElse(StatisticAggregationsDescriptor.empty());
            TableFinishOperator.TableFinishOperatorFactory operatorFactory = new TableFinishOperator.TableFinishOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.createTableFinisher(this.session, node, LocalExecutionPlanner.this.metadata), statisticsAggregation, descriptor, this.session);
            ImmutableMap layout = ImmutableMap.of((Object)node.getOutputSymbols().get(0), (Object)0);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)layout, context, source);
        }

        @Override
        public PhysicalOperation visitDelete(DeleteNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            DeleteOperator.DeleteOperatorFactory operatorFactory = new DeleteOperator.DeleteOperatorFactory(context.getNextOperatorId(), node.getId(), source.getLayout().get(node.getRowId()));
            ImmutableMap layout = ImmutableMap.builder().put((Object)node.getOutputSymbols().get(0), (Object)0).put((Object)node.getOutputSymbols().get(1), (Object)1).build();
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)layout, context, source);
        }

        @Override
        public PhysicalOperation visitTableDelete(TableDeleteNode node, LocalExecutionPlanContext context) {
            TableDeleteOperator.TableDeleteOperatorFactory operatorFactory = new TableDeleteOperator.TableDeleteOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.metadata, this.session, node.getTarget());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        @Override
        public PhysicalOperation visitUnion(UnionNode node, LocalExecutionPlanContext context) {
            throw new UnsupportedOperationException("Union node should not be present in a local execution plan");
        }

        @Override
        public PhysicalOperation visitEnforceSingleRow(EnforceSingleRowNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            EnforceSingleRowOperator.EnforceSingleRowOperatorFactory operatorFactory = new EnforceSingleRowOperator.EnforceSingleRowOperatorFactory(context.getNextOperatorId(), node.getId());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, source);
        }

        @Override
        public PhysicalOperation visitAssignUniqueId(AssignUniqueId node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            OperatorFactory operatorFactory = AssignUniqueIdOperator.createOperatorFactory(context.getNextOperatorId(), node.getId());
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, source);
        }

        @Override
        public PhysicalOperation visitExchange(ExchangeNode node, LocalExecutionPlanContext context) {
            Preconditions.checkArgument((node.getScope() == ExchangeNode.Scope.LOCAL ? 1 : 0) != 0, (Object)"Only local exchanges are supported in the local planner");
            if (node.getOrderingScheme().isPresent()) {
                return this.createLocalMerge(node, context);
            }
            return this.createLocalExchange(node, context);
        }

        private PhysicalOperation createLocalMerge(ExchangeNode node, LocalExecutionPlanContext context) {
            Preconditions.checkArgument((boolean)node.getOrderingScheme().isPresent(), (Object)"orderingScheme is absent");
            Preconditions.checkState((node.getSources().size() == 1 ? 1 : 0) != 0, (Object)"single source is expected");
            context.setDriverInstanceCount(1);
            PlanNode sourceNode = (PlanNode)Iterables.getOnlyElement(node.getSources());
            LocalExecutionPlanContext subContext = context.createSubContext();
            PhysicalOperation source = sourceNode.accept(this, subContext);
            int operatorsCount = subContext.getDriverInstanceCount().orElse(1);
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            LocalExchange.LocalExchangeFactory exchangeFactory = new LocalExchange.LocalExchangeFactory(node.getPartitioningScheme().getPartitioning().getHandle(), operatorsCount, types, (List<Integer>)ImmutableList.of(), Optional.empty(), source.getPipelineExecutionStrategy(), LocalExecutionPlanner.this.maxLocalExchangeBufferSize);
            ArrayList<OperatorFactory> operatorFactories = new ArrayList<OperatorFactory>(source.getOperatorFactories());
            List<Symbol> expectedLayout = node.getInputs().get(0);
            Function<Page, Page> pagePreprocessor = LocalExecutionPlanner.enforceLayoutProcessor(expectedLayout, source.getLayout());
            operatorFactories.add(new LocalExchangeSinkOperator.LocalExchangeSinkOperatorFactory(exchangeFactory, subContext.getNextOperatorId(), node.getId(), exchangeFactory.newSinkFactoryId(), pagePreprocessor));
            context.addDriverFactory(subContext.isInputDriver(), false, operatorFactories, subContext.getDriverInstanceCount(), source.getPipelineExecutionStrategy());
            context.setInputDriver(false);
            OrderingScheme orderingScheme = node.getOrderingScheme().get();
            ImmutableMap<Symbol, Integer> layout = this.makeLayout(node);
            List<Integer> sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderingScheme.getOrderBy(), layout);
            List<SortOrder> orderings = orderingScheme.getOrderingList();
            LocalMergeSourceOperator.LocalMergeSourceOperatorFactory operatorFactory = new LocalMergeSourceOperator.LocalMergeSourceOperatorFactory(context.getNextOperatorId(), node.getId(), exchangeFactory, types, LocalExecutionPlanner.this.orderingCompiler, sortChannels, orderings);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)layout, context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        private PhysicalOperation createLocalExchange(ExchangeNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source;
            int driverInstanceCount;
            if (node.getType() == ExchangeNode.Type.GATHER) {
                driverInstanceCount = 1;
                context.setDriverInstanceCount(1);
            } else if (context.getDriverInstanceCount().isPresent()) {
                driverInstanceCount = context.getDriverInstanceCount().getAsInt();
            } else {
                driverInstanceCount = SystemSessionProperties.getTaskConcurrency(this.session);
                context.setDriverInstanceCount(driverInstanceCount);
            }
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            List channels = (List)node.getPartitioningScheme().getPartitioning().getArguments().stream().map(argument -> node.getOutputSymbols().indexOf(argument.getColumn())).collect(ImmutableList.toImmutableList());
            Optional<Integer> hashChannel = node.getPartitioningScheme().getHashColumn().map(symbol -> node.getOutputSymbols().indexOf(symbol));
            PipelineExecutionStrategy exchangeSourcePipelineExecutionStrategy = PipelineExecutionStrategy.GROUPED_EXECUTION;
            ArrayList<DriverFactoryParameters> driverFactoryParametersList = new ArrayList<DriverFactoryParameters>();
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode sourceNode = node.getSources().get(i);
                LocalExecutionPlanContext subContext = context.createSubContext();
                source = sourceNode.accept(this, subContext);
                driverFactoryParametersList.add(new DriverFactoryParameters(subContext, source));
                if (source.getPipelineExecutionStrategy() != PipelineExecutionStrategy.UNGROUPED_EXECUTION) continue;
                exchangeSourcePipelineExecutionStrategy = PipelineExecutionStrategy.UNGROUPED_EXECUTION;
            }
            LocalExchange.LocalExchangeFactory localExchangeFactory = new LocalExchange.LocalExchangeFactory(node.getPartitioningScheme().getPartitioning().getHandle(), driverInstanceCount, types, channels, hashChannel, exchangeSourcePipelineExecutionStrategy, LocalExecutionPlanner.this.maxLocalExchangeBufferSize);
            for (int i = 0; i < node.getSources().size(); ++i) {
                DriverFactoryParameters driverFactoryParameters = (DriverFactoryParameters)driverFactoryParametersList.get(i);
                source = driverFactoryParameters.getSource();
                LocalExecutionPlanContext subContext = driverFactoryParameters.getSubContext();
                List<Symbol> expectedLayout = node.getInputs().get(i);
                Function<Page, Page> pagePreprocessor = LocalExecutionPlanner.enforceLayoutProcessor(expectedLayout, source.getLayout());
                ArrayList<OperatorFactory> operatorFactories = new ArrayList<OperatorFactory>(source.getOperatorFactories());
                operatorFactories.add(new LocalExchangeSinkOperator.LocalExchangeSinkOperatorFactory(localExchangeFactory, subContext.getNextOperatorId(), node.getId(), localExchangeFactory.newSinkFactoryId(), pagePreprocessor));
                context.addDriverFactory(subContext.isInputDriver(), false, operatorFactories, subContext.getDriverInstanceCount(), exchangeSourcePipelineExecutionStrategy);
            }
            context.setInputDriver(false);
            Verify.verify((context.getDriverInstanceCount().getAsInt() == localExchangeFactory.getBufferCount() ? 1 : 0) != 0, (String)"driver instance count must match the number of exchange partitions", (Object[])new Object[0]);
            return new PhysicalOperation((OperatorFactory)new LocalExchangeSourceOperator.LocalExchangeSourceOperatorFactory(context.getNextOperatorId(), node.getId(), localExchangeFactory), (Map<Symbol, Integer>)this.makeLayout(node), context, exchangeSourcePipelineExecutionStrategy);
        }

        @Override
        protected PhysicalOperation visitPlan(PlanNode node, LocalExecutionPlanContext context) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        private List<Type> getSourceOperatorTypes(PlanNode node, TypeProvider types) {
            return this.getSymbolTypes(node.getOutputSymbols(), types);
        }

        private List<Type> getSymbolTypes(List<Symbol> symbols, TypeProvider types) {
            return (List)symbols.stream().map(types::get).collect(ImmutableList.toImmutableList());
        }

        private AccumulatorFactory buildAccumulatorFactory(PhysicalOperation source, AggregationNode.Aggregation aggregation) {
            InternalAggregationFunction internalAggregationFunction = LocalExecutionPlanner.this.metadata.getAggregateFunctionImplementation(aggregation.getResolvedFunction());
            ArrayList<Integer> valueChannels = new ArrayList<Integer>();
            for (Expression argument : aggregation.getArguments()) {
                if (argument instanceof LambdaExpression) continue;
                Symbol argumentSymbol = Symbol.from(argument);
                valueChannels.add(source.getLayout().get(argumentSymbol));
            }
            List lambdaExpressions = (List)aggregation.getArguments().stream().filter(LambdaExpression.class::isInstance).map(LambdaExpression.class::cast).collect(ImmutableList.toImmutableList());
            List functionTypes = (List)aggregation.getResolvedFunction().getSignature().getArgumentTypes().stream().filter(FunctionType.class::isInstance).map(FunctionType.class::cast).collect(ImmutableList.toImmutableList());
            List<LambdaProvider> lambdaProviders = this.makeLambdaProviders(lambdaExpressions, internalAggregationFunction.getLambdaInterfaces(), functionTypes);
            Optional<Integer> maskChannel = aggregation.getMask().map(value -> source.getLayout().get(value));
            Object sortOrders = ImmutableList.of();
            Object sortKeys = ImmutableList.of();
            if (aggregation.getOrderingScheme().isPresent()) {
                OrderingScheme orderingScheme = aggregation.getOrderingScheme().get();
                sortKeys = orderingScheme.getOrderBy();
                sortOrders = (List)sortKeys.stream().map(orderingScheme::getOrdering).collect(ImmutableList.toImmutableList());
            }
            return internalAggregationFunction.bind(valueChannels, maskChannel, source.getTypes(), LocalExecutionPlanner.getChannelsForSymbols((List<Symbol>)sortKeys, source.getLayout()), (List<SortOrder>)sortOrders, LocalExecutionPlanner.this.pagesIndexFactory, aggregation.isDistinct(), LocalExecutionPlanner.this.joinCompiler, lambdaProviders, this.session);
        }

        private List<LambdaProvider> makeLambdaProviders(List<LambdaExpression> lambdaExpressions, List<Class<?>> lambdaInterfaces, List<FunctionType> functionTypes) {
            ArrayList<LambdaProvider> lambdaProviders = new ArrayList<LambdaProvider>();
            if (!lambdaExpressions.isEmpty()) {
                Verify.verify((lambdaExpressions.size() == functionTypes.size() ? 1 : 0) != 0);
                Verify.verify((lambdaExpressions.size() == lambdaInterfaces.size() ? 1 : 0) != 0);
                for (int i = 0; i < lambdaExpressions.size(); ++i) {
                    LambdaExpression lambdaExpression = lambdaExpressions.get(i);
                    FunctionType functionType = functionTypes.get(i);
                    Verify.verify((lambdaExpression.getArguments().size() == functionType.getArgumentTypes().size() ? 1 : 0) != 0);
                    HashMap<NodeRef, Type> lambdaArgumentExpressionTypes = new HashMap<NodeRef, Type>();
                    HashMap<Symbol, Type> lambdaArgumentSymbolTypes = new HashMap<Symbol, Type>();
                    for (int j = 0; j < lambdaExpression.getArguments().size(); ++j) {
                        LambdaArgumentDeclaration argument = (LambdaArgumentDeclaration)lambdaExpression.getArguments().get(j);
                        Type type = functionType.getArgumentTypes().get(j);
                        lambdaArgumentExpressionTypes.put(NodeRef.of((Node)argument), type);
                        lambdaArgumentSymbolTypes.put(new Symbol(argument.getName().getValue()), type);
                    }
                    ImmutableMap expressionTypes = ImmutableMap.builder().put((Object)NodeRef.of((Node)lambdaExpression), (Object)functionType).putAll(lambdaArgumentExpressionTypes).putAll(LocalExecutionPlanner.this.typeAnalyzer.getTypes(this.session, TypeProvider.copyOf(lambdaArgumentSymbolTypes), lambdaExpression.getBody())).build();
                    LambdaDefinitionExpression lambda = (LambdaDefinitionExpression)this.toRowExpression((Expression)lambdaExpression, (Map<NodeRef<Expression>, Type>)expressionTypes, (Map<Symbol, Integer>)ImmutableMap.of());
                    Class<? extends LambdaProvider> lambdaProviderClass = LambdaBytecodeGenerator.compileLambdaProvider(lambda, LocalExecutionPlanner.this.metadata, lambdaInterfaces.get(i));
                    try {
                        lambdaProviders.add(Reflection.constructorMethodHandle(lambdaProviderClass, ConnectorSession.class).invoke(this.session.toConnectorSession()));
                        continue;
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                }
            }
            return lambdaProviders;
        }

        private PhysicalOperation planGlobalAggregation(AggregationNode node, PhysicalOperation source, LocalExecutionPlanContext context) {
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            AggregationOperator.AggregationOperatorFactory operatorFactory = this.createAggregationOperatorFactory(node.getId(), node.getAggregations(), node.getStep(), 0, (ImmutableMap.Builder<Symbol, Integer>)outputMappings, source, context, node.getStep().isOutputPartial());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), context, source);
        }

        private AggregationOperator.AggregationOperatorFactory createAggregationOperatorFactory(PlanNodeId planNodeId, Map<Symbol, AggregationNode.Aggregation> aggregations, AggregationNode.Step step, int startOutputChannel, ImmutableMap.Builder<Symbol, Integer> outputMappings, PhysicalOperation source, LocalExecutionPlanContext context, boolean useSystemMemory) {
            int outputChannel = startOutputChannel;
            ImmutableList.Builder accumulatorFactories = ImmutableList.builder();
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : aggregations.entrySet()) {
                Symbol symbol = entry.getKey();
                AggregationNode.Aggregation aggregation = entry.getValue();
                accumulatorFactories.add((Object)this.buildAccumulatorFactory(source, aggregation));
                outputMappings.put((Object)symbol, (Object)outputChannel);
                ++outputChannel;
            }
            return new AggregationOperator.AggregationOperatorFactory(context.getNextOperatorId(), planNodeId, step, (List<AccumulatorFactory>)accumulatorFactories.build(), useSystemMemory);
        }

        private PhysicalOperation planGroupByAggregation(AggregationNode node, PhysicalOperation source, boolean spillEnabled, DataSize unspillMemoryLimit, LocalExecutionPlanContext context) {
            ImmutableMap.Builder mappings = ImmutableMap.builder();
            OperatorFactory operatorFactory = this.createHashAggregationOperatorFactory(node.getId(), node.getAggregations(), node.getGlobalGroupingSets(), node.getGroupingKeys(), node.getStep(), node.getHashSymbol(), node.getGroupIdSymbol(), source, node.hasDefaultOutput(), spillEnabled, node.isStreamable(), unspillMemoryLimit, context, 0, (ImmutableMap.Builder<Symbol, Integer>)mappings, 10000, Optional.of(LocalExecutionPlanner.this.maxPartialAggregationMemorySize), node.getStep().isOutputPartial());
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)mappings.build(), context, source);
        }

        private OperatorFactory createHashAggregationOperatorFactory(PlanNodeId planNodeId, Map<Symbol, AggregationNode.Aggregation> aggregations, Set<Integer> globalGroupingSets, List<Symbol> groupBySymbols, AggregationNode.Step step, Optional<Symbol> hashSymbol, Optional<Symbol> groupIdSymbol, PhysicalOperation source, boolean hasDefaultOutput, boolean spillEnabled, boolean isStreamable, DataSize unspillMemoryLimit, LocalExecutionPlanContext context, int startOutputChannel, ImmutableMap.Builder<Symbol, Integer> outputMappings, int expectedGroups, Optional<DataSize> maxPartialAggregationMemorySize, boolean useSystemMemory) {
            ArrayList aggregationOutputSymbols = new ArrayList();
            ArrayList<AccumulatorFactory> accumulatorFactories = new ArrayList<AccumulatorFactory>();
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry2 : aggregations.entrySet()) {
                Iterator symbol = entry2.getKey();
                AggregationNode.Aggregation aggregation = entry2.getValue();
                accumulatorFactories.add(this.buildAccumulatorFactory(source, aggregation));
                aggregationOutputSymbols.add(symbol);
            }
            int channel = startOutputChannel;
            Optional<Integer> groupIdChannel = Optional.empty();
            for (Symbol symbol : groupBySymbols) {
                outputMappings.put((Object)symbol, (Object)channel);
                if (groupIdSymbol.isPresent() && groupIdSymbol.get().equals(symbol)) {
                    groupIdChannel = Optional.of(channel);
                }
                ++channel;
            }
            if (hashSymbol.isPresent()) {
                outputMappings.put((Object)hashSymbol.get(), (Object)channel++);
            }
            for (Symbol symbol : aggregationOutputSymbols) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            List<Integer> groupByChannels = LocalExecutionPlanner.getChannelsForSymbols(groupBySymbols, source.getLayout());
            List list = (List)groupByChannels.stream().map(entry -> source.getTypes().get((int)entry)).collect(ImmutableList.toImmutableList());
            if (isStreamable) {
                return StreamingAggregationOperator.createOperatorFactory(context.getNextOperatorId(), planNodeId, source.getTypes(), list, groupByChannels, step, accumulatorFactories, LocalExecutionPlanner.this.joinCompiler);
            }
            Optional<Integer> hashChannel = hashSymbol.map(LocalExecutionPlanner.channelGetter(source));
            return new HashAggregationOperator.HashAggregationOperatorFactory(context.getNextOperatorId(), planNodeId, list, groupByChannels, (List<Integer>)ImmutableList.copyOf(globalGroupingSets), step, hasDefaultOutput, accumulatorFactories, hashChannel, groupIdChannel, expectedGroups, maxPartialAggregationMemorySize, spillEnabled, unspillMemoryLimit, LocalExecutionPlanner.this.spillerFactory, LocalExecutionPlanner.this.joinCompiler, useSystemMemory);
        }

        private static /* synthetic */ StatisticAggregationsDescriptor lambda$visitTableFinish$46(Map aggregationOutput, StatisticAggregationsDescriptor desc) {
            return desc.map(aggregationOutput::get);
        }

        private static /* synthetic */ PartitionedLookupSourceFactory lambda$createLookupSourceFactory$31(PhysicalOperation buildSource, ImmutableList buildOutputTypes, List buildChannels, int partitionCount, boolean buildOuter, Lifespan lifespan) {
            return new PartitionedLookupSourceFactory(buildSource.getTypes(), (List<Type>)buildOutputTypes, (List)buildChannels.stream().map(buildSource.getTypes()::get).collect(ImmutableList.toImmutableList()), partitionCount, buildOuter);
        }

        private /* synthetic */ RecordSet lambda$visitIndexSource$9(List overlappingFieldSets, List remappedProbeKeyChannels, RecordSet recordSet) {
            if (!overlappingFieldSets.isEmpty()) {
                recordSet = new FieldSetFilteringRecordSet(LocalExecutionPlanner.this.metadata, recordSet, overlappingFieldSets);
            }
            return new MappedRecordSet(recordSet, remappedProbeKeyChannels);
        }
    }

    public static class LocalExecutionPlan {
        private final List<DriverFactory> driverFactories;
        private final List<PlanNodeId> partitionedSourceOrder;
        private final StageExecutionDescriptor stageExecutionDescriptor;

        public LocalExecutionPlan(List<DriverFactory> driverFactories, List<PlanNodeId> partitionedSourceOrder, StageExecutionDescriptor stageExecutionDescriptor) {
            this.driverFactories = ImmutableList.copyOf((Collection)Objects.requireNonNull(driverFactories, "driverFactories is null"));
            this.partitionedSourceOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionedSourceOrder, "partitionedSourceOrder is null"));
            this.stageExecutionDescriptor = Objects.requireNonNull(stageExecutionDescriptor, "stageExecutionDescriptor is null");
        }

        public List<DriverFactory> getDriverFactories() {
            return this.driverFactories;
        }

        public List<PlanNodeId> getPartitionedSourceOrder() {
            return this.partitionedSourceOrder;
        }

        public StageExecutionDescriptor getStageExecutionDescriptor() {
            return this.stageExecutionDescriptor;
        }
    }

    private static class IndexSourceContext {
        private final SetMultimap<Symbol, Integer> indexLookupToProbeInput;

        public IndexSourceContext(SetMultimap<Symbol, Integer> indexLookupToProbeInput) {
            this.indexLookupToProbeInput = ImmutableSetMultimap.copyOf((Multimap)((Multimap)Objects.requireNonNull(indexLookupToProbeInput, "indexLookupToProbeInput is null")));
        }

        private SetMultimap<Symbol, Integer> getIndexLookupToProbeInput() {
            return this.indexLookupToProbeInput;
        }
    }

    private static class LocalExecutionPlanContext {
        private final TaskContext taskContext;
        private final TypeProvider types;
        private final List<DriverFactory> driverFactories;
        private final Optional<IndexSourceContext> indexSourceContext;
        private final LocalDynamicFiltersCollector dynamicFiltersCollector;
        private final AtomicInteger nextPipelineId;
        private int nextOperatorId;
        private boolean inputDriver = true;
        private OptionalInt driverInstanceCount = OptionalInt.empty();

        public LocalExecutionPlanContext(TaskContext taskContext, TypeProvider types) {
            this(taskContext, types, new ArrayList<DriverFactory>(), Optional.empty(), new LocalDynamicFiltersCollector(), new AtomicInteger(0));
        }

        private LocalExecutionPlanContext(TaskContext taskContext, TypeProvider types, List<DriverFactory> driverFactories, Optional<IndexSourceContext> indexSourceContext, LocalDynamicFiltersCollector dynamicFiltersCollector, AtomicInteger nextPipelineId) {
            this.taskContext = taskContext;
            this.types = types;
            this.driverFactories = driverFactories;
            this.indexSourceContext = indexSourceContext;
            this.dynamicFiltersCollector = dynamicFiltersCollector;
            this.nextPipelineId = nextPipelineId;
        }

        public void addDriverFactory(boolean inputDriver, boolean outputDriver, List<OperatorFactory> operatorFactories, OptionalInt driverInstances, PipelineExecutionStrategy pipelineExecutionStrategy) {
            if (pipelineExecutionStrategy == PipelineExecutionStrategy.GROUPED_EXECUTION) {
                OperatorFactory firstOperatorFactory = operatorFactories.get(0);
                if (inputDriver) {
                    Preconditions.checkArgument((firstOperatorFactory instanceof ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory || firstOperatorFactory instanceof TableScanOperator.TableScanOperatorFactory ? 1 : 0) != 0);
                } else {
                    Preconditions.checkArgument((firstOperatorFactory instanceof LocalExchangeSourceOperator.LocalExchangeSourceOperatorFactory || firstOperatorFactory instanceof LookupOuterOperator.LookupOuterOperatorFactory ? 1 : 0) != 0);
                }
            }
            if (SystemSessionProperties.isLateMaterializationEnabled(this.taskContext.getSession())) {
                operatorFactories = WorkProcessorPipelineSourceOperator.convertOperators(this.getNextOperatorId(), operatorFactories);
            }
            this.driverFactories.add(new DriverFactory(this.getNextPipelineId(), inputDriver, outputDriver, operatorFactories, driverInstances, pipelineExecutionStrategy));
        }

        private List<DriverFactory> getDriverFactories() {
            return ImmutableList.copyOf(this.driverFactories);
        }

        public Session getSession() {
            return this.taskContext.getSession();
        }

        public StageId getStageId() {
            return this.taskContext.getTaskId().getStageId();
        }

        public TaskId getTaskId() {
            return this.taskContext.getTaskId();
        }

        public TypeProvider getTypes() {
            return this.types;
        }

        public LocalDynamicFiltersCollector getDynamicFiltersCollector() {
            return this.dynamicFiltersCollector;
        }

        private void addLocalDynamicFilters(Map<DynamicFilterId, Domain> dynamicTupleDomain) {
            this.dynamicFiltersCollector.collectDynamicFilterDomains(dynamicTupleDomain);
        }

        private void addCoordinatorDynamicFilters(Map<DynamicFilterId, Domain> dynamicTupleDomain) {
            this.taskContext.updateDomains(dynamicTupleDomain);
        }

        public Optional<IndexSourceContext> getIndexSourceContext() {
            return this.indexSourceContext;
        }

        private int getNextPipelineId() {
            return this.nextPipelineId.getAndIncrement();
        }

        private int getNextOperatorId() {
            return this.nextOperatorId++;
        }

        private boolean isInputDriver() {
            return this.inputDriver;
        }

        private void setInputDriver(boolean inputDriver) {
            this.inputDriver = inputDriver;
        }

        public LocalExecutionPlanContext createSubContext() {
            Preconditions.checkState((boolean)this.indexSourceContext.isEmpty(), (Object)"index build plan cannot have sub-contexts");
            return new LocalExecutionPlanContext(this.taskContext, this.types, this.driverFactories, this.indexSourceContext, this.dynamicFiltersCollector, this.nextPipelineId);
        }

        public LocalExecutionPlanContext createIndexSourceSubContext(IndexSourceContext indexSourceContext) {
            return new LocalExecutionPlanContext(this.taskContext, this.types, this.driverFactories, Optional.of(indexSourceContext), this.dynamicFiltersCollector, this.nextPipelineId);
        }

        public OptionalInt getDriverInstanceCount() {
            return this.driverInstanceCount;
        }

        public void setDriverInstanceCount(int driverInstanceCount) {
            Preconditions.checkArgument((driverInstanceCount > 0 ? 1 : 0) != 0, (Object)"driverInstanceCount must be > 0");
            if (this.driverInstanceCount.isPresent()) {
                Preconditions.checkState((this.driverInstanceCount.getAsInt() == driverInstanceCount ? 1 : 0) != 0, (Object)("driverInstance count already set to " + this.driverInstanceCount.getAsInt()));
            }
            this.driverInstanceCount = OptionalInt.of(driverInstanceCount);
        }
    }
}

