/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.Field;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.GroupingOperation;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.SymbolReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class SymbolAllocator {
    private final Map<Symbol, Type> symbols;
    private int nextId;

    public SymbolAllocator() {
        this.symbols = new HashMap<Symbol, Type>();
    }

    public SymbolAllocator(Map<Symbol, Type> initial) {
        this.symbols = new HashMap<Symbol, Type>(initial);
    }

    public Symbol newSymbol(Symbol symbolHint) {
        return this.newSymbol(symbolHint, null);
    }

    public Symbol newSymbol(Symbol symbolHint, String suffix) {
        Preconditions.checkArgument((boolean)this.symbols.containsKey(symbolHint), (Object)"symbolHint not in symbols map");
        return this.newSymbol(symbolHint.getName(), this.symbols.get(symbolHint), suffix);
    }

    public Symbol newSymbol(String nameHint, Type type) {
        return this.newSymbol(nameHint, type, null);
    }

    public Symbol newHashSymbol() {
        return this.newSymbol("$hashValue", (Type)BigintType.BIGINT);
    }

    public Symbol newSymbol(String nameHint, Type type, String suffix) {
        String tail;
        Objects.requireNonNull(nameHint, "name is null");
        Objects.requireNonNull(type, "type is null");
        nameHint = nameHint.toLowerCase(Locale.ENGLISH);
        int index = nameHint.lastIndexOf("_");
        if (index > 0 && (Ints.tryParse((String)(tail = nameHint.substring(index + 1))) != null || index == nameHint.length() - 1)) {
            nameHint = nameHint.substring(0, index);
        }
        Object unique = nameHint;
        if (suffix != null) {
            unique = (String)unique + "$" + suffix;
        }
        Object attempt = unique;
        while (this.symbols.containsKey(new Symbol((String)attempt))) {
            attempt = (String)unique + "_" + this.nextId();
        }
        Symbol symbol = new Symbol((String)attempt);
        this.symbols.put(symbol, type);
        return symbol;
    }

    public Symbol newSymbol(Expression expression, Type type) {
        return this.newSymbol(expression, type, null);
    }

    public Symbol newSymbol(Expression expression, Type type, String suffix) {
        String nameHint = "expr";
        if (expression instanceof Identifier) {
            nameHint = ((Identifier)expression).getValue();
        } else if (expression instanceof FunctionCall) {
            FunctionCall functionCall = (FunctionCall)expression;
            nameHint = ResolvedFunction.extractFunctionName(functionCall.getName());
        } else if (expression instanceof SymbolReference) {
            nameHint = ((SymbolReference)expression).getName();
        } else if (expression instanceof GroupingOperation) {
            nameHint = "grouping";
        }
        return this.newSymbol(nameHint, type, suffix);
    }

    public Symbol newSymbol(Field field) {
        String nameHint = field.getName().orElse("field");
        return this.newSymbol(nameHint, field.getType());
    }

    public TypeProvider getTypes() {
        return TypeProvider.viewOf(this.symbols);
    }

    private int nextId() {
        return this.nextId++;
    }
}

