/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.SetOperationNodeTranslator;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.IntersectNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.ProjectNode;
import java.util.Objects;

public class ImplementIntersectAsUnion
implements Rule<IntersectNode> {
    private static final Pattern<IntersectNode> PATTERN = Patterns.intersect();
    private final Metadata metadata;

    public ImplementIntersectAsUnion(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<IntersectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(IntersectNode node, Captures captures, Rule.Context context) {
        SetOperationNodeTranslator translator = new SetOperationNodeTranslator(this.metadata, context.getSymbolAllocator(), context.getIdAllocator());
        SetOperationNodeTranslator.TranslationResult result = translator.makeSetContainmentPlan(node);
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), new FilterNode(context.getIdAllocator().getNextId(), result.getPlanNode(), ExpressionUtils.and(result.getPresentExpressions())), Assignments.identity(node.getOutputSymbols())));
    }
}

