/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Marker;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.DomainTranslator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.RowNumberNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class PushPredicateThroughProjectIntoRowNumber
implements Rule<FilterNode> {
    private static final Capture<ProjectNode> PROJECT = Capture.newCapture();
    private static final Capture<RowNumberNode> ROW_NUMBER = Capture.newCapture();
    private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.project().matching(ProjectNode::isIdentity).capturedAs(PROJECT).with(Patterns.source().matching(Patterns.rowNumber().capturedAs(ROW_NUMBER)))));
    private final Metadata metadata;

    public PushPredicateThroughProjectIntoRowNumber(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(FilterNode filter, Captures captures, Rule.Context context) {
        ProjectNode project = (ProjectNode)captures.get(PROJECT);
        RowNumberNode rowNumber = (RowNumberNode)captures.get(ROW_NUMBER);
        Symbol rowNumberSymbol = rowNumber.getRowNumberSymbol();
        if (!project.getAssignments().getSymbols().contains(rowNumberSymbol)) {
            return Rule.Result.empty();
        }
        DomainTranslator.ExtractionResult extractionResult = DomainTranslator.fromPredicate(this.metadata, context.getSession(), filter.getPredicate(), context.getSymbolAllocator().getTypes());
        TupleDomain<Symbol> tupleDomain = extractionResult.getTupleDomain();
        OptionalInt upperBound = PushPredicateThroughProjectIntoRowNumber.extractUpperBound(tupleDomain, rowNumberSymbol);
        if (upperBound.isEmpty()) {
            return Rule.Result.empty();
        }
        if (upperBound.getAsInt() <= 0) {
            return Rule.Result.ofPlanNode(new ValuesNode(filter.getId(), filter.getOutputSymbols(), (List<List<Expression>>)ImmutableList.of()));
        }
        boolean updatedMaxRowCountPerPartition = false;
        if (rowNumber.getMaxRowCountPerPartition().isEmpty() || rowNumber.getMaxRowCountPerPartition().get() > upperBound.getAsInt()) {
            rowNumber = new RowNumberNode(rowNumber.getId(), rowNumber.getSource(), rowNumber.getPartitionBy(), rowNumber.isOrderSensitive(), rowNumber.getRowNumberSymbol(), Optional.of(upperBound.getAsInt()), rowNumber.getHashSymbol());
            project = (ProjectNode)project.replaceChildren((List<PlanNode>)ImmutableList.of((Object)rowNumber));
            updatedMaxRowCountPerPartition = true;
        }
        if (!PushPredicateThroughProjectIntoRowNumber.allRowNumberValuesInDomain(tupleDomain, rowNumberSymbol, rowNumber.getMaxRowCountPerPartition().get().intValue())) {
            if (updatedMaxRowCountPerPartition) {
                return Rule.Result.ofPlanNode(filter.replaceChildren((List<PlanNode>)ImmutableList.of((Object)project)));
            }
            return Rule.Result.empty();
        }
        TupleDomain newTupleDomain = tupleDomain.filter((symbol, domain) -> !symbol.equals(rowNumberSymbol));
        Expression newPredicate = ExpressionUtils.combineConjuncts(this.metadata, extractionResult.getRemainingExpression(), new DomainTranslator(this.metadata).toPredicate((TupleDomain<Symbol>)newTupleDomain));
        if (newPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
            return Rule.Result.ofPlanNode(project);
        }
        return Rule.Result.ofPlanNode(new FilterNode(filter.getId(), project, newPredicate));
    }

    private static OptionalInt extractUpperBound(TupleDomain<Symbol> tupleDomain, Symbol symbol) {
        if (tupleDomain.isNone()) {
            return OptionalInt.empty();
        }
        Domain rowNumberDomain = (Domain)((Map)tupleDomain.getDomains().get()).get(symbol);
        if (rowNumberDomain == null) {
            return OptionalInt.empty();
        }
        ValueSet values = rowNumberDomain.getValues();
        if (values.isAll() || values.isNone() || values.getRanges().getRangeCount() <= 0) {
            return OptionalInt.empty();
        }
        Range span = values.getRanges().getSpan();
        if (span.getHigh().isUpperUnbounded()) {
            return OptionalInt.empty();
        }
        long upperBound = (Long)span.getHigh().getValue();
        if (span.getHigh().getBound() == Marker.Bound.BELOW) {
            --upperBound;
        }
        if (upperBound >= Integer.MIN_VALUE && upperBound <= Integer.MAX_VALUE) {
            return OptionalInt.of(Math.toIntExact(upperBound));
        }
        return OptionalInt.empty();
    }

    private static boolean allRowNumberValuesInDomain(TupleDomain<Symbol> tupleDomain, Symbol symbol, long upperBound) {
        if (tupleDomain.isNone()) {
            return false;
        }
        Domain domain = (Domain)((Map)tupleDomain.getDomains().get()).get(symbol);
        if (domain == null) {
            return true;
        }
        return domain.getValues().contains(ValueSet.ofRanges((Range)Range.range((Type)domain.getType(), (Object)0L, (boolean)true, (Object)upperBound, (boolean)true), (Range[])new Range[0]));
    }
}

