/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.FunctionId;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Marker;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.planner.DomainTranslator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.TopNRowNumberNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class PushPredicateThroughProjectIntoWindow
implements Rule<FilterNode> {
    private static final Capture<ProjectNode> PROJECT = Capture.newCapture();
    private static final Capture<WindowNode> WINDOW = Capture.newCapture();
    private final Pattern<FilterNode> pattern;
    private final Metadata metadata;

    public PushPredicateThroughProjectIntoWindow(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.pattern = Patterns.filter().with(Patterns.source().matching(Patterns.project().matching(ProjectNode::isIdentity).capturedAs(PROJECT).with(Patterns.source().matching(Patterns.window().matching(window -> {
            if (window.getOrderingScheme().isEmpty()) {
                return false;
            }
            if (window.getWindowFunctions().size() != 1) {
                return false;
            }
            FunctionId functionId = ((WindowNode.Function)Iterables.getOnlyElement(window.getWindowFunctions().values())).getResolvedFunction().getFunctionId();
            return functionId.equals(metadata.resolveFunction(QualifiedName.of((String)"row_number"), (List<TypeSignatureProvider>)ImmutableList.of()).getFunctionId());
        }).capturedAs(WINDOW)))));
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isOptimizeTopNRowNumber(session);
    }

    @Override
    public Rule.Result apply(FilterNode filter, Captures captures, Rule.Context context) {
        ProjectNode project = (ProjectNode)captures.get(PROJECT);
        WindowNode window = (WindowNode)captures.get(WINDOW);
        Symbol rowNumberSymbol = (Symbol)Iterables.getOnlyElement(window.getWindowFunctions().keySet());
        if (!project.getAssignments().getSymbols().contains(rowNumberSymbol)) {
            return Rule.Result.empty();
        }
        DomainTranslator.ExtractionResult extractionResult = DomainTranslator.fromPredicate(this.metadata, context.getSession(), filter.getPredicate(), context.getSymbolAllocator().getTypes());
        TupleDomain<Symbol> tupleDomain = extractionResult.getTupleDomain();
        OptionalInt upperBound = PushPredicateThroughProjectIntoWindow.extractUpperBound(tupleDomain, rowNumberSymbol);
        if (upperBound.isEmpty()) {
            return Rule.Result.empty();
        }
        if (upperBound.getAsInt() <= 0) {
            return Rule.Result.ofPlanNode(new ValuesNode(filter.getId(), filter.getOutputSymbols(), (List<List<Expression>>)ImmutableList.of()));
        }
        project = (ProjectNode)project.replaceChildren((List<PlanNode>)ImmutableList.of((Object)new TopNRowNumberNode(window.getId(), window.getSource(), window.getSpecification(), rowNumberSymbol, upperBound.getAsInt(), false, Optional.empty())));
        if (!PushPredicateThroughProjectIntoWindow.allRowNumberValuesInDomain(tupleDomain, rowNumberSymbol, upperBound.getAsInt())) {
            return Rule.Result.ofPlanNode(filter.replaceChildren((List<PlanNode>)ImmutableList.of((Object)project)));
        }
        TupleDomain newTupleDomain = tupleDomain.filter((symbol, domain) -> !symbol.equals(rowNumberSymbol));
        Expression newPredicate = ExpressionUtils.combineConjuncts(this.metadata, extractionResult.getRemainingExpression(), new DomainTranslator(this.metadata).toPredicate((TupleDomain<Symbol>)newTupleDomain));
        if (newPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
            return Rule.Result.ofPlanNode(project);
        }
        return Rule.Result.ofPlanNode(new FilterNode(filter.getId(), project, newPredicate));
    }

    private static OptionalInt extractUpperBound(TupleDomain<Symbol> tupleDomain, Symbol symbol) {
        if (tupleDomain.isNone()) {
            return OptionalInt.empty();
        }
        Domain rowNumberDomain = (Domain)((Map)tupleDomain.getDomains().get()).get(symbol);
        if (rowNumberDomain == null) {
            return OptionalInt.empty();
        }
        ValueSet values = rowNumberDomain.getValues();
        if (values.isAll() || values.isNone() || values.getRanges().getRangeCount() <= 0) {
            return OptionalInt.empty();
        }
        Range span = values.getRanges().getSpan();
        if (span.getHigh().isUpperUnbounded()) {
            return OptionalInt.empty();
        }
        long upperBound = (Long)span.getHigh().getValue();
        if (span.getHigh().getBound() == Marker.Bound.BELOW) {
            --upperBound;
        }
        if (upperBound >= Integer.MIN_VALUE && upperBound <= Integer.MAX_VALUE) {
            return OptionalInt.of(Math.toIntExact(upperBound));
        }
        return OptionalInt.empty();
    }

    private static boolean allRowNumberValuesInDomain(TupleDomain<Symbol> tupleDomain, Symbol symbol, long upperBound) {
        if (tupleDomain.isNone()) {
            return false;
        }
        Domain domain = (Domain)((Map)tupleDomain.getDomains().get()).get(symbol);
        if (domain == null) {
            return true;
        }
        return domain.getValues().contains(ValueSet.ofRanges((Range)Range.range((Type)domain.getType(), (Object)0L, (boolean)true, (Object)upperBound, (boolean)true), (Range[])new Range[0]));
    }
}

