/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.spi.connector.SampleType;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.SampleNode;
import io.prestosql.sql.planner.plan.TableScanNode;

public class PushSampleIntoTableScan
implements Rule<SampleNode> {
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Pattern<SampleNode> PATTERN = Patterns.sample().with(Patterns.Sample.sampleType().equalTo((Object)SampleNode.Type.SYSTEM)).with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));
    private final Metadata metadata;

    public PushSampleIntoTableScan(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Pattern<SampleNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isAllowPushdownIntoConnectors(session);
    }

    @Override
    public Rule.Result apply(SampleNode sample, Captures captures, Rule.Context context) {
        TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
        return this.metadata.applySample(context.getSession(), tableScan.getTable(), PushSampleIntoTableScan.getSamplingType(sample.getSampleType()), sample.getSampleRatio()).map(result -> Rule.Result.ofPlanNode(new TableScanNode(tableScan.getId(), (TableHandle)result, tableScan.getOutputSymbols(), tableScan.getAssignments(), tableScan.getEnforcedConstraint()))).orElseGet(Rule.Result::empty);
    }

    private static SampleType getSamplingType(SampleNode.Type sampleNodeType) {
        switch (sampleNodeType) {
            case SYSTEM: {
                return SampleType.SYSTEM;
            }
            case BERNOULLI: {
                return SampleType.BERNOULLI;
            }
        }
        throw new UnsupportedOperationException("Not yet implemented for " + sampleNodeType);
    }
}

