/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.spi.connector.SortItem;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.plan.TopNNode;
import java.util.List;
import java.util.Map;

public class PushTopNIntoTableScan
implements Rule<TopNNode> {
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Pattern<TopNNode> PATTERN = Patterns.topN().with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));
    private final Metadata metadata;

    public PushTopNIntoTableScan(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Pattern<TopNNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TopNNode topNNode, Captures captures, Rule.Context context) {
        TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
        long topNCount = topNNode.getCount();
        List<SortItem> sortItems = topNNode.getOrderingScheme().toSortItems();
        Map assignments = (Map)tableScan.getAssignments().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((Symbol)entry.getKey()).getName(), Map.Entry::getValue));
        return this.metadata.applyTopN(context.getSession(), tableScan.getTable(), topNCount, sortItems, assignments).map(result -> {
            PlanNode node = TableScanNode.newInstance(context.getIdAllocator().getNextId(), (TableHandle)result.getHandle(), tableScan.getOutputSymbols(), tableScan.getAssignments());
            if (!result.isTopNGuaranteed()) {
                node = new TopNNode(topNNode.getId(), node, topNNode.getCount(), topNNode.getOrderingScheme(), TopNNode.Step.FINAL);
            }
            return Rule.Result.ofPlanNode(node);
        }).orElseGet(Rule.Result::empty);
    }
}

