/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.planprinter;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.cost.PlanCostEstimate;
import io.prestosql.cost.PlanNodeStatsAndCostSummary;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.StatsAndCosts;
import io.prestosql.execution.StageInfo;
import io.prestosql.execution.StageStats;
import io.prestosql.execution.TableInfo;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.TableHandle;
import io.prestosql.operator.StageExecutionDescriptor;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Marker;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.statistics.ColumnStatisticMetadata;
import io.prestosql.spi.statistics.TableStatisticType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.Partitioning;
import io.prestosql.sql.planner.PartitioningScheme;
import io.prestosql.sql.planner.PlanFragment;
import io.prestosql.sql.planner.SubPlan;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SystemPartitioningHandle;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.GroupReference;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.ApplyNode;
import io.prestosql.sql.planner.plan.AssignUniqueId;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.CorrelatedJoinNode;
import io.prestosql.sql.planner.plan.DeleteNode;
import io.prestosql.sql.planner.plan.DistinctLimitNode;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.EnforceSingleRowNode;
import io.prestosql.sql.planner.plan.ExceptNode;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.ExplainAnalyzeNode;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.GroupIdNode;
import io.prestosql.sql.planner.plan.IndexJoinNode;
import io.prestosql.sql.planner.plan.IndexSourceNode;
import io.prestosql.sql.planner.plan.IntersectNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.MarkDistinctNode;
import io.prestosql.sql.planner.plan.OffsetNode;
import io.prestosql.sql.planner.plan.OutputNode;
import io.prestosql.sql.planner.plan.PlanFragmentId;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.RemoteSourceNode;
import io.prestosql.sql.planner.plan.RowNumberNode;
import io.prestosql.sql.planner.plan.SampleNode;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import io.prestosql.sql.planner.plan.SortNode;
import io.prestosql.sql.planner.plan.SpatialJoinNode;
import io.prestosql.sql.planner.plan.StatisticAggregations;
import io.prestosql.sql.planner.plan.StatisticAggregationsDescriptor;
import io.prestosql.sql.planner.plan.StatisticsWriterNode;
import io.prestosql.sql.planner.plan.TableDeleteNode;
import io.prestosql.sql.planner.plan.TableFinishNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.plan.TableWriterNode;
import io.prestosql.sql.planner.plan.TopNNode;
import io.prestosql.sql.planner.plan.TopNRowNumberNode;
import io.prestosql.sql.planner.plan.UnionNode;
import io.prestosql.sql.planner.plan.UnnestNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.planner.planprinter.JsonRenderer;
import io.prestosql.sql.planner.planprinter.NodeRepresentation;
import io.prestosql.sql.planner.planprinter.PlanNodeStats;
import io.prestosql.sql.planner.planprinter.PlanNodeStatsSummarizer;
import io.prestosql.sql.planner.planprinter.PlanRepresentation;
import io.prestosql.sql.planner.planprinter.TableInfoSupplier;
import io.prestosql.sql.planner.planprinter.TextRenderer;
import io.prestosql.sql.planner.planprinter.ValuePrinter;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.util.GraphvizPrinter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PlanPrinter {
    private final PlanRepresentation representation;
    private final Function<TableScanNode, TableInfo> tableInfoSupplier;
    private final ValuePrinter valuePrinter;

    private PlanPrinter(PlanNode planRoot, TypeProvider types, Optional<StageExecutionDescriptor> stageExecutionStrategy, Function<TableScanNode, TableInfo> tableInfoSupplier, ValuePrinter valuePrinter, StatsAndCosts estimatedStatsAndCosts, Optional<Map<PlanNodeId, PlanNodeStats>> stats) {
        Objects.requireNonNull(planRoot, "planRoot is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(tableInfoSupplier, "tableInfoSupplier is null");
        Objects.requireNonNull(valuePrinter, "valuePrinter is null");
        Objects.requireNonNull(estimatedStatsAndCosts, "estimatedStatsAndCosts is null");
        Objects.requireNonNull(stats, "stats is null");
        this.tableInfoSupplier = tableInfoSupplier;
        this.valuePrinter = valuePrinter;
        Optional<Duration> totalScheduledTime = stats.map(s -> new Duration((double)s.values().stream().mapToLong(planNode -> planNode.getPlanNodeScheduledTime().toMillis()).sum(), TimeUnit.MILLISECONDS));
        Optional<Duration> totalCpuTime = stats.map(s -> new Duration((double)s.values().stream().mapToLong(planNode -> planNode.getPlanNodeCpuTime().toMillis()).sum(), TimeUnit.MILLISECONDS));
        this.representation = new PlanRepresentation(planRoot, types, totalCpuTime, totalScheduledTime);
        Visitor visitor = new Visitor(stageExecutionStrategy, types, estimatedStatsAndCosts, stats);
        planRoot.accept(visitor, null);
    }

    private String toText(boolean verbose, int level) {
        return new TextRenderer(verbose, level).render(this.representation);
    }

    private String toJson() {
        return new JsonRenderer().render(this.representation);
    }

    public static String jsonFragmentPlan(PlanNode root, Map<Symbol, Type> symbols, Metadata metadata, Session session) {
        TypeProvider typeProvider = TypeProvider.copyOf((Map)symbols.entrySet().stream().distinct().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
        TableInfoSupplier tableInfoSupplier = new TableInfoSupplier(metadata, session);
        ValuePrinter valuePrinter = new ValuePrinter(metadata, session);
        return new PlanPrinter(root, typeProvider, Optional.empty(), tableInfoSupplier, valuePrinter, StatsAndCosts.empty(), Optional.empty()).toJson();
    }

    public static String textLogicalPlan(PlanNode plan, TypeProvider types, Metadata metadata, StatsAndCosts estimatedStatsAndCosts, Session session, int level, boolean verbose) {
        TableInfoSupplier tableInfoSupplier = new TableInfoSupplier(metadata, session);
        ValuePrinter valuePrinter = new ValuePrinter(metadata, session);
        return new PlanPrinter(plan, types, Optional.empty(), tableInfoSupplier, valuePrinter, estimatedStatsAndCosts, Optional.empty()).toText(verbose, level);
    }

    public static String textDistributedPlan(StageInfo outputStageInfo, Metadata metadata, Session session, boolean verbose) {
        return PlanPrinter.textDistributedPlan(outputStageInfo, new ValuePrinter(metadata, session), verbose);
    }

    public static String textDistributedPlan(StageInfo outputStageInfo, ValuePrinter valuePrinter, boolean verbose) {
        Map tableInfos = (Map)StageInfo.getAllStages(Optional.of(outputStageInfo)).stream().map(StageInfo::getTables).map(Map::entrySet).flatMap(Collection::stream).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        StringBuilder builder = new StringBuilder();
        List<StageInfo> allStages = StageInfo.getAllStages(Optional.of(outputStageInfo));
        List allFragments = (List)allStages.stream().map(StageInfo::getPlan).collect(ImmutableList.toImmutableList());
        Map<PlanNodeId, PlanNodeStats> aggregatedStats = PlanNodeStatsSummarizer.aggregateStageStats(allStages);
        for (StageInfo stageInfo : allStages) {
            builder.append(PlanPrinter.formatFragment(tableScanNode -> (TableInfo)tableInfos.get(tableScanNode.getId()), valuePrinter, stageInfo.getPlan(), Optional.of(stageInfo), Optional.of(aggregatedStats), verbose, allFragments));
        }
        return builder.toString();
    }

    public static String textDistributedPlan(SubPlan plan, Metadata metadata, Session session, boolean verbose) {
        TableInfoSupplier tableInfoSupplier = new TableInfoSupplier(metadata, session);
        ValuePrinter valuePrinter = new ValuePrinter(metadata, session);
        StringBuilder builder = new StringBuilder();
        for (PlanFragment fragment : plan.getAllFragments()) {
            builder.append(PlanPrinter.formatFragment(tableInfoSupplier, valuePrinter, fragment, Optional.empty(), Optional.empty(), verbose, plan.getAllFragments()));
        }
        return builder.toString();
    }

    private static String formatFragment(Function<TableScanNode, TableInfo> tableInfoSupplier, ValuePrinter valuePrinter, PlanFragment fragment, Optional<StageInfo> stageInfo, Optional<Map<PlanNodeId, PlanNodeStats>> planNodeStats, boolean verbose, List<PlanFragment> allFragments) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Fragment %s [%s]\n", fragment.getId(), fragment.getPartitioning()));
        if (stageInfo.isPresent()) {
            StageStats stageStats = stageInfo.get().getStageStats();
            double avgPositionsPerTask = stageInfo.get().getTasks().stream().mapToLong(task -> task.getStats().getProcessedInputPositions()).average().orElse(Double.NaN);
            double squaredDifferences = stageInfo.get().getTasks().stream().mapToDouble(task -> Math.pow((double)task.getStats().getProcessedInputPositions() - avgPositionsPerTask, 2.0)).sum();
            double sdAmongTasks = Math.sqrt(squaredDifferences / (double)stageInfo.get().getTasks().size());
            builder.append(TextRenderer.indentString(1)).append(String.format("CPU: %s, Scheduled: %s, Input: %s (%s); per task: avg.: %s std.dev.: %s, Output: %s (%s)\n", stageStats.getTotalCpuTime().convertToMostSuccinctTimeUnit(), stageStats.getTotalScheduledTime().convertToMostSuccinctTimeUnit(), TextRenderer.formatPositions(stageStats.getProcessedInputPositions()), stageStats.getProcessedInputDataSize(), TextRenderer.formatDouble(avgPositionsPerTask), TextRenderer.formatDouble(sdAmongTasks), TextRenderer.formatPositions(stageStats.getOutputPositions()), stageStats.getOutputDataSize()));
        }
        PartitioningScheme partitioningScheme = fragment.getPartitioningScheme();
        builder.append(TextRenderer.indentString(1)).append(String.format("Output layout: [%s]\n", Joiner.on((String)", ").join(partitioningScheme.getOutputLayout())));
        boolean replicateNullsAndAny = partitioningScheme.isReplicateNullsAndAny();
        List arguments = (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> {
            if (argument.isConstant()) {
                NullableValue constant = argument.getConstant();
                String printableValue = valuePrinter.castToVarchar(constant.getType(), constant.getValue());
                return constant.getType().getDisplayName() + "(" + printableValue + ")";
            }
            return argument.getColumn().toString();
        }).collect(ImmutableList.toImmutableList());
        builder.append(TextRenderer.indentString(1));
        if (replicateNullsAndAny) {
            builder.append(String.format("Output partitioning: %s (replicate nulls and any) [%s]%s\n", partitioningScheme.getPartitioning().getHandle(), Joiner.on((String)", ").join((Iterable)arguments), PlanPrinter.formatHash(partitioningScheme.getHashColumn())));
        } else {
            builder.append(String.format("Output partitioning: %s [%s]%s\n", partitioningScheme.getPartitioning().getHandle(), Joiner.on((String)", ").join((Iterable)arguments), PlanPrinter.formatHash(partitioningScheme.getHashColumn())));
        }
        builder.append(TextRenderer.indentString(1)).append(String.format("Stage Execution Strategy: %s\n", new Object[]{fragment.getStageExecutionDescriptor().getStageExecutionStrategy()}));
        TypeProvider typeProvider = TypeProvider.copyOf((Map)allFragments.stream().flatMap(f -> f.getSymbols().entrySet().stream()).distinct().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
        builder.append(new PlanPrinter(fragment.getRoot(), typeProvider, Optional.of(fragment.getStageExecutionDescriptor()), tableInfoSupplier, valuePrinter, fragment.getStatsAndCosts(), planNodeStats).toText(verbose, 1)).append("\n");
        return builder.toString();
    }

    public static String graphvizLogicalPlan(PlanNode plan, TypeProvider types) {
        PlanFragment fragment = new PlanFragment(new PlanFragmentId("graphviz_plan"), plan, types.allTypes(), SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<PlanNodeId>)ImmutableList.of((Object)plan.getId()), new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), plan.getOutputSymbols()), StageExecutionDescriptor.ungroupedExecution(), StatsAndCosts.empty(), Optional.empty());
        return GraphvizPrinter.printLogical((List<PlanFragment>)ImmutableList.of((Object)fragment));
    }

    public static String graphvizDistributedPlan(SubPlan plan) {
        return GraphvizPrinter.printDistributed(plan);
    }

    private static String formatFrame(WindowNode.Frame frame) {
        StringBuilder builder = new StringBuilder(frame.getType().toString());
        frame.getOriginalStartValue().ifPresent(value -> builder.append(" ").append(value));
        builder.append(" ").append(frame.getStartType());
        frame.getOriginalEndValue().ifPresent(value -> builder.append(" ").append(value));
        builder.append(" ").append(frame.getEndType());
        return builder.toString();
    }

    @SafeVarargs
    private static String formatHash(Optional<Symbol> ... hashes) {
        List symbols = Arrays.stream(hashes).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (symbols.isEmpty()) {
            return "";
        }
        return "[" + Joiner.on((String)", ").join(symbols) + "]";
    }

    private static String formatOutputs(TypeProvider types, Iterable<Symbol> outputs) {
        return Streams.stream(outputs).map(input -> input + ":" + types.get((Symbol)input).getDisplayName()).collect(Collectors.joining(", "));
    }

    public static String formatAggregation(AggregationNode.Aggregation aggregation) {
        StringBuilder builder = new StringBuilder();
        Object arguments = Joiner.on((String)", ").join(aggregation.getArguments());
        if (aggregation.getArguments().isEmpty() && "count".equalsIgnoreCase(aggregation.getResolvedFunction().getSignature().getName())) {
            arguments = "*";
        }
        if (aggregation.isDistinct()) {
            arguments = "DISTINCT " + (String)arguments;
        }
        builder.append(aggregation.getResolvedFunction().getSignature().getName()).append('(').append((String)arguments);
        aggregation.getOrderingScheme().ifPresent(orderingScheme -> builder.append(' ').append(orderingScheme.getOrderBy().stream().map(input -> input + " " + orderingScheme.getOrdering((Symbol)input)).collect(Collectors.joining(", "))));
        builder.append(')');
        aggregation.getFilter().ifPresent(expression -> builder.append(" FILTER (WHERE ").append(expression).append(")"));
        aggregation.getMask().ifPresent(symbol -> builder.append(" (mask = ").append(symbol).append(")"));
        return builder.toString();
    }

    private static Expression unresolveFunctions(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                FunctionCall rewritten = (FunctionCall)treeRewriter.defaultRewrite((Expression)node, (Object)context);
                return new FunctionCall(rewritten.getLocation(), QualifiedName.of((String)ResolvedFunction.extractFunctionName(node.getName())), rewritten.getWindow(), rewritten.getFilter(), rewritten.getOrderBy(), rewritten.isDistinct(), rewritten.getNullTreatment(), rewritten.getArguments());
            }
        }, (Expression)expression);
    }

    private class Visitor
    extends PlanVisitor<Void, Void> {
        private final Optional<StageExecutionDescriptor> stageExecutionStrategy;
        private final TypeProvider types;
        private final StatsAndCosts estimatedStatsAndCosts;
        private final Optional<Map<PlanNodeId, PlanNodeStats>> stats;

        public Visitor(Optional<StageExecutionDescriptor> stageExecutionStrategy, TypeProvider types, StatsAndCosts estimatedStatsAndCosts, Optional<Map<PlanNodeId, PlanNodeStats>> stats) {
            this.stageExecutionStrategy = Objects.requireNonNull(stageExecutionStrategy, "stageExecutionStrategy is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.estimatedStatsAndCosts = Objects.requireNonNull(estimatedStatsAndCosts, "estimatedStatsAndCosts is null");
            this.stats = Objects.requireNonNull(stats, "stats is null");
        }

        @Override
        public Void visitExplainAnalyze(ExplainAnalyzeNode node, Void context) {
            this.addNode(node, "ExplainAnalyze");
            return this.processChildren(node, context);
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            NodeRepresentation nodeOutput;
            ArrayList<Expression> joinExpressions = new ArrayList<Expression>();
            for (JoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(PlanPrinter.unresolveFunctions((Expression)clause.toExpression()));
            }
            node.getFilter().map(x$0 -> PlanPrinter.unresolveFunctions(x$0)).ifPresent(joinExpressions::add);
            if (node.isCrossJoin()) {
                Preconditions.checkState((boolean)joinExpressions.isEmpty());
                nodeOutput = this.addNode(node, "CrossJoin");
            } else {
                nodeOutput = this.addNode(node, node.getType().getJoinLabel(), String.format("[%s]%s", Joiner.on((String)" AND ").join(joinExpressions), PlanPrinter.formatHash(node.getLeftHashSymbol(), node.getRightHashSymbol())), node.getReorderJoinStatsAndCost());
            }
            node.getDistributionType().ifPresent(distributionType -> nodeOutput.appendDetailsLine("Distribution: %s", distributionType));
            if (!node.getDynamicFilters().isEmpty()) {
                nodeOutput.appendDetails("dynamicFilterAssignments = %s", this.printDynamicFilterAssignments(node.getDynamicFilters()));
            }
            node.getLeft().accept(this, context);
            node.getRight().accept(this, context);
            return null;
        }

        @Override
        public Void visitSpatialJoin(SpatialJoinNode node, Void context) {
            NodeRepresentation nodeOutput = this.addNode(node, node.getType().getJoinLabel(), String.format("[%s]", node.getFilter()));
            nodeOutput.appendDetailsLine("Distribution: %s", new Object[]{node.getDistributionType()});
            node.getLeft().accept(this, context);
            node.getRight().accept(this, context);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Void context) {
            NodeRepresentation nodeOutput = this.addNode(node, "SemiJoin", String.format("[%s = %s]%s", node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), PlanPrinter.formatHash(node.getSourceHashSymbol(), node.getFilteringSourceHashSymbol())));
            node.getDistributionType().ifPresent(distributionType -> nodeOutput.appendDetailsLine("Distribution: %s", distributionType));
            node.getDynamicFilterId().ifPresent(dynamicFilterId -> nodeOutput.appendDetailsLine("dynamicFilterId: %s", dynamicFilterId));
            node.getSource().accept(this, context);
            node.getFilteringSource().accept(this, context);
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Void context) {
            NodeRepresentation nodeOutput = this.addNode(node, "IndexSource", String.format("[%s, lookup = %s]", node.getIndexHandle(), node.getLookupSymbols()));
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getAssignments().entrySet()) {
                if (!node.getOutputSymbols().contains(entry.getKey())) continue;
                nodeOutput.appendDetailsLine("%s := %s", entry.getKey(), entry.getValue());
            }
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Void context) {
            ArrayList<ComparisonExpression> joinExpressions = new ArrayList<ComparisonExpression>();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)clause.getProbe().toSymbolReference(), (Expression)clause.getIndex().toSymbolReference()));
            }
            this.addNode(node, String.format("%sIndexJoin", node.getType().getJoinLabel()), String.format("[%s]%s", Joiner.on((String)" AND ").join(joinExpressions), PlanPrinter.formatHash(node.getProbeHashSymbol(), node.getIndexHashSymbol())));
            node.getProbeSource().accept(this, context);
            node.getIndexSource().accept(this, context);
            return null;
        }

        @Override
        public Void visitOffset(OffsetNode node, Void context) {
            this.addNode(node, "Offset", String.format("[%s]", node.getCount()));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitLimit(LimitNode node, Void context) {
            this.addNode(node, String.format("Limit%s", node.isPartial() ? "Partial" : ""), String.format("[%s%s]", node.getCount(), node.isWithTies() ? "+ties" : ""));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitDistinctLimit(DistinctLimitNode node, Void context) {
            this.addNode(node, String.format("DistinctLimit%s", node.isPartial() ? "Partial" : ""), String.format("[%s]%s", node.getLimit(), PlanPrinter.formatHash(node.getHashSymbol())));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            String type = "";
            if (node.getStep() != AggregationNode.Step.SINGLE) {
                type = String.format("(%s)", node.getStep().toString());
            }
            if (node.isStreamable()) {
                type = String.format("%s(STREAMING)", type);
            }
            String key = "";
            if (!node.getGroupingKeys().isEmpty()) {
                key = node.getGroupingKeys().toString();
            }
            NodeRepresentation nodeOutput = this.addNode(node, String.format("Aggregate%s%s%s", type, key, PlanPrinter.formatHash(node.getHashSymbol())));
            node.getAggregations().forEach((symbol, aggregation) -> nodeOutput.appendDetailsLine("%s := %s", symbol, PlanPrinter.formatAggregation(aggregation)));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitGroupId(GroupIdNode node, Void context) {
            List inputGroupingSetSymbols = node.getGroupingSets().stream().map(set -> set.stream().map(symbol -> node.getGroupingColumns().get(symbol)).collect(Collectors.toList())).collect(Collectors.toList());
            NodeRepresentation nodeOutput = this.addNode(node, "GroupId", String.format("%s", inputGroupingSetSymbols));
            for (Map.Entry<Symbol, Symbol> mapping : node.getGroupingColumns().entrySet()) {
                nodeOutput.appendDetailsLine("%s := %s", mapping.getKey(), mapping.getValue());
            }
            return this.processChildren(node, context);
        }

        @Override
        public Void visitMarkDistinct(MarkDistinctNode node, Void context) {
            this.addNode(node, "MarkDistinct", String.format("[distinct=%s marker=%s]%s", PlanPrinter.formatOutputs(this.types, node.getDistinctSymbols()), node.getMarkerSymbol(), PlanPrinter.formatHash(node.getHashSymbol())));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitWindow(WindowNode node, Void context) {
            List partitionBy = (List)node.getPartitionBy().stream().map(Objects::toString).collect(ImmutableList.toImmutableList());
            ArrayList<String> args = new ArrayList<String>();
            if (!partitionBy.isEmpty()) {
                List prePartitioned = (List)node.getPartitionBy().stream().filter(node.getPrePartitionedInputs()::contains).collect(ImmutableList.toImmutableList());
                List notPrePartitioned = (List)node.getPartitionBy().stream().filter(column -> !node.getPrePartitionedInputs().contains(column)).collect(ImmutableList.toImmutableList());
                StringBuilder builder = new StringBuilder();
                if (!prePartitioned.isEmpty()) {
                    builder.append("<").append(Joiner.on((String)", ").join((Iterable)prePartitioned)).append(">");
                    if (!notPrePartitioned.isEmpty()) {
                        builder.append(", ");
                    }
                }
                if (!notPrePartitioned.isEmpty()) {
                    builder.append(Joiner.on((String)", ").join((Iterable)notPrePartitioned));
                }
                args.add(String.format("partition by (%s)", builder));
            }
            if (node.getOrderingScheme().isPresent()) {
                OrderingScheme orderingScheme = node.getOrderingScheme().get();
                args.add(String.format("order by (%s)", Stream.concat(orderingScheme.getOrderBy().stream().limit(node.getPreSortedOrderPrefix()).map(symbol -> "<" + symbol + " " + orderingScheme.getOrdering((Symbol)symbol) + ">"), orderingScheme.getOrderBy().stream().skip(node.getPreSortedOrderPrefix()).map(symbol -> symbol + " " + orderingScheme.getOrdering((Symbol)symbol))).collect(Collectors.joining(", "))));
            }
            NodeRepresentation nodeOutput = this.addNode(node, "Window", String.format("[%s]%s", Joiner.on((String)", ").join(args), PlanPrinter.formatHash(node.getHashSymbol())));
            for (Map.Entry<Symbol, WindowNode.Function> entry : node.getWindowFunctions().entrySet()) {
                WindowNode.Function function = entry.getValue();
                String frameInfo = PlanPrinter.formatFrame(function.getFrame());
                nodeOutput.appendDetailsLine("%s := %s(%s) %s", entry.getKey(), function.getResolvedFunction().getSignature().getName(), Joiner.on((String)", ").join(function.getArguments()), frameInfo);
            }
            return this.processChildren(node, context);
        }

        @Override
        public Void visitTopNRowNumber(TopNRowNumberNode node, Void context) {
            List partitionBy = (List)node.getPartitionBy().stream().map(Object::toString).collect(ImmutableList.toImmutableList());
            List orderBy = (List)node.getOrderingScheme().getOrderBy().stream().map(input -> input + " " + node.getOrderingScheme().getOrdering((Symbol)input)).collect(ImmutableList.toImmutableList());
            ArrayList<String> args = new ArrayList<String>();
            args.add(String.format("partition by (%s)", Joiner.on((String)", ").join((Iterable)partitionBy)));
            args.add(String.format("order by (%s)", Joiner.on((String)", ").join((Iterable)orderBy)));
            NodeRepresentation nodeOutput = this.addNode(node, "TopNRowNumber", String.format("[%s limit %s]%s", Joiner.on((String)", ").join(args), node.getMaxRowCountPerPartition(), PlanPrinter.formatHash(node.getHashSymbol())));
            nodeOutput.appendDetailsLine("%s := %s", node.getRowNumberSymbol(), "row_number()");
            return this.processChildren(node, context);
        }

        @Override
        public Void visitRowNumber(RowNumberNode node, Void context) {
            List partitionBy = (List)node.getPartitionBy().stream().map(Objects::toString).collect(ImmutableList.toImmutableList());
            ArrayList<String> args = new ArrayList<String>();
            if (!partitionBy.isEmpty()) {
                args.add(String.format("partition by (%s)", Joiner.on((String)", ").join((Iterable)partitionBy)));
            }
            if (node.getMaxRowCountPerPartition().isPresent()) {
                args.add(String.format("limit = %s", node.getMaxRowCountPerPartition().get()));
            }
            NodeRepresentation nodeOutput = this.addNode(node, "RowNumber", String.format("[%s]%s", Joiner.on((String)", ").join(args), PlanPrinter.formatHash(node.getHashSymbol())));
            nodeOutput.appendDetailsLine("%s := %s", node.getRowNumberSymbol(), "row_number()");
            return this.processChildren(node, context);
        }

        @Override
        public Void visitTableScan(TableScanNode node, Void context) {
            TableHandle table = node.getTable();
            NodeRepresentation nodeOutput = this.stageExecutionStrategy.isPresent() ? this.addNode(node, "TableScan", String.format("[%s, grouped = %s]", table, this.stageExecutionStrategy.get().isScanGroupedExecution(node.getId()))) : this.addNode(node, "TableScan", String.format("[%s]", table));
            this.printTableScanInfo(nodeOutput, node);
            return null;
        }

        @Override
        public Void visitValues(ValuesNode node, Void context) {
            NodeRepresentation nodeOutput = this.addNode(node, "Values");
            for (List<Expression> row : node.getRows()) {
                nodeOutput.appendDetailsLine(row.stream().map(x$0 -> PlanPrinter.unresolveFunctions(x$0)).map(Expression::toString).collect(Collectors.joining(", ", "(", ")")), new Object[0]);
            }
            return null;
        }

        @Override
        public Void visitFilter(FilterNode node, Void context) {
            return this.visitScanFilterAndProjectInfo(node, Optional.of(node), Optional.empty(), context);
        }

        @Override
        public Void visitProject(ProjectNode node, Void context) {
            if (node.getSource() instanceof FilterNode) {
                return this.visitScanFilterAndProjectInfo(node, Optional.of((FilterNode)node.getSource()), Optional.of(node), context);
            }
            return this.visitScanFilterAndProjectInfo(node, Optional.empty(), Optional.of(node), context);
        }

        private Void visitScanFilterAndProjectInfo(PlanNode node, Optional<FilterNode> filterNode, Optional<ProjectNode> projectNode, Void context) {
            Preconditions.checkState((projectNode.isPresent() || filterNode.isPresent() ? 1 : 0) != 0);
            PlanNode sourceNode = filterNode.isPresent() ? filterNode.get().getSource() : projectNode.get().getSource();
            Optional<Object> scanNode = sourceNode instanceof TableScanNode ? Optional.of((TableScanNode)sourceNode) : Optional.empty();
            Object formatString = "[";
            Object operatorName = "";
            LinkedList<Object> arguments = new LinkedList<Object>();
            if (scanNode.isPresent()) {
                operatorName = (String)operatorName + "Scan";
                formatString = (String)formatString + "table = %s, ";
                TableHandle table = ((TableScanNode)scanNode.get()).getTable();
                arguments.add(table);
                if (this.stageExecutionStrategy.isPresent()) {
                    formatString = (String)formatString + "grouped = %s, ";
                    arguments.add(this.stageExecutionStrategy.get().isScanGroupedExecution(((TableScanNode)scanNode.get()).getId()));
                }
            }
            if (filterNode.isPresent()) {
                operatorName = (String)operatorName + "Filter";
                formatString = (String)formatString + "filterPredicate = %s, ";
                Expression predicate = filterNode.get().getPredicate();
                DynamicFilters.ExtractResult extractResult = DynamicFilters.extractDynamicFilters(predicate);
                arguments.add(ExpressionUtils.combineConjunctsWithDuplicates(extractResult.getStaticConjuncts()));
                if (!extractResult.getDynamicConjuncts().isEmpty()) {
                    formatString = (String)formatString + "dynamicFilter = %s, ";
                    arguments.add(this.printDynamicFilters(extractResult.getDynamicConjuncts()));
                }
            }
            if (((String)formatString).length() > 1) {
                formatString = ((String)formatString).substring(0, ((String)formatString).length() - 2);
            }
            formatString = (String)formatString + "]";
            if (projectNode.isPresent()) {
                operatorName = (String)operatorName + "Project";
            }
            List<PlanNodeId> allNodes = Stream.of(scanNode, filterNode, projectNode).filter(Optional::isPresent).map(Optional::get).map(PlanNode::getId).collect(Collectors.toList());
            NodeRepresentation nodeOutput = this.addNode(node, (String)operatorName, String.format((String)formatString, arguments.toArray()), allNodes, (List<PlanNode>)ImmutableList.of((Object)sourceNode), (List<PlanFragmentId>)ImmutableList.of(), Optional.empty());
            if (projectNode.isPresent()) {
                this.printAssignments(nodeOutput, projectNode.get().getAssignments());
            }
            if (scanNode.isPresent()) {
                this.printTableScanInfo(nodeOutput, (TableScanNode)scanNode.get());
                PlanNodeStats nodeStats = this.stats.map(s -> (PlanNodeStats)s.get(node.getId())).orElse(null);
                if (nodeStats != null) {
                    nodeOutput.appendDetails("Input: %s (%s)", TextRenderer.formatPositions(nodeStats.getPlanNodeInputPositions()), nodeStats.getPlanNodeInputDataSize().toString());
                    double filtered = 100.0 * (double)(nodeStats.getPlanNodeInputPositions() - nodeStats.getPlanNodeOutputPositions()) / (double)nodeStats.getPlanNodeInputPositions();
                    nodeOutput.appendDetailsLine(", Filtered: %s%%", TextRenderer.formatDouble(filtered));
                }
                return null;
            }
            sourceNode.accept(this, context);
            return null;
        }

        private String printDynamicFilters(Collection<DynamicFilters.Descriptor> filters) {
            return filters.stream().map(filter -> filter.getId() + " -> " + filter.getInput()).collect(Collectors.joining(", ", "{", "}"));
        }

        private String printDynamicFilterAssignments(Map<DynamicFilterId, Symbol> filters) {
            return filters.entrySet().stream().map(filter -> filter.getValue() + " -> " + filter.getKey()).collect(Collectors.joining(", ", "{", "}"));
        }

        private void printTableScanInfo(NodeRepresentation nodeOutput, TableScanNode node) {
            TupleDomain<ColumnHandle> predicate = PlanPrinter.this.tableInfoSupplier.apply(node).getPredicate();
            if (predicate.isNone()) {
                nodeOutput.appendDetailsLine(":: NONE", new Object[0]);
            } else {
                for (Map.Entry<Symbol, ColumnHandle> assignment : node.getAssignments().entrySet()) {
                    ColumnHandle column = assignment.getValue();
                    nodeOutput.appendDetailsLine("%s := %s", assignment.getKey(), column);
                    this.printConstraint(nodeOutput, column, predicate);
                }
                if (!predicate.isAll()) {
                    ImmutableSet outputs = ImmutableSet.copyOf(node.getAssignments().values());
                    ((Map)predicate.getDomains().get()).entrySet().stream().filter(arg_0 -> Visitor.lambda$printTableScanInfo$15((Set)outputs, arg_0)).forEach(entry -> {
                        ColumnHandle column = (ColumnHandle)entry.getKey();
                        nodeOutput.appendDetailsLine("%s", column);
                        this.printConstraint(nodeOutput, column, predicate);
                    });
                }
            }
        }

        @Override
        public Void visitUnnest(UnnestNode node, Void context) {
            Object name = node.getFilter().isPresent() ? node.getJoinType().getJoinLabel() + " Unnest" : (!node.getReplicateSymbols().isEmpty() ? "CrossJoin Unnest" : "Unnest");
            List unnestInputs = (List)node.getMappings().stream().map(UnnestNode.Mapping::getInput).collect(ImmutableList.toImmutableList());
            this.addNode(node, (String)name, String.format("[replicate=%s, unnest=%s", PlanPrinter.formatOutputs(this.types, node.getReplicateSymbols()), PlanPrinter.formatOutputs(this.types, unnestInputs)) + (node.getFilter().isPresent() ? String.format(", filter=%s]", node.getFilter().get().toString()) : "]"));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitOutput(OutputNode node, Void context) {
            NodeRepresentation nodeOutput = this.addNode(node, "Output", String.format("[%s]", Joiner.on((String)", ").join(node.getColumnNames())));
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                Symbol symbol;
                String name = node.getColumnNames().get(i);
                if (name.equals((symbol = node.getOutputSymbols().get(i)).toString())) continue;
                nodeOutput.appendDetailsLine("%s := %s", name, symbol);
            }
            return this.processChildren(node, context);
        }

        @Override
        public Void visitTopN(TopNNode node, Void context) {
            String keys = node.getOrderingScheme().getOrderBy().stream().map(input -> input + " " + node.getOrderingScheme().getOrdering((Symbol)input)).collect(Collectors.joining(", "));
            this.addNode(node, String.format("TopN%s", node.getStep() == TopNNode.Step.PARTIAL ? "Partial" : ""), String.format("[%s by (%s)]", node.getCount(), keys));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitSort(SortNode node, Void context) {
            String keys = node.getOrderingScheme().getOrderBy().stream().map(input -> input + " " + node.getOrderingScheme().getOrdering((Symbol)input)).collect(Collectors.joining(", "));
            this.addNode(node, String.format("%sSort", node.isPartial() ? "Partial" : ""), String.format("[%s]", keys));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitRemoteSource(RemoteSourceNode node, Void context) {
            this.addNode(node, String.format("Remote%s", node.getOrderingScheme().isPresent() ? "Merge" : "Source"), String.format("[%s]", Joiner.on((char)',').join(node.getSourceFragmentIds())), (List<PlanNodeId>)ImmutableList.of(), (List<PlanNode>)ImmutableList.of(), node.getSourceFragmentIds(), Optional.empty());
            return null;
        }

        @Override
        public Void visitUnion(UnionNode node, Void context) {
            this.addNode(node, "Union");
            return this.processChildren(node, context);
        }

        @Override
        public Void visitIntersect(IntersectNode node, Void context) {
            this.addNode(node, "Intersect");
            return this.processChildren(node, context);
        }

        @Override
        public Void visitExcept(ExceptNode node, Void context) {
            this.addNode(node, "Except");
            return this.processChildren(node, context);
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Void context) {
            NodeRepresentation nodeOutput = this.addNode(node, "TableWriter");
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                String name = node.getColumnNames().get(i);
                Symbol symbol = node.getColumns().get(i);
                nodeOutput.appendDetailsLine("%s := %s", name, symbol);
            }
            if (node.getStatisticsAggregation().isPresent()) {
                Verify.verify((boolean)node.getStatisticsAggregationDescriptor().isPresent(), (String)"statisticsAggregationDescriptor is not present", (Object[])new Object[0]);
                this.printStatisticAggregations(nodeOutput, node.getStatisticsAggregation().get(), node.getStatisticsAggregationDescriptor().get());
            }
            return this.processChildren(node, context);
        }

        @Override
        public Void visitStatisticsWriterNode(StatisticsWriterNode node, Void context) {
            this.addNode(node, "StatisticsWriter", String.format("[%s]", node.getTarget()));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitTableFinish(TableFinishNode node, Void context) {
            NodeRepresentation nodeOutput = this.addNode(node, "TableCommit", String.format("[%s]", node.getTarget()));
            if (node.getStatisticsAggregation().isPresent()) {
                Verify.verify((boolean)node.getStatisticsAggregationDescriptor().isPresent(), (String)"statisticsAggregationDescriptor is not present", (Object[])new Object[0]);
                this.printStatisticAggregations(nodeOutput, node.getStatisticsAggregation().get(), node.getStatisticsAggregationDescriptor().get());
            }
            return this.processChildren(node, context);
        }

        private void printStatisticAggregations(NodeRepresentation nodeOutput, StatisticAggregations aggregations, StatisticAggregationsDescriptor<Symbol> descriptor) {
            nodeOutput.appendDetailsLine("Collected statistics:", new Object[0]);
            this.printStatisticAggregationsInfo(nodeOutput, descriptor.getTableStatistics(), descriptor.getColumnStatistics(), aggregations.getAggregations());
            nodeOutput.appendDetailsLine(TextRenderer.indentString(1) + "grouped by => [%s]", this.getStatisticGroupingSetsInfo(descriptor.getGrouping()));
        }

        private String getStatisticGroupingSetsInfo(Map<String, Symbol> columnMappings) {
            return columnMappings.entrySet().stream().map(entry -> String.format("%s := %s", entry.getValue(), entry.getKey())).collect(Collectors.joining(", "));
        }

        private void printStatisticAggregationsInfo(NodeRepresentation nodeOutput, Map<TableStatisticType, Symbol> tableStatistics, Map<ColumnStatisticMetadata, Symbol> columnStatistics, Map<Symbol, AggregationNode.Aggregation> aggregations) {
            nodeOutput.appendDetailsLine("aggregations =>", new Object[0]);
            for (Map.Entry<TableStatisticType, Symbol> entry : tableStatistics.entrySet()) {
                nodeOutput.appendDetailsLine(TextRenderer.indentString(1) + "%s => [%s := %s]", entry.getValue(), entry.getKey(), PlanPrinter.formatAggregation(aggregations.get(entry.getValue())));
            }
            for (Map.Entry<TableStatisticType, Symbol> entry : columnStatistics.entrySet()) {
                nodeOutput.appendDetailsLine(TextRenderer.indentString(1) + "%s[%s] => [%s := %s]", ((ColumnStatisticMetadata)entry.getKey()).getStatisticType(), ((ColumnStatisticMetadata)entry.getKey()).getColumnName(), entry.getValue(), PlanPrinter.formatAggregation(aggregations.get(entry.getValue())));
            }
        }

        @Override
        public Void visitSample(SampleNode node, Void context) {
            this.addNode(node, "Sample", String.format("[%s: %s]", new Object[]{node.getSampleType(), node.getSampleRatio()}));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitExchange(ExchangeNode node, Void context) {
            if (node.getOrderingScheme().isPresent()) {
                OrderingScheme orderingScheme = node.getOrderingScheme().get();
                List orderBy = (List)orderingScheme.getOrderBy().stream().map(input -> input + " " + orderingScheme.getOrdering((Symbol)input)).collect(ImmutableList.toImmutableList());
                this.addNode(node, String.format("%sMerge", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, node.getScope().toString())), String.format("[%s]", Joiner.on((String)", ").join((Iterable)orderBy)));
            } else if (node.getScope() == ExchangeNode.Scope.LOCAL) {
                this.addNode(node, "LocalExchange", String.format("[%s%s]%s (%s)", node.getPartitioningScheme().getPartitioning().getHandle(), node.getPartitioningScheme().isReplicateNullsAndAny() ? " - REPLICATE NULLS AND ANY" : "", PlanPrinter.formatHash(node.getPartitioningScheme().getHashColumn()), Joiner.on((String)", ").join(node.getPartitioningScheme().getPartitioning().getArguments())));
            } else {
                this.addNode(node, String.format("%sExchange", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, node.getScope().toString())), String.format("[%s%s]%s", new Object[]{node.getType(), node.getPartitioningScheme().isReplicateNullsAndAny() ? " - REPLICATE NULLS AND ANY" : "", PlanPrinter.formatHash(node.getPartitioningScheme().getHashColumn())}));
            }
            return this.processChildren(node, context);
        }

        @Override
        public Void visitDelete(DeleteNode node, Void context) {
            this.addNode(node, "Delete", String.format("[%s]", node.getTarget()));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitTableDelete(TableDeleteNode node, Void context) {
            this.addNode(node, "TableDelete", String.format("[%s]", node.getTarget()));
            return this.processChildren(node, context);
        }

        @Override
        public Void visitEnforceSingleRow(EnforceSingleRowNode node, Void context) {
            this.addNode(node, "EnforceSingleRow");
            return this.processChildren(node, context);
        }

        @Override
        public Void visitAssignUniqueId(AssignUniqueId node, Void context) {
            this.addNode(node, "AssignUniqueId");
            return this.processChildren(node, context);
        }

        @Override
        public Void visitGroupReference(GroupReference node, Void context) {
            this.addNode(node, "GroupReference", String.format("[%s]", node.getGroupId()), (List<PlanNode>)ImmutableList.of(), Optional.empty());
            return null;
        }

        @Override
        public Void visitApply(ApplyNode node, Void context) {
            NodeRepresentation nodeOutput = this.addNode(node, "Apply", String.format("[%s]", node.getCorrelation()));
            this.printAssignments(nodeOutput, node.getSubqueryAssignments());
            return this.processChildren(node, context);
        }

        @Override
        public Void visitCorrelatedJoin(CorrelatedJoinNode node, Void context) {
            this.addNode(node, "CorrelatedJoin", String.format("[%s%s]", node.getCorrelation(), node.getFilter().equals((Object)BooleanLiteral.TRUE_LITERAL) ? "" : " " + node.getFilter()));
            return this.processChildren(node, context);
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        private Void processChildren(PlanNode node, Void context) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, context);
            }
            return null;
        }

        private void printAssignments(NodeRepresentation nodeOutput, Assignments assignments) {
            for (Map.Entry<Symbol, Expression> entry : assignments.getMap().entrySet()) {
                if (entry.getValue() instanceof SymbolReference && ((SymbolReference)entry.getValue()).getName().equals(entry.getKey().getName())) continue;
                nodeOutput.appendDetailsLine("%s := %s", entry.getKey(), PlanPrinter.unresolveFunctions(entry.getValue()));
            }
        }

        private void printConstraint(NodeRepresentation nodeOutput, ColumnHandle column, TupleDomain<ColumnHandle> constraint) {
            Preconditions.checkArgument((!constraint.isNone() ? 1 : 0) != 0);
            Map domains = (Map)constraint.getDomains().get();
            if (domains.containsKey(column)) {
                nodeOutput.appendDetailsLine("    :: %s", this.formatDomain(((Domain)domains.get(column)).simplify()));
            }
        }

        private String formatDomain(Domain domain) {
            ImmutableList.Builder parts = ImmutableList.builder();
            if (domain.isNullAllowed()) {
                parts.add((Object)"NULL");
            }
            Type type = domain.getType();
            domain.getValues().getValuesProcessor().consume(ranges -> {
                for (Range range : ranges.getOrderedRanges()) {
                    StringBuilder builder = new StringBuilder();
                    if (range.isSingleValue()) {
                        String value = PlanPrinter.this.valuePrinter.castToVarchar(type, range.getSingleValue());
                        builder.append('[').append(value).append(']');
                    } else {
                        builder.append(range.getLow().getBound() == Marker.Bound.EXACTLY ? (char)'[' : (char)'(');
                        if (range.getLow().isLowerUnbounded()) {
                            builder.append("<min>");
                        } else {
                            builder.append(PlanPrinter.this.valuePrinter.castToVarchar(type, range.getLow().getValue()));
                        }
                        builder.append(", ");
                        if (range.getHigh().isUpperUnbounded()) {
                            builder.append("<max>");
                        } else {
                            builder.append(PlanPrinter.this.valuePrinter.castToVarchar(type, range.getHigh().getValue()));
                        }
                        builder.append(range.getHigh().getBound() == Marker.Bound.EXACTLY ? (char)']' : (char)')');
                    }
                    parts.add((Object)builder.toString());
                }
            }, discreteValues -> discreteValues.getValues().stream().map(value -> PlanPrinter.this.valuePrinter.castToVarchar(type, value)).sorted().forEach(arg_0 -> ((ImmutableList.Builder)parts).add(arg_0)), allOrNone -> {
                if (allOrNone.isAll()) {
                    parts.add((Object)"ALL VALUES");
                }
            });
            return "[" + Joiner.on((String)", ").join((Iterable)parts.build()) + "]";
        }

        public NodeRepresentation addNode(PlanNode node, String name) {
            return this.addNode(node, name, "");
        }

        public NodeRepresentation addNode(PlanNode node, String name, String identifier) {
            return this.addNode(node, name, identifier, node.getSources(), Optional.empty());
        }

        public NodeRepresentation addNode(PlanNode node, String name, String identifier, Optional<PlanNodeStatsAndCostSummary> reorderJoinStatsAndCost) {
            return this.addNode(node, name, identifier, node.getSources(), reorderJoinStatsAndCost);
        }

        public NodeRepresentation addNode(PlanNode node, String name, String identifier, List<PlanNode> children, Optional<PlanNodeStatsAndCostSummary> reorderJoinStatsAndCost) {
            return this.addNode(node, name, identifier, (List<PlanNodeId>)ImmutableList.of((Object)node.getId()), children, (List<PlanFragmentId>)ImmutableList.of(), reorderJoinStatsAndCost);
        }

        public NodeRepresentation addNode(PlanNode rootNode, String name, String identifier, List<PlanNodeId> allNodes, List<PlanNode> children, List<PlanFragmentId> remoteSources, Optional<PlanNodeStatsAndCostSummary> reorderJoinStatsAndCost) {
            List childrenIds = (List)children.stream().map(PlanNode::getId).collect(ImmutableList.toImmutableList());
            List<PlanNodeStatsEstimate> estimatedStats = allNodes.stream().map(nodeId -> this.estimatedStatsAndCosts.getStats().getOrDefault(nodeId, PlanNodeStatsEstimate.unknown())).collect(Collectors.toList());
            List<PlanCostEstimate> estimatedCosts = allNodes.stream().map(nodeId -> this.estimatedStatsAndCosts.getCosts().getOrDefault(nodeId, PlanCostEstimate.unknown())).collect(Collectors.toList());
            NodeRepresentation nodeOutput = new NodeRepresentation(rootNode.getId(), name, rootNode.getClass().getSimpleName(), identifier, (List)rootNode.getOutputSymbols().stream().map(s -> new NodeRepresentation.TypedSymbol((Symbol)s, this.types.get((Symbol)s).getDisplayName())).collect(ImmutableList.toImmutableList()), this.stats.map(s -> (PlanNodeStats)s.get(rootNode.getId())), estimatedStats, estimatedCosts, reorderJoinStatsAndCost, childrenIds, remoteSources);
            PlanPrinter.this.representation.addNode(nodeOutput);
            return nodeOutput;
        }

        private static /* synthetic */ boolean lambda$printTableScanInfo$15(Set outputs, Map.Entry entry) {
            return !outputs.contains(entry.getKey());
        }
    }
}

