/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.sanity;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.planner.SubExpressionExtractor;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.OutputNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.sanity.PlanSanityChecker;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.SymbolReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class DynamicFiltersChecker
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, Metadata metadata, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        plan.accept(new PlanVisitor<Set<DynamicFilterId>, Void>(){

            @Override
            protected Set<DynamicFilterId> visitPlan(PlanNode node, Void context) {
                HashSet<DynamicFilterId> consumed = new HashSet<DynamicFilterId>();
                for (PlanNode source : node.getSources()) {
                    consumed.addAll((Collection<DynamicFilterId>)source.accept(this, context));
                }
                return consumed;
            }

            @Override
            public Set<DynamicFilterId> visitOutput(OutputNode node, Void context) {
                Set<DynamicFilterId> unmatched = this.visitPlan((PlanNode)node, context);
                Verify.verify((boolean)unmatched.isEmpty(), (String)"All consumed dynamic filters could not be matched with a join/semi-join.", (Object[])new Object[0]);
                return unmatched;
            }

            @Override
            public Set<DynamicFilterId> visitJoin(JoinNode node, Void context) {
                Set<DynamicFilterId> currentJoinDynamicFilters = node.getDynamicFilters().keySet();
                Set<DynamicFilterId> consumedProbeSide = node.getLeft().accept(this, context);
                Sets.SetView unconsumedByProbeSide = Sets.difference(currentJoinDynamicFilters, consumedProbeSide);
                Verify.verify((boolean)unconsumedByProbeSide.isEmpty(), (String)"Dynamic filters %s present in join were not fully consumed by it's probe side.", (Object)unconsumedByProbeSide);
                Set<DynamicFilterId> consumedBuildSide = node.getRight().accept(this, context);
                Sets.SetView unconsumedByBuildSide = Sets.intersection(currentJoinDynamicFilters, consumedBuildSide);
                Verify.verify((boolean)unconsumedByBuildSide.isEmpty(), (String)"Dynamic filters %s present in join were consumed by it's build side.", (Object)unconsumedByBuildSide);
                List nonPushedDownFilters = node.getFilter().map(DynamicFilters::extractDynamicFilters).map(DynamicFilters.ExtractResult::getDynamicConjuncts).orElse((List)ImmutableList.of());
                Verify.verify((boolean)nonPushedDownFilters.isEmpty(), (String)"Dynamic filters %s present in join filter predicate were not pushed down.", (Object)nonPushedDownFilters);
                HashSet<DynamicFilterId> unmatched = new HashSet<DynamicFilterId>(consumedBuildSide);
                unmatched.addAll(consumedProbeSide);
                unmatched.removeAll(currentJoinDynamicFilters);
                return ImmutableSet.copyOf(unmatched);
            }

            @Override
            public Set<DynamicFilterId> visitSemiJoin(SemiJoinNode node, Void context) {
                Set<DynamicFilterId> consumedSourceSide = node.getSource().accept(this, context);
                Set<DynamicFilterId> consumedFilteringSourceSide = node.getFilteringSource().accept(this, context);
                HashSet<DynamicFilterId> unmatched = new HashSet<DynamicFilterId>(consumedSourceSide);
                unmatched.addAll(consumedFilteringSourceSide);
                if (node.getDynamicFilterId().isPresent()) {
                    DynamicFilterId dynamicFilterId = node.getDynamicFilterId().get();
                    Verify.verify((boolean)consumedSourceSide.contains(dynamicFilterId), (String)"The dynamic filter %s present in semi-join was not consumed by it's source side.", (Object)dynamicFilterId);
                    Verify.verify((!consumedFilteringSourceSide.contains(dynamicFilterId) ? 1 : 0) != 0, (String)"The dynamic filter %s present in semi-join was consumed by it's filtering source side.", (Object)dynamicFilterId);
                    unmatched.remove(dynamicFilterId);
                }
                return ImmutableSet.copyOf(unmatched);
            }

            @Override
            public Set<DynamicFilterId> visitFilter(FilterNode node, Void context) {
                List<DynamicFilters.Descriptor> dynamicFilters = DynamicFiltersChecker.extractDynamicPredicates(node.getPredicate());
                if (!dynamicFilters.isEmpty()) {
                    Verify.verify((boolean)(node.getSource() instanceof TableScanNode), (String)"Dynamic filters %s present in filter predicate whose source is not a table scan.", dynamicFilters);
                }
                ImmutableSet.Builder consumed = ImmutableSet.builder();
                dynamicFilters.forEach(descriptor -> {
                    Verify.verify((boolean)(descriptor.getInput() instanceof SymbolReference), (String)"Dynamic filter expression must be a SymbolReference", (Object[])new Object[0]);
                    consumed.add((Object)descriptor.getId());
                });
                consumed.addAll((Iterable)node.getSource().accept(this, context));
                return consumed.build();
            }
        }, null);
    }

    private static List<DynamicFilters.Descriptor> extractDynamicPredicates(Expression expression) {
        return (List)SubExpressionExtractor.extract(expression).stream().map(DynamicFilters::getDescriptor).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }
}

