/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.rewrite;

import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.execution.ParameterExtractor;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.security.AccessControl;
import io.prestosql.sql.ParsingUtil;
import io.prestosql.sql.QueryUtil;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.Analyzer;
import io.prestosql.sql.analyzer.QueryExplainer;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.rewrite.StatementRewrite;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.DescribeInput;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Limit;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.Parameter;
import io.prestosql.sql.tree.Relation;
import io.prestosql.sql.tree.Row;
import io.prestosql.sql.tree.Select;
import io.prestosql.sql.tree.SortItem;
import io.prestosql.sql.tree.Statement;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.type.TypeUtils;
import io.prestosql.type.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class DescribeInputRewrite
implements StatementRewrite.Rewrite {
    DescribeInputRewrite() {
    }

    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, AccessControl accessControl, WarningCollector warningCollector) {
        return (Statement)new Visitor(session, parser, metadata, queryExplainer, parameters, parameterLookup, accessControl, warningCollector).process((Node)node, null);
    }

    private static final class Visitor
    extends AstVisitor<Node, Void> {
        private final Session session;
        private final SqlParser parser;
        private final Metadata metadata;
        private final Optional<QueryExplainer> queryExplainer;
        private final List<Expression> parameters;
        private final Map<NodeRef<Parameter>, Expression> parameterLookup;
        private final AccessControl accessControl;
        private final WarningCollector warningCollector;

        public Visitor(Session session, SqlParser parser, Metadata metadata, Optional<QueryExplainer> queryExplainer, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, AccessControl accessControl, WarningCollector warningCollector) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.parser = parser;
            this.metadata = metadata;
            this.queryExplainer = queryExplainer;
            this.accessControl = accessControl;
            this.parameters = parameters;
            this.parameterLookup = parameterLookup;
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        protected Node visitDescribeInput(DescribeInput node, Void context) {
            String sqlString = this.session.getPreparedStatement(node.getName().getValue());
            Statement statement = this.parser.createStatement(sqlString, ParsingUtil.createParsingOptions(this.session));
            Analyzer analyzer = new Analyzer(this.session, this.metadata, this.parser, this.accessControl, this.queryExplainer, this.parameters, this.parameterLookup, this.warningCollector);
            Analysis analysis = analyzer.analyze(statement, true);
            List<Parameter> parameters = ParameterExtractor.getParameters(statement);
            Row[] rows = (Row[])parameters.stream().map(parameter -> Visitor.createDescribeInputRow(this.session, parameter, analysis)).toArray(Row[]::new);
            Optional<Object> limit = Optional.empty();
            if (rows.length == 0) {
                rows = new Row[]{QueryUtil.row((Expression[])new Expression[]{new NullLiteral(), new NullLiteral()})};
                limit = Optional.of(new Limit((Expression)new LongLiteral("0")));
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{QueryUtil.identifier((String)"Position"), QueryUtil.identifier((String)"Type")}), (Relation)QueryUtil.aliased((Relation)QueryUtil.values((Row[])rows), (String)"Parameter Input", (List)ImmutableList.of((Object)"Position", (Object)"Type")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"Position")})), Optional.empty(), limit);
        }

        private static Row createDescribeInputRow(Session session, Parameter parameter, Analysis queryAnalysis) {
            Object type = queryAnalysis.getCoercion((Expression)parameter);
            if (type == null) {
                type = UnknownType.UNKNOWN;
            }
            return QueryUtil.row((Expression[])new Expression[]{new LongLiteral(Integer.toString(parameter.getPosition())), new StringLiteral(TypeUtils.getDisplayLabel(type, SystemSessionProperties.isOmitDateTimeTypePrecision(session)))});
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }
    }
}

