/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.prestosql.operator.InterpretedHashGenerator;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.FixedWidthType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class TypeUtils {
    public static final int NULL_HASH_CODE = 0;

    private TypeUtils() {
    }

    public static int expectedValueSize(Type type, int defaultSize) {
        if (type instanceof FixedWidthType) {
            return ((FixedWidthType)type).getFixedSize();
        }
        if (type instanceof VarcharType) {
            return ((VarcharType)type).getLength().map(length -> Math.min(length, defaultSize)).orElse(defaultSize);
        }
        if (type instanceof CharType) {
            return Math.min(((CharType)type).getLength(), defaultSize);
        }
        return defaultSize;
    }

    public static long hashPosition(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return 0L;
        }
        return type.hash(block, position);
    }

    public static long hashPosition(MethodHandle methodHandle, Type type, Block block, int position) {
        if (block.isNull(position)) {
            return 0L;
        }
        try {
            if (type.getJavaType() == Boolean.TYPE) {
                return methodHandle.invoke(type.getBoolean(block, position));
            }
            if (type.getJavaType() == Long.TYPE) {
                return methodHandle.invoke(type.getLong(block, position));
            }
            if (type.getJavaType() == Double.TYPE) {
                return methodHandle.invoke(type.getDouble(block, position));
            }
            if (type.getJavaType() == Slice.class) {
                return methodHandle.invoke(type.getSlice(block, position));
            }
            if (!type.getJavaType().isPrimitive()) {
                return methodHandle.invoke(type.getObject(block, position));
            }
            throw new UnsupportedOperationException("Unsupported native container type: " + type.getJavaType() + " with type " + type.getTypeSignature());
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    public static boolean positionEqualsPosition(Type type, Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        boolean leftIsNull = leftBlock.isNull(leftPosition);
        boolean rightIsNull = rightBlock.isNull(rightPosition);
        if (leftIsNull || rightIsNull) {
            return leftIsNull && rightIsNull;
        }
        return type.equalTo(leftBlock, leftPosition, rightBlock, rightPosition);
    }

    public static long getHashPosition(List<? extends Type> hashTypes, Block[] hashBlocks, int position) {
        int[] hashChannels = new int[hashBlocks.length];
        for (int i = 0; i < hashBlocks.length; ++i) {
            hashChannels[i] = i;
        }
        InterpretedHashGenerator hashGenerator = new InterpretedHashGenerator((List<Type>)ImmutableList.copyOf(hashTypes), hashChannels);
        Page page = new Page(hashBlocks);
        return hashGenerator.hashPosition(position, page);
    }

    public static Block getHashBlock(List<? extends Type> hashTypes, Block ... hashBlocks) {
        Preconditions.checkArgument((hashTypes.size() == hashBlocks.length ? 1 : 0) != 0);
        int[] hashChannels = new int[hashBlocks.length];
        for (int i = 0; i < hashBlocks.length; ++i) {
            hashChannels[i] = i;
        }
        InterpretedHashGenerator hashGenerator = new InterpretedHashGenerator((List<Type>)ImmutableList.copyOf(hashTypes), hashChannels);
        int positionCount = hashBlocks[0].getPositionCount();
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(positionCount);
        Page page = new Page(hashBlocks);
        for (int i = 0; i < positionCount; ++i) {
            BigintType.BIGINT.writeLong(builder, hashGenerator.hashPosition(i, page));
        }
        return builder.build();
    }

    public static Page getHashPage(Page page, List<? extends Type> types, List<Integer> hashChannels) {
        ImmutableList.Builder hashTypes = ImmutableList.builder();
        Block[] hashBlocks = new Block[hashChannels.size()];
        int hashBlockIndex = 0;
        for (int channel : hashChannels) {
            hashTypes.add((Object)types.get(channel));
            hashBlocks[hashBlockIndex++] = page.getBlock(channel);
        }
        return page.appendColumn(TypeUtils.getHashBlock((List<? extends Type>)hashTypes.build(), hashBlocks));
    }

    public static void checkElementNotNull(boolean isNull, String errorMsg) {
        if (isNull) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, errorMsg);
        }
    }

    public static String getDisplayLabel(Type type, boolean legacy) {
        if (legacy) {
            return TypeUtils.getDisplayLabelForLegacyClients(type);
        }
        return type.getDisplayName();
    }

    private static String getDisplayLabelForLegacyClients(Type type) {
        if (type instanceof TimestampType && ((TimestampType)type).getPrecision() == 3) {
            return "timestamp";
        }
        if (type instanceof TimestampWithTimeZoneType && ((TimestampWithTimeZoneType)type).getPrecision() == 3) {
            return "timestamp with time zone";
        }
        if (type instanceof TimeType && ((TimeType)type).getPrecision() == 3) {
            return "time";
        }
        if (type instanceof TimeWithTimeZoneType && ((TimeWithTimeZoneType)type).getPrecision() == 3) {
            return "time with time zone";
        }
        if (type instanceof ArrayType) {
            return "array(" + TypeUtils.getDisplayLabelForLegacyClients(((ArrayType)type).getElementType()) + ")";
        }
        if (type instanceof MapType) {
            return "map(" + TypeUtils.getDisplayLabelForLegacyClients(((MapType)type).getKeyType()) + ", " + TypeUtils.getDisplayLabelForLegacyClients(((MapType)type).getValueType()) + ")";
        }
        if (type instanceof RowType) {
            return TypeUtils.getRowDisplayLabelForLegacyClients((RowType)type);
        }
        return type.getDisplayName();
    }

    private static String getRowDisplayLabelForLegacyClients(RowType type) {
        List fields = (List)type.getFields().stream().map(field -> {
            String typeDisplayName = TypeUtils.getDisplayLabelForLegacyClients(field.getType());
            if (field.getName().isPresent()) {
                return (String)field.getName().get() + " " + typeDisplayName;
            }
            return typeDisplayName;
        }).collect(ImmutableList.toImmutableList());
        return String.format("%s(%s)", "row", Joiner.on((String)", ").join((Iterable)fields));
    }
}

