/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type.setdigest;

import io.prestosql.array.ObjectBigArray;
import io.prestosql.spi.function.AccumulatorStateFactory;
import io.prestosql.spi.function.GroupedAccumulatorState;
import io.prestosql.type.setdigest.SetDigest;
import io.prestosql.type.setdigest.SetDigestState;
import org.openjdk.jol.info.ClassLayout;

public class SetDigestStateFactory
implements AccumulatorStateFactory<SetDigestState> {
    private static final int SIZE_OF_SINGLE = ClassLayout.parseClass(SingleSetDigestState.class).instanceSize();
    private static final int SIZE_OF_GROUPED = ClassLayout.parseClass(GroupedSetDigestState.class).instanceSize();

    public SetDigestState createSingleState() {
        return new SingleSetDigestState();
    }

    public Class<? extends SetDigestState> getSingleStateClass() {
        return SingleSetDigestState.class;
    }

    public SetDigestState createGroupedState() {
        return new GroupedSetDigestState();
    }

    public Class<? extends SetDigestState> getGroupedStateClass() {
        return GroupedSetDigestState.class;
    }

    public static class SingleSetDigestState
    implements SetDigestState {
        private SetDigest digest;

        @Override
        public SetDigest getDigest() {
            return this.digest;
        }

        @Override
        public void setDigest(SetDigest value) {
            this.digest = value;
        }

        public long getEstimatedSize() {
            if (this.digest == null) {
                return SIZE_OF_SINGLE;
            }
            return SIZE_OF_SINGLE + this.digest.estimatedInMemorySize();
        }
    }

    public static class GroupedSetDigestState
    implements GroupedAccumulatorState,
    SetDigestState {
        private final ObjectBigArray<SetDigest> digests = new ObjectBigArray();
        private long groupId;
        private long size;

        public void setGroupId(long groupId) {
            this.groupId = groupId;
        }

        public void ensureCapacity(long size) {
            this.digests.ensureCapacity(size);
        }

        @Override
        public SetDigest getDigest() {
            return (SetDigest)this.digests.get(this.groupId);
        }

        @Override
        public void setDigest(SetDigest value) {
            if (this.getDigest() != null) {
                this.size -= (long)this.getDigest().estimatedInMemorySize();
            }
            this.size += (long)value.estimatedInMemorySize();
            this.digests.set(this.groupId, (Object)value);
        }

        public long getEstimatedSize() {
            return (long)SIZE_OF_GROUPED + this.size + this.digests.sizeOf();
        }
    }
}

