/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.FunctionInvoker;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.Type;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.booleans.BooleanOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleHash;
import it.unimi.dsi.fastutil.doubles.DoubleOpenCustomHashSet;
import it.unimi.dsi.fastutil.longs.LongHash;
import it.unimi.dsi.fastutil.longs.LongOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class FastutilSetHelper {
    private FastutilSetHelper() {
    }

    public static Set<?> toFastutilHashSet(Set<?> set, Type type, Metadata metadata) {
        return FastutilSetHelper.toFastutilHashSet(set, type, metadata.getScalarFunctionInvoker(metadata.resolveOperator(OperatorType.HASH_CODE, (List<? extends Type>)ImmutableList.of((Object)type)), Optional.empty()), metadata.getScalarFunctionInvoker(metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type)), Optional.empty()));
    }

    public static Set<?> toFastutilHashSet(Set<?> set, Type type, FunctionInvoker hashCode, FunctionInvoker equals) {
        Objects.requireNonNull(set, "set is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(hashCode, "hashCode is null");
        Preconditions.checkArgument((boolean)hashCode.getInstanceFactory().isEmpty(), (Object)"hashCode method has instance factory");
        Objects.requireNonNull(equals, "equals is null");
        Preconditions.checkArgument((boolean)equals.getInstanceFactory().isEmpty(), (Object)"equals method has instance factory");
        Class javaElementType = type.getJavaType();
        if (javaElementType == Long.TYPE) {
            return new LongOpenCustomHashSet(set, 0.25f, (LongHash.Strategy)new LongStrategy(hashCode, equals));
        }
        if (javaElementType == Double.TYPE) {
            return new DoubleOpenCustomHashSet(set, 0.25f, (DoubleHash.Strategy)new DoubleStrategy(hashCode, equals));
        }
        if (javaElementType == Boolean.TYPE) {
            return new BooleanOpenHashSet(set, 0.25f);
        }
        if (!type.getJavaType().isPrimitive()) {
            return new ObjectOpenCustomHashSet(set, 0.25f, (Hash.Strategy)new ObjectStrategy(hashCode, equals));
        }
        throw new UnsupportedOperationException("Unsupported native type in set: " + type.getJavaType() + " with type " + type.getTypeSignature());
    }

    public static boolean in(boolean booleanValue, BooleanOpenHashSet set) {
        return set.contains(booleanValue);
    }

    public static boolean in(double doubleValue, DoubleOpenCustomHashSet set) {
        return set.contains(doubleValue);
    }

    public static boolean in(long longValue, LongOpenCustomHashSet set) {
        return set.contains(longValue);
    }

    public static boolean in(Object objectValue, ObjectOpenCustomHashSet<?> set) {
        return set.contains(objectValue);
    }

    private static final class ObjectStrategy
    implements Hash.Strategy<Object> {
        private final MethodHandle hashCodeHandle;
        private final MethodHandle equalsHandle;

        private ObjectStrategy(FunctionInvoker hashCode, FunctionInvoker equals) {
            this.hashCodeHandle = hashCode.getMethodHandle().asType(MethodType.methodType(Long.TYPE, Object.class));
            this.equalsHandle = equals.getMethodHandle().asType(MethodType.methodType(Boolean.class, Object.class, Object.class));
        }

        public int hashCode(Object value) {
            if (value == null) {
                return 0;
            }
            try {
                return Long.hashCode(this.hashCodeHandle.invokeExact(value));
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }

        public boolean equals(Object a, Object b) {
            if (b == null || a == null) {
                return a == null && b == null;
            }
            try {
                Boolean result = this.equalsHandle.invokeExact(a, b);
                Verify.verifyNotNull((Object)result, (String)"result is null", (Object[])new Object[0]);
                return Boolean.TRUE.equals(result);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }

    private static final class DoubleStrategy
    implements DoubleHash.Strategy {
        private final MethodHandle hashCodeHandle;
        private final MethodHandle equalsHandle;

        private DoubleStrategy(FunctionInvoker hashCode, FunctionInvoker equals) {
            this.hashCodeHandle = hashCode.getMethodHandle();
            this.equalsHandle = equals.getMethodHandle();
        }

        public int hashCode(double value) {
            try {
                return Long.hashCode(this.hashCodeHandle.invokeExact(value));
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }

        public boolean equals(double a, double b) {
            try {
                Boolean result = this.equalsHandle.invokeExact(a, b);
                Verify.verifyNotNull((Object)result, (String)"result is null", (Object[])new Object[0]);
                return Boolean.TRUE.equals(result);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }

    private static final class LongStrategy
    implements LongHash.Strategy {
        private final MethodHandle hashCodeHandle;
        private final MethodHandle equalsHandle;

        private LongStrategy(FunctionInvoker hashCode, FunctionInvoker equals) {
            this.hashCodeHandle = hashCode.getMethodHandle();
            this.equalsHandle = equals.getMethodHandle();
        }

        public int hashCode(long value) {
            try {
                return Long.hashCode(this.hashCodeHandle.invokeExact(value));
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }

        public boolean equals(long a, long b) {
            try {
                Boolean result = this.equalsHandle.invokeExact(a, b);
                Verify.verifyNotNull((Object)result, (String)"result is null", (Object[])new Object[0]);
                return Boolean.TRUE.equals(result);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }
}

