/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql;

import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.testing.TestingSession;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestSession {
    @Test
    public void testSetCatalogProperty() {
        Session session = Session.builder((Session)TestingSession.testSessionBuilder().build()).setCatalogSessionProperty("some_catalog", "first_property", "some_value").build();
        Assertions.assertThat((Map)session.getUnprocessedCatalogProperties()).isEqualTo(Map.of("some_catalog", Map.of("first_property", "some_value")));
        Assertions.assertThat((Map)session.getConnectorProperties()).isEqualTo(Map.of());
        Assertions.assertThat((Map)session.getConnectorProperties(new CatalogName("some_catalog"))).isEqualTo(Map.of());
    }

    @Test
    public void testBuildWithCatalogProperty() {
        Session session = Session.builder((Session)TestingSession.testSessionBuilder().build()).setCatalogSessionProperty("some_catalog", "first_property", "some_value").build();
        session = Session.builder((Session)session).build();
        Assertions.assertThat((Map)session.getUnprocessedCatalogProperties()).isEqualTo(Map.of("some_catalog", Map.of("first_property", "some_value")));
        Assertions.assertThat((Map)session.getConnectorProperties()).isEqualTo(Map.of());
        Assertions.assertThat((Map)session.getConnectorProperties(new CatalogName("some_catalog"))).isEqualTo(Map.of());
    }

    @Test
    public void testAddSecondCatalogProperty() {
        Session session = Session.builder((Session)TestingSession.testSessionBuilder().build()).setCatalogSessionProperty("some_catalog", "first_property", "some_value").build();
        session = Session.builder((Session)session).setCatalogSessionProperty("some_catalog", "second_property", "another_value").build();
        Assertions.assertThat((Map)session.getUnprocessedCatalogProperties()).isEqualTo(Map.of("some_catalog", Map.of("first_property", "some_value", "second_property", "another_value")));
        Assertions.assertThat((Map)session.getConnectorProperties()).isEqualTo(Map.of());
        Assertions.assertThat((Map)session.getConnectorProperties(new CatalogName("some_catalog"))).isEqualTo(Map.of());
    }
}

