/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.connector.MockConnectorAccessControl;
import io.prestosql.connector.MockConnectorColumnHandle;
import io.prestosql.connector.MockConnectorFactory;
import io.prestosql.connector.MockConnectorInsertTableHandle;
import io.prestosql.connector.MockConnectorOutputTableHandle;
import io.prestosql.connector.MockConnectorTableHandle;
import io.prestosql.connector.MockConnectorTransactionHandle;
import io.prestosql.spi.connector.AggregateFunction;
import io.prestosql.spi.connector.AggregationApplicationResult;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorNewTableLayout;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.ProjectionApplicationResult;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.SortItem;
import io.prestosql.spi.connector.TableScanRedirectApplicationResult;
import io.prestosql.spi.connector.TopNApplicationResult;
import io.prestosql.spi.eventlistener.EventListener;
import io.prestosql.spi.expression.ConnectorExpression;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.transaction.IsolationLevel;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class MockConnector
implements Connector {
    private final Function<ConnectorSession, List<String>> listSchemaNames;
    private final BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables;
    private final BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews;
    private final BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle;
    private final Function<SchemaTableName, List<ColumnMetadata>> getColumns;
    private final MockConnectorFactory.ApplyProjection applyProjection;
    private final MockConnectorFactory.ApplyAggregation applyAggregation;
    private final MockConnectorFactory.ApplyTopN applyTopN;
    private final MockConnectorFactory.ApplyFilter applyFilter;
    private final MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect;
    private final BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorNewTableLayout>> getInsertLayout;
    private final BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorNewTableLayout>> getNewTableLayout;
    private final Supplier<Iterable<EventListener>> eventListeners;
    private final MockConnectorFactory.ListRoleGrants roleGrants;
    private final MockConnectorAccessControl accessControl;

    MockConnector(Function<ConnectorSession, List<String>> listSchemaNames, BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables, BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews, BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle, Function<SchemaTableName, List<ColumnMetadata>> getColumns, MockConnectorFactory.ApplyProjection applyProjection, MockConnectorFactory.ApplyAggregation applyAggregation, MockConnectorFactory.ApplyTopN applyTopN, MockConnectorFactory.ApplyFilter applyFilter, MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect, BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorNewTableLayout>> getInsertLayout, BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorNewTableLayout>> getNewTableLayout, Supplier<Iterable<EventListener>> eventListeners, MockConnectorFactory.ListRoleGrants roleGrants, MockConnectorAccessControl accessControl) {
        this.listSchemaNames = Objects.requireNonNull(listSchemaNames, "listSchemaNames is null");
        this.listTables = Objects.requireNonNull(listTables, "listTables is null");
        this.getViews = Objects.requireNonNull(getViews, "getViews is null");
        this.getTableHandle = Objects.requireNonNull(getTableHandle, "getTableHandle is null");
        this.getColumns = Objects.requireNonNull(getColumns, "getColumns is null");
        this.applyProjection = Objects.requireNonNull(applyProjection, "applyProjection is null");
        this.applyAggregation = Objects.requireNonNull(applyAggregation, "applyAggregation is null");
        this.applyTopN = Objects.requireNonNull(applyTopN, "applyTopN is null");
        this.applyFilter = Objects.requireNonNull(applyFilter, "applyFilter is null");
        this.applyTableScanRedirect = Objects.requireNonNull(applyTableScanRedirect, "applyTableScanRedirection is null");
        this.getInsertLayout = Objects.requireNonNull(getInsertLayout, "getInsertLayout is null");
        this.getNewTableLayout = Objects.requireNonNull(getNewTableLayout, "getNewTableLayout is null");
        this.eventListeners = Objects.requireNonNull(eventListeners, "eventListeners is null");
        this.roleGrants = Objects.requireNonNull(roleGrants, "roleGrants is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        return MockConnectorTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
        return new MockConnectorMetadata();
    }

    public ConnectorSplitManager getSplitManager() {
        return new ConnectorSplitManager(){};
    }

    public Iterable<EventListener> getEventListeners() {
        return this.eventListeners.get();
    }

    public ConnectorAccessControl getAccessControl() {
        return this.accessControl;
    }

    private class MockConnectorMetadata
    implements ConnectorMetadata {
        private MockConnectorMetadata() {
        }

        public boolean schemaExists(ConnectorSession session, String schemaName) {
            return MockConnector.this.listSchemaNames.apply(session).contains(schemaName);
        }

        public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle handle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
            return MockConnector.this.applyProjection.apply(session, handle, projections, assignments);
        }

        public Optional<AggregationApplicationResult<ConnectorTableHandle>> applyAggregation(ConnectorSession session, ConnectorTableHandle handle, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
            return MockConnector.this.applyAggregation.apply(session, handle, aggregates, assignments, groupingSets);
        }

        public Optional<TopNApplicationResult<ConnectorTableHandle>> applyTopN(ConnectorSession session, ConnectorTableHandle handle, long topNCount, List<SortItem> sortItems, Map<String, ColumnHandle> assignments) {
            return MockConnector.this.applyTopN.apply(session, handle, topNCount, sortItems, assignments);
        }

        public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
            return MockConnector.this.applyFilter.apply(session, handle, constraint);
        }

        public Optional<TableScanRedirectApplicationResult> applyTableScanRedirect(ConnectorSession session, ConnectorTableHandle tableHandle) {
            return MockConnector.this.applyTableScanRedirect.apply(session, tableHandle);
        }

        public List<String> listSchemaNames(ConnectorSession session) {
            return MockConnector.this.listSchemaNames.apply(session);
        }

        public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
            return MockConnector.this.getTableHandle.apply(session, tableName);
        }

        public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
            MockConnectorTableHandle table = (MockConnectorTableHandle)tableHandle;
            return new ConnectorTableMetadata(table.getTableName(), MockConnector.this.getColumns.apply(table.getTableName()));
        }

        public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
            if (schemaName.isPresent()) {
                return MockConnector.this.listTables.apply(session, schemaName.get());
            }
            ImmutableList.Builder tableNames = ImmutableList.builder();
            for (String schema : this.listSchemaNames(session)) {
                tableNames.addAll((Iterable)MockConnector.this.listTables.apply(session, schema));
            }
            return tableNames.build();
        }

        public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
            MockConnectorTableHandle table = (MockConnectorTableHandle)tableHandle;
            return (Map)MockConnector.this.getColumns.apply(table.getTableName()).stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, column -> new MockConnectorColumnHandle(column.getName(), column.getType())));
        }

        public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
            MockConnectorColumnHandle mockColumnHandle = (MockConnectorColumnHandle)columnHandle;
            return new ColumnMetadata(mockColumnHandle.getName(), mockColumnHandle.getType());
        }

        public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
            return (Map)this.listTables(session, prefix.getSchema()).stream().filter(arg_0 -> ((SchemaTablePrefix)prefix).matches(arg_0)).collect(ImmutableMap.toImmutableMap(table -> table, MockConnector.this.getColumns));
        }

        public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
            return MockConnector.this.getViews.apply(session, schemaName.map(SchemaTablePrefix::new).orElseGet(SchemaTablePrefix::new));
        }

        public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
            return Optional.ofNullable(MockConnector.this.getViews.apply(session, viewName.toSchemaTablePrefix()).get(viewName));
        }

        public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
            return new MockConnectorInsertTableHandle();
        }

        public Optional<ConnectorNewTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
            MockConnectorTableHandle table = (MockConnectorTableHandle)tableHandle;
            return MockConnector.this.getInsertLayout.apply(session, table.getTableName());
        }

        public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
            return new MockConnectorOutputTableHandle();
        }

        public Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
            return MockConnector.this.getNewTableLayout.apply(session, tableMetadata);
        }

        public boolean usesLegacyTableLayouts() {
            return false;
        }

        public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
            return new ConnectorTableProperties();
        }

        public Set<String> listRoles(ConnectorSession session) {
            return (Set)MockConnector.this.roleGrants.apply(session, Optional.empty(), Optional.empty(), OptionalLong.empty()).stream().map(grant -> grant.getRoleName()).collect(ImmutableSet.toImmutableSet());
        }

        public Set<RoleGrant> listRoleGrants(ConnectorSession session, PrestoPrincipal principal) {
            return (Set)MockConnector.this.roleGrants.apply(session, Optional.empty(), Optional.empty(), OptionalLong.empty()).stream().filter(grant -> grant.getGrantee().equals((Object)principal)).collect(ImmutableSet.toImmutableSet());
        }

        public Set<RoleGrant> listAllRoleGrants(ConnectorSession session, Optional<Set<String>> roles, Optional<Set<String>> grantees, OptionalLong limit) {
            return MockConnector.this.roleGrants.apply(session, roles, grantees, limit);
        }

        public Set<RoleGrant> listApplicableRoles(ConnectorSession session, PrestoPrincipal principal) {
            return this.listRoleGrants(session, principal);
        }

        public Set<String> listEnabledRoles(ConnectorSession session) {
            return this.listRoles(session);
        }

        public void grantSchemaPrivileges(ConnectorSession session, String schemaName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
            MockConnector.this.accessControl.grantSchemaPrivileges(schemaName, privileges, grantee, grantOption);
        }

        public void revokeSchemaPrivileges(ConnectorSession session, String schemaName, Set<Privilege> privileges, PrestoPrincipal revokee, boolean grantOption) {
            MockConnector.this.accessControl.revokeSchemaPrivileges(schemaName, privileges, revokee, grantOption);
        }

        public void grantTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
            MockConnector.this.accessControl.grantTablePrivileges(tableName, privileges, grantee, grantOption);
        }

        public void revokeTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, PrestoPrincipal revokee, boolean grantOption) {
            MockConnector.this.accessControl.revokeTablePrivileges(tableName, privileges, revokee, grantOption);
        }
    }
}

