/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector;

import com.google.common.collect.ImmutableSet;
import io.prestosql.connector.Grants;
import io.prestosql.plugin.base.security.AllowAllAccessControl;
import io.prestosql.spi.connector.ConnectorSecurityContext;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.ConnectorIdentity;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

class MockConnectorAccessControl
extends AllowAllAccessControl {
    private static final String INFORMATION_SCHEMA = "information_schema";
    private final Grants<String> schemaGrants;
    private final Grants<SchemaTableName> tableGrants;

    MockConnectorAccessControl(Grants<String> schemaGrants, Grants<SchemaTableName> tableGrants) {
        this.schemaGrants = Objects.requireNonNull(schemaGrants, "schemaGrants is null");
        this.tableGrants = Objects.requireNonNull(tableGrants, "tableGrants is null");
    }

    public Set<String> filterSchemas(ConnectorSecurityContext context, Set<String> schemaNames) {
        return (Set)schemaNames.stream().filter(schema -> this.canAccessSchema(context.getIdentity(), (String)schema)).collect(ImmutableSet.toImmutableSet());
    }

    public void checkCanGrantSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, PrestoPrincipal grantee, boolean grantOption) {
        if (!this.schemaGrants.canGrant(context.getIdentity().getUser(), schemaName, privilege)) {
            AccessDeniedException.denyGrantSchemaPrivilege((String)privilege.toString(), (String)schemaName);
        }
    }

    public void checkCanRevokeSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, PrestoPrincipal revokee, boolean grantOption) {
        if (!this.schemaGrants.canGrant(context.getIdentity().getUser(), schemaName, privilege)) {
            AccessDeniedException.denyRevokeSchemaPrivilege((String)privilege.toString(), (String)schemaName);
        }
    }

    public Set<SchemaTableName> filterTables(ConnectorSecurityContext context, Set<SchemaTableName> tableNames) {
        return (Set)tableNames.stream().filter(tableName -> this.canAccessSchema(context.getIdentity(), tableName.getSchemaName()) || this.canAccessTable(context.getIdentity(), (SchemaTableName)tableName)).collect(ImmutableSet.toImmutableSet());
    }

    public void checkCanGrantTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal grantee, boolean grantOption) {
        String user = context.getIdentity().getUser();
        if (!this.schemaGrants.canGrant(user, tableName.getSchemaName(), privilege) && !this.tableGrants.canGrant(user, tableName, privilege)) {
            AccessDeniedException.denyGrantTablePrivilege((String)privilege.toString(), (String)tableName.getTableName());
        }
    }

    public void checkCanRevokeTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal revokee, boolean grantOption) {
        String user = context.getIdentity().getUser();
        if (!this.schemaGrants.canGrant(user, tableName.getSchemaName(), privilege) && !this.tableGrants.canGrant(user, tableName, privilege)) {
            AccessDeniedException.denyRevokeTablePrivilege((String)privilege.toString(), (String)tableName.toString());
        }
    }

    public void grantSchemaPrivileges(String schemaName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        this.schemaGrants.grant(grantee, schemaName, privileges, grantOption);
    }

    public void revokeSchemaPrivileges(String schemaName, Set<Privilege> privileges, PrestoPrincipal revokee, boolean grantOption) {
        this.schemaGrants.revoke(revokee, schemaName, privileges, grantOption);
    }

    public void grantTablePrivileges(SchemaTableName tableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        this.tableGrants.grant(grantee, tableName, privileges, grantOption);
    }

    public void revokeTablePrivileges(SchemaTableName tableName, Set<Privilege> privileges, PrestoPrincipal revokee, boolean grantOption) {
        this.tableGrants.revoke(revokee, tableName, privileges, grantOption);
    }

    private boolean canAccessSchema(ConnectorIdentity identity, String schemaName) {
        return schemaName.equalsIgnoreCase(INFORMATION_SCHEMA) || Arrays.stream(Privilege.values()).anyMatch(privilege -> this.schemaGrants.isAllowed(identity.getUser(), schemaName, (Privilege)privilege));
    }

    private boolean canAccessTable(ConnectorIdentity identity, SchemaTableName tableName) {
        return Arrays.stream(Privilege.values()).anyMatch(privilege -> this.tableGrants.isAllowed(identity.getUser(), tableName, (Privilege)privilege));
    }
}

