/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.connector.AllowAllGrants;
import io.prestosql.connector.Grants;
import io.prestosql.connector.MockConnector;
import io.prestosql.connector.MockConnectorAccessControl;
import io.prestosql.connector.MockConnectorHandleResolver;
import io.prestosql.connector.MockConnectorTableHandle;
import io.prestosql.spi.connector.AggregateFunction;
import io.prestosql.spi.connector.AggregationApplicationResult;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import io.prestosql.spi.connector.ConnectorNewTableLayout;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.ProjectionApplicationResult;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.SortItem;
import io.prestosql.spi.connector.TableScanRedirectApplicationResult;
import io.prestosql.spi.connector.TopNApplicationResult;
import io.prestosql.spi.eventlistener.EventListener;
import io.prestosql.spi.expression.ConnectorExpression;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public class MockConnectorFactory
implements ConnectorFactory {
    private final Function<ConnectorSession, List<String>> listSchemaNames;
    private final BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables;
    private final BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews;
    private final BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle;
    private final Function<SchemaTableName, List<ColumnMetadata>> getColumns;
    private final ApplyProjection applyProjection;
    private final ApplyAggregation applyAggregation;
    private final ApplyTopN applyTopN;
    private final ApplyFilter applyFilter;
    private final ApplyTableScanRedirect applyTableScanRedirect;
    private final BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorNewTableLayout>> getInsertLayout;
    private final BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorNewTableLayout>> getNewTableLayout;
    private final Supplier<Iterable<EventListener>> eventListeners;
    private final ListRoleGrants roleGrants;
    private final MockConnectorAccessControl accessControl;

    private MockConnectorFactory(Function<ConnectorSession, List<String>> listSchemaNames, BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables, BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews, BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle, Function<SchemaTableName, List<ColumnMetadata>> getColumns, ApplyProjection applyProjection, ApplyAggregation applyAggregation, ApplyTopN applyTopN, ApplyFilter applyFilter, ApplyTableScanRedirect applyTableScanRedirect, BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorNewTableLayout>> getInsertLayout, BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorNewTableLayout>> getNewTableLayout, Supplier<Iterable<EventListener>> eventListeners, ListRoleGrants roleGrants, MockConnectorAccessControl accessControl) {
        this.listSchemaNames = Objects.requireNonNull(listSchemaNames, "listSchemaNames is null");
        this.listTables = Objects.requireNonNull(listTables, "listTables is null");
        this.getViews = Objects.requireNonNull(getViews, "getViews is null");
        this.getTableHandle = Objects.requireNonNull(getTableHandle, "getTableHandle is null");
        this.getColumns = Objects.requireNonNull(getColumns, "getColumns is null");
        this.applyProjection = Objects.requireNonNull(applyProjection, "applyProjection is null");
        this.applyAggregation = Objects.requireNonNull(applyAggregation, "applyAggregation is null");
        this.applyTopN = Objects.requireNonNull(applyTopN, "applyTopN is null");
        this.applyFilter = Objects.requireNonNull(applyFilter, "applyFilter is null");
        this.applyTableScanRedirect = Objects.requireNonNull(applyTableScanRedirect, "applyTableScanRedirection is null");
        this.getInsertLayout = Objects.requireNonNull(getInsertLayout, "getInsertLayout is null");
        this.getNewTableLayout = Objects.requireNonNull(getNewTableLayout, "getNewTableLayout is null");
        this.eventListeners = Objects.requireNonNull(eventListeners, "eventListeners is null");
        this.roleGrants = Objects.requireNonNull(roleGrants, "roleGrants is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public String getName() {
        return "mock";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new MockConnectorHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        return new MockConnector(this.listSchemaNames, this.listTables, this.getViews, this.getTableHandle, this.getColumns, this.applyProjection, this.applyAggregation, this.applyTopN, this.applyFilter, this.applyTableScanRedirect, this.getInsertLayout, this.getNewTableLayout, this.eventListeners, this.roleGrants, this.accessControl);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Function<ConnectorSession, List<String>> listSchemaNames = Builder.defaultListSchemaNames();
        private BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables = Builder.defaultListTables();
        private BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews = Builder.defaultGetViews();
        private BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle = Builder.defaultGetTableHandle();
        private Function<SchemaTableName, List<ColumnMetadata>> getColumns = Builder.defaultGetColumns();
        private ApplyProjection applyProjection = (session, handle, projections, assignments) -> Optional.empty();
        private ApplyAggregation applyAggregation = (session, handle, aggregates, assignments, groupingSets) -> Optional.empty();
        private BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorNewTableLayout>> getInsertLayout = Builder.defaultGetInsertLayout();
        private BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorNewTableLayout>> getNewTableLayout = Builder.defaultGetNewTableLayout();
        private Supplier<Iterable<EventListener>> eventListeners = ImmutableList::of;
        private ListRoleGrants roleGrants = Builder.defaultRoleAuthorizations();
        private ApplyTopN applyTopN = (session, handle, topNCount, sortItems, assignments) -> Optional.empty();
        private Grants<String> schemaGrants = new AllowAllGrants<String>();
        private Grants<SchemaTableName> tableGrants = new AllowAllGrants<SchemaTableName>();
        private ApplyFilter applyFilter = (session, handle, constraint) -> Optional.empty();
        private ApplyTableScanRedirect applyTableScanRedirect = (session, handle) -> Optional.empty();

        public Builder withListSchemaNames(Function<ConnectorSession, List<String>> listSchemaNames) {
            this.listSchemaNames = Objects.requireNonNull(listSchemaNames, "listSchemaNames is null");
            return this;
        }

        public Builder withListRoleGrants(ListRoleGrants roleGrants) {
            this.roleGrants = Objects.requireNonNull(roleGrants, "roleGrants is null");
            return this;
        }

        public Builder withListTables(BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables) {
            this.listTables = Objects.requireNonNull(listTables, "listTables is null");
            return this;
        }

        public Builder withGetViews(BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews) {
            this.getViews = Objects.requireNonNull(getViews, "getViews is null");
            return this;
        }

        public Builder withGetTableHandle(BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle) {
            this.getTableHandle = Objects.requireNonNull(getTableHandle, "getTableHandle is null");
            return this;
        }

        public Builder withGetColumns(Function<SchemaTableName, List<ColumnMetadata>> getColumns) {
            this.getColumns = Objects.requireNonNull(getColumns, "getColumns is null");
            return this;
        }

        public Builder withApplyProjection(ApplyProjection applyProjection) {
            this.applyProjection = applyProjection;
            return this;
        }

        public Builder withApplyAggregation(ApplyAggregation applyAggregation) {
            this.applyAggregation = applyAggregation;
            return this;
        }

        public Builder withApplyTopN(ApplyTopN applyTopN) {
            this.applyTopN = applyTopN;
            return this;
        }

        public Builder withApplyFilter(ApplyFilter applyFilter) {
            this.applyFilter = applyFilter;
            return this;
        }

        public Builder withApplyTableScanRedirect(ApplyTableScanRedirect applyTableScanRedirect) {
            this.applyTableScanRedirect = applyTableScanRedirect;
            return this;
        }

        public Builder withGetInsertLayout(BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorNewTableLayout>> getInsertLayout) {
            this.getInsertLayout = Objects.requireNonNull(getInsertLayout, "getInsertLayout is null");
            return this;
        }

        public Builder withGetNewTableLayout(BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorNewTableLayout>> getNewTableLayout) {
            this.getNewTableLayout = Objects.requireNonNull(getNewTableLayout, "getNewTableLayout is null");
            return this;
        }

        public Builder withEventListener(EventListener listener) {
            Objects.requireNonNull(listener, "listener is null");
            this.withEventListener(() -> listener);
            return this;
        }

        public Builder withEventListener(Supplier<EventListener> listenerFactory) {
            Objects.requireNonNull(listenerFactory, "listenerFactory is null");
            this.eventListeners = () -> ImmutableList.of((Object)((EventListener)listenerFactory.get()));
            return this;
        }

        public Builder withSchemaGrants(Grants<String> schemaGrants) {
            this.schemaGrants = schemaGrants;
            return this;
        }

        public Builder withTableGrants(Grants<SchemaTableName> tableGrants) {
            this.tableGrants = tableGrants;
            return this;
        }

        public MockConnectorFactory build() {
            return new MockConnectorFactory(this.listSchemaNames, this.listTables, this.getViews, this.getTableHandle, this.getColumns, this.applyProjection, this.applyAggregation, this.applyTopN, this.applyFilter, this.applyTableScanRedirect, this.getInsertLayout, this.getNewTableLayout, this.eventListeners, this.roleGrants, new MockConnectorAccessControl(this.schemaGrants, this.tableGrants));
        }

        public static Function<ConnectorSession, List<String>> defaultListSchemaNames() {
            return session -> ImmutableList.of();
        }

        public static ListRoleGrants defaultRoleAuthorizations() {
            return (session, roles, grantees, limit) -> ImmutableSet.of();
        }

        public static BiFunction<ConnectorSession, String, List<SchemaTableName>> defaultListTables() {
            return (session, schemaName) -> ImmutableList.of();
        }

        public static BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> defaultGetViews() {
            return (session, schemaTablePrefix) -> ImmutableMap.of();
        }

        public static BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> defaultGetTableHandle() {
            return (session, schemaTableName) -> new MockConnectorTableHandle((SchemaTableName)schemaTableName);
        }

        public static BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorNewTableLayout>> defaultGetInsertLayout() {
            return (session, tableHandle) -> Optional.empty();
        }

        public static BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorNewTableLayout>> defaultGetNewTableLayout() {
            return (session, tableHandle) -> Optional.empty();
        }

        public static Function<SchemaTableName, List<ColumnMetadata>> defaultGetColumns() {
            return table -> (List)IntStream.range(0, 100).boxed().map(i -> new ColumnMetadata("column_" + i, (Type)VarcharType.createUnboundedVarcharType())).collect(ImmutableList.toImmutableList());
        }
    }

    @FunctionalInterface
    public static interface ListRoleGrants {
        public Set<RoleGrant> apply(ConnectorSession var1, Optional<Set<String>> var2, Optional<Set<String>> var3, OptionalLong var4);
    }

    @FunctionalInterface
    public static interface ApplyTableScanRedirect {
        public Optional<TableScanRedirectApplicationResult> apply(ConnectorSession var1, ConnectorTableHandle var2);
    }

    @FunctionalInterface
    public static interface ApplyFilter {
        public Optional<ConstraintApplicationResult<ConnectorTableHandle>> apply(ConnectorSession var1, ConnectorTableHandle var2, Constraint var3);
    }

    @FunctionalInterface
    public static interface ApplyTopN {
        public Optional<TopNApplicationResult<ConnectorTableHandle>> apply(ConnectorSession var1, ConnectorTableHandle var2, long var3, List<SortItem> var5, Map<String, ColumnHandle> var6);
    }

    @FunctionalInterface
    public static interface ApplyAggregation {
        public Optional<AggregationApplicationResult<ConnectorTableHandle>> apply(ConnectorSession var1, ConnectorTableHandle var2, List<AggregateFunction> var3, Map<String, ColumnHandle> var4, List<List<ColumnHandle>> var5);
    }

    @FunctionalInterface
    public static interface ApplyProjection {
        public Optional<ProjectionApplicationResult<ConnectorTableHandle>> apply(ConnectorSession var1, ConnectorTableHandle var2, List<ConnectorExpression> var3, Map<String, ColumnHandle> var4);
    }
}

