/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.cost.CachingCostProvider;
import io.prestosql.cost.CachingStatsProvider;
import io.prestosql.cost.CostCalculator;
import io.prestosql.cost.CostCalculatorUsingExchanges;
import io.prestosql.cost.CostCalculatorWithEstimatedExchanges;
import io.prestosql.cost.CostProvider;
import io.prestosql.cost.PlanCostEstimate;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.StatsAndCosts;
import io.prestosql.cost.StatsCalculator;
import io.prestosql.cost.StatsProvider;
import io.prestosql.cost.SymbolStatsEstimate;
import io.prestosql.cost.TaskCountEstimator;
import io.prestosql.execution.QueryManagerConfig;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.TableHandle;
import io.prestosql.plugin.tpch.TpchColumnHandle;
import io.prestosql.plugin.tpch.TpchConnectorFactory;
import io.prestosql.plugin.tpch.TpchTableHandle;
import io.prestosql.plugin.tpch.TpchTableLayoutHandle;
import io.prestosql.plugin.tpch.TpchTransactionHandle;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.planner.Plan;
import io.prestosql.sql.planner.PlanFragmenter;
import io.prestosql.sql.planner.SubPlan;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.EnforceSingleRowNode;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.plan.UnionNode;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.IsNullPredicate;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.TestingSession;
import io.prestosql.transaction.TransactionBuilder;
import io.prestosql.transaction.TransactionManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestCostCalculator {
    private static final int NUMBER_OF_NODES = 10;
    private static final double AVERAGE_ROW_SIZE = 8.0;
    private static final double IS_NULL_OVERHEAD = 1.125;
    private static final double OFFSET_AND_IS_NULL_OVERHEAD = 1.625;
    private CostCalculator costCalculatorUsingExchanges;
    private CostCalculator costCalculatorWithEstimatedExchanges;
    private PlanFragmenter planFragmenter;
    private Session session;
    private LocalQueryRunner localQueryRunner;

    @BeforeClass
    public void setUp() {
        TaskCountEstimator taskCountEstimator = new TaskCountEstimator(() -> 10);
        this.costCalculatorUsingExchanges = new CostCalculatorUsingExchanges(taskCountEstimator);
        this.costCalculatorWithEstimatedExchanges = new CostCalculatorWithEstimatedExchanges(this.costCalculatorUsingExchanges, taskCountEstimator);
        this.session = TestingSession.testSessionBuilder().setCatalog("tpch").build();
        this.localQueryRunner = LocalQueryRunner.create((Session)this.session);
        this.localQueryRunner.createCatalog("tpch", (ConnectorFactory)new TpchConnectorFactory(), (Map)ImmutableMap.of());
        this.planFragmenter = new PlanFragmenter(this.localQueryRunner.getMetadata(), this.localQueryRunner.getNodePartitioningManager(), new QueryManagerConfig());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.costCalculatorUsingExchanges = null;
        this.costCalculatorWithEstimatedExchanges = null;
        this.planFragmenter = null;
        this.session = null;
        this.localQueryRunner.close();
        this.localQueryRunner = null;
    }

    @Test
    public void testTableScan() {
        TableScanNode tableScan = this.tableScan("ts", "orderkey");
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)tableScan, (Map<String, PlanCostEstimate>)ImmutableMap.of(), (Map<String, PlanNodeStatsEstimate>)ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0)), (Map<String, Type>)types).cpu(1125.0).memory(0.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)tableScan, (Map<String, PlanCostEstimate>)ImmutableMap.of(), (Map<String, PlanNodeStatsEstimate>)ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0)), (Map<String, Type>)types).cpu(1125.0).memory(0.0).network(0.0);
        this.assertCostFragmentedPlan((PlanNode)tableScan, (Map<String, PlanCostEstimate>)ImmutableMap.of(), (Map<String, PlanNodeStatsEstimate>)ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0)), (Map<String, Type>)types).cpu(1125.0).memory(0.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)tableScan, (Map<String, Type>)types);
    }

    @Test
    public void testProject() {
        TableScanNode tableScan = this.tableScan("ts", "orderkey");
        PlanNode project = this.project("project", (PlanNode)tableScan, "string", (Expression)new Cast((Expression)new SymbolReference("orderkey"), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR)));
        ImmutableMap costs = ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.cpuCost(1000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"project", (Object)TestCostCalculator.statsEstimate(project, 4000.0), (Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0));
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"string", (Object)VarcharType.VARCHAR);
        this.assertCost(project, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(7500.0).memory(0.0).network(0.0);
        this.assertCostEstimatedExchanges(project, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(7500.0).memory(0.0).network(0.0);
        this.assertCostFragmentedPlan(project, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(7500.0).memory(0.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats(project, (Map<String, Type>)types);
    }

    @Test
    public void testFilter() {
        TableScanNode tableScan = this.tableScan("ts", "string");
        IsNullPredicate expression = new IsNullPredicate((Expression)new SymbolReference("string"));
        FilterNode filter = new FilterNode(new PlanNodeId("filter"), (PlanNode)tableScan, (Expression)expression);
        ImmutableMap costs = ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.cpuCost(1000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"filter", (Object)TestCostCalculator.statsEstimate((PlanNode)filter, 4000.0), (Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0));
        ImmutableMap types = ImmutableMap.of((Object)"string", (Object)VarcharType.VARCHAR);
        this.assertCost((PlanNode)filter, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(2625.0).memory(0.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)filter, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(2625.0).memory(0.0).network(0.0);
        this.assertCostFragmentedPlan((PlanNode)filter, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(2625.0).memory(0.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)filter, (Map<String, Type>)types);
    }

    @Test
    public void testRepartitionedJoin() {
        TableScanNode ts1 = this.tableScan("ts1", "orderkey");
        TableScanNode ts2 = this.tableScan("ts2", "orderkey_0");
        JoinNode join = this.join("join", (PlanNode)ts1, (PlanNode)ts2, JoinNode.DistributionType.PARTITIONED, "orderkey", "orderkey_0");
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.cpuCost(6000.0), (Object)"ts2", (Object)TestCostCalculator.cpuCost(1000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 12000.0), (Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 6000.0), (Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0));
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"orderkey_0", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(28375.0).memory(1125.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(37375.0).memory(1125.0).network(7875.0);
        this.assertCostFragmentedPlan((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(28375.0).memory(1125.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)join, (Map<String, Type>)types);
    }

    @Test
    public void testReplicatedJoin() {
        TableScanNode ts1 = this.tableScan("ts1", "orderkey");
        TableScanNode ts2 = this.tableScan("ts2", "orderkey_0");
        JoinNode join = this.join("join", (PlanNode)ts1, (PlanNode)ts2, JoinNode.DistributionType.REPLICATED, "orderkey", "orderkey_0");
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.cpuCost(6000.0), (Object)"ts2", (Object)TestCostCalculator.cpuCost(1000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 12000.0), (Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 6000.0), (Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0));
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"orderkey_0", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(48625.0).memory(11250.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(49750.0).memory(11250.0).network(11250.0);
        this.assertCostFragmentedPlan((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(48625.0).memory(11250.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)join, (Map<String, Type>)types);
    }

    @Test
    public void testMemoryCostJoinAboveJoin() {
        TableScanNode ts1 = this.tableScan("ts1", "key1");
        TableScanNode ts2 = this.tableScan("ts2", "key2");
        TableScanNode ts3 = this.tableScan("ts3", "key3");
        JoinNode join23 = this.join("join23", (PlanNode)ts2, (PlanNode)ts3, JoinNode.DistributionType.PARTITIONED, "key2", "key3");
        JoinNode join = this.join("join", (PlanNode)ts1, (PlanNode)join23, JoinNode.DistributionType.PARTITIONED, "key1", "key2");
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)new PlanCostEstimate(0.0, 128.0, 128.0, 0.0), (Object)"ts2", (Object)new PlanCostEstimate(0.0, 64.0, 64.0, 0.0), (Object)"ts3", (Object)new PlanCostEstimate(0.0, 32.0, 32.0, 0.0));
        ImmutableMap stats = ImmutableMap.of((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 10000.0), (Object)"join23", (Object)TestCostCalculator.statsEstimate((PlanNode)join23, 2000.0), (Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 10000.0), (Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0), (Object)"ts3", (Object)TestCostCalculator.statsEstimate((PlanNode)ts3, 100.0));
        ImmutableMap types = ImmutableMap.of((Object)"key1", (Object)BigintType.BIGINT, (Object)"key2", (Object)BigintType.BIGINT, (Object)"key3", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)join23, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).memory(208.5).memoryWhenOutputting(176.5);
        this.assertCost((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).memory(2554.5).memoryWhenOutputting(2378.0);
        this.assertCostEstimatedExchanges((PlanNode)join23, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).memory(208.5).memoryWhenOutputting(176.5);
        this.assertCostEstimatedExchanges((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).memory(2554.5).memoryWhenOutputting(2378.0);
        this.assertCostFragmentedPlan((PlanNode)join23, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).memory(208.5).memoryWhenOutputting(176.5);
        this.assertCostFragmentedPlan((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).memory(2554.5).memoryWhenOutputting(2378.0);
    }

    @Test
    public void testAggregation() {
        TableScanNode tableScan = this.tableScan("ts", "orderkey");
        AggregationNode aggregation = this.aggregation("agg", (PlanNode)tableScan);
        ImmutableMap costs = ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.cpuCost(6000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 6000.0), (Object)"agg", (Object)TestCostCalculator.statsEstimate((PlanNode)aggregation, 13.0));
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"count", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)aggregation, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(12750.0).memory(14.625).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)aggregation, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(26250.0).memory(14.625).network(6750.0);
        this.assertCostFragmentedPlan((PlanNode)aggregation, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(12750.0).memory(14.625).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)aggregation, (Map<String, Type>)types);
    }

    @Test
    public void testRepartitionedJoinWithExchange() {
        TableScanNode ts1 = this.tableScan("ts1", "orderkey");
        TableScanNode ts2 = this.tableScan("ts2", "orderkey_0");
        ExchangeNode remoteExchange1 = ExchangeNode.partitionedExchange((PlanNodeId)new PlanNodeId("re1"), (ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (PlanNode)ts1, (List)ImmutableList.of((Object)new Symbol("orderkey")), Optional.empty());
        ExchangeNode remoteExchange2 = ExchangeNode.partitionedExchange((PlanNodeId)new PlanNodeId("re2"), (ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (PlanNode)ts2, (List)ImmutableList.of((Object)new Symbol("orderkey_0")), Optional.empty());
        ExchangeNode localExchange = ExchangeNode.partitionedExchange((PlanNodeId)new PlanNodeId("le"), (ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanNode)remoteExchange2, (List)ImmutableList.of((Object)new Symbol("orderkey_0")), Optional.empty());
        JoinNode join = this.join("join", (PlanNode)remoteExchange1, (PlanNode)localExchange, JoinNode.DistributionType.PARTITIONED, "orderkey", "orderkey_0");
        ImmutableMap stats = ImmutableMap.builder().put((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 12000.0)).put((Object)"re1", (Object)TestCostCalculator.statsEstimate((PlanNode)remoteExchange1, 10000.0)).put((Object)"re2", (Object)TestCostCalculator.statsEstimate((PlanNode)remoteExchange2, 10000.0)).put((Object)"le", (Object)TestCostCalculator.statsEstimate((PlanNode)localExchange, 6000.0)).put((Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 6000.0)).put((Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0)).build();
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"orderkey_0", (Object)BigintType.BIGINT);
        this.assertFragmentedEqualsUnfragmented((PlanNode)join, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types);
    }

    @Test
    public void testReplicatedJoinWithExchange() {
        TableScanNode ts1 = this.tableScan("ts1", "orderkey");
        TableScanNode ts2 = this.tableScan("ts2", "orderkey_0");
        ExchangeNode remoteExchange2 = ExchangeNode.replicatedExchange((PlanNodeId)new PlanNodeId("re2"), (ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (PlanNode)ts2);
        ExchangeNode localExchange = ExchangeNode.partitionedExchange((PlanNodeId)new PlanNodeId("le"), (ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanNode)remoteExchange2, (List)ImmutableList.of((Object)new Symbol("orderkey_0")), Optional.empty());
        JoinNode join = this.join("join", (PlanNode)ts1, (PlanNode)localExchange, JoinNode.DistributionType.REPLICATED, "orderkey", "orderkey_0");
        ImmutableMap stats = ImmutableMap.builder().put((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 12000.0)).put((Object)"re2", (Object)TestCostCalculator.statsEstimate((PlanNode)remoteExchange2, 10000.0)).put((Object)"le", (Object)TestCostCalculator.statsEstimate((PlanNode)localExchange, 6000.0)).put((Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 6000.0)).put((Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0)).build();
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"orderkey_0", (Object)BigintType.BIGINT);
        this.assertFragmentedEqualsUnfragmented((PlanNode)join, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types);
    }

    @Test
    public void testUnion() {
        TableScanNode ts1 = this.tableScan("ts1", "orderkey");
        TableScanNode ts2 = this.tableScan("ts2", "orderkey_0");
        ImmutableListMultimap.Builder outputMappings = ImmutableListMultimap.builder();
        outputMappings.put((Object)new Symbol("orderkey_1"), (Object)new Symbol("orderkey"));
        outputMappings.put((Object)new Symbol("orderkey_1"), (Object)new Symbol("orderkey_0"));
        UnionNode union = new UnionNode(new PlanNodeId("union"), (List)ImmutableList.of((Object)ts1, (Object)ts2), (ListMultimap)outputMappings.build(), (List)ImmutableList.of((Object)new Symbol("orderkey_1")));
        ImmutableMap stats = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 4000.0), (Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0), (Object)"union", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 5000.0));
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.cpuCost(1000.0), (Object)"ts2", (Object)TestCostCalculator.cpuCost(1000.0));
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"orderkey_0", (Object)BigintType.BIGINT, (Object)"orderkey_1", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)union, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(2000.0).memory(0.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)union, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(2000.0).memory(0.0).network(5625.0);
    }

    @Test
    public void testLimit() {
        TableScanNode ts1 = this.tableScan("ts1", "orderkey");
        LimitNode limit = new LimitNode(new PlanNodeId("limit"), (PlanNode)ts1, 5L, false);
        ImmutableMap stats = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 4000.0), (Object)"limit", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 40.0));
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.cpuCost(1000.0));
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)limit, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(1045.0).memory(0.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)limit, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(1045.0).memory(0.0).network(0.0);
    }

    @Test
    public void testEnforceSingleRow() {
        TableScanNode ts1 = this.tableScan("ts1", "orderkey");
        EnforceSingleRowNode singleRow = new EnforceSingleRowNode(new PlanNodeId("singleRow"), (PlanNode)ts1);
        ImmutableMap stats = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 4000.0), (Object)"singleRow", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 8.0));
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.cpuCost(1000.0));
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)singleRow, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(1000.0).memory(0.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)singleRow, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(1000.0).memory(0.0).network(0.0);
    }

    private CostAssertionBuilder assertCost(PlanNode node, Map<String, PlanCostEstimate> costs, Map<String, PlanNodeStatsEstimate> stats, Map<String, Type> types) {
        return this.assertCost(this.costCalculatorUsingExchanges, node, costs, stats, types);
    }

    private CostAssertionBuilder assertCostEstimatedExchanges(PlanNode node, Map<String, PlanCostEstimate> costs, Map<String, PlanNodeStatsEstimate> stats, Map<String, Type> types) {
        return this.assertCost(this.costCalculatorWithEstimatedExchanges, node, costs, stats, types);
    }

    private CostAssertionBuilder assertCostFragmentedPlan(PlanNode node, Map<String, PlanCostEstimate> costs, Map<String, PlanNodeStatsEstimate> stats, Map<String, Type> types) {
        TypeProvider typeProvider = TypeProvider.copyOf((Map)((Map)types.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> new Symbol((String)entry.getKey()), Map.Entry::getValue))));
        CachingStatsProvider statsProvider = new CachingStatsProvider(this.statsCalculator(stats), this.session, typeProvider);
        TestingCostProvider costProvider = new TestingCostProvider(costs, this.costCalculatorUsingExchanges, (StatsProvider)statsProvider, this.session, typeProvider);
        SubPlan subPlan = this.fragment(new Plan(node, typeProvider, StatsAndCosts.create((PlanNode)node, (StatsProvider)statsProvider, (CostProvider)costProvider)));
        return new CostAssertionBuilder(subPlan.getFragment().getStatsAndCosts().getCosts().getOrDefault(node.getId(), PlanCostEstimate.unknown()));
    }

    private CostAssertionBuilder assertCost(CostCalculator costCalculator, PlanNode node, Map<String, PlanCostEstimate> costs, Map<String, PlanNodeStatsEstimate> stats, Map<String, Type> types) {
        Function<PlanNode, PlanNodeStatsEstimate> statsProvider = planNode -> (PlanNodeStatsEstimate)stats.get(planNode.getId().toString());
        PlanCostEstimate cost = this.calculateCost(costCalculator, node, this.sourceCostProvider(costCalculator, costs, statsProvider, types), statsProvider, types);
        return new CostAssertionBuilder(cost);
    }

    private Function<PlanNode, PlanCostEstimate> sourceCostProvider(CostCalculator costCalculator, Map<String, PlanCostEstimate> costs, Function<PlanNode, PlanNodeStatsEstimate> statsProvider, Map<String, Type> types) {
        return node -> {
            PlanCostEstimate providedCost = (PlanCostEstimate)costs.get(node.getId().toString());
            if (providedCost != null) {
                return providedCost;
            }
            return this.calculateCost(costCalculator, (PlanNode)node, this.sourceCostProvider(costCalculator, costs, statsProvider, types), statsProvider, types);
        };
    }

    private void assertCostHasUnknownComponentsForUnknownStats(PlanNode node, Map<String, Type> types) {
        new CostAssertionBuilder(this.calculateCost(this.costCalculatorUsingExchanges, node, planNode -> PlanCostEstimate.unknown(), planNode -> PlanNodeStatsEstimate.unknown(), types)).hasUnknownComponents();
        new CostAssertionBuilder(this.calculateCost(this.costCalculatorWithEstimatedExchanges, node, planNode -> PlanCostEstimate.unknown(), planNode -> PlanNodeStatsEstimate.unknown(), types)).hasUnknownComponents();
    }

    private void assertFragmentedEqualsUnfragmented(PlanNode node, Map<String, PlanNodeStatsEstimate> stats, Map<String, Type> types) {
        StatsCalculator statsCalculator = this.statsCalculator(stats);
        PlanCostEstimate costWithExchanges = this.calculateCost(node, this.costCalculatorUsingExchanges, statsCalculator, types);
        PlanCostEstimate costWithFragments = this.calculateCostFragmentedPlan(node, statsCalculator, types);
        Assert.assertEquals((Object)costWithExchanges, (Object)costWithFragments);
    }

    private StatsCalculator statsCalculator(Map<String, PlanNodeStatsEstimate> stats) {
        return (node, sourceStats, lookup, session, types) -> Objects.requireNonNull((PlanNodeStatsEstimate)stats.get(node.getId().toString()), "no stats for node");
    }

    private PlanCostEstimate calculateCost(CostCalculator costCalculator, PlanNode node, Function<PlanNode, PlanCostEstimate> costs, Function<PlanNode, PlanNodeStatsEstimate> stats, Map<String, Type> types) {
        return costCalculator.calculateCost(node, planNode -> Objects.requireNonNull((PlanNodeStatsEstimate)stats.apply(planNode), "no stats for node"), source -> Objects.requireNonNull((PlanCostEstimate)costs.apply(source), String.format("no cost for source: %s", source.getId())), this.session, TypeProvider.copyOf((Map)((Map)types.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> new Symbol((String)entry.getKey()), Map.Entry::getValue)))));
    }

    private PlanCostEstimate calculateCost(PlanNode node, CostCalculator costCalculator, StatsCalculator statsCalculator, Map<String, Type> types) {
        TypeProvider typeProvider = TypeProvider.copyOf((Map)((Map)types.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> new Symbol((String)entry.getKey()), Map.Entry::getValue))));
        CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, this.session, typeProvider);
        CachingCostProvider costProvider = new CachingCostProvider(costCalculator, (StatsProvider)statsProvider, Optional.empty(), this.session, typeProvider);
        return costProvider.getCost(node);
    }

    private PlanCostEstimate calculateCostFragmentedPlan(PlanNode node, StatsCalculator statsCalculator, Map<String, Type> types) {
        TypeProvider typeProvider = TypeProvider.copyOf((Map)((Map)types.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> new Symbol((String)entry.getKey()), Map.Entry::getValue))));
        CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, this.session, typeProvider);
        CachingCostProvider costProvider = new CachingCostProvider(this.costCalculatorUsingExchanges, (StatsProvider)statsProvider, Optional.empty(), this.session, typeProvider);
        SubPlan subPlan = this.fragment(new Plan(node, typeProvider, StatsAndCosts.create((PlanNode)node, (StatsProvider)statsProvider, (CostProvider)costProvider)));
        return subPlan.getFragment().getStatsAndCosts().getCosts().getOrDefault(node.getId(), PlanCostEstimate.unknown());
    }

    private static PlanNodeStatsEstimate statsEstimate(PlanNode node, double outputSizeInBytes) {
        return TestCostCalculator.statsEstimate(node.getOutputSymbols(), outputSizeInBytes);
    }

    private static PlanNodeStatsEstimate statsEstimate(Collection<Symbol> symbols, double outputSizeInBytes) {
        Preconditions.checkArgument((symbols.size() > 0 ? 1 : 0) != 0, (Object)"No symbols");
        Preconditions.checkArgument((ImmutableSet.copyOf(symbols).size() == symbols.size() ? 1 : 0) != 0, (Object)"Duplicate symbols");
        double rowCount = outputSizeInBytes / (double)symbols.size() / 8.0;
        PlanNodeStatsEstimate.Builder builder = PlanNodeStatsEstimate.builder().setOutputRowCount(rowCount);
        for (Symbol symbol : symbols) {
            builder.addSymbolStatistics(symbol, SymbolStatsEstimate.builder().setNullsFraction(0.0).setAverageRowSize(8.0).build());
        }
        return builder.build();
    }

    private TableScanNode tableScan(String id, String ... symbols) {
        List symbolsList = (List)Arrays.stream(symbols).map(Symbol::new).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder assignments = ImmutableMap.builder();
        for (Symbol symbol : symbolsList) {
            assignments.put((Object)symbol, (Object)new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT));
        }
        TpchTableHandle tableHandle = new TpchTableHandle("orders", 1.0);
        return new TableScanNode(new PlanNodeId(id), new TableHandle(new CatalogName("tpch"), (ConnectorTableHandle)tableHandle, (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE, Optional.of(new TpchTableLayoutHandle(tableHandle, TupleDomain.all()))), symbolsList, (Map)assignments.build(), TupleDomain.all(), false);
    }

    private PlanNode project(String id, PlanNode source, String symbol, Expression expression) {
        return new ProjectNode(new PlanNodeId(id), source, Assignments.of((Symbol)new Symbol(symbol), (Expression)expression));
    }

    private AggregationNode aggregation(String id, PlanNode source) {
        AggregationNode.Aggregation aggregation = new AggregationNode.Aggregation(this.localQueryRunner.getMetadata().resolveFunction(QualifiedName.of((String)"count"), (List)ImmutableList.of()), (List)ImmutableList.of(), false, Optional.empty(), Optional.empty(), Optional.empty());
        return new AggregationNode(new PlanNodeId(id), source, (Map)ImmutableMap.of((Object)new Symbol("count"), (Object)aggregation), AggregationNode.singleGroupingSet((List)source.getOutputSymbols()), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty());
    }

    private JoinNode join(String planNodeId, PlanNode left, PlanNode right, JoinNode.DistributionType distributionType, String ... symbols) {
        Preconditions.checkArgument((symbols.length % 2 == 0 ? 1 : 0) != 0);
        ImmutableList.Builder criteria = ImmutableList.builder();
        for (int i = 0; i < symbols.length; i += 2) {
            criteria.add((Object)new JoinNode.EquiJoinClause(new Symbol(symbols[i]), new Symbol(symbols[i + 1])));
        }
        return new JoinNode(new PlanNodeId(planNodeId), JoinNode.Type.INNER, left, right, (List)criteria.build(), left.getOutputSymbols(), right.getOutputSymbols(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(distributionType), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
    }

    private SubPlan fragment(Plan plan) {
        return this.inTransaction(session -> this.planFragmenter.createSubPlans(session, plan, false, WarningCollector.NOOP));
    }

    private <T> T inTransaction(Function<Session, T> transactionSessionConsumer) {
        return (T)TransactionBuilder.transaction((TransactionManager)this.localQueryRunner.getTransactionManager(), (AccessControl)new AllowAllAccessControl()).singleStatement().execute(this.session, session -> {
            session.getCatalog().ifPresent(catalog -> this.localQueryRunner.getMetadata().getCatalogHandle(session, catalog));
            return transactionSessionConsumer.apply((Session)session);
        });
    }

    private static PlanCostEstimate cpuCost(double cpuCost) {
        return new PlanCostEstimate(cpuCost, 0.0, 0.0, 0.0);
    }

    private static class CostAssertionBuilder {
        private final PlanCostEstimate actual;

        CostAssertionBuilder(PlanCostEstimate actual) {
            this.actual = Objects.requireNonNull(actual, "actual is null");
        }

        CostAssertionBuilder cpu(double value) {
            Assert.assertEquals((double)this.actual.getCpuCost(), (double)value, (double)1.0E-6);
            return this;
        }

        CostAssertionBuilder memory(double value) {
            Assert.assertEquals((double)this.actual.getMaxMemory(), (double)value, (double)1.0E-6);
            return this;
        }

        CostAssertionBuilder memoryWhenOutputting(double value) {
            Assert.assertEquals((double)this.actual.getMaxMemoryWhenOutputting(), (double)value, (double)1.0E-6);
            return this;
        }

        CostAssertionBuilder network(double value) {
            Assert.assertEquals((double)this.actual.getNetworkCost(), (double)value, (double)1.0E-6);
            return this;
        }

        CostAssertionBuilder hasUnknownComponents() {
            Assert.assertTrue((boolean)this.actual.hasUnknownComponents());
            return this;
        }
    }

    private static class TestingCostProvider
    implements CostProvider {
        private final Map<String, PlanCostEstimate> costs;
        private final CostCalculator costCalculator;
        private final StatsProvider statsProvider;
        private final Session session;
        private final TypeProvider types;

        private TestingCostProvider(Map<String, PlanCostEstimate> costs, CostCalculator costCalculator, StatsProvider statsProvider, Session session, TypeProvider types) {
            this.costs = ImmutableMap.copyOf(Objects.requireNonNull(costs, "costs is null"));
            this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
            this.statsProvider = Objects.requireNonNull(statsProvider, "statsProvider is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = Objects.requireNonNull(types, "types is null");
        }

        public PlanCostEstimate getCost(PlanNode node) {
            if (this.costs.containsKey(node.getId().toString())) {
                return this.costs.get(node.getId().toString());
            }
            return this.costCalculator.calculateCost(node, this.statsProvider, (CostProvider)this, this.session, this.types);
        }
    }
}

