/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.cost.CostComparator;
import io.prestosql.cost.PlanCostEstimate;
import io.prestosql.testing.TestingSession;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCostComparator {
    @Test
    public void testCpuWeight() {
        new CostComparisonAssertion(1.0, 0.0, 0.0).smaller(200.0, 200.0, 200.0).larger(1000.0, 100.0, 100.0).assertCompare();
    }

    @Test
    public void testMemoryWeight() {
        new CostComparisonAssertion(0.0, 1.0, 0.0).smaller(200.0, 200.0, 200.0).larger(100.0, 1000.0, 100.0).assertCompare();
    }

    @Test
    public void testNetworkWeight() {
        new CostComparisonAssertion(0.0, 0.0, 1.0).smaller(200.0, 200.0, 200.0).larger(100.0, 100.0, 1000.0).assertCompare();
    }

    @Test
    public void testAllWeights() {
        new CostComparisonAssertion(1.0, 1.0, 1.0).smaller(333.0, 333.0, 333.0).larger(200.0, 300.0, 500.0).assertCompare();
        new CostComparisonAssertion(1.0, 1000.0, 1.0).smaller(300.0, 299.0, 300.0).larger(100.0, 300.0, 100.0).assertCompare();
    }

    @Test
    public void testUnknownCost() {
        CostComparator costComparator = new CostComparator(1.0, 1.0, 1.0);
        Session session = TestingSession.testSessionBuilder().build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> costComparator.compare(session, PlanCostEstimate.zero(), PlanCostEstimate.unknown())).isInstanceOf(IllegalArgumentException.class)).hasMessage("cannot compare unknown costs");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> costComparator.compare(session, PlanCostEstimate.unknown(), PlanCostEstimate.zero())).isInstanceOf(IllegalArgumentException.class)).hasMessage("cannot compare unknown costs");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> costComparator.compare(session, PlanCostEstimate.unknown(), PlanCostEstimate.unknown())).isInstanceOf(IllegalArgumentException.class)).hasMessage("cannot compare unknown costs");
    }

    private static class CostComparisonAssertion {
        private final CostComparator costComparator;
        private final Session session = TestingSession.testSessionBuilder().build();
        private PlanCostEstimate smaller;
        private PlanCostEstimate larger;

        public CostComparisonAssertion(double cpuWeight, double memoryWeight, double networkWeight) {
            this.costComparator = new CostComparator(cpuWeight, memoryWeight, networkWeight);
        }

        public void assertCompare() {
            Preconditions.checkState((this.smaller != null ? 1 : 0) != 0, (Object)"smaller not set");
            Preconditions.checkState((this.larger != null ? 1 : 0) != 0, (Object)"larger not set");
            Assert.assertTrue((this.costComparator.compare(this.session, this.smaller, this.larger) < 0 ? 1 : 0) != 0, (String)"smaller < larger is false");
            Assert.assertTrue((this.costComparator.compare(this.session, this.larger, this.smaller) > 0 ? 1 : 0) != 0, (String)"larger > smaller is false");
        }

        public CostComparisonAssertion smaller(double cpu, double memory, double network) {
            Preconditions.checkState((this.smaller == null ? 1 : 0) != 0, (Object)"already set");
            this.smaller = new PlanCostEstimate(cpu, memory, 0.0, network);
            return this;
        }

        public CostComparisonAssertion larger(double cpu, double memory, double network) {
            Preconditions.checkState((this.larger == null ? 1 : 0) != 0, (Object)"already set");
            this.larger = new PlanCostEstimate(cpu, memory, 0.0, network);
            return this;
        }
    }
}

