/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import io.prestosql.cost.BaseStatsCalculatorTest;
import io.prestosql.cost.PlanNodeStatsAssertion;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.StatsCalculatorTester;
import io.prestosql.cost.SymbolStatsEstimate;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.FunctionCallBuilder;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.testing.TestingSession;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestFilterStatsRule
extends BaseStatsCalculatorTest {
    public StatsCalculatorTester defaultFilterTester;

    @BeforeClass
    public void setupClass() {
        this.defaultFilterTester = new StatsCalculatorTester(TestingSession.testSessionBuilder().setSystemProperty("default_filter_factor_enabled", "true").build());
    }

    @AfterClass(alwaysRun=true)
    public void tearDownClass() {
        this.defaultFilterTester.close();
        this.defaultFilterTester = null;
    }

    @Test
    public void testEstimatableFilter() {
        this.tester().assertStatsFor(pb -> pb.filter(PlanBuilder.expression("i1 = 5"), (PlanNode)pb.values(pb.symbol("i1"), pb.symbol("i2"), pb.symbol("i3")))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics(new Symbol("i1"), SymbolStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol("i2"), SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol("i3"), SymbolStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).build()).build()).check(check -> check.outputRowsCount(2.0).symbolStats("i1", assertion -> assertion.lowValue(5.0).highValue(5.0).distinctValuesCount(1.0).dataSizeUnknown().nullsFraction(0.0)).symbolStats("i2", assertion -> assertion.lowValue(0.0).highValue(3.0).dataSizeUnknown().distinctValuesCount(2.0).nullsFraction(0.0)).symbolStats("i3", assertion -> assertion.lowValue(10.0).highValue(15.0).dataSizeUnknown().distinctValuesCount(1.9).nullsFraction(0.05)));
        this.defaultFilterTester.assertStatsFor(pb -> pb.filter(PlanBuilder.expression("i1 = 5"), (PlanNode)pb.values(pb.symbol("i1"), pb.symbol("i2"), pb.symbol("i3")))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics(new Symbol("i1"), SymbolStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol("i2"), SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol("i3"), SymbolStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).build()).build()).check(check -> check.outputRowsCount(2.0).symbolStats("i1", assertion -> assertion.lowValue(5.0).highValue(5.0).distinctValuesCount(1.0).dataSizeUnknown().nullsFraction(0.0)).symbolStats("i2", assertion -> assertion.lowValue(0.0).highValue(3.0).dataSizeUnknown().distinctValuesCount(2.0).nullsFraction(0.0)).symbolStats("i3", assertion -> assertion.lowValue(10.0).highValue(15.0).dataSizeUnknown().distinctValuesCount(1.9).nullsFraction(0.05)));
    }

    @Test
    public void testUnestimatableFunction() {
        ComparisonExpression unestimatableExpression = new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new FunctionCallBuilder(this.tester().getMetadata()).setName(QualifiedName.of((String)"sin")).addArgument((Type)DoubleType.DOUBLE, (Expression)new SymbolReference("i1")).build(), (Expression)new LongLiteral("1"));
        this.tester().assertStatsFor(pb -> pb.filter((Expression)unestimatableExpression, (PlanNode)pb.values(pb.symbol("i1"), pb.symbol("i2"), pb.symbol("i3")))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics(new Symbol("i1"), SymbolStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol("i2"), SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol("i3"), SymbolStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).build()).build()).check(PlanNodeStatsAssertion::outputRowsCountUnknown);
        this.defaultFilterTester.assertStatsFor(pb -> pb.filter((Expression)unestimatableExpression, (PlanNode)pb.values(pb.symbol("i1"), pb.symbol("i2"), pb.symbol("i3")))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics(new Symbol("i1"), SymbolStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol("i2"), SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol("i3"), SymbolStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).build()).build()).check(check -> check.outputRowsCount(9.0).symbolStats("i1", assertion -> assertion.lowValue(1.0).highValue(10.0).dataSizeUnknown().distinctValuesCount(5.0).nullsFraction(0.0)).symbolStats("i2", assertion -> assertion.lowValue(0.0).highValue(3.0).dataSizeUnknown().distinctValuesCount(4.0).nullsFraction(0.0)).symbolStats("i3", assertion -> assertion.lowValue(10.0).highValue(15.0).dataSizeUnknown().distinctValuesCount(4.0).nullsFraction(0.1)));
    }
}

