/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.eventlistener.EventListenerManager;
import io.prestosql.execution.CallTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.security.DenyAllAccessControl;
import io.prestosql.spi.block.MethodHandleUtil;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.procedure.Procedure;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.tree.Call;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.testing.TestingAccessControlManager;
import io.prestosql.testing.TestingEventListenerManager;
import io.prestosql.testing.TestingSession;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionManager;
import java.lang.invoke.MethodHandle;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCallTask {
    private ExecutorService executor;
    private static boolean invoked;

    @BeforeClass
    public void init() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"call-task-test-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void close() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @BeforeMethod
    public void cleanup() {
        invoked = false;
    }

    @Test
    public void testExecute() {
        this.executeCallTask(MethodHandleUtil.methodHandle(TestCallTask.class, (String)"testingMethod", (Class[])new Class[0]), transactionManager -> new AllowAllAccessControl());
        Assertions.assertThat((boolean)invoked).isTrue();
    }

    @Test
    public void testExecuteNoPermission() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeCallTask(MethodHandleUtil.methodHandle(TestCallTask.class, (String)"testingMethod", (Class[])new Class[0]), transactionManager -> new DenyAllAccessControl())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot execute procedure test.test.testing_procedure");
        Assertions.assertThat((boolean)invoked).isFalse();
    }

    @Test
    public void testExecuteNoPermissionOnInsert() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeCallTask(MethodHandleUtil.methodHandle(TestingProcedure.class, (String)"testingMethod", (Class[])new Class[]{ConnectorAccessControl.class}), transactionManager -> {
            TestingAccessControlManager accessControl = new TestingAccessControlManager(transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager());
            accessControl.loadSystemAccessControl("allow-all", (Map)ImmutableMap.of());
            accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"testing_table", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.INSERT_TABLE)});
            return accessControl;
        })).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot insert into table test.test.testing_table");
    }

    private void executeCallTask(MethodHandle methodHandle, Function<TransactionManager, AccessControl> accessControlProvider) {
        TransactionManager transactionManager = this.createTransactionManager();
        MetadataManager metadata = this.createMetadataManager(transactionManager, new Procedure("test", "testing_procedure", (List)ImmutableList.of(), methodHandle));
        AccessControl accessControl = accessControlProvider.apply(transactionManager);
        new CallTask().execute(new Call(QualifiedName.of((String)"testing_procedure"), (List)ImmutableList.of()), transactionManager, (Metadata)metadata, accessControl, this.stateMachine(transactionManager, metadata, accessControl), (List)ImmutableList.of());
    }

    private TransactionManager createTransactionManager() {
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.registerCatalog(TestingSession.createBogusTestingCatalog((String)"test"));
        return InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
    }

    private MetadataManager createMetadataManager(TransactionManager transactionManager, Procedure procedure) {
        MetadataManager metadata = MetadataManager.createTestMetadataManager((TransactionManager)transactionManager, (FeaturesConfig)new FeaturesConfig());
        metadata.getProcedureRegistry().addProcedures(new CatalogName("test"), (Collection)ImmutableList.of((Object)procedure));
        return metadata;
    }

    private QueryStateMachine stateMachine(TransactionManager transactionManager, MetadataManager metadata, AccessControl accessControl) {
        return QueryStateMachine.begin((String)"CALL testing_procedure()", Optional.empty(), (Session)this.testSession(transactionManager), (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)transactionManager, (AccessControl)accessControl, (Executor)this.executor, (Metadata)metadata, (WarningCollector)WarningCollector.NOOP, Optional.empty());
    }

    private Session testSession(TransactionManager transactionManager) {
        return TestingSession.testSessionBuilder().setCatalog("test").setSchema("test").setTransactionId(transactionManager.beginTransaction(true)).build();
    }

    public static void testingMethod() {
        invoked = true;
    }

    public static class TestingProcedure {
        public static void testingMethod(ConnectorAccessControl connectorAccessControl) {
            connectorAccessControl.checkCanInsertIntoTable(null, new SchemaTableName("test", "testing_table"));
        }
    }
}

