/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import io.prestosql.execution.QueryIdGenerator;
import io.prestosql.spi.QueryId;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQueryIdGenerator {
    @Test
    public void testCreateNextQueryId() {
        int i;
        TestIdGenerator idGenerator = new TestIdGenerator();
        long millis = new DateTime(2001, 7, 14, 1, 2, 3, 4, DateTimeZone.UTC).getMillis();
        idGenerator.setNow(millis);
        for (i = 0; i < 100000; ++i) {
            Assert.assertEquals((Object)idGenerator.createNextQueryId(), (Object)new QueryId(String.format("20010714_010203_%05d_%s", i, idGenerator.getCoordinatorId())));
        }
        idGenerator.setNow(millis += 1000L);
        for (i = 0; i < 100000; ++i) {
            Assert.assertEquals((Object)idGenerator.createNextQueryId(), (Object)new QueryId(String.format("20010714_010204_%05d_%s", i, idGenerator.getCoordinatorId())));
        }
        idGenerator.setNow(millis += 1000L);
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)idGenerator.createNextQueryId(), (Object)new QueryId(String.format("20010714_010205_%05d_%s", i, idGenerator.getCoordinatorId())));
        }
        millis = new DateTime(2001, 7, 15, 0, 0, 0, 0, DateTimeZone.UTC).getMillis();
        idGenerator.setNow(millis);
        for (i = 0; i < 100000; ++i) {
            Assert.assertEquals((Object)idGenerator.createNextQueryId(), (Object)new QueryId(String.format("20010715_000000_%05d_%s", i, idGenerator.getCoordinatorId())));
        }
    }

    private static class TestIdGenerator
    extends QueryIdGenerator {
        private long now;

        private TestIdGenerator() {
        }

        public void setNow(long now) {
            this.now = now;
        }

        protected long nowInMillis() {
            return this.now;
        }
    }
}

