/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.execution.QueryPreparer;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.QueryUtil;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.tree.AllColumns;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Relation;
import io.prestosql.sql.tree.Select;
import io.prestosql.sql.tree.SelectItem;
import io.prestosql.testing.TestingSession;
import io.prestosql.testing.assertions.PrestoExceptionAssert;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQueryPreparer {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final QueryPreparer QUERY_PREPARER = new QueryPreparer(SQL_PARSER);

    @Test
    public void testSelectStatement() {
        QueryPreparer.PreparedQuery preparedQuery = QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "SELECT * FROM foo");
        Assert.assertEquals((Object)preparedQuery.getStatement(), (Object)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo"))));
    }

    @Test
    public void testExecuteStatement() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT * FROM foo").build();
        QueryPreparer.PreparedQuery preparedQuery = QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query");
        Assert.assertEquals((Object)preparedQuery.getStatement(), (Object)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo"))));
    }

    @Test
    public void testExecuteStatementDoesNotExist() {
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "execute my_query")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND);
    }

    @Test
    public void testTooManyParameters() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT * FROM foo where col1 = ?").build();
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1,2")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE);
    }

    @Test
    public void testTooFewParameters() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT ? FROM foo where col1 = ?").build();
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE);
    }

    @Test
    public void testParameterMismatchWithOffset() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT ? FROM foo OFFSET ? ROWS").build();
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE);
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1, 2, 3, 4, 5, 6")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE);
    }

    @Test
    public void testParameterMismatchWithLimit() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT ? FROM foo LIMIT ?").build();
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE);
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1, 2, 3, 4, 5, 6")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE);
    }

    @Test
    public void testParameterMismatchWithFetchFirst() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT ? FROM foo FETCH FIRST ? ROWS ONLY").build();
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE);
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1, 2, 3, 4, 5, 6")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_PARAMETER_USAGE);
    }
}

