/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.execution.QueryStats;
import io.prestosql.operator.FilterAndProjectOperator;
import io.prestosql.operator.OperatorStats;
import io.prestosql.operator.TableWriterOperator;
import io.prestosql.server.DynamicFilterService;
import io.prestosql.spi.eventlistener.StageGcStatistics;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQueryStats {
    public static final List<OperatorStats> operatorSummaries = ImmutableList.of((Object)new OperatorStats(10, 11, 12, new PlanNodeId("13"), TableWriterOperator.class.getSimpleName(), 14L, 15L, new Duration(16.0, TimeUnit.NANOSECONDS), new Duration(17.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)181L), 1811L, DataSize.succinctBytes((long)182L), 1822L, DataSize.succinctBytes((long)18L), DataSize.succinctBytes((long)19L), 110L, 111.0, 112L, new Duration(113.0, TimeUnit.NANOSECONDS), new Duration(114.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)116L), 117L, 1833L, DataSize.succinctBytes((long)118L), new Duration(119.0, TimeUnit.NANOSECONDS), 120L, new Duration(121.0, TimeUnit.NANOSECONDS), new Duration(122.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)124L), DataSize.succinctBytes((long)125L), DataSize.succinctBytes((long)126L), DataSize.succinctBytes((long)127L), DataSize.succinctBytes((long)128L), DataSize.succinctBytes((long)129L), DataSize.succinctBytes((long)130L), DataSize.succinctBytes((long)131L), Optional.empty(), null), (Object)new OperatorStats(20, 21, 22, new PlanNodeId("23"), FilterAndProjectOperator.class.getSimpleName(), 24L, 25L, new Duration(26.0, TimeUnit.NANOSECONDS), new Duration(27.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)281L), 2811L, DataSize.succinctBytes((long)282L), 2822L, DataSize.succinctBytes((long)28L), DataSize.succinctBytes((long)29L), 210L, 211.0, 212L, new Duration(213.0, TimeUnit.NANOSECONDS), new Duration(214.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)216L), 217L, 2833L, DataSize.succinctBytes((long)218L), new Duration(219.0, TimeUnit.NANOSECONDS), 220L, new Duration(221.0, TimeUnit.NANOSECONDS), new Duration(222.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)224L), DataSize.succinctBytes((long)225L), DataSize.succinctBytes((long)226L), DataSize.succinctBytes((long)227L), DataSize.succinctBytes((long)228L), DataSize.succinctBytes((long)229L), DataSize.succinctBytes((long)230L), DataSize.succinctBytes((long)231L), Optional.empty(), null), (Object)new OperatorStats(30, 31, 32, new PlanNodeId("33"), TableWriterOperator.class.getSimpleName(), 34L, 35L, new Duration(36.0, TimeUnit.NANOSECONDS), new Duration(37.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)381L), 3811L, DataSize.succinctBytes((long)382L), 3822L, DataSize.succinctBytes((long)38L), DataSize.succinctBytes((long)39L), 310L, 311.0, 312L, new Duration(313.0, TimeUnit.NANOSECONDS), new Duration(314.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)316L), 317L, 3833L, DataSize.succinctBytes((long)318L), new Duration(319.0, TimeUnit.NANOSECONDS), 320L, new Duration(321.0, TimeUnit.NANOSECONDS), new Duration(322.0, TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)324L), DataSize.succinctBytes((long)325L), DataSize.succinctBytes((long)326L), DataSize.succinctBytes((long)327L), DataSize.succinctBytes((long)328L), DataSize.succinctBytes((long)329L), DataSize.succinctBytes((long)330L), DataSize.succinctBytes((long)331L), Optional.empty(), null));
    public static final QueryStats EXPECTED = new QueryStats(new DateTime(1L), new DateTime(2L), new DateTime(3L), new DateTime(4L), new Duration(6.0, TimeUnit.NANOSECONDS), new Duration(5.0, TimeUnit.NANOSECONDS), new Duration(31.0, TimeUnit.NANOSECONDS), new Duration(32.0, TimeUnit.NANOSECONDS), new Duration(41.0, TimeUnit.NANOSECONDS), new Duration(33.0, TimeUnit.NANOSECONDS), new Duration(100.0, TimeUnit.NANOSECONDS), new Duration(200.0, TimeUnit.NANOSECONDS), 9, 10, 11, 12, 13, 15, 30, 16, 17.0, DataSize.ofBytes((long)18L), DataSize.ofBytes((long)19L), DataSize.ofBytes((long)20L), DataSize.ofBytes((long)21L), DataSize.ofBytes((long)22L), DataSize.ofBytes((long)30L), DataSize.ofBytes((long)23L), DataSize.ofBytes((long)24L), DataSize.ofBytes((long)25L), DataSize.ofBytes((long)26L), true, new Duration(20.0, TimeUnit.NANOSECONDS), new Duration(21.0, TimeUnit.NANOSECONDS), new Duration(23.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), DataSize.ofBytes((long)241L), 251L, new Duration(23.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)242L), 252L, DataSize.ofBytes((long)24L), 25L, DataSize.ofBytes((long)26L), 27L, DataSize.ofBytes((long)28L), 29L, DataSize.ofBytes((long)30L), (List)ImmutableList.of((Object)new StageGcStatistics(101, 102, 103, 104, 105, 106, 107)), DynamicFilterService.DynamicFiltersStats.EMPTY, operatorSummaries);

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(QueryStats.class);
        String json = codec.toJson((Object)EXPECTED);
        QueryStats actual = (QueryStats)codec.fromJson(json);
        TestQueryStats.assertExpectedQueryStats(actual);
    }

    public static void assertExpectedQueryStats(QueryStats actual) {
        Assert.assertEquals((Object)actual.getCreateTime(), (Object)new DateTime(1L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getExecutionStartTime(), (Object)new DateTime(2L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getLastHeartbeat(), (Object)new DateTime(3L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getEndTime(), (Object)new DateTime(4L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getElapsedTime(), (Object)new Duration(6.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getQueuedTime(), (Object)new Duration(5.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getResourceWaitingTime(), (Object)new Duration(31.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getDispatchingTime(), (Object)new Duration(32.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getExecutionTime(), (Object)new Duration(41.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAnalysisTime(), (Object)new Duration(33.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getPlanningTime(), (Object)new Duration(100.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishingTime(), (Object)new Duration(200.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((int)actual.getTotalTasks(), (int)9);
        Assert.assertEquals((int)actual.getRunningTasks(), (int)10);
        Assert.assertEquals((int)actual.getCompletedTasks(), (int)11);
        Assert.assertEquals((int)actual.getTotalDrivers(), (int)12);
        Assert.assertEquals((int)actual.getQueuedDrivers(), (int)13);
        Assert.assertEquals((int)actual.getRunningDrivers(), (int)15);
        Assert.assertEquals((int)actual.getBlockedDrivers(), (int)30);
        Assert.assertEquals((int)actual.getCompletedDrivers(), (int)16);
        Assert.assertEquals((Object)actual.getCumulativeUserMemory(), (Object)17.0);
        Assert.assertEquals((Object)actual.getUserMemoryReservation(), (Object)DataSize.ofBytes((long)18L));
        Assert.assertEquals((Object)actual.getRevocableMemoryReservation(), (Object)DataSize.ofBytes((long)19L));
        Assert.assertEquals((Object)actual.getTotalMemoryReservation(), (Object)DataSize.ofBytes((long)20L));
        Assert.assertEquals((Object)actual.getPeakUserMemoryReservation(), (Object)DataSize.ofBytes((long)21L));
        Assert.assertEquals((Object)actual.getPeakRevocableMemoryReservation(), (Object)DataSize.ofBytes((long)22L));
        Assert.assertEquals((Object)actual.getPeakTotalMemoryReservation(), (Object)DataSize.ofBytes((long)23L));
        Assert.assertEquals((Object)actual.getPeakTaskUserMemory(), (Object)DataSize.ofBytes((long)24L));
        Assert.assertEquals((Object)actual.getPeakTaskRevocableMemory(), (Object)DataSize.ofBytes((long)25L));
        Assert.assertEquals((Object)actual.getPeakTaskTotalMemory(), (Object)DataSize.ofBytes((long)26L));
        Assert.assertEquals((Object)actual.getSpilledDataSize(), (Object)DataSize.ofBytes((long)693L));
        Assert.assertEquals((Object)actual.getTotalScheduledTime(), (Object)new Duration(20.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalCpuTime(), (Object)new Duration(21.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalBlockedTime(), (Object)new Duration(23.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getPhysicalInputDataSize(), (Object)DataSize.ofBytes((long)241L));
        Assert.assertEquals((long)actual.getPhysicalInputPositions(), (long)251L);
        Assert.assertEquals((Object)actual.getInternalNetworkInputDataSize(), (Object)DataSize.ofBytes((long)242L));
        Assert.assertEquals((long)actual.getInternalNetworkInputPositions(), (long)252L);
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)DataSize.ofBytes((long)24L));
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)25L);
        Assert.assertEquals((Object)actual.getProcessedInputDataSize(), (Object)DataSize.ofBytes((long)26L));
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)27L);
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)DataSize.ofBytes((long)28L));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)29L);
        Assert.assertEquals((Object)actual.getPhysicalWrittenDataSize(), (Object)DataSize.ofBytes((long)30L));
        Assert.assertEquals((int)actual.getStageGcStatistics().size(), (int)1);
        StageGcStatistics gcStatistics = (StageGcStatistics)actual.getStageGcStatistics().get(0);
        Assert.assertEquals((int)gcStatistics.getStageId(), (int)101);
        Assert.assertEquals((int)gcStatistics.getTasks(), (int)102);
        Assert.assertEquals((int)gcStatistics.getFullGcTasks(), (int)103);
        Assert.assertEquals((int)gcStatistics.getMinFullGcSec(), (int)104);
        Assert.assertEquals((int)gcStatistics.getMaxFullGcSec(), (int)105);
        Assert.assertEquals((int)gcStatistics.getTotalFullGcSec(), (int)106);
        Assert.assertEquals((int)gcStatistics.getAverageFullGcSec(), (int)107);
        Assert.assertEquals((long)420L, (long)actual.getWrittenPositions());
        Assert.assertEquals((long)58L, (long)actual.getLogicalWrittenDataSize().toBytes());
        Assert.assertEquals((Object)DynamicFilterService.DynamicFiltersStats.EMPTY, (Object)actual.getDynamicFiltersStats());
    }
}

