/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.buffer;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.prestosql.execution.buffer.PagesSerde;
import io.prestosql.execution.buffer.PagesSerdeUtil;
import io.prestosql.execution.buffer.TestingPagesSerdeFactory;
import io.prestosql.operator.PageAssertions;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.Iterator;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPagesSerde {
    @Test
    public void testRoundTrip() {
        PagesSerde serde = new TestingPagesSerdeFactory().createPagesSerde();
        BlockBuilder expectedBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 5);
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "alice");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "bob");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "charlie");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "dave");
        Block expectedBlock = expectedBlockBuilder.build();
        Page expectedPage = new Page(new Block[]{expectedBlock, expectedBlock, expectedBlock});
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        PagesSerdeUtil.writePages((PagesSerde)serde, (SliceOutput)sliceOutput, (Page[])new Page[]{expectedPage, expectedPage, expectedPage});
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR);
        Iterator pageIterator = PagesSerdeUtil.readPages((PagesSerde)serde, (SliceInput)sliceOutput.slice().getInput());
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)pageIterator.next(), expectedPage);
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)pageIterator.next(), expectedPage);
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)pageIterator.next(), expectedPage);
        Assert.assertFalse((boolean)pageIterator.hasNext());
    }

    @Test
    public void testBigintSerializedSize() {
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(null, 5);
        Page page = new Page(new Block[]{builder.build()});
        int pageSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), page);
        Assert.assertEquals((int)pageSize, (int)52);
        BigintType.BIGINT.writeLong(builder, 123L);
        pageSize = 35;
        page = new Page(new Block[]{builder.build()});
        int firstValueSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), page) - pageSize;
        Assert.assertEquals((int)firstValueSize, (int)9);
        BigintType.BIGINT.writeLong(builder, 456L);
        page = new Page(new Block[]{builder.build()});
        int secondValueSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), page) - (pageSize + firstValueSize);
        Assert.assertEquals((int)secondValueSize, (int)8);
    }

    @Test
    public void testVarcharSerializedSize() {
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, 5);
        Page page = new Page(new Block[]{builder.build()});
        int pageSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), page);
        Assert.assertEquals((int)pageSize, (int)44);
        VarcharType.VARCHAR.writeString(builder, "alice");
        page = new Page(new Block[]{builder.build()});
        int firstValueSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), page) - pageSize;
        Assert.assertEquals((int)firstValueSize, (int)9);
        VarcharType.VARCHAR.writeString(builder, "bob");
        page = new Page(new Block[]{builder.build()});
        int secondValueSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), page) - (pageSize + firstValueSize);
        Assert.assertEquals((int)secondValueSize, (int)7);
    }

    @Test
    public void testClosedContext() {
        PagesSerde serde = new TestingPagesSerdeFactory().createPagesSerde();
        PagesSerde.PagesSerdeContext context = serde.newContext();
        context.close();
        try {
            serde.serialize(context, new Page(1));
            Assert.fail((String)"Expected failure from closed context");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"PagesSerdeContext is already closed");
        }
    }

    private static int serializedSize(List<? extends Type> types, Page expectedPage) {
        PagesSerde serde = new TestingPagesSerdeFactory().createPagesSerde();
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        PagesSerdeUtil.writePages((PagesSerde)serde, (SliceOutput)sliceOutput, (Page[])new Page[]{expectedPage});
        Slice slice = sliceOutput.slice();
        Iterator pageIterator = PagesSerdeUtil.readPages((PagesSerde)serde, (SliceInput)slice.getInput());
        if (pageIterator.hasNext()) {
            PageAssertions.assertPageEquals(types, (Page)pageIterator.next(), expectedPage);
        } else {
            Assert.assertEquals((int)expectedPage.getPositionCount(), (int)0);
        }
        Assert.assertFalse((boolean)pageIterator.hasNext());
        return slice.length();
    }
}

