/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.scheduler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.Threads;
import io.prestosql.client.NodeVersion;
import io.prestosql.execution.MockRemoteTaskFactory;
import io.prestosql.execution.NodeTaskMap;
import io.prestosql.execution.RemoteTask;
import io.prestosql.execution.TaskId;
import io.prestosql.execution.scheduler.FixedCountScheduler;
import io.prestosql.execution.scheduler.ScheduleResult;
import io.prestosql.metadata.InternalNode;
import io.prestosql.metadata.Split;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestFixedCountScheduler {
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "executor-%s")));
    private ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "scheduledExecutor-%s")));
    private final MockRemoteTaskFactory taskFactory = new MockRemoteTaskFactory(this.executor, this.scheduledExecutor);

    @AfterClass(alwaysRun=true)
    public void destroyExecutor() {
        this.executor.shutdownNow();
        this.executor = null;
        this.scheduledExecutor.shutdown();
        this.scheduledExecutor = null;
    }

    @Test
    public void testSingleNode() {
        FixedCountScheduler nodeScheduler = new FixedCountScheduler((node, partition, totalPartitions) -> Optional.of(this.taskFactory.createTableScanTask(new TaskId("test", 1, 1), node, (List<Split>)ImmutableList.of(), new NodeTaskMap.PartitionedSplitCountTracker(delta -> {}))), TestFixedCountScheduler.generateRandomNodes(1));
        ScheduleResult result = nodeScheduler.schedule();
        Assert.assertTrue((boolean)result.isFinished());
        Assert.assertTrue((boolean)result.getBlocked().isDone());
        Assert.assertEquals((int)result.getNewTasks().size(), (int)1);
        Assert.assertTrue((boolean)((RemoteTask)result.getNewTasks().iterator().next()).getNodeId().equals("other 0"));
    }

    @Test
    public void testMultipleNodes() {
        FixedCountScheduler nodeScheduler = new FixedCountScheduler((node, partition, totalPartitions) -> Optional.of(this.taskFactory.createTableScanTask(new TaskId("test", 1, 1), node, (List<Split>)ImmutableList.of(), new NodeTaskMap.PartitionedSplitCountTracker(delta -> {}))), TestFixedCountScheduler.generateRandomNodes(5));
        ScheduleResult result = nodeScheduler.schedule();
        Assert.assertTrue((boolean)result.isFinished());
        Assert.assertTrue((boolean)result.getBlocked().isDone());
        Assert.assertEquals((int)result.getNewTasks().size(), (int)5);
        Assert.assertEquals((int)((ImmutableSet)result.getNewTasks().stream().map(RemoteTask::getNodeId).collect(ImmutableSet.toImmutableSet())).size(), (int)5);
    }

    private static List<InternalNode> generateRandomNodes(int count) {
        return (List)IntStream.range(0, count).mapToObj(i -> new InternalNode("other " + i, URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false)).collect(ImmutableList.toImmutableList());
    }
}

