/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.scheduler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import io.prestosql.cost.StatsAndCosts;
import io.prestosql.execution.scheduler.PhasedExecutionSchedule;
import io.prestosql.metadata.TableHandle;
import io.prestosql.operator.StageExecutionDescriptor;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.planner.Partitioning;
import io.prestosql.sql.planner.PartitioningHandle;
import io.prestosql.sql.planner.PartitioningScheme;
import io.prestosql.sql.planner.PlanFragment;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SystemPartitioningHandle;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanFragmentId;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.RemoteSourceNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.plan.UnionNode;
import io.prestosql.testing.TestingHandles;
import io.prestosql.testing.TestingMetadata;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPhasedExecutionSchedule {
    @Test
    public void testExchange() {
        PlanFragment aFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("a");
        PlanFragment bFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("b");
        PlanFragment cFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("c");
        PlanFragment exchangeFragment = TestPhasedExecutionSchedule.createExchangePlanFragment("exchange", aFragment, bFragment, cFragment);
        List phases = PhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)aFragment, (Object)bFragment, (Object)cFragment, (Object)exchangeFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)exchangeFragment.getId()), (Object)ImmutableSet.of((Object)aFragment.getId()), (Object)ImmutableSet.of((Object)bFragment.getId()), (Object)ImmutableSet.of((Object)cFragment.getId())));
    }

    @Test
    public void testUnion() {
        PlanFragment aFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("a");
        PlanFragment bFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("b");
        PlanFragment cFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("c");
        PlanFragment unionFragment = TestPhasedExecutionSchedule.createUnionPlanFragment("union", aFragment, bFragment, cFragment);
        List phases = PhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)aFragment, (Object)bFragment, (Object)cFragment, (Object)unionFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)unionFragment.getId()), (Object)ImmutableSet.of((Object)aFragment.getId()), (Object)ImmutableSet.of((Object)bFragment.getId()), (Object)ImmutableSet.of((Object)cFragment.getId())));
    }

    @Test
    public void testJoin() {
        PlanFragment buildFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("build");
        PlanFragment probeFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("probe");
        PlanFragment joinFragment = TestPhasedExecutionSchedule.createJoinPlanFragment(JoinNode.Type.INNER, "join", buildFragment, probeFragment);
        List phases = PhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)joinFragment, (Object)buildFragment, (Object)probeFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)joinFragment.getId()), (Object)ImmutableSet.of((Object)buildFragment.getId()), (Object)ImmutableSet.of((Object)probeFragment.getId())));
    }

    @Test
    public void testRightJoin() {
        PlanFragment buildFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("build");
        PlanFragment probeFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("probe");
        PlanFragment joinFragment = TestPhasedExecutionSchedule.createJoinPlanFragment(JoinNode.Type.RIGHT, "join", buildFragment, probeFragment);
        List phases = PhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)joinFragment, (Object)buildFragment, (Object)probeFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)joinFragment.getId()), (Object)ImmutableSet.of((Object)buildFragment.getId()), (Object)ImmutableSet.of((Object)probeFragment.getId())));
    }

    @Test
    public void testBroadcastJoin() {
        PlanFragment buildFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("build");
        PlanFragment joinFragment = TestPhasedExecutionSchedule.createBroadcastJoinPlanFragment("join", buildFragment);
        List phases = PhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)joinFragment, (Object)buildFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)joinFragment.getId(), (Object)buildFragment.getId())));
    }

    @Test
    public void testJoinWithDeepSources() {
        PlanFragment buildSourceFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("buildSource");
        PlanFragment buildMiddleFragment = TestPhasedExecutionSchedule.createExchangePlanFragment("buildMiddle", buildSourceFragment);
        PlanFragment buildTopFragment = TestPhasedExecutionSchedule.createExchangePlanFragment("buildTop", buildMiddleFragment);
        PlanFragment probeSourceFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("probeSource");
        PlanFragment probeMiddleFragment = TestPhasedExecutionSchedule.createExchangePlanFragment("probeMiddle", probeSourceFragment);
        PlanFragment probeTopFragment = TestPhasedExecutionSchedule.createExchangePlanFragment("probeTop", probeMiddleFragment);
        PlanFragment joinFragment = TestPhasedExecutionSchedule.createJoinPlanFragment(JoinNode.Type.INNER, "join", buildTopFragment, probeTopFragment);
        List phases = PhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)joinFragment, (Object)buildTopFragment, (Object)buildMiddleFragment, (Object)buildSourceFragment, (Object)probeTopFragment, (Object)probeMiddleFragment, (Object)probeSourceFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)joinFragment.getId()), (Object)ImmutableSet.of((Object)buildTopFragment.getId()), (Object)ImmutableSet.of((Object)buildMiddleFragment.getId()), (Object)ImmutableSet.of((Object)buildSourceFragment.getId()), (Object)ImmutableSet.of((Object)probeTopFragment.getId()), (Object)ImmutableSet.of((Object)probeMiddleFragment.getId()), (Object)ImmutableSet.of((Object)probeSourceFragment.getId())));
    }

    private static PlanFragment createExchangePlanFragment(String name, PlanFragment ... fragments) {
        RemoteSourceNode planNode = new RemoteSourceNode(new PlanNodeId(name + "_id"), (List)Stream.of(fragments).map(PlanFragment::getId).collect(ImmutableList.toImmutableList()), fragments[0].getPartitioningScheme().getOutputLayout(), Optional.empty(), ExchangeNode.Type.REPARTITION);
        return TestPhasedExecutionSchedule.createFragment((PlanNode)planNode);
    }

    private static PlanFragment createUnionPlanFragment(String name, PlanFragment ... fragments) {
        UnionNode planNode = new UnionNode(new PlanNodeId(name + "_id"), (List)Stream.of(fragments).map(fragment -> new RemoteSourceNode(new PlanNodeId(fragment.getId().toString()), fragment.getId(), fragment.getPartitioningScheme().getOutputLayout(), Optional.empty(), ExchangeNode.Type.REPARTITION)).collect(ImmutableList.toImmutableList()), (ListMultimap)ImmutableListMultimap.of(), (List)ImmutableList.of());
        return TestPhasedExecutionSchedule.createFragment((PlanNode)planNode);
    }

    private static PlanFragment createBroadcastJoinPlanFragment(String name, PlanFragment buildFragment) {
        Symbol symbol = new Symbol("column");
        TableScanNode tableScan = TableScanNode.newInstance((PlanNodeId)new PlanNodeId(name), (TableHandle)TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of((Object)symbol), (Map)ImmutableMap.of((Object)symbol, (Object)new TestingMetadata.TestingColumnHandle("column")), (boolean)false);
        RemoteSourceNode remote = new RemoteSourceNode(new PlanNodeId("build_id"), buildFragment.getId(), (List)ImmutableList.of(), Optional.empty(), ExchangeNode.Type.REPLICATE);
        JoinNode join = new JoinNode(new PlanNodeId(name + "_id"), JoinNode.Type.INNER, (PlanNode)tableScan, (PlanNode)remote, (List)ImmutableList.of(), tableScan.getOutputSymbols(), remote.getOutputSymbols(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        return TestPhasedExecutionSchedule.createFragment((PlanNode)join);
    }

    private static PlanFragment createJoinPlanFragment(JoinNode.Type joinType, String name, PlanFragment buildFragment, PlanFragment probeFragment) {
        RemoteSourceNode probe = new RemoteSourceNode(new PlanNodeId("probe_id"), probeFragment.getId(), (List)ImmutableList.of(), Optional.empty(), ExchangeNode.Type.REPARTITION);
        RemoteSourceNode build = new RemoteSourceNode(new PlanNodeId("build_id"), buildFragment.getId(), (List)ImmutableList.of(), Optional.empty(), ExchangeNode.Type.REPARTITION);
        JoinNode planNode = new JoinNode(new PlanNodeId(name + "_id"), joinType, (PlanNode)probe, (PlanNode)build, (List)ImmutableList.of(), probe.getOutputSymbols(), build.getOutputSymbols(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        return TestPhasedExecutionSchedule.createFragment((PlanNode)planNode);
    }

    private static PlanFragment createTableScanPlanFragment(String name) {
        Symbol symbol = new Symbol("column");
        TableScanNode planNode = TableScanNode.newInstance((PlanNodeId)new PlanNodeId(name), (TableHandle)TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of((Object)symbol), (Map)ImmutableMap.of((Object)symbol, (Object)new TestingMetadata.TestingColumnHandle("column")), (boolean)false);
        return TestPhasedExecutionSchedule.createFragment((PlanNode)planNode);
    }

    private static PlanFragment createFragment(PlanNode planNode) {
        ImmutableMap.Builder types = ImmutableMap.builder();
        for (Symbol symbol : planNode.getOutputSymbols()) {
            types.put((Object)symbol, (Object)VarcharType.VARCHAR);
        }
        return new PlanFragment(new PlanFragmentId(planNode.getId() + "_fragment_id"), planNode, (Map)types.build(), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)planNode.getId()), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), planNode.getOutputSymbols()), StageExecutionDescriptor.ungroupedExecution(), StatsAndCosts.empty(), Optional.empty());
    }
}

