/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.memory;

import io.airlift.concurrent.Threads;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.units.DataSize;
import io.prestosql.ExceededMemoryLimitException;
import io.prestosql.execution.TaskId;
import io.prestosql.execution.TaskStateMachine;
import io.prestosql.memory.MemoryPool;
import io.prestosql.memory.QueryContext;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.memory.context.MemoryTrackingContext;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.DriverStats;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorStats;
import io.prestosql.operator.PipelineContext;
import io.prestosql.operator.PipelineStats;
import io.prestosql.operator.TaskContext;
import io.prestosql.operator.TaskStats;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.memory.MemoryPoolId;
import io.prestosql.spiller.SpillSpaceTracker;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.TestingSession;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestMemoryTracking {
    private static final DataSize queryMaxMemory = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private static final DataSize queryMaxTotalMemory = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private static final DataSize memoryPoolSize = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private static final DataSize maxSpillSize = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private static final DataSize queryMaxSpillSize = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private static final SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(maxSpillSize);
    private QueryContext queryContext;
    private TaskContext taskContext;
    private PipelineContext pipelineContext;
    private DriverContext driverContext;
    private OperatorContext operatorContext;
    private MemoryPool memoryPool;
    private ExecutorService notificationExecutor;
    private ScheduledExecutorService yieldExecutor;

    @BeforeClass
    public void setUp() {
        this.notificationExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"local-query-runner-executor-%s"));
        this.yieldExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"local-query-runner-scheduler-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.notificationExecutor.shutdownNow();
        this.yieldExecutor.shutdownNow();
        this.queryContext = null;
        this.taskContext = null;
        this.pipelineContext = null;
        this.driverContext = null;
        this.operatorContext = null;
        this.memoryPool = null;
    }

    @BeforeMethod
    public void setUpTest() {
        this.memoryPool = new MemoryPool(new MemoryPoolId("test"), memoryPoolSize);
        this.queryContext = new QueryContext(new QueryId("test_query"), queryMaxMemory, queryMaxTotalMemory, this.memoryPool, (GcMonitor)new TestingGcMonitor(), (Executor)this.notificationExecutor, this.yieldExecutor, queryMaxSpillSize, spillSpaceTracker);
        this.taskContext = this.queryContext.addTaskContext(new TaskStateMachine(new TaskId("query", 0, 0), (Executor)this.notificationExecutor), TestingSession.testSessionBuilder().build(), () -> {}, true, true, OptionalInt.empty());
        this.pipelineContext = this.taskContext.addPipelineContext(0, true, true, false);
        this.driverContext = this.pipelineContext.addDriverContext();
        this.operatorContext = this.driverContext.addOperatorContext(1, new PlanNodeId("a"), "test-operator");
    }

    @Test
    public void testOperatorAllocations() {
        MemoryTrackingContext operatorMemoryContext = this.operatorContext.getOperatorMemoryContext();
        LocalMemoryContext systemMemory = this.operatorContext.newLocalSystemMemoryContext("test");
        LocalMemoryContext userMemory = this.operatorContext.localUserMemoryContext();
        LocalMemoryContext revocableMemory = this.operatorContext.localRevocableMemoryContext();
        userMemory.setBytes(100L);
        this.assertOperatorMemoryAllocations(operatorMemoryContext, 100L, 0L, 0L);
        systemMemory.setBytes(1000000L);
        this.assertOperatorMemoryAllocations(operatorMemoryContext, 100L, 1000000L, 0L);
        systemMemory.setBytes(2000000L);
        this.assertOperatorMemoryAllocations(operatorMemoryContext, 100L, 2000000L, 0L);
        userMemory.setBytes(500L);
        this.assertOperatorMemoryAllocations(operatorMemoryContext, 500L, 2000000L, 0L);
        userMemory.setBytes(userMemory.getBytes() - 500L);
        this.assertOperatorMemoryAllocations(operatorMemoryContext, 0L, 2000000L, 0L);
        revocableMemory.setBytes(300L);
        this.assertOperatorMemoryAllocations(operatorMemoryContext, 0L, 2000000L, 300L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> userMemory.setBytes(userMemory.getBytes() - 500L)).isInstanceOf(IllegalArgumentException.class)).hasMessage("bytes cannot be negative");
        this.operatorContext.destroy();
        this.assertOperatorMemoryAllocations(operatorMemoryContext, 0L, 0L, 0L);
    }

    @Test
    public void testLocalTotalMemoryLimitExceeded() {
        LocalMemoryContext systemMemoryContext = this.operatorContext.newLocalSystemMemoryContext("test");
        systemMemoryContext.setBytes(100L);
        this.assertOperatorMemoryAllocations(this.operatorContext.getOperatorMemoryContext(), 0L, 100L, 0L);
        systemMemoryContext.setBytes(queryMaxTotalMemory.toBytes());
        this.assertOperatorMemoryAllocations(this.operatorContext.getOperatorMemoryContext(), 0L, queryMaxTotalMemory.toBytes(), 0L);
        try {
            systemMemoryContext.setBytes(queryMaxTotalMemory.toBytes() + 1L);
            Assert.fail((String)"allocation should hit the per-node total memory limit");
        }
        catch (ExceededMemoryLimitException e) {
            Assert.assertEquals((String)e.getMessage(), (String)String.format("Query exceeded per-node total memory limit of %1$s [Allocated: %1$s, Delta: 1B, Top Consumers: {test=%1$s}]", queryMaxTotalMemory));
        }
    }

    @Test
    public void testLocalSystemAllocations() {
        long pipelineLocalAllocation = 1000000L;
        long taskLocalAllocation = 10000000L;
        LocalMemoryContext pipelineLocalSystemMemoryContext = this.pipelineContext.localSystemMemoryContext();
        pipelineLocalSystemMemoryContext.setBytes(pipelineLocalAllocation);
        this.assertLocalMemoryAllocations(this.pipelineContext.getPipelineMemoryContext(), pipelineLocalAllocation, 0L, pipelineLocalAllocation);
        LocalMemoryContext taskLocalSystemMemoryContext = this.taskContext.localSystemMemoryContext();
        taskLocalSystemMemoryContext.setBytes(taskLocalAllocation);
        this.assertLocalMemoryAllocations(this.taskContext.getTaskMemoryContext(), pipelineLocalAllocation + taskLocalAllocation, 0L, taskLocalAllocation);
        Assert.assertEquals((long)this.pipelineContext.getPipelineStats().getSystemMemoryReservation().toBytes(), (long)pipelineLocalAllocation, (String)"task level allocations should not be visible at the pipeline level");
        pipelineLocalSystemMemoryContext.setBytes(pipelineLocalSystemMemoryContext.getBytes() - pipelineLocalAllocation);
        this.assertLocalMemoryAllocations(this.pipelineContext.getPipelineMemoryContext(), taskLocalAllocation, 0L, 0L);
        taskLocalSystemMemoryContext.setBytes(taskLocalSystemMemoryContext.getBytes() - taskLocalAllocation);
        this.assertLocalMemoryAllocations(this.taskContext.getTaskMemoryContext(), 0L, 0L, 0L);
    }

    @Test
    public void testStats() {
        LocalMemoryContext systemMemory = this.operatorContext.newLocalSystemMemoryContext("test");
        LocalMemoryContext userMemory = this.operatorContext.localUserMemoryContext();
        userMemory.setBytes(100000000L);
        systemMemory.setBytes(200000000L);
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 100000000L, 0L, 200000000L);
        userMemory.setBytes(600000000L);
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 600000000L, 0L, 200000000L);
        userMemory.setBytes(userMemory.getBytes() - 300000000L);
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 300000000L, 0L, 200000000L);
        userMemory.setBytes(userMemory.getBytes() - 300000000L);
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 0L, 0L, 200000000L);
        this.operatorContext.destroy();
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 0L, 0L, 0L);
    }

    @Test
    public void testRevocableMemoryAllocations() {
        LocalMemoryContext systemMemory = this.operatorContext.newLocalSystemMemoryContext("test");
        LocalMemoryContext userMemory = this.operatorContext.localUserMemoryContext();
        LocalMemoryContext revocableMemory = this.operatorContext.localRevocableMemoryContext();
        revocableMemory.setBytes(100000000L);
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 0L, 100000000L, 0L);
        userMemory.setBytes(100000000L);
        systemMemory.setBytes(100000000L);
        revocableMemory.setBytes(200000000L);
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 100000000L, 200000000L, 100000000L);
    }

    @Test
    public void testTrySetBytes() {
        LocalMemoryContext localMemoryContext = this.operatorContext.localUserMemoryContext();
        Assert.assertTrue((boolean)localMemoryContext.trySetBytes(100000000L));
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 100000000L, 0L, 0L);
        Assert.assertTrue((boolean)localMemoryContext.trySetBytes(200000000L));
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 200000000L, 0L, 0L);
        Assert.assertTrue((boolean)localMemoryContext.trySetBytes(100000000L));
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 100000000L, 0L, 0L);
        Assert.assertFalse((boolean)localMemoryContext.trySetBytes(this.memoryPool.getMaxBytes() + 1L));
        this.assertStats(this.operatorContext.getOperatorStats(), this.driverContext.getDriverStats(), this.pipelineContext.getPipelineStats(), this.taskContext.getTaskStats(), 100000000L, 0L, 0L);
    }

    @Test
    public void testTrySetZeroBytesFullPool() {
        LocalMemoryContext localMemoryContext = this.operatorContext.localUserMemoryContext();
        this.memoryPool.reserve(new QueryId("test_query"), "test", this.memoryPool.getFreeBytes());
        Assert.assertTrue((boolean)localMemoryContext.trySetBytes(localMemoryContext.getBytes()));
    }

    @Test
    public void testDestroy() {
        LocalMemoryContext newLocalSystemMemoryContext = this.operatorContext.newLocalSystemMemoryContext("test");
        LocalMemoryContext newLocalUserMemoryContext = this.operatorContext.localUserMemoryContext();
        LocalMemoryContext newLocalRevocableMemoryContext = this.operatorContext.localRevocableMemoryContext();
        newLocalSystemMemoryContext.setBytes(100000L);
        newLocalRevocableMemoryContext.setBytes(200000L);
        newLocalUserMemoryContext.setBytes(400000L);
        Assert.assertEquals((long)this.operatorContext.getOperatorMemoryContext().getSystemMemory(), (long)100000L);
        Assert.assertEquals((long)this.operatorContext.getOperatorMemoryContext().getUserMemory(), (long)400000L);
        this.operatorContext.destroy();
        this.assertOperatorMemoryAllocations(this.operatorContext.getOperatorMemoryContext(), 0L, 0L, 0L);
    }

    private void assertStats(OperatorStats operatorStats, DriverStats driverStats, PipelineStats pipelineStats, TaskStats taskStats, long expectedUserMemory, long expectedRevocableMemory, long expectedSystemMemory) {
        Assert.assertEquals((long)operatorStats.getUserMemoryReservation().toBytes(), (long)expectedUserMemory);
        Assert.assertEquals((long)driverStats.getUserMemoryReservation().toBytes(), (long)expectedUserMemory);
        Assert.assertEquals((long)pipelineStats.getUserMemoryReservation().toBytes(), (long)expectedUserMemory);
        Assert.assertEquals((long)taskStats.getUserMemoryReservation().toBytes(), (long)expectedUserMemory);
        Assert.assertEquals((long)operatorStats.getSystemMemoryReservation().toBytes(), (long)expectedSystemMemory);
        Assert.assertEquals((long)driverStats.getSystemMemoryReservation().toBytes(), (long)expectedSystemMemory);
        Assert.assertEquals((long)pipelineStats.getSystemMemoryReservation().toBytes(), (long)expectedSystemMemory);
        Assert.assertEquals((long)taskStats.getSystemMemoryReservation().toBytes(), (long)expectedSystemMemory);
        Assert.assertEquals((long)operatorStats.getRevocableMemoryReservation().toBytes(), (long)expectedRevocableMemory);
        Assert.assertEquals((long)driverStats.getRevocableMemoryReservation().toBytes(), (long)expectedRevocableMemory);
        Assert.assertEquals((long)pipelineStats.getRevocableMemoryReservation().toBytes(), (long)expectedRevocableMemory);
        Assert.assertEquals((long)taskStats.getRevocableMemoryReservation().toBytes(), (long)expectedRevocableMemory);
    }

    private void assertOperatorMemoryAllocations(MemoryTrackingContext memoryTrackingContext, long expectedUserMemory, long expectedSystemMemory, long expectedRevocableMemory) {
        Assert.assertEquals((long)memoryTrackingContext.getUserMemory(), (long)expectedUserMemory, (String)"User memory verification failed");
        Assert.assertEquals((long)this.memoryPool.getReservedBytes(), (long)(expectedUserMemory + expectedSystemMemory), (String)"Memory pool verification failed");
        Assert.assertEquals((long)memoryTrackingContext.getSystemMemory(), (long)expectedSystemMemory, (String)"System memory verification failed");
        Assert.assertEquals((long)memoryTrackingContext.getRevocableMemory(), (long)expectedRevocableMemory, (String)"Revocable memory verification failed");
    }

    private void assertLocalMemoryAllocations(MemoryTrackingContext memoryTrackingContext, long expectedPoolMemory, long expectedContextUserMemory, long expectedContextSystemMemory) {
        Assert.assertEquals((long)memoryTrackingContext.getUserMemory(), (long)expectedContextUserMemory, (String)"User memory verification failed");
        Assert.assertEquals((long)this.memoryPool.getReservedBytes(), (long)expectedPoolMemory, (String)"Memory pool verification failed");
        Assert.assertEquals((long)memoryTrackingContext.localSystemMemoryContext().getBytes(), (long)expectedContextSystemMemory, (String)"Local system memory verification failed");
    }
}

