/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.memory;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.prestosql.memory.NodeMemoryConfig;
import java.util.Map;
import org.testng.annotations.Test;

public class TestNodeMemoryConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((NodeMemoryConfig)ConfigAssertions.recordDefaults(NodeMemoryConfig.class)).setMaxQueryMemoryPerNode(DataSize.ofBytes((long)Math.round((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.1))).setMaxQueryTotalMemoryPerNode(DataSize.ofBytes((long)Math.round((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.3))).setHeapHeadroom(DataSize.ofBytes((long)Math.round((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.3))).setReservedPoolDisabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"query.max-memory-per-node", (Object)"1GB").put((Object)"query.max-total-memory-per-node", (Object)"3GB").put((Object)"memory.heap-headroom-per-node", (Object)"1GB").put((Object)"experimental.reserved-pool-disabled", (Object)"false").build();
        NodeMemoryConfig expected = new NodeMemoryConfig().setMaxQueryMemoryPerNode(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setMaxQueryTotalMemoryPerNode(DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setHeapHeadroom(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setReservedPoolDisabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

