/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.client.ClientCapabilities;
import io.prestosql.connector.CatalogName;
import io.prestosql.connector.MockConnectorFactory;
import io.prestosql.connector.informationschema.InformationSchemaColumnHandle;
import io.prestosql.connector.informationschema.InformationSchemaMetadata;
import io.prestosql.connector.informationschema.InformationSchemaTableHandle;
import io.prestosql.metadata.Catalog;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.QualifiedTablePrefix;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.testing.TestingConnectorContext;
import io.prestosql.testing.TestingSession;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionId;
import io.prestosql.transaction.TransactionManager;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInformationSchemaMetadata {
    private final TransactionManager transactionManager;
    private final Metadata metadata;

    public TestInformationSchemaMetadata() {
        MockConnectorFactory.Builder builder = MockConnectorFactory.builder();
        MockConnectorFactory mockConnectorFactory = builder.withListSchemaNames(connectorSession -> ImmutableList.of((Object)"test_schema")).withListTables((connectorSession, schemaNameOrNull) -> ImmutableList.of((Object)new SchemaTableName("test_schema", "test_view"), (Object)new SchemaTableName("test_schema", "another_table"))).withGetViews((connectorSession, prefix) -> {
            ConnectorViewDefinition definition = new ConnectorViewDefinition("select 1", Optional.of("test_catalog"), Optional.of("test_schema"), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("test", BigintType.BIGINT.getTypeId())), Optional.of("comment"), Optional.empty(), true);
            SchemaTableName viewName = new SchemaTableName("test_schema", "test_view");
            return ImmutableMap.of((Object)viewName, (Object)definition);
        }).build();
        Connector testConnector = mockConnectorFactory.create("test", (Map<String, String>)ImmutableMap.of(), (ConnectorContext)new TestingConnectorContext());
        CatalogManager catalogManager = new CatalogManager();
        String catalogName = "test_catalog";
        CatalogName catalog = new CatalogName("test_catalog");
        catalogManager.registerCatalog(new Catalog(catalogName, catalog, testConnector, CatalogName.createInformationSchemaCatalogName((CatalogName)catalog), testConnector, CatalogName.createSystemTablesCatalogName((CatalogName)catalog), testConnector));
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager, (FeaturesConfig)new FeaturesConfig());
    }

    @Test
    public void testInformationSchemaPredicatePushdown() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        ImmutableMap.Builder domains = new ImmutableMap.Builder();
        domains.put((Object)new InformationSchemaColumnHandle("table_schema"), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test_schema")));
        domains.put((Object)new InformationSchemaColumnHandle("table_name"), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test_view")));
        Constraint constraint = new Constraint(TupleDomain.withColumnDomains((Map)domains.build()));
        ConnectorSession session = TestInformationSchemaMetadata.createNewSession(transactionId);
        InformationSchemaMetadata metadata = new InformationSchemaMetadata("test_catalog", this.metadata);
        InformationSchemaTableHandle tableHandle = (InformationSchemaTableHandle)metadata.getTableHandle(session, new SchemaTableName("information_schema", "views"));
        tableHandle = metadata.applyFilter(session, (ConnectorTableHandle)tableHandle, constraint).map(ConstraintApplicationResult::getHandle).map(InformationSchemaTableHandle.class::cast).orElseThrow(AssertionError::new);
        Assert.assertEquals((Set)tableHandle.getPrefixes(), (Set)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "test_schema", "test_view")));
    }

    @Test
    public void testInformationSchemaPredicatePushdownWithConstraintPredicate() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        Constraint constraint = new Constraint(TupleDomain.all(), TestInformationSchemaMetadata::testConstraint);
        ConnectorSession session = TestInformationSchemaMetadata.createNewSession(transactionId);
        InformationSchemaMetadata metadata = new InformationSchemaMetadata("test_catalog", this.metadata);
        InformationSchemaTableHandle tableHandle = (InformationSchemaTableHandle)metadata.getTableHandle(session, new SchemaTableName("information_schema", "columns"));
        tableHandle = metadata.applyFilter(session, (ConnectorTableHandle)tableHandle, constraint).map(ConstraintApplicationResult::getHandle).map(InformationSchemaTableHandle.class::cast).orElseThrow(AssertionError::new);
        Assert.assertEquals((Set)tableHandle.getPrefixes(), (Set)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "test_schema", "test_view")));
    }

    @Test
    public void testInformationSchemaPredicatePushdownWithoutSchemaPredicate() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        ImmutableMap.Builder domains = new ImmutableMap.Builder();
        domains.put((Object)new InformationSchemaColumnHandle("table_name"), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test_view")));
        Constraint constraint = new Constraint(TupleDomain.withColumnDomains((Map)domains.build()));
        ConnectorSession session = TestInformationSchemaMetadata.createNewSession(transactionId);
        InformationSchemaMetadata metadata = new InformationSchemaMetadata("test_catalog", this.metadata);
        InformationSchemaTableHandle tableHandle = (InformationSchemaTableHandle)metadata.getTableHandle(session, new SchemaTableName("information_schema", "views"));
        tableHandle = metadata.applyFilter(session, (ConnectorTableHandle)tableHandle, constraint).map(ConstraintApplicationResult::getHandle).map(InformationSchemaTableHandle.class::cast).orElseThrow(AssertionError::new);
        Assert.assertEquals((Set)tableHandle.getPrefixes(), (Set)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "test_schema", "test_view")));
    }

    @Test
    public void testInformationSchemaPredicatePushdownWithoutTablePredicate() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        ImmutableMap.Builder domains = new ImmutableMap.Builder();
        domains.put((Object)new InformationSchemaColumnHandle("table_schema"), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test_schema")));
        Constraint constraint = new Constraint(TupleDomain.withColumnDomains((Map)domains.build()));
        ConnectorSession session = TestInformationSchemaMetadata.createNewSession(transactionId);
        InformationSchemaMetadata metadata = new InformationSchemaMetadata("test_catalog", this.metadata);
        InformationSchemaTableHandle tableHandle = (InformationSchemaTableHandle)metadata.getTableHandle(session, new SchemaTableName("information_schema", "views"));
        tableHandle = metadata.applyFilter(session, (ConnectorTableHandle)tableHandle, constraint).map(ConstraintApplicationResult::getHandle).map(InformationSchemaTableHandle.class::cast).orElseThrow(AssertionError::new);
        Assert.assertEquals((Set)tableHandle.getPrefixes(), (Set)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "test_schema")));
    }

    @Test
    public void testInformationSchemaPredicatePushdownWithConstraintPredicateOnViewsTable() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        Constraint constraint = new Constraint(TupleDomain.all(), TestInformationSchemaMetadata::testConstraint);
        ConnectorSession session = TestInformationSchemaMetadata.createNewSession(transactionId);
        InformationSchemaMetadata metadata = new InformationSchemaMetadata("test_catalog", this.metadata);
        InformationSchemaTableHandle tableHandle = (InformationSchemaTableHandle)metadata.getTableHandle(session, new SchemaTableName("information_schema", "views"));
        tableHandle = metadata.applyFilter(session, (ConnectorTableHandle)tableHandle, constraint).map(ConstraintApplicationResult::getHandle).map(InformationSchemaTableHandle.class::cast).orElseThrow(AssertionError::new);
        Assert.assertEquals((Set)tableHandle.getPrefixes(), (Set)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "test_schema")));
    }

    @Test
    public void testInformationSchemaPredicatePushdownOnCatalogWiseTables() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        Constraint constraint = new Constraint(TupleDomain.all());
        ConnectorSession session = TestInformationSchemaMetadata.createNewSession(transactionId);
        InformationSchemaMetadata metadata = new InformationSchemaMetadata("test_catalog", this.metadata);
        InformationSchemaTableHandle tableHandle = (InformationSchemaTableHandle)metadata.getTableHandle(session, new SchemaTableName("information_schema", "schemata"));
        Optional result = metadata.applyFilter(session, (ConnectorTableHandle)tableHandle, constraint);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testInformationSchemaPredicatePushdownForEmptyNames() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        ConnectorSession session = TestInformationSchemaMetadata.createNewSession(transactionId);
        InformationSchemaMetadata metadata = new InformationSchemaMetadata("test_catalog", this.metadata);
        InformationSchemaColumnHandle tableSchemaColumn = new InformationSchemaColumnHandle("table_schema");
        InformationSchemaColumnHandle tableNameColumn = new InformationSchemaColumnHandle("table_name");
        ConnectorTableHandle tableHandle = metadata.getTableHandle(session, new SchemaTableName("information_schema", "tables"));
        InformationSchemaTableHandle filtered = metadata.applyFilter(session, tableHandle, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)tableSchemaColumn, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"")))))).map(ConstraintApplicationResult::getHandle).map(InformationSchemaTableHandle.class::cast).orElseThrow(AssertionError::new);
        Assert.assertEquals((Set)filtered.getPrefixes(), (Set)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "")));
        filtered = metadata.applyFilter(session, tableHandle, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)tableNameColumn, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"")))))).map(ConstraintApplicationResult::getHandle).map(InformationSchemaTableHandle.class::cast).orElseThrow(AssertionError::new);
        Assert.assertEquals((Set)filtered.getPrefixes(), (Set)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "test_schema", "")));
    }

    private static boolean testConstraint(Map<ColumnHandle, NullableValue> bindings) {
        NullableValue catalog = bindings.get(new InformationSchemaColumnHandle("table_catalog"));
        NullableValue schema = bindings.get(new InformationSchemaColumnHandle("table_schema"));
        NullableValue table = bindings.get(new InformationSchemaColumnHandle("table_name"));
        boolean isValid = true;
        if (catalog != null) {
            isValid = ((Slice)catalog.getValue()).toStringUtf8().equals("test_catalog");
        }
        if (schema != null) {
            isValid &= ((Slice)schema.getValue()).toStringUtf8().equals("test_schema");
        }
        if (table != null) {
            isValid &= ((Slice)table.getValue()).toStringUtf8().equals("test_view");
        }
        return isValid;
    }

    private static ConnectorSession createNewSession(TransactionId transactionId) {
        return TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("information_schema").setClientCapabilities((Set)Arrays.stream(ClientCapabilities.values()).map(Enum::toString).collect(ImmutableSet.toImmutableSet())).setTransactionId(transactionId).build().toConnectorSession();
    }
}

