/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.metadata.BoundSignature;
import io.prestosql.metadata.FunctionId;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.Signature;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeId;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestResolvedFunction {
    private static final Pattern VARCHAR_MATCHER = Pattern.compile("varchar\\(([0-9]+)\\)");

    @Test
    public void test() {
        ResolvedFunction resolvedFunction = TestResolvedFunction.createResolvedFunction("top", 3);
        ResolvedFunction.ResolvedFunctionDecoder decoder = new ResolvedFunction.ResolvedFunctionDecoder(TestResolvedFunction::varcharTypeLoader);
        Optional copy = decoder.fromQualifiedName(resolvedFunction.toQualifiedName());
        Assert.assertTrue((boolean)copy.isPresent());
        Assert.assertEquals(copy.get(), (Object)resolvedFunction);
    }

    private static ResolvedFunction createResolvedFunction(String name, int depth) {
        return new ResolvedFunction(new BoundSignature(name + "_" + depth, (Type)VarcharType.createVarcharType((int)(10 + depth)), (List)ImmutableList.of((Object)VarcharType.createVarcharType((int)(20 + depth)), (Object)VarcharType.createVarcharType((int)(30 + depth)))), FunctionId.toFunctionId((Signature)Signature.builder().name(name).returnType(new TypeSignature("x", new TypeSignatureParameter[0])).argumentTypes(new TypeSignature[]{new TypeSignature("y", new TypeSignatureParameter[0]), new TypeSignature("z", new TypeSignatureParameter[0])}).build()), (Map)ImmutableSet.of((Object)VarcharType.createVarcharType((int)11), (Object)VarcharType.createVarcharType((int)12), (Object)VarcharType.createVarcharType((int)13)).stream().collect(ImmutableMap.toImmutableMap(Type::getTypeSignature, Function.identity())), (Set)(depth == 0 ? ImmutableSet.of() : ImmutableSet.of((Object)TestResolvedFunction.createResolvedFunction("left", depth - 1), (Object)TestResolvedFunction.createResolvedFunction("right", depth - 1))));
    }

    private static Type varcharTypeLoader(TypeId typeId) {
        Matcher matcher = VARCHAR_MATCHER.matcher(typeId.getId());
        boolean matches = matcher.matches();
        Assert.assertTrue((boolean)matches);
        return VarcharType.createVarcharType((int)Integer.parseInt(matcher.group(1)));
    }
}

