/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.prestosql.RowPagesBuilder;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.execution.Lifespan;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.HashBuilderOperator;
import io.prestosql.operator.JoinBridgeManager;
import io.prestosql.operator.LookupJoinOperators;
import io.prestosql.operator.LookupSourceFactory;
import io.prestosql.operator.LookupSourceProvider;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.PagesIndex;
import io.prestosql.operator.PartitionedLookupSourceFactory;
import io.prestosql.operator.TaskContext;
import io.prestosql.spi.Page;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spiller.PartitioningSpillerFactory;
import io.prestosql.spiller.SingleStreamSpillerFactory;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.TestingTaskContext;
import io.prestosql.type.BlockTypeOperators;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=3)
@Warmup(iterations=5)
@Measurement(iterations=10, time=2, timeUnit=TimeUnit.SECONDS)
public class BenchmarkHashBuildAndJoinOperators {
    private static final int HASH_BUILD_OPERATOR_ID = 1;
    private static final int HASH_JOIN_OPERATOR_ID = 2;
    private static final PlanNodeId TEST_PLAN_NODE_ID = new PlanNodeId("test");
    private static final LookupJoinOperators LOOKUP_JOIN_OPERATORS = new LookupJoinOperators();
    private static final BlockTypeOperators TYPE_OPERATOR_FACTORY = new BlockTypeOperators(new TypeOperators());

    @Benchmark
    public JoinBridgeManager<PartitionedLookupSourceFactory> benchmarkBuildHash(BuildContext buildContext) {
        ImmutableList outputChannels = ImmutableList.of((Object)0, (Object)1, (Object)2);
        JoinBridgeManager<PartitionedLookupSourceFactory> joinBridgeManager = BenchmarkHashBuildAndJoinOperators.getLookupSourceFactoryManager(buildContext, (List<Integer>)outputChannels);
        BenchmarkHashBuildAndJoinOperators.buildHash(buildContext, joinBridgeManager, (List<Integer>)outputChannels);
        return joinBridgeManager;
    }

    private static JoinBridgeManager<PartitionedLookupSourceFactory> getLookupSourceFactoryManager(BuildContext buildContext, List<Integer> outputChannels) {
        return JoinBridgeManager.lookupAllAtOnce((PartitionedLookupSourceFactory)new PartitionedLookupSourceFactory(buildContext.getTypes(), (List)outputChannels.stream().map(buildContext.getTypes()::get).collect(ImmutableList.toImmutableList()), (List)buildContext.getHashChannels().stream().map(buildContext.getTypes()::get).collect(ImmutableList.toImmutableList()), 1, false, TYPE_OPERATOR_FACTORY));
    }

    private static void buildHash(BuildContext buildContext, JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager, List<Integer> outputChannels) {
        DriverContext driverContext = buildContext.createTaskContext().addPipelineContext(0, true, true, false).addDriverContext();
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(1, TEST_PLAN_NODE_ID, lookupSourceFactoryManager, outputChannels, buildContext.getHashChannels(), buildContext.getHashChannel(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), 10000, (PagesIndex.Factory)new PagesIndex.TestingFactory(false), false, SingleStreamSpillerFactory.unsupportedSingleStreamSpillerFactory());
        HashBuilderOperator operator = hashBuilderOperatorFactory.createOperator(driverContext);
        for (Page page : buildContext.getBuildPages()) {
            operator.addInput(page);
        }
        LookupSourceFactory lookupSourceFactory = (LookupSourceFactory)lookupSourceFactoryManager.getJoinBridge(Lifespan.taskWide());
        ListenableFuture lookupSourceProvider = lookupSourceFactory.createLookupSourceProvider();
        operator.finish();
        if (!lookupSourceProvider.isDone()) {
            throw new AssertionError((Object)"Expected lookup source provider to be ready");
        }
        ((LookupSourceProvider)MoreFutures.getFutureValue((Future)lookupSourceProvider)).close();
    }

    @Benchmark
    public List<Page> benchmarkJoinHash(JoinContext joinContext) throws Exception {
        DriverContext driverContext = joinContext.createTaskContext().addPipelineContext(0, true, true, false).addDriverContext();
        Operator joinOperator = joinContext.getJoinOperatorFactory().createOperator(driverContext);
        Iterator<Page> input = joinContext.getProbePages().iterator();
        ImmutableList.Builder outputPages = ImmutableList.builder();
        boolean finishing = false;
        for (int loops = 0; !joinOperator.isFinished() && loops < 1000000; ++loops) {
            Page outputPage;
            if (joinOperator.needsInput()) {
                if (input.hasNext()) {
                    Page inputPage = input.next();
                    joinOperator.addInput(inputPage);
                } else if (!finishing) {
                    joinOperator.finish();
                    finishing = true;
                }
            }
            if ((outputPage = joinOperator.getOutput()) == null) continue;
            outputPages.add((Object)outputPage);
        }
        joinOperator.close();
        return outputPages.build();
    }

    @Test
    public void testBenchmarkJoinHash() throws Exception {
        JoinContext joinContext = new JoinContext();
        joinContext.setup();
        this.benchmarkJoinHash(joinContext);
        List<Page> pages = this.benchmarkJoinHash(joinContext);
        Preconditions.checkState((!pages.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((pages.get(0).getPositionCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBenchmarkBuildHash() {
        BuildContext buildContext = new BuildContext();
        buildContext.setup();
        this.benchmarkBuildHash(buildContext);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkHashBuildAndJoinOperators.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class JoinContext
    extends BuildContext {
        protected static final int PROBE_ROWS_NUMBER = 1400000;
        @Param(value={"0.1", "1", "2"})
        protected double matchRate = 1.0;
        @Param(value={"bigint", "all"})
        protected String outputColumns = "bigint";
        protected List<Page> probePages;
        protected List<Integer> outputChannels;
        protected OperatorFactory joinOperatorFactory;

        @Override
        @Setup
        public void setup() {
            super.setup();
            switch (this.outputColumns) {
                case "varchar": {
                    this.outputChannels = Ints.asList((int[])new int[]{0});
                    break;
                }
                case "bigint": {
                    this.outputChannels = Ints.asList((int[])new int[]{1});
                    break;
                }
                case "all": {
                    this.outputChannels = Ints.asList((int[])new int[]{0, 1, 2});
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unknown outputColumns value [%s]", this.hashColumns));
                }
            }
            JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = BenchmarkHashBuildAndJoinOperators.getLookupSourceFactoryManager(this, this.outputChannels);
            this.joinOperatorFactory = LOOKUP_JOIN_OPERATORS.innerJoin(2, TEST_PLAN_NODE_ID, lookupSourceFactory, this.types, this.hashChannels, this.hashChannel, Optional.of(this.outputChannels), OptionalInt.empty(), PartitioningSpillerFactory.unsupportedPartitioningSpillerFactory(), TYPE_OPERATOR_FACTORY);
            BenchmarkHashBuildAndJoinOperators.buildHash(this, lookupSourceFactory, this.outputChannels);
            this.initializeProbePages();
        }

        public OperatorFactory getJoinOperatorFactory() {
            return this.joinOperatorFactory;
        }

        public List<Page> getProbePages() {
            return this.probePages;
        }

        protected void initializeProbePages() {
            RowPagesBuilder probePagesBuilder = RowPagesBuilder.rowPagesBuilder(this.buildHashEnabled, (List<Integer>)this.hashChannels, (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
            Random random = new Random(42L);
            int remainingRows = 1400000;
            int rowsInPage = 0;
            while (remainingRows > 0) {
                double roll = random.nextDouble();
                int columnA = 20 + remainingRows;
                int columnB = 30 + remainingRows;
                int columnC = 40 + remainingRows;
                int rowsCount = 1;
                if (this.matchRate < 1.0) {
                    if (roll > this.matchRate) {
                        columnA *= -1;
                        columnB *= -1;
                        columnC *= -1;
                    }
                } else if (this.matchRate > 1.0) {
                    roll = roll * 2.0 * this.matchRate + 1.0;
                    rowsCount = (int)Math.floor(roll);
                }
                for (int i = 0; i < rowsCount; ++i) {
                    if (rowsInPage >= 1024) {
                        probePagesBuilder.pageBreak();
                        rowsInPage = 0;
                    }
                    probePagesBuilder.row(String.format("%d", columnA), columnB, columnC);
                    --remainingRows;
                    ++rowsInPage;
                }
            }
            this.probePages = probePagesBuilder.build();
        }
    }

    @State(value=Scope.Thread)
    public static class BuildContext {
        protected static final int ROWS_PER_PAGE = 1024;
        protected static final int BUILD_ROWS_NUMBER = 8000000;
        @Param(value={"varchar", "bigint", "all"})
        protected String hashColumns = "bigint";
        @Param(value={"false", "true"})
        protected boolean buildHashEnabled;
        @Param(value={"1", "5"})
        protected int buildRowsRepetition = 1;
        protected ExecutorService executor;
        protected ScheduledExecutorService scheduledExecutor;
        protected List<Page> buildPages;
        protected OptionalInt hashChannel;
        protected List<Type> types;
        protected List<Integer> hashChannels;

        @Setup
        public void setup() {
            switch (this.hashColumns) {
                case "varchar": {
                    this.hashChannels = Ints.asList((int[])new int[]{0});
                    break;
                }
                case "bigint": {
                    this.hashChannels = Ints.asList((int[])new int[]{1});
                    break;
                }
                case "all": {
                    this.hashChannels = Ints.asList((int[])new int[]{0, 1, 2});
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unknown hashColumns value [%s]", this.hashColumns));
                }
            }
            this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
            this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
            this.initializeBuildPages();
        }

        public TaskContext createTaskContext() {
            return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        }

        public OptionalInt getHashChannel() {
            return this.hashChannel;
        }

        public List<Integer> getHashChannels() {
            return this.hashChannels;
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public List<Page> getBuildPages() {
            return this.buildPages;
        }

        protected void initializeBuildPages() {
            int newRows;
            RowPagesBuilder buildPagesBuilder = RowPagesBuilder.rowPagesBuilder(this.buildHashEnabled, this.hashChannels, (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
            int maxValue = 8000000 / this.buildRowsRepetition + 40;
            for (int rows = 0; rows < 8000000; rows += newRows) {
                newRows = Math.min(8000000 - rows, 1024);
                buildPagesBuilder.addSequencePage(newRows, (rows + 20) % maxValue, (rows + 30) % maxValue, (rows + 40) % maxValue);
                buildPagesBuilder.pageBreak();
            }
            this.types = buildPagesBuilder.getTypes();
            this.buildPages = buildPagesBuilder.build();
            this.hashChannel = buildPagesBuilder.getHashChannel().map(OptionalInt::of).orElse(OptionalInt.empty());
        }
    }
}

