/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.execution.StateMachine;
import io.prestosql.execution.buffer.BufferState;
import io.prestosql.execution.buffer.OutputBuffer;
import io.prestosql.execution.buffer.OutputBuffers;
import io.prestosql.execution.buffer.PagesSerdeFactory;
import io.prestosql.execution.buffer.PartitionedOutputBuffer;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.memory.context.SimpleLocalMemoryContext;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.HashGenerator;
import io.prestosql.operator.InterpretedHashGenerator;
import io.prestosql.operator.PartitionFunction;
import io.prestosql.operator.PartitionedOutputOperator;
import io.prestosql.operator.exchange.LocalPartitionGenerator;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.TestingTaskContext;
import io.prestosql.type.BlockTypeOperators;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=2)
@Warmup(iterations=20, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=20, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkPartitionedOutputOperator {
    @Benchmark
    public void addPage(BenchmarkData data) {
        PartitionedOutputOperator operator = data.createPartitionedOutputOperator();
        for (int i = 0; i < data.getPageCount(); ++i) {
            operator.addInput(data.getDataPage());
        }
        operator.finish();
    }

    public static void main(String[] args) throws RunnerException {
        BenchmarkData data = new BenchmarkData();
        new BenchmarkPartitionedOutputOperator().addPage(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).jvmArgs(new String[]{"-Xmx10g"}).include(".*" + BenchmarkPartitionedOutputOperator.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int PAGE_COUNT = 5000;
        private static final int PARTITION_COUNT = 512;
        private static final int ENTRIES_PER_PAGE = 256;
        private static final DataSize MAX_MEMORY = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
        private static final RowType rowType = RowType.anonymous((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR));
        private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)rowType, (Object)rowType, (Object)rowType);
        private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"BenchmarkPartitionedOutputOperator-executor-%s"));
        private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)"BenchmarkPartitionedOutputOperator-scheduledExecutor-%s"));
        private final Page dataPage = this.createPage();

        private int getPageCount() {
            return 5000;
        }

        public Page getDataPage() {
            return this.dataPage;
        }

        private PartitionedOutputOperator createPartitionedOutputOperator() {
            BlockTypeOperators blockTypeOperators = new BlockTypeOperators(new TypeOperators());
            LocalPartitionGenerator partitionFunction = new LocalPartitionGenerator((HashGenerator)new InterpretedHashGenerator((List)ImmutableList.of((Object)BigintType.BIGINT), new int[]{0}, blockTypeOperators), 512);
            PagesSerdeFactory serdeFactory = new PagesSerdeFactory(MetadataManager.createTestMetadataManager().getBlockEncodingSerde(), false);
            OutputBuffers buffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED);
            for (int partition = 0; partition < 512; ++partition) {
                buffers = buffers.withBuffer(new OutputBuffers.OutputBufferId(partition), partition);
            }
            PartitionedOutputBuffer buffer = this.createPartitionedBuffer(buffers.withNoMoreBufferIds(), DataSize.ofBytes((long)Long.MAX_VALUE));
            PartitionedOutputOperator.PartitionedOutputFactory operatorFactory = new PartitionedOutputOperator.PartitionedOutputFactory((PartitionFunction)partitionFunction, (List)ImmutableList.of((Object)0), (List)ImmutableList.of(Optional.empty()), false, OptionalInt.empty(), (OutputBuffer)buffer, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
            return (PartitionedOutputOperator)operatorFactory.createOutputOperator(0, new PlanNodeId("plan-node-0"), TYPES, Function.identity(), serdeFactory).createOperator(this.createDriverContext());
        }

        private Page createPage() {
            List<Object>[] testRows = this.generateTestRows((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), 256);
            PageBuilder pageBuilder = new PageBuilder(TYPES);
            BlockBuilder bigintBlockBuilder = pageBuilder.getBlockBuilder(0);
            BlockBuilder rowBlockBuilder = pageBuilder.getBlockBuilder(1);
            BlockBuilder rowBlockBuilder2 = pageBuilder.getBlockBuilder(2);
            BlockBuilder rowBlockBuilder3 = pageBuilder.getBlockBuilder(3);
            for (int i = 0; i < 256; ++i) {
                BigintType.BIGINT.writeLong(bigintBlockBuilder, (long)i);
                this.writeRow(testRows[i], rowBlockBuilder);
                this.writeRow(testRows[i], rowBlockBuilder2);
                this.writeRow(testRows[i], rowBlockBuilder3);
            }
            pageBuilder.declarePositions(256);
            return pageBuilder.build();
        }

        private void writeRow(List<Object> testRow, BlockBuilder rowBlockBuilder) {
            BlockBuilder singleRowBlockWriter = rowBlockBuilder.beginBlockEntry();
            for (Object fieldValue : testRow) {
                if (fieldValue instanceof String) {
                    VarcharType.VARCHAR.writeSlice(singleRowBlockWriter, Slices.utf8Slice((String)((String)fieldValue)));
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            rowBlockBuilder.closeEntry();
        }

        private List<Object>[] generateTestRows(List<Type> fieldTypes, int numRows) {
            List[] testRows = new List[numRows];
            for (int i = 0; i < numRows; ++i) {
                ArrayList<String> testRow = new ArrayList<String>(fieldTypes.size());
                for (int j = 0; j < fieldTypes.size(); ++j) {
                    if (fieldTypes.get(j) != VarcharType.VARCHAR) {
                        throw new UnsupportedOperationException();
                    }
                    byte[] data = new byte[ThreadLocalRandom.current().nextInt(128)];
                    ThreadLocalRandom.current().nextBytes(data);
                    testRow.add(new String(data, StandardCharsets.ISO_8859_1));
                }
                testRows[i] = testRow;
            }
            return testRows;
        }

        private DriverContext createDriverContext() {
            return TestingTaskContext.builder((Executor)EXECUTOR, (ScheduledExecutorService)SCHEDULER, (Session)SessionTestUtils.TEST_SESSION).setMemoryPoolSize(MAX_MEMORY).build().addPipelineContext(0, true, true, false).addDriverContext();
        }

        private PartitionedOutputBuffer createPartitionedBuffer(OutputBuffers buffers, DataSize dataSize) {
            return new PartitionedOutputBuffer("task-instance-id", new StateMachine("bufferState", (Executor)SCHEDULER, (Object)BufferState.OPEN, (Iterable)BufferState.TERMINAL_BUFFER_STATES), buffers, dataSize, () -> new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "test"), (Executor)SCHEDULER);
        }
    }
}

