/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.CompletedWork;
import io.prestosql.operator.GroupByHash;
import io.prestosql.operator.GroupByIdBlock;
import io.prestosql.operator.Work;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;

public class CyclingGroupByHash
implements GroupByHash {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(CyclingGroupByHash.class).instanceSize();
    private final int totalGroupCount;
    private int maxGroupId;
    private int currentGroupId;

    public CyclingGroupByHash(int totalGroupCount) {
        this.totalGroupCount = totalGroupCount;
    }

    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    public long getHashCollisions() {
        return 0L;
    }

    public double getExpectedHashCollisions() {
        return 0.0;
    }

    public List<Type> getTypes() {
        return ImmutableList.of();
    }

    public int getGroupCount() {
        return this.maxGroupId + 1;
    }

    public void appendValuesTo(int groupId, PageBuilder pageBuilder, int outputChannelOffset) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public Work<?> addPage(Page page) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public Work<GroupByIdBlock> getGroupIds(Page page) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, page.getChannelCount());
        for (int i = 0; i < page.getPositionCount(); ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)this.currentGroupId);
            this.maxGroupId = Math.max(this.currentGroupId, this.maxGroupId);
            this.currentGroupId = (this.currentGroupId + 1) % this.totalGroupCount;
        }
        return new CompletedWork((Object)new GroupByIdBlock((long)this.getGroupCount(), blockBuilder.build()));
    }

    public boolean contains(int position, Page page, int[] hashChannels) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public long getRawHash(int groupyId) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public int getCapacity() {
        return this.totalGroupCount;
    }
}

