/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.testing.TestingHttpClient;
import io.airlift.http.client.testing.TestingResponse;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceOutput;
import io.airlift.units.DataSize;
import io.prestosql.execution.buffer.BufferResult;
import io.prestosql.execution.buffer.PagesSerde;
import io.prestosql.execution.buffer.PagesSerdeUtil;
import io.prestosql.execution.buffer.SerializedPage;
import io.prestosql.execution.buffer.TestingPagesSerdeFactory;
import io.prestosql.spi.Page;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.testng.Assert;

public class MockExchangeRequestProcessor
implements TestingHttpClient.Processor {
    private static final String TASK_INSTANCE_ID = "task-instance-id";
    private static final PagesSerde PAGES_SERDE = TestingPagesSerdeFactory.testingPagesSerde();
    private final LoadingCache<URI, MockBuffer> buffers = CacheBuilder.newBuilder().build(CacheLoader.from(x$0 -> new MockBuffer((URI)x$0)));
    private final DataSize expectedMaxSize;

    public MockExchangeRequestProcessor(DataSize expectedMaxSize) {
        this.expectedMaxSize = expectedMaxSize;
    }

    public void addPage(URI location, Page page) {
        ((MockBuffer)this.buffers.getUnchecked((Object)location)).addPage(page);
    }

    public void setComplete(URI location) {
        ((MockBuffer)this.buffers.getUnchecked((Object)location)).setCompleted();
    }

    public Response handle(Request request) {
        HttpStatus status;
        if (request.getMethod().equalsIgnoreCase("DELETE")) {
            return new TestingResponse(HttpStatus.NO_CONTENT, (ListMultimap)ImmutableListMultimap.of(), new byte[0]);
        }
        Assert.assertTrue((!request.getHeaders().get((Object)"X-Presto-Max-Size").isEmpty() ? 1 : 0) != 0);
        DataSize maxSize = DataSize.valueOf((String)request.getHeader("X-Presto-Max-Size"));
        Assert.assertEquals((Object)maxSize, (Object)this.expectedMaxSize);
        RequestLocation requestLocation = new RequestLocation(request.getUri());
        URI location = requestLocation.getLocation();
        BufferResult result = ((MockBuffer)this.buffers.getUnchecked((Object)location)).getPages(requestLocation.getSequenceId(), maxSize);
        byte[] bytes = new byte[]{};
        if (!result.getSerializedPages().isEmpty()) {
            DynamicSliceOutput sliceOutput = new DynamicSliceOutput(64);
            sliceOutput.writeInt(-22745087);
            sliceOutput.writeLong(PagesSerdeUtil.calculateChecksum((List)result.getSerializedPages()));
            sliceOutput.writeInt(result.getSerializedPages().size());
            PagesSerdeUtil.writeSerializedPages((SliceOutput)sliceOutput, (Iterable)result.getSerializedPages());
            bytes = sliceOutput.slice().getBytes();
            status = HttpStatus.OK;
        } else {
            status = HttpStatus.NO_CONTENT;
        }
        return new TestingResponse(status, (ListMultimap)ImmutableListMultimap.of((Object)"Content-Type", (Object)"application/X-presto-pages", (Object)"X-Presto-Task-Instance-Id", (Object)String.valueOf(result.getTaskInstanceId()), (Object)"X-Presto-Page-Sequence-Id", (Object)String.valueOf(result.getToken()), (Object)"X-Presto-Page-End-Sequence-Id", (Object)String.valueOf(result.getNextToken()), (Object)"X-Presto-Buffer-Complete", (Object)String.valueOf(result.isBufferComplete())), bytes);
    }

    private static class MockBuffer {
        private final URI location;
        private final AtomicBoolean completed = new AtomicBoolean();
        private final AtomicLong token = new AtomicLong();
        private final BlockingQueue<SerializedPage> serializedPages = new LinkedBlockingQueue<SerializedPage>();

        private MockBuffer(URI location) {
            this.location = location;
        }

        public void setCompleted() {
            this.completed.set(true);
        }

        public synchronized void addPage(Page page) {
            Preconditions.checkState((this.completed.get() != Boolean.TRUE.booleanValue() ? 1 : 0) != 0, (String)"Location %s is complete", (Object)this.location);
            try (PagesSerde.PagesSerdeContext context = PAGES_SERDE.newContext();){
                this.serializedPages.add(PAGES_SERDE.serialize(context, page));
            }
        }

        public BufferResult getPages(long sequenceId, DataSize maxSize) {
            if (this.completed.get() && this.serializedPages.isEmpty()) {
                return BufferResult.emptyResults((String)MockExchangeRequestProcessor.TASK_INSTANCE_ID, (long)this.token.get(), (boolean)true);
            }
            Assert.assertEquals((long)sequenceId, (long)this.token.get(), (String)"token");
            SerializedPage serializedPage = null;
            try {
                serializedPage = this.serializedPages.poll(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (serializedPage == null) {
                return BufferResult.emptyResults((String)MockExchangeRequestProcessor.TASK_INSTANCE_ID, (long)this.token.get(), (boolean)false);
            }
            ArrayList<SerializedPage> responsePages = new ArrayList<SerializedPage>();
            responsePages.add(serializedPage);
            for (long responseSize = (long)serializedPage.getSizeInBytes(); responseSize < maxSize.toBytes() && (serializedPage = (SerializedPage)this.serializedPages.poll()) != null; responseSize += (long)serializedPage.getSizeInBytes()) {
                responsePages.add(serializedPage);
            }
            long nextToken = this.token.get() + (long)responsePages.size();
            BufferResult bufferResult = new BufferResult(MockExchangeRequestProcessor.TASK_INSTANCE_ID, this.token.get(), nextToken, false, responsePages);
            this.token.set(nextToken);
            return bufferResult;
        }
    }

    private static class RequestLocation {
        private final URI location;
        private final long sequenceId;

        public RequestLocation(URI uri) {
            String string = uri.toString();
            int index = string.lastIndexOf(47);
            this.location = URI.create(string.substring(0, index));
            this.sequenceId = Long.parseLong(string.substring(index + 1));
        }

        public URI getLocation() {
            return this.location;
        }

        public long getSequenceId() {
            return this.sequenceId;
        }
    }
}

