/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.Threads;
import io.prestosql.RowPagesBuilder;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.block.BlockAssertions;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.AggregationOperator;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorAssertion;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.ByteArrayBlock;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.TestingTaskContext;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestAggregationOperator {
    private static final Metadata metadata = MetadataManager.createTestMetadataManager();
    private static final InternalAggregationFunction LONG_AVERAGE = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"avg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
    private static final InternalAggregationFunction DOUBLE_SUM = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"sum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE})));
    private static final InternalAggregationFunction LONG_SUM = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"sum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
    private static final InternalAggregationFunction REAL_SUM = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"sum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{RealType.REAL})));
    private static final InternalAggregationFunction COUNT = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"count"), (List)ImmutableList.of()));
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testMaskWithDirtyNulls() {
        ImmutableList input = ImmutableList.of((Object)new Page(4, new Block[]{BlockAssertions.createLongsBlock(1, 2, 3, 4), new ByteArrayBlock(4, Optional.of(new boolean[]{true, true, false, false}), new byte[]{0, 27, 0, 75})}));
        AggregationOperator.AggregationOperatorFactory operatorFactory = new AggregationOperator.AggregationOperatorFactory(0, new PlanNodeId("test"), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)COUNT.bind((List)ImmutableList.of((Object)0), Optional.of(1))), false);
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, (List<Page>)input, expected);
    }

    @Test
    public void testAggregation() {
        InternalAggregationFunction countVarcharColumn = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"count"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})));
        InternalAggregationFunction maxVarcharColumn = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"max"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})));
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, RealType.REAL, DoubleType.DOUBLE, VarcharType.VARCHAR}).addSequencePage(100, 0, 0, 300, 500, 400, 500, 500).build();
        AggregationOperator.AggregationOperatorFactory operatorFactory = new AggregationOperator.AggregationOperatorFactory(0, new PlanNodeId("test"), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)COUNT.bind((List)ImmutableList.of((Object)0), Optional.empty()), (Object)LONG_SUM.bind((List)ImmutableList.of((Object)1), Optional.empty()), (Object)LONG_AVERAGE.bind((List)ImmutableList.of((Object)1), Optional.empty()), (Object)maxVarcharColumn.bind((List)ImmutableList.of((Object)2), Optional.empty()), (Object)countVarcharColumn.bind((List)ImmutableList.of((Object)0), Optional.empty()), (Object)LONG_SUM.bind((List)ImmutableList.of((Object)3), Optional.empty()), (Object)REAL_SUM.bind((List)ImmutableList.of((Object)4), Optional.empty()), (Object)DOUBLE_SUM.bind((List)ImmutableList.of((Object)5), Optional.empty()), (Object)maxVarcharColumn.bind((List)ImmutableList.of((Object)6), Optional.empty())), false);
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, DoubleType.DOUBLE, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT, RealType.REAL, DoubleType.DOUBLE, VarcharType.VARCHAR}).row(new Object[]{100L, 4950L, 49.5, "399", 100L, 54950L, Float.valueOf(44950.0f), 54950.0, "599"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected);
        Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)0L);
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
    }

    @Test
    public void testMemoryTracking() throws Exception {
        this.testMemoryTracking(false);
        this.testMemoryTracking(true);
    }

    private void testMemoryTracking(boolean useSystemMemory) throws Exception {
        Page input = (Page)Iterables.getOnlyElement(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).addSequencePage(100, 0).build());
        AggregationOperator.AggregationOperatorFactory operatorFactory = new AggregationOperator.AggregationOperatorFactory(0, new PlanNodeId("test"), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)LONG_SUM.bind((List)ImmutableList.of((Object)0), Optional.empty())), useSystemMemory);
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
        try (Operator operator = operatorFactory.createOperator(driverContext);){
            Assert.assertTrue((boolean)operator.needsInput());
            operator.addInput(input);
            if (useSystemMemory) {
                Assertions.assertThat((long)driverContext.getSystemMemoryUsage()).isGreaterThan(0L);
                Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
            } else {
                Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)0L);
                Assertions.assertThat((long)driverContext.getMemoryUsage()).isGreaterThan(0L);
            }
            OperatorAssertion.toPages(operator, Collections.emptyIterator());
        }
        Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)0L);
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
    }
}

