/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.prestosql.metadata.AggregationFunctionMetadata;
import io.prestosql.metadata.BoundSignature;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionDependencies;
import io.prestosql.metadata.FunctionId;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlAggregationFunction;
import io.prestosql.operator.ParametricImplementationsGroup;
import io.prestosql.operator.TestAnnotationEngine;
import io.prestosql.operator.aggregation.AggregationFromAnnotationsParser;
import io.prestosql.operator.aggregation.AggregationImplementation;
import io.prestosql.operator.aggregation.AggregationMetadata;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.ParametricAggregation;
import io.prestosql.operator.aggregation.state.NullableDoubleState;
import io.prestosql.operator.aggregation.state.NullableLongState;
import io.prestosql.operator.aggregation.state.SliceState;
import io.prestosql.operator.annotations.LiteralImplementationDependency;
import io.prestosql.operator.annotations.OperatorImplementationDependency;
import io.prestosql.operator.annotations.TypeImplementationDependency;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.Convention;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.function.TypeParameterSpecialization;
import io.prestosql.spi.function.TypeParameters;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.type.Constraint;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAnnotationEngineForAggregates
extends TestAnnotationEngine {
    private static final MetadataManager METADATA = MetadataManager.createTestMetadataManager();
    protected static final FunctionDependencies NO_FUNCTION_DEPENDENCIES = new FunctionDependencies((Metadata)METADATA, (Map)ImmutableMap.of(), (Collection)ImmutableSet.of());

    @Test
    public void testSimpleExactAggregationParse() {
        Signature expectedSignature = new Signature("simple_exact_aggregate", DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(ExactAggregationFunction.class);
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple exact aggregate description");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 1, 0, 0);
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(implementations.getExactImplementations().values());
        Assert.assertEquals((Object)implementation.getDefinitionClass(), ExactAggregationFunction.class);
        this.assertDependencyCount(implementation, 0, 0, 0);
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementation.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        FunctionBinding functionBinding = new FunctionBinding(aggregation.getFunctionMetadata().getFunctionId(), new BoundSignature(expectedSignature.getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE)), (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata(functionBinding);
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertTrue((boolean)aggregationMetadata.getIntermediateType().isPresent());
        InternalAggregationFunction specialized = aggregation.specialize(functionBinding, NO_FUNCTION_DEPENDENCIES);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertEquals((String)specialized.name(), (String)"simple_exact_aggregate");
    }

    @Test
    public void testStateOnDifferentThanFirstPositionAggregationParse() {
        Signature expectedSignature = new Signature("simple_exact_aggregate_aggregation_state_moved", DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(StateOnDifferentThanFirstPositionAggregationFunction.class);
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(aggregation.getImplementations().getExactImplementations().values());
        Assert.assertEquals((Object)implementation.getDefinitionClass(), StateOnDifferentThanFirstPositionAggregationFunction.class);
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, (Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE);
        Assert.assertTrue((boolean)implementation.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
    }

    @Test
    public void testNotAnnotatedAggregateStateAggregationParse() {
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(NotAnnotatedAggregateStateAggregationFunction.class);
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(aggregation.getImplementations().getExactImplementations().values());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementation.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        FunctionBinding functionBinding = new FunctionBinding(aggregation.getFunctionMetadata().getFunctionId(), new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE)), (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata(functionBinding);
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertTrue((boolean)aggregationMetadata.getIntermediateType().isPresent());
        InternalAggregationFunction specialized = aggregation.specialize(functionBinding, NO_FUNCTION_DEPENDENCIES);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertEquals((String)specialized.name(), (String)"no_aggregation_state_aggregate");
    }

    @Test
    public void testNotDecomposableAggregationParse() {
        Signature expectedSignature = new Signature("custom_decomposable_aggregate", DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(NotDecomposableAggregationFunction.class);
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Aggregate with Decomposable=false");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        FunctionBinding functionBinding = new FunctionBinding(aggregation.getFunctionMetadata().getFunctionId(), new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE)), (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata(functionBinding);
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertFalse((boolean)aggregationMetadata.getIntermediateType().isPresent());
        InternalAggregationFunction specialized = aggregation.specialize(functionBinding, NO_FUNCTION_DEPENDENCIES);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertEquals((String)specialized.name(), (String)"custom_decomposable_aggregate");
    }

    @Test
    public void testSimpleGenericAggregationFunctionParse() {
        Signature expectedSignature = new Signature("simple_generic_implementations", (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), new TypeSignature("T", new TypeSignatureParameter[0]), (List)ImmutableList.of((Object)new TypeSignature("T", new TypeSignatureParameter[0])), false);
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(GenericAggregationFunction.class);
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple aggregate with two generic implementations");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 0, 0, 2);
        AggregationImplementation implementationDouble = (AggregationImplementation)((ImmutableList)implementations.getGenericImplementations().stream().filter(impl -> impl.getStateClass() == NullableDoubleState.class).collect(ImmutableList.toImmutableList())).get(0);
        Assert.assertEquals((Object)implementationDouble.getDefinitionClass(), GenericAggregationFunction.class);
        this.assertDependencyCount(implementationDouble, 0, 0, 0);
        Assert.assertFalse((boolean)implementationDouble.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementationDouble.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        Assert.assertEquals((Object)implementationDouble.getStateClass(), NullableDoubleState.class);
        AggregationImplementation implementationLong = (AggregationImplementation)((ImmutableList)implementations.getGenericImplementations().stream().filter(impl -> impl.getStateClass() == NullableLongState.class).collect(ImmutableList.toImmutableList())).get(0);
        Assert.assertEquals((Object)implementationLong.getDefinitionClass(), GenericAggregationFunction.class);
        this.assertDependencyCount(implementationLong, 0, 0, 0);
        Assert.assertFalse((boolean)implementationLong.hasSpecializedTypeParameters());
        Assert.assertTrue((boolean)implementationLong.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        Assert.assertEquals((Object)implementationLong.getStateClass(), NullableLongState.class);
        FunctionBinding functionBinding = new FunctionBinding(aggregation.getFunctionMetadata().getFunctionId(), new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE)), (Map)ImmutableMap.of((Object)"T", (Object)DoubleType.DOUBLE), (Map)ImmutableMap.of());
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata(functionBinding);
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertTrue((boolean)aggregationMetadata.getIntermediateType().isPresent());
        InternalAggregationFunction specialized = aggregation.specialize(functionBinding, NO_FUNCTION_DEPENDENCIES);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertTrue((boolean)specialized.getParameterTypes().equals(ImmutableList.of((Object)DoubleType.DOUBLE)));
        Assert.assertEquals((String)specialized.name(), (String)"simple_generic_implementations");
    }

    @Test
    public void testSimpleBlockInputAggregationParse() {
        Signature expectedSignature = new Signature("block_input_aggregate", DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(BlockInputAggregationFunction.class);
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple aggregate with @BlockPosition usage");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 1, 0, 0);
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(implementations.getExactImplementations().values());
        Assert.assertEquals((Object)implementation.getDefinitionClass(), BlockInputAggregationFunction.class);
        this.assertDependencyCount(implementation, 0, 0, 0);
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, (Object)AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX);
        Assert.assertEquals((Collection)implementation.getInputParameterMetadataTypes(), (Collection)expectedMetadataTypes);
        FunctionBinding functionBinding = new FunctionBinding(aggregation.getFunctionMetadata().getFunctionId(), new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE)), (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata(functionBinding);
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertTrue((boolean)aggregationMetadata.getIntermediateType().isPresent());
        InternalAggregationFunction specialized = aggregation.specialize(functionBinding, NO_FUNCTION_DEPENDENCIES);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertEquals((String)specialized.name(), (String)"block_input_aggregate");
    }

    @Test(enabled=false)
    public void testSimpleImplicitSpecializedAggregationParse() {
        Signature expectedSignature = new Signature("implicit_specialized_aggregate", (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), new TypeSignature("T", new TypeSignatureParameter[0]), (List)ImmutableList.of((Object)new TypeSignature("array", new TypeSignatureParameter[]{TypeSignatureParameter.typeParameter((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))}), (Object)new TypeSignature("T", new TypeSignatureParameter[0])), false);
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(ImplicitSpecializedAggregationFunction.class);
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple implicit specialized aggregate");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 0, 0, 2);
        AggregationImplementation implementation1 = (AggregationImplementation)implementations.getSpecializedImplementations().get(0);
        Assert.assertTrue((boolean)implementation1.hasSpecializedTypeParameters());
        Assert.assertFalse((boolean)implementation1.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementation1.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        AggregationImplementation implementation2 = (AggregationImplementation)implementations.getSpecializedImplementations().get(1);
        Assert.assertTrue((boolean)implementation2.hasSpecializedTypeParameters());
        Assert.assertFalse((boolean)implementation2.hasSpecializedTypeParameters());
        Assert.assertTrue((boolean)implementation2.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        FunctionBinding functionBinding = new FunctionBinding(aggregation.getFunctionMetadata().getFunctionId(), new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)new ArrayType((Type)DoubleType.DOUBLE))), (Map)ImmutableMap.of((Object)"T", (Object)DoubleType.DOUBLE), (Map)ImmutableMap.of());
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata(functionBinding);
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertTrue((boolean)aggregationMetadata.getIntermediateType().isPresent());
        InternalAggregationFunction specialized = aggregation.specialize(functionBinding, NO_FUNCTION_DEPENDENCIES);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertEquals((String)specialized.name(), (String)"implicit_specialized_aggregate");
    }

    @Test(enabled=false)
    public void testSimpleExplicitSpecializedAggregationParse() {
        Signature expectedSignature = new Signature("explicit_specialized_aggregate", (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), new TypeSignature("T", new TypeSignatureParameter[0]), (List)ImmutableList.of((Object)new TypeSignature("array", new TypeSignatureParameter[]{TypeSignatureParameter.typeParameter((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))})), false);
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(ExplicitSpecializedAggregationFunction.class);
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple explicit specialized aggregate");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 0, 1, 1);
        AggregationImplementation implementation1 = (AggregationImplementation)implementations.getSpecializedImplementations().get(0);
        Assert.assertTrue((boolean)implementation1.hasSpecializedTypeParameters());
        Assert.assertFalse((boolean)implementation1.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementation1.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        AggregationImplementation implementation2 = (AggregationImplementation)implementations.getSpecializedImplementations().get(1);
        Assert.assertTrue((boolean)implementation2.hasSpecializedTypeParameters());
        Assert.assertFalse((boolean)implementation2.hasSpecializedTypeParameters());
        Assert.assertTrue((boolean)implementation2.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        FunctionBinding functionBinding = new FunctionBinding(aggregation.getFunctionMetadata().getFunctionId(), new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)new ArrayType((Type)DoubleType.DOUBLE))), (Map)ImmutableMap.of((Object)"T", (Object)DoubleType.DOUBLE), (Map)ImmutableMap.of());
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata(functionBinding);
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertTrue((boolean)aggregationMetadata.getIntermediateType().isPresent());
        InternalAggregationFunction specialized = aggregation.specialize(functionBinding, NO_FUNCTION_DEPENDENCIES);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertEquals((String)specialized.name(), (String)"implicit_specialized_aggregate");
    }

    @Test
    public void testMultiOutputAggregationParse() {
        Signature expectedSignature1 = new Signature("multi_output_aggregate_1", DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        Signature expectedSignature2 = new Signature("multi_output_aggregate_2", DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        List aggregations = AggregationFromAnnotationsParser.parseFunctionDefinitions(MultiOutputAggregationFunction.class);
        Assert.assertEquals((int)aggregations.size(), (int)2);
        ParametricAggregation aggregation1 = (ParametricAggregation)((ImmutableList)aggregations.stream().filter(aggregate -> aggregate.getFunctionMetadata().getSignature().getName().equals("multi_output_aggregate_1")).collect(ImmutableList.toImmutableList())).get(0);
        Assert.assertEquals((Object)aggregation1.getFunctionMetadata().getSignature(), (Object)expectedSignature1);
        Assert.assertEquals((String)aggregation1.getFunctionMetadata().getDescription(), (String)"Simple multi output function aggregate specialized description");
        ParametricAggregation aggregation2 = (ParametricAggregation)((ImmutableList)aggregations.stream().filter(aggregate -> aggregate.getFunctionMetadata().getSignature().getName().equals("multi_output_aggregate_2")).collect(ImmutableList.toImmutableList())).get(0);
        Assert.assertEquals((Object)aggregation2.getFunctionMetadata().getSignature(), (Object)expectedSignature2);
        Assert.assertEquals((String)aggregation2.getFunctionMetadata().getDescription(), (String)"Simple multi output function aggregate generic description");
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        ParametricImplementationsGroup implementations1 = aggregation1.getImplementations();
        this.assertImplementationCount(implementations1, 1, 0, 0);
        ParametricImplementationsGroup implementations2 = aggregation2.getImplementations();
        this.assertImplementationCount(implementations2, 1, 0, 0);
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(implementations1.getExactImplementations().values());
        Assert.assertEquals((Object)implementation.getDefinitionClass(), MultiOutputAggregationFunction.class);
        this.assertDependencyCount(implementation, 0, 0, 0);
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        Assert.assertTrue((boolean)implementation.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        FunctionBinding functionBinding = new FunctionBinding(aggregation1.getFunctionMetadata().getFunctionId(), new BoundSignature(aggregation1.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE)), (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
        AggregationFunctionMetadata aggregationMetadata = aggregation1.getAggregationMetadata(functionBinding);
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertTrue((boolean)aggregationMetadata.getIntermediateType().isPresent());
        InternalAggregationFunction specialized = aggregation1.specialize(functionBinding, NO_FUNCTION_DEPENDENCIES);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertEquals((String)specialized.name(), (String)"multi_output_aggregate_1");
    }

    @Test
    public void testInjectOperatorAggregateParse() {
        Signature expectedSignature = new Signature("inject_operator_aggregate", DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(InjectOperatorAggregateFunction.class);
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple aggregate with operator injected");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        AggregationImplementation implementation = (AggregationImplementation)Iterables.getOnlyElement(implementations.getExactImplementations().values());
        Assert.assertEquals((Object)implementation.getDefinitionClass(), InjectOperatorAggregateFunction.class);
        this.assertDependencyCount(implementation, 1, 1, 1);
        Assert.assertTrue((boolean)(implementation.getInputDependencies().get(0) instanceof OperatorImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getCombineDependencies().get(0) instanceof OperatorImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getOutputDependencies().get(0) instanceof OperatorImplementationDependency));
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementation.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        BoundSignature boundSignature = new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE));
        InternalAggregationFunction specialized = TestAnnotationEngineForAggregates.specializeAggregationFunction(boundSignature, (SqlAggregationFunction)aggregation);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertEquals((String)specialized.name(), (String)"inject_operator_aggregate");
    }

    @Test
    public void testInjectTypeAggregateParse() {
        Signature expectedSignature = new Signature("inject_type_aggregate", (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), new TypeSignature("T", new TypeSignatureParameter[0]), (List)ImmutableList.of((Object)new TypeSignature("T", new TypeSignatureParameter[0])), false);
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(InjectTypeAggregateFunction.class);
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple aggregate with type injected");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        Assert.assertEquals((int)implementations.getGenericImplementations().size(), (int)1);
        AggregationImplementation implementation = (AggregationImplementation)implementations.getGenericImplementations().get(0);
        Assert.assertEquals((Object)implementation.getDefinitionClass(), InjectTypeAggregateFunction.class);
        this.assertDependencyCount(implementation, 1, 1, 1);
        Assert.assertTrue((boolean)(implementation.getInputDependencies().get(0) instanceof TypeImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getCombineDependencies().get(0) instanceof TypeImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getOutputDependencies().get(0) instanceof TypeImplementationDependency));
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementation.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        BoundSignature boundSignature = new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE));
        InternalAggregationFunction specialized = TestAnnotationEngineForAggregates.specializeAggregationFunction(boundSignature, (SqlAggregationFunction)aggregation);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertEquals((String)specialized.name(), (String)"inject_type_aggregate");
    }

    @Test
    public void testInjectLiteralAggregateParse() {
        Signature expectedSignature = new Signature("inject_literal_aggregate", new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")}), (List)ImmutableList.of((Object)new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})));
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(InjectLiteralAggregateFunction.class);
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple aggregate with type literal");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        Assert.assertEquals((int)implementations.getGenericImplementations().size(), (int)1);
        AggregationImplementation implementation = (AggregationImplementation)implementations.getGenericImplementations().get(0);
        Assert.assertEquals((Object)implementation.getDefinitionClass(), InjectLiteralAggregateFunction.class);
        this.assertDependencyCount(implementation, 1, 1, 1);
        Assert.assertTrue((boolean)(implementation.getInputDependencies().get(0) instanceof LiteralImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getCombineDependencies().get(0) instanceof LiteralImplementationDependency));
        Assert.assertTrue((boolean)(implementation.getOutputDependencies().get(0) instanceof LiteralImplementationDependency));
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementation.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        FunctionBinding functionBinding = new FunctionBinding(aggregation.getFunctionMetadata().getFunctionId(), new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)VarcharType.createVarcharType((int)17), (List)ImmutableList.of((Object)VarcharType.createVarcharType((int)17))), (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)17L));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata(functionBinding);
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertTrue((boolean)aggregationMetadata.getIntermediateType().isPresent());
        InternalAggregationFunction specialized = aggregation.specialize(functionBinding, NO_FUNCTION_DEPENDENCIES);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)VarcharType.createVarcharType((int)17));
        Assert.assertEquals((String)specialized.name(), (String)"inject_literal_aggregate");
    }

    @Test
    public void testLongConstraintAggregateFunctionParse() {
        Signature expectedSignature = new Signature("parametric_aggregate_long_constraint", (List)ImmutableList.of(), (List)ImmutableList.of((Object)new LongVariableConstraint("z", "x + y")), new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"z")}), (List)ImmutableList.of((Object)new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")}), (Object)new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"y")})), false);
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(LongConstraintAggregateFunction.class);
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Parametric aggregate with parametric type returned");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        Assert.assertEquals((int)implementations.getGenericImplementations().size(), (int)1);
        AggregationImplementation implementation = (AggregationImplementation)implementations.getGenericImplementations().get(0);
        Assert.assertEquals((Object)implementation.getDefinitionClass(), LongConstraintAggregateFunction.class);
        this.assertDependencyCount(implementation, 0, 0, 0);
        Assert.assertFalse((boolean)implementation.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementation.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        FunctionBinding functionBinding = new FunctionBinding(aggregation.getFunctionMetadata().getFunctionId(), new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)VarcharType.createVarcharType((int)30), (List)ImmutableList.of((Object)VarcharType.createVarcharType((int)17), (Object)VarcharType.createVarcharType((int)13))), (Map)ImmutableMap.of(), (Map)ImmutableMap.builder().put((Object)"x", (Object)17L).put((Object)"y", (Object)13L).put((Object)"z", (Object)30L).build());
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata(functionBinding);
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertTrue((boolean)aggregationMetadata.getIntermediateType().isPresent());
        InternalAggregationFunction specialized = aggregation.specialize(functionBinding, NO_FUNCTION_DEPENDENCIES);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)VarcharType.createVarcharType((int)30));
        Assert.assertEquals((String)specialized.name(), (String)"parametric_aggregate_long_constraint");
    }

    @Test
    public void testFixedTypeParameterInjectionAggregateFunctionParse() {
        Signature expectedSignature = new Signature("fixed_type_parameter_injection", (List)ImmutableList.of(), (List)ImmutableList.of(), DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()), false);
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(FixedTypeParameterInjectionAggregateFunction.class);
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple aggregate with fixed parameter type injected");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 1, 0, 0);
        AggregationImplementation implementationDouble = (AggregationImplementation)implementations.getExactImplementations().get(expectedSignature);
        Assert.assertEquals((Object)implementationDouble.getDefinitionClass(), FixedTypeParameterInjectionAggregateFunction.class);
        this.assertDependencyCount(implementationDouble, 1, 1, 1);
        Assert.assertFalse((boolean)implementationDouble.hasSpecializedTypeParameters());
        ImmutableList expectedMetadataTypes = ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL);
        Assert.assertTrue((boolean)implementationDouble.getInputParameterMetadataTypes().equals(expectedMetadataTypes));
        Assert.assertEquals((Object)implementationDouble.getStateClass(), NullableDoubleState.class);
    }

    @Test
    public void testPartiallyFixedTypeParameterInjectionAggregateFunctionParse() {
        Signature expectedSignature = new Signature("partially_fixed_type_parameter_injection", (List)ImmutableList.of((Object)Signature.typeVariable((String)"T1"), (Object)Signature.typeVariable((String)"T2")), (List)ImmutableList.of(), DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)new TypeSignature("T1", new TypeSignatureParameter[0]), (Object)new TypeSignature("T2", new TypeSignatureParameter[0])), false);
        ParametricAggregation aggregation = AggregationFromAnnotationsParser.parseFunctionDefinition(PartiallyFixedTypeParameterInjectionAggregateFunction.class);
        Assert.assertEquals((String)aggregation.getFunctionMetadata().getDescription(), (String)"Simple aggregate with fixed parameter type injected");
        Assert.assertTrue((boolean)aggregation.getFunctionMetadata().isDeterministic());
        Assert.assertEquals((Object)aggregation.getFunctionMetadata().getSignature(), (Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        this.assertImplementationCount(implementations, 0, 0, 1);
        AggregationImplementation implementationDouble = (AggregationImplementation)((ImmutableList)implementations.getGenericImplementations().stream().filter(impl -> impl.getStateClass() == NullableDoubleState.class).collect(ImmutableList.toImmutableList())).get(0);
        Assert.assertEquals((Object)implementationDouble.getDefinitionClass(), PartiallyFixedTypeParameterInjectionAggregateFunction.class);
        this.assertDependencyCount(implementationDouble, 1, 1, 1);
        Assert.assertFalse((boolean)implementationDouble.hasSpecializedTypeParameters());
        Assert.assertEquals((Collection)implementationDouble.getInputParameterMetadataTypes(), (Collection)ImmutableList.of((Object)AggregationMetadata.ParameterMetadata.ParameterType.STATE, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, (Object)AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL));
        Assert.assertEquals((Object)implementationDouble.getStateClass(), NullableDoubleState.class);
        BoundSignature boundSignature = new BoundSignature(aggregation.getFunctionMetadata().getSignature().getName(), (Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
        InternalAggregationFunction specialized = TestAnnotationEngineForAggregates.specializeAggregationFunction(boundSignature, (SqlAggregationFunction)aggregation);
        Assert.assertEquals((Object)specialized.getFinalType(), (Object)DoubleType.DOUBLE);
        Assert.assertEquals((Collection)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE), (Collection)specialized.getParameterTypes());
        Assert.assertEquals((String)specialized.name(), (String)"partially_fixed_type_parameter_injection");
    }

    private static InternalAggregationFunction specializeAggregationFunction(BoundSignature boundSignature, SqlAggregationFunction aggregation) {
        FunctionMetadata functionMetadata = aggregation.getFunctionMetadata();
        FunctionBinding functionBinding = MetadataManager.toFunctionBinding((FunctionId)functionMetadata.getFunctionId(), (BoundSignature)boundSignature, (Signature)functionMetadata.getSignature());
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata(functionBinding);
        Assert.assertFalse((boolean)aggregationMetadata.isOrderSensitive());
        Assert.assertTrue((boolean)aggregationMetadata.getIntermediateType().isPresent());
        ResolvedFunction resolvedFunction = METADATA.resolve(functionBinding, aggregation.getFunctionDependencies(functionBinding));
        FunctionDependencies functionDependencies = new FunctionDependencies((Metadata)METADATA, resolvedFunction.getTypeDependencies(), (Collection)resolvedFunction.getFunctionDependencies());
        return aggregation.specialize(functionBinding, functionDependencies);
    }

    @AggregationFunction(value="partially_fixed_type_parameter_injection")
    @Description(value="Simple aggregate with fixed parameter type injected")
    public static final class PartiallyFixedTypeParameterInjectionAggregateFunction {
        @InputFunction
        @TypeParameters(value={@TypeParameter(value="T1"), @TypeParameter(value="T2")})
        public static void input(@TypeParameter(value="ROW(ARRAY(T1),ROW(ROW(T2)),CHAR)") Type type, @AggregationState NullableDoubleState state, @SqlType(value="T1") double x, @SqlType(value="T2") double y) {
        }

        @CombineFunction
        @TypeParameters(value={@TypeParameter(value="T1"), @TypeParameter(value="T2")})
        public static void combine(@TypeParameter(value="ROW(ARRAY(T1),ROW(ROW(T2)),CHAR)") Type type, @AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="double")
        @TypeParameters(value={@TypeParameter(value="T1"), @TypeParameter(value="T2")})
        public static void output(@TypeParameter(value="ROW(ARRAY(T1),ROW(ROW(T2)),CHAR)") Type type, @AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="fixed_type_parameter_injection")
    @Description(value="Simple aggregate with fixed parameter type injected")
    public static final class FixedTypeParameterInjectionAggregateFunction {
        @InputFunction
        public static void input(@TypeParameter(value="ROW(ARRAY(BIGINT),ROW(ROW(CHAR)),BIGINT,MAP(BIGINT,CHAR))") Type type, @AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@TypeParameter(value="ROW(ARRAY(BIGINT),ROW(ROW(CHAR)),BIGINT,MAP(BIGINT,CHAR))") Type type, @AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="double")
        public static void output(@TypeParameter(value="ROW(ARRAY(BIGINT),ROW(ROW(CHAR)),BIGINT,MAP(BIGINT,CHAR))") Type type, @AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="parametric_aggregate_long_constraint")
    @Description(value="Parametric aggregate with parametric type returned")
    public static final class LongConstraintAggregateFunction {
        @InputFunction
        @LiteralParameters(value={"x", "y", "z"})
        @Constraint(variable="z", expression="x + y")
        public static void input(@AggregationState SliceState state, @SqlType(value="varchar(x)") Slice slice1, @SqlType(value="varchar(y)") Slice slice2) {
        }

        @CombineFunction
        public static void combine(@AggregationState SliceState combine1, @AggregationState SliceState combine2) {
        }

        @OutputFunction(value="varchar(z)")
        public static void output(@AggregationState SliceState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="inject_literal_aggregate")
    @Description(value="Simple aggregate with type literal")
    public static final class InjectLiteralAggregateFunction {
        @InputFunction
        @LiteralParameters(value={"x"})
        public static void input(@LiteralParameter(value="x") Long varcharSize, @AggregationState SliceState state, @SqlType(value="varchar(x)") Slice slice) {
        }

        @CombineFunction
        public static void combine(@LiteralParameter(value="x") Long varcharSize, @AggregationState SliceState combine1, @AggregationState SliceState combine2) {
        }

        @OutputFunction(value="varchar(x)")
        public static void output(@LiteralParameter(value="x") Long varcharSize, @AggregationState SliceState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="inject_type_aggregate")
    @Description(value="Simple aggregate with type injected")
    public static final class InjectTypeAggregateFunction {
        @InputFunction
        @TypeParameter(value="T")
        public static void input(@TypeParameter(value="T") Type type, @AggregationState NullableDoubleState state, @SqlType(value="T") double value) {
        }

        @CombineFunction
        public static void combine(@TypeParameter(value="T") Type type, @AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="T")
        public static void output(@TypeParameter(value="T") Type type, @AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="inject_operator_aggregate")
    @Description(value="Simple aggregate with operator injected")
    public static final class InjectOperatorAggregateFunction {
        @InputFunction
        public static void input(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"double", "double"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle methodHandle, @AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"double", "double"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle methodHandle, @AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"double", "double"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle methodHandle, @AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="multi_output_aggregate")
    @Description(value="Simple multi output function aggregate generic description")
    public static final class MultiOutputAggregationFunction {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @AggregationFunction(value="multi_output_aggregate_1")
        @Description(value="Simple multi output function aggregate specialized description")
        @OutputFunction(value="double")
        public static void output1(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }

        @AggregationFunction(value="multi_output_aggregate_2")
        @OutputFunction(value="double")
        public static void output2(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="explicit_specialized_aggregate")
    @Description(value="Simple explicit specialized aggregate")
    public static final class ExplicitSpecializedAggregationFunction {
        @InputFunction
        @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="array(T)") Block arrayBlock) {
        }

        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableLongState state, @SqlType(value="array(T)") Block arrayBlock) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="implicit_specialized_aggregate")
    @Description(value="Simple implicit specialized aggregate")
    public static final class ImplicitSpecializedAggregationFunction {
        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") double additionalValue) {
        }

        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableLongState state, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") long additionalValue) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="block_input_aggregate")
    @Description(value="Simple aggregate with @BlockPosition usage")
    public static final class BlockInputAggregationFunction {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @BlockPosition @SqlType(value="double") Block value, @BlockIndex int id) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="simple_generic_implementations")
    @Description(value="Simple aggregate with two generic implementations")
    public static final class GenericAggregationFunction {
        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="T") double value) {
        }

        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableLongState state, @SqlType(value="T") long value) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="custom_decomposable_aggregate", decomposable=false)
    @Description(value="Aggregate with Decomposable=false")
    public static final class NotDecomposableAggregationFunction {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="no_aggregation_state_aggregate")
    @Description(value="Aggregate with no @AggregationState annotations")
    public static final class NotAnnotatedAggregateStateAggregationFunction {
        @InputFunction
        public static void input(NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(NullableDoubleState combine1, NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="simple_exact_aggregate_aggregation_state_moved")
    @Description(value="Simple exact function which has @AggregationState on different than first positions")
    public static final class StateOnDifferentThanFirstPositionAggregationFunction {
        @InputFunction
        public static void input(@SqlType(value="double") double value, @AggregationState NullableDoubleState state) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(BlockBuilder out, @AggregationState NullableDoubleState state) {
        }
    }

    @AggregationFunction(value="simple_exact_aggregate")
    @Description(value="Simple exact aggregate description")
    public static final class ExactAggregationFunction {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }
}

