/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.prestosql.SequencePageBuilder;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.PageAssertions;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.spi.Page;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.gen.ExpressionCompiler;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.testing.TestingConnectorSession;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestColumnarPageProcessor {
    private static final int POSITIONS = 100;
    private final List<Type> types = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR);
    private final Metadata metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testProcess() {
        PageProcessor processor = this.newPageProcessor();
        Page page = TestColumnarPageProcessor.createPage(this.types, false);
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        PageAssertions.assertPageEquals(this.types, outputPage, page);
    }

    @Test
    public void testProcessWithDictionary() {
        PageProcessor processor = this.newPageProcessor();
        Page page = TestColumnarPageProcessor.createPage(this.types, true);
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        PageAssertions.assertPageEquals(this.types, outputPage, page);
    }

    private static Page createPage(List<? extends Type> types, boolean dictionary) {
        return dictionary ? SequencePageBuilder.createSequencePageWithDictionaryBlocks(types, 100) : SequencePageBuilder.createSequencePage(types, 100);
    }

    private PageProcessor newPageProcessor() {
        return (PageProcessor)new ExpressionCompiler(this.metadata, new PageFunctionCompiler(this.metadata, 0)).compilePageProcessor(Optional.empty(), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)this.types.get(0)), (Object)Expressions.field((int)1, (Type)this.types.get(1))), 8192).get();
    }
}

