/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import io.prestosql.operator.CyclingGroupByHash;
import io.prestosql.operator.GroupByHash;
import io.prestosql.operator.GroupByIdBlock;
import io.prestosql.operator.Work;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCyclingGroupByHash {
    @Test
    public void testSingleGroup() {
        CyclingGroupByHash groupByHash = new CyclingGroupByHash(1);
        Page page = TestCyclingGroupByHash.createPage(1);
        GroupByIdBlock groupByIdBlock = TestCyclingGroupByHash.computeGroupByIdBlock(groupByHash, page);
        TestCyclingGroupByHash.assertGrouping(groupByIdBlock, 0L);
        Assert.assertEquals((long)groupByIdBlock.getGroupCount(), (long)1L);
        page = TestCyclingGroupByHash.createPage(2);
        groupByIdBlock = TestCyclingGroupByHash.computeGroupByIdBlock(groupByHash, page);
        TestCyclingGroupByHash.assertGrouping(groupByIdBlock, 0L, 0L);
        Assert.assertEquals((long)groupByIdBlock.getGroupCount(), (long)1L);
    }

    @Test
    public void testMultipleGroup() {
        CyclingGroupByHash groupByHash = new CyclingGroupByHash(2);
        Page page = TestCyclingGroupByHash.createPage(3);
        GroupByIdBlock groupByIdBlock = TestCyclingGroupByHash.computeGroupByIdBlock(groupByHash, page);
        TestCyclingGroupByHash.assertGrouping(groupByIdBlock, 0L, 1L, 0L);
        Assert.assertEquals((long)groupByIdBlock.getGroupCount(), (long)2L);
        page = TestCyclingGroupByHash.createPage(2);
        groupByIdBlock = TestCyclingGroupByHash.computeGroupByIdBlock(groupByHash, page);
        TestCyclingGroupByHash.assertGrouping(groupByIdBlock, 1L, 0L);
        Assert.assertEquals((long)groupByIdBlock.getGroupCount(), (long)2L);
    }

    @Test
    public void testPartialGroup() {
        CyclingGroupByHash groupByHash = new CyclingGroupByHash(3);
        Page page = TestCyclingGroupByHash.createPage(2);
        GroupByIdBlock groupByIdBlock = TestCyclingGroupByHash.computeGroupByIdBlock(groupByHash, page);
        TestCyclingGroupByHash.assertGrouping(groupByIdBlock, 0L, 1L);
        Assert.assertEquals((long)groupByIdBlock.getGroupCount(), (long)2L);
    }

    private static void assertGrouping(GroupByIdBlock groupByIdBlock, long ... groupIds) {
        Assert.assertEquals((int)groupByIdBlock.getPositionCount(), (int)groupIds.length);
        for (int i = 0; i < groupByIdBlock.getPositionCount(); ++i) {
            Assert.assertEquals((long)groupByIdBlock.getGroupId(i), (long)groupIds[i]);
        }
    }

    private static GroupByIdBlock computeGroupByIdBlock(GroupByHash groupByHash, Page page) {
        Work groupIds = groupByHash.getGroupIds(page);
        while (!groupIds.process()) {
        }
        return (GroupByIdBlock)groupIds.getResult();
    }

    private static Page createPage(int positionCount) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, positionCount);
        for (int i = 0; i < positionCount; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        Block block = blockBuilder.build();
        return new Page(new Block[]{block});
    }
}

