/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import io.airlift.testing.Assertions;
import io.prestosql.RowPagesBuilder;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.operator.DistinctLimitOperator;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.GroupByHashYieldAssertion;
import io.prestosql.operator.OperatorAssertion;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.spi.Page;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.TestingTaskContext;
import io.prestosql.type.BlockTypeOperators;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDistinctLimitOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;
    private JoinCompiler joinCompiler;
    private BlockTypeOperators blockTypeOperators;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
        TypeOperators typeOperators = new TypeOperators();
        this.blockTypeOperators = new BlockTypeOperators(typeOperators);
        this.joinCompiler = new JoinCompiler(typeOperators);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @DataProvider
    public Object[][] dataType() {
        return new Object[][]{{VarcharType.VARCHAR}, {BigintType.BIGINT}};
    }

    @DataProvider(name="hashEnabledValues")
    public static Object[][] hashEnabledValuesProvider() {
        return new Object[][]{{true}, {false}};
    }

    @Test(dataProvider="hashEnabledValues")
    public void testDistinctLimit(boolean hashEnabled) {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(3, 1).addSequencePage(5, 2).build();
        DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(0, new PlanNodeId("test"), rowPagesBuilder.getTypes(), Ints.asList((int[])new int[]{0}), 5L, rowPagesBuilder.getHashChannel(), this.joinCompiler, this.blockTypeOperators);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).row(new Object[]{2L}).row(new Object[]{3L}).row(new Object[]{4L}).row(new Object[]{5L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)1));
    }

    @Test(dataProvider="hashEnabledValues")
    public void testDistinctLimitWithPageAlignment(boolean hashEnabled) {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(3, 1).addSequencePage(3, 2).build();
        DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(0, new PlanNodeId("test"), rowPagesBuilder.getTypes(), Ints.asList((int[])new int[]{0}), 3L, rowPagesBuilder.getHashChannel(), this.joinCompiler, this.blockTypeOperators);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).row(new Object[]{2L}).row(new Object[]{3L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)1));
    }

    @Test(dataProvider="hashEnabledValues")
    public void testDistinctLimitValuesLessThanLimit(boolean hashEnabled) {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(3, 1).addSequencePage(3, 2).build();
        DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(0, new PlanNodeId("test"), rowPagesBuilder.getTypes(), Ints.asList((int[])new int[]{0}), 5L, rowPagesBuilder.getHashChannel(), this.joinCompiler, this.blockTypeOperators);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).row(new Object[]{2L}).row(new Object[]{3L}).row(new Object[]{4L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)1));
    }

    @Test(dataProvider="dataType")
    public void testMemoryReservationYield(Type type) {
        List<Page> input = GroupByHashYieldAssertion.createPagesWithDistinctHashKeys(type, 6000, 600);
        DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)type, (Object)BigintType.BIGINT), (List)ImmutableList.of((Object)0), Integer.MAX_VALUE, Optional.of(1), this.joinCompiler, this.blockTypeOperators);
        GroupByHashYieldAssertion.GroupByHashYieldResult result = GroupByHashYieldAssertion.finishOperatorWithYieldingGroupByHash(input, type, (OperatorFactory)operatorFactory, operator -> ((DistinctLimitOperator)operator).getCapacity(), 1400000L);
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(result.getYieldCount()), (Comparable)Integer.valueOf(5));
        Assertions.assertGreaterThan((Comparable)Long.valueOf(result.getMaxReservedBytes()), (Comparable)Long.valueOf(0x1400000L));
        Assert.assertEquals((int)result.getOutput().stream().mapToInt(Page::getPositionCount).sum(), (int)3600000);
    }
}

