/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.operator.ExchangeClientConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestExchangeClientConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ExchangeClientConfig)ConfigAssertions.recordDefaults(ExchangeClientConfig.class)).setMaxBufferSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setConcurrentRequestMultiplier(3).setMinErrorDuration(new Duration(5.0, TimeUnit.MINUTES)).setMaxErrorDuration(new Duration(5.0, TimeUnit.MINUTES)).setMaxResponseSize(new HttpClientConfig().getMaxContentLength()).setPageBufferClientMaxCallbackThreads(25).setClientThreads(25).setAcknowledgePages(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"exchange.max-buffer-size", (Object)"1GB").put((Object)"exchange.concurrent-request-multiplier", (Object)"13").put((Object)"exchange.min-error-duration", (Object)"13s").put((Object)"exchange.max-error-duration", (Object)"33s").put((Object)"exchange.max-response-size", (Object)"1MB").put((Object)"exchange.client-threads", (Object)"2").put((Object)"exchange.page-buffer-client.max-callback-threads", (Object)"16").put((Object)"exchange.acknowledge-pages", (Object)"false").build();
        ExchangeClientConfig expected = new ExchangeClientConfig().setMaxBufferSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setConcurrentRequestMultiplier(13).setMinErrorDuration(new Duration(33.0, TimeUnit.SECONDS)).setMaxErrorDuration(new Duration(33.0, TimeUnit.SECONDS)).setMaxResponseSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setClientThreads(2).setPageBufferClientMaxCallbackThreads(16).setAcknowledgePages(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

