/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.prestosql.RowPagesBuilder;
import io.prestosql.operator.GroupByHash;
import io.prestosql.operator.GroupedTopNBuilder;
import io.prestosql.operator.NoChannelGroupByHash;
import io.prestosql.operator.PageAssertions;
import io.prestosql.operator.PageWithPositionComparator;
import io.prestosql.operator.SimplePageWithPositionComparator;
import io.prestosql.operator.UpdateMemory;
import io.prestosql.operator.Work;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.SortOrder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.type.BlockTypeOperators;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestGroupedTopNBuilder {
    private static final TypeOperators TYPE_OPERATORS_CACHE = new TypeOperators();

    @DataProvider
    public static Object[][] produceRowNumbers() {
        return new Object[][]{{true}, {false}};
    }

    @DataProvider
    public static Object[][] pageRowCounts() {
        return new Object[][]{{10000, 20}, {20, 10000}};
    }

    @Test
    public void testEmptyInput() {
        GroupedTopNBuilder groupedTopNBuilder = new GroupedTopNBuilder((List)ImmutableList.of((Object)BigintType.BIGINT), (left, leftPosition, right, rightPosition) -> {
            throw new UnsupportedOperationException();
        }, 5, false, (GroupByHash)new NoChannelGroupByHash());
        Assert.assertFalse((boolean)groupedTopNBuilder.buildResult().hasNext());
    }

    @Test(dataProvider="produceRowNumbers")
    public void testMultiGroupTopN(boolean produceRowNumbers) {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
        List<Page> input = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.3).row(2L, 0.2).row(3L, 0.9).row(3L, 0.1).pageBreak().row(1L, 0.4).pageBreak().row(1L, 0.5).row(1L, 0.6).row(4L, 0.6).row(2L, 0.8).row(2L, 0.7).pageBreak().row(2L, 0.9).build();
        for (Page page : input) {
            page.compact();
        }
        GroupByHash groupByHash = TestGroupedTopNBuilder.createGroupByHash((List<Type>)ImmutableList.of((Object)((Type)types.get(0))), (List<Integer>)ImmutableList.of((Object)0), UpdateMemory.NOOP);
        GroupedTopNBuilder groupedTopNBuilder = new GroupedTopNBuilder((List)types, (PageWithPositionComparator)new SimplePageWithPositionComparator((List)types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), TYPE_OPERATORS_CACHE), 2, produceRowNumbers, groupByHash);
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(0)).process());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(1)).process());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(2)).process());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(3)).process());
        ImmutableList output = ImmutableList.copyOf((Iterator)groupedTopNBuilder.buildResult());
        Assert.assertEquals((int)output.size(), (int)1);
        Page expected = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE, BigintType.BIGINT}).row(1L, 0.3, 1).row(1L, 0.4, 2).row(2L, 0.2, 1).row(2L, 0.7, 2).row(3L, 0.1, 1).row(3L, 0.9, 2).row(4L, 0.6, 1).build().get(0);
        if (produceRowNumbers) {
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), (Page)output.get(0), expected);
        } else {
            PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)output.get(0), new Page(new Block[]{expected.getBlock(0), expected.getBlock(1)}));
        }
    }

    @Test(dataProvider="produceRowNumbers")
    public void testSingleGroupTopN(boolean produceRowNumbers) {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
        List<Page> input = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.3).row(2L, 0.2).row(3L, 0.9).row(3L, 0.1).pageBreak().row(1L, 0.4).pageBreak().row(1L, 0.5).row(1L, 0.6).row(4L, 0.6).row(2L, 0.8).row(2L, 0.7).pageBreak().row(2L, 0.9).build();
        for (Page page : input) {
            page.compact();
        }
        GroupedTopNBuilder groupedTopNBuilder = new GroupedTopNBuilder((List)types, (PageWithPositionComparator)new SimplePageWithPositionComparator((List)types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), TYPE_OPERATORS_CACHE), 5, produceRowNumbers, (GroupByHash)new NoChannelGroupByHash());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(0)).process());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(1)).process());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(2)).process());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(3)).process());
        ImmutableList output = ImmutableList.copyOf((Iterator)groupedTopNBuilder.buildResult());
        Assert.assertEquals((int)output.size(), (int)1);
        Page expected = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE, BigintType.BIGINT}).row(3L, 0.1, 1).row(2L, 0.2, 2).row(1L, 0.3, 3).row(1L, 0.4, 4).row(1L, 0.5, 5).build().get(0);
        if (produceRowNumbers) {
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), (Page)output.get(0), expected);
        } else {
            PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)output.get(0), new Page(new Block[]{expected.getBlock(0), expected.getBlock(1)}));
        }
    }

    @Test
    public void testYield() {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
        Page input = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.3).row(1L, 0.2).row(1L, 0.9).row(1L, 0.1).build().get(0);
        input.compact();
        AtomicBoolean unblock = new AtomicBoolean();
        GroupByHash groupByHash = TestGroupedTopNBuilder.createGroupByHash((List<Type>)ImmutableList.of((Object)((Type)types.get(0))), (List<Integer>)ImmutableList.of((Object)0), unblock::get);
        GroupedTopNBuilder groupedTopNBuilder = new GroupedTopNBuilder((List)types, (PageWithPositionComparator)new SimplePageWithPositionComparator((List)types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), TYPE_OPERATORS_CACHE), 5, false, groupByHash);
        Work work = groupedTopNBuilder.processPage(input);
        Assert.assertFalse((boolean)work.process());
        Assert.assertFalse((boolean)work.process());
        unblock.set(true);
        Assert.assertTrue((boolean)work.process());
        ImmutableList output = ImmutableList.copyOf((Iterator)groupedTopNBuilder.buildResult());
        Assert.assertEquals((int)output.size(), (int)1);
        Page expected = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.1).row(1L, 0.2).row(1L, 0.3).row(1L, 0.9).build().get(0);
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)output.get(0), expected);
    }

    private static GroupByHash createGroupByHash(List<Type> partitionTypes, List<Integer> partitionChannels, UpdateMemory updateMemory) {
        TypeOperators typeOperators = new TypeOperators();
        return GroupByHash.createGroupByHash(partitionTypes, (int[])Ints.toArray(partitionChannels), Optional.empty(), (int)1, (boolean)false, (JoinCompiler)new JoinCompiler(typeOperators), (BlockTypeOperators)new BlockTypeOperators(typeOperators), (UpdateMemory)updateMemory);
    }
}

