/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.block.BlockAssertions;
import io.prestosql.execution.Lifespan;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.JoinBridgeManager;
import io.prestosql.operator.NestedLoopBuildOperator;
import io.prestosql.operator.NestedLoopJoinBridge;
import io.prestosql.operator.NestedLoopJoinPages;
import io.prestosql.operator.NestedLoopJoinPagesSupplier;
import io.prestosql.operator.PipelineExecutionStrategy;
import io.prestosql.operator.TaskContext;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.BigintType;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.TestingTaskContext;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestNestedLoopBuildOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testNestedLoopBuild() throws Exception {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        JoinBridgeManager nestedLoopJoinBridgeManager = new JoinBridgeManager(false, PipelineExecutionStrategy.UNGROUPED_EXECUTION, PipelineExecutionStrategy.UNGROUPED_EXECUTION, lifespan -> new NestedLoopJoinPagesSupplier(), (List)buildTypes);
        NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(3, new PlanNodeId("test"), nestedLoopJoinBridgeManager);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        NestedLoopBuildOperator nestedLoopBuildOperator = (NestedLoopBuildOperator)nestedLoopBuildOperatorFactory.createOperator(driverContext);
        NestedLoopJoinBridge nestedLoopJoinBridge = (NestedLoopJoinBridge)nestedLoopJoinBridgeManager.getJoinBridge(Lifespan.taskWide());
        Assert.assertFalse((boolean)nestedLoopJoinBridge.getPagesFuture().isDone());
        Page buildPage1 = new Page(3, new Block[]{BlockAssertions.createLongSequenceBlock(11, 14)});
        Page buildPageEmpty = new Page(0);
        Page buildPage2 = new Page(3000, new Block[]{BlockAssertions.createLongSequenceBlock(4000, 7000)});
        nestedLoopBuildOperator.addInput(buildPage1);
        nestedLoopBuildOperator.addInput(buildPageEmpty);
        nestedLoopBuildOperator.addInput(buildPage2);
        nestedLoopBuildOperator.finish();
        Assert.assertTrue((boolean)nestedLoopJoinBridge.getPagesFuture().isDone());
        List buildPages = ((NestedLoopJoinPages)nestedLoopJoinBridge.getPagesFuture().get()).getPages();
        Assert.assertEquals(buildPages.get(0), (Object)buildPage1);
        Assert.assertEquals(buildPages.get(1), (Object)buildPage2);
        Assert.assertEquals((int)buildPages.size(), (int)2);
    }

    @Test
    public void testNestedLoopBuildNoBlock() throws Exception {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of();
        JoinBridgeManager nestedLoopJoinBridgeManager = new JoinBridgeManager(false, PipelineExecutionStrategy.UNGROUPED_EXECUTION, PipelineExecutionStrategy.UNGROUPED_EXECUTION, lifespan -> new NestedLoopJoinPagesSupplier(), (List)buildTypes);
        NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(3, new PlanNodeId("test"), nestedLoopJoinBridgeManager);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        NestedLoopBuildOperator nestedLoopBuildOperator = (NestedLoopBuildOperator)nestedLoopBuildOperatorFactory.createOperator(driverContext);
        NestedLoopJoinBridge nestedLoopJoinBridge = (NestedLoopJoinBridge)nestedLoopJoinBridgeManager.getJoinBridge(Lifespan.taskWide());
        Assert.assertFalse((boolean)nestedLoopJoinBridge.getPagesFuture().isDone());
        Page buildPage1 = new Page(3);
        Page buildPageEmpty = new Page(0);
        Page buildPage2 = new Page(3000);
        nestedLoopBuildOperator.addInput(buildPage1);
        nestedLoopBuildOperator.addInput(buildPageEmpty);
        nestedLoopBuildOperator.addInput(buildPage2);
        nestedLoopBuildOperator.finish();
        Assert.assertTrue((boolean)nestedLoopJoinBridge.getPagesFuture().isDone());
        List buildPages = ((NestedLoopJoinPages)nestedLoopJoinBridge.getPagesFuture().get()).getPages();
        Assert.assertEquals((int)buildPages.size(), (int)1);
        Assert.assertEquals((int)((Page)buildPages.get(0)).getPositionCount(), (int)3003);
    }

    @Test
    public void testNestedLoopNoBlocksMaxSizeLimit() throws Exception {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of();
        JoinBridgeManager nestedLoopJoinBridgeManager = new JoinBridgeManager(false, PipelineExecutionStrategy.UNGROUPED_EXECUTION, PipelineExecutionStrategy.UNGROUPED_EXECUTION, lifespan -> new NestedLoopJoinPagesSupplier(), (List)buildTypes);
        NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(3, new PlanNodeId("test"), nestedLoopJoinBridgeManager);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        NestedLoopBuildOperator nestedLoopBuildOperator = (NestedLoopBuildOperator)nestedLoopBuildOperatorFactory.createOperator(driverContext);
        NestedLoopJoinBridge nestedLoopJoinBridge = (NestedLoopJoinBridge)nestedLoopJoinBridgeManager.getJoinBridge(Lifespan.taskWide());
        Assert.assertFalse((boolean)nestedLoopJoinBridge.getPagesFuture().isDone());
        Page massivePage = new Page(8292);
        nestedLoopBuildOperator.addInput(massivePage);
        nestedLoopBuildOperator.finish();
        Assert.assertTrue((boolean)nestedLoopJoinBridge.getPagesFuture().isDone());
        List buildPages = ((NestedLoopJoinPages)nestedLoopJoinBridge.getPagesFuture().get()).getPages();
        Assert.assertEquals((int)buildPages.size(), (int)2);
        Assert.assertEquals((int)((Page)buildPages.get(0)).getPositionCount(), (int)8192);
        Assert.assertEquals((int)((Page)buildPages.get(1)).getPositionCount(), (int)100);
    }

    private TaskContext createTaskContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION);
    }
}

