/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import io.prestosql.block.BlockAssertions;
import io.prestosql.operator.PageUtils;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.LazyBlock;
import java.util.concurrent.atomic.AtomicLong;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPageUtils {
    @Test
    public void testRecordMaterializedBytes() {
        Block first = BlockAssertions.createIntsBlock(1, 2, 3);
        LazyBlock second = TestPageUtils.lazyWrapper(first);
        LazyBlock third = TestPageUtils.lazyWrapper(first);
        Page page = new Page(3, new Block[]{first, second, third});
        second.getLoadedBlock();
        AtomicLong sizeInBytes = new AtomicLong();
        PageUtils.recordMaterializedBytes((Page)page, sizeInBytes::getAndAdd);
        Assert.assertEquals((long)sizeInBytes.get(), (long)(first.getSizeInBytes() * 2L));
        page.getBlock(2).getLoadedBlock();
        Assert.assertEquals((long)sizeInBytes.get(), (long)(first.getSizeInBytes() * 3L));
    }

    private static LazyBlock lazyWrapper(Block block) {
        return new LazyBlock(block.getPositionCount(), () -> ((Block)block).getLoadedBlock());
    }
}

