/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import io.prestosql.block.BlockAssertions;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.operator.aggregation.AggregationTestUtils;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.tree.QualifiedName;
import java.util.List;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestRealAverageAggregation
extends AbstractTestAggregationFunction {
    private InternalAggregationFunction avgFunction;

    @BeforeClass
    public void setUp() {
        this.avgFunction = MetadataManager.createTestMetadataManager().getAggregateFunctionImplementation(this.metadata.resolveFunction(QualifiedName.of((String)"avg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{RealType.REAL})));
    }

    @Test
    public void averageOfNullIsNull() {
        AggregationTestUtils.assertAggregation(this.avgFunction, null, BlockAssertions.createBlockOfReals(null, null));
    }

    @Test
    public void averageOfSingleValueEqualsThatValue() {
        AggregationTestUtils.assertAggregation(this.avgFunction, (Object)Float.valueOf(1.23f), BlockAssertions.createBlockOfReals(Float.valueOf(1.23f)));
    }

    @Test
    public void averageOfTwoMaxFloatsEqualsMaxFloat() {
        AggregationTestUtils.assertAggregation(this.avgFunction, (Object)Float.valueOf(Float.MAX_VALUE), BlockAssertions.createBlockOfReals(Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MAX_VALUE)));
    }

    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = RealType.REAL.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(i));
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected String getFunctionName() {
        return "avg";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)RealType.REAL);
    }

    @Override
    protected Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        float sum = 0.0f;
        for (int i = start; i < start + length; ++i) {
            sum += (float)i;
        }
        return Float.valueOf(sum / (float)length);
    }
}

