/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.prestosql.RowPagesBuilder;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.OperatorAssertion;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.StreamingAggregationOperator;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.Page;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.TestingTaskContext;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestStreamingAggregationOperator {
    private static final Metadata metadata = MetadataManager.createTestMetadataManager();
    private static final InternalAggregationFunction LONG_SUM = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"sum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
    private static final InternalAggregationFunction COUNT = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"count"), (List)ImmutableList.of()));
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;
    private OperatorFactory operatorFactory;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
        this.operatorFactory = StreamingAggregationOperator.createOperatorFactory((int)0, (PlanNodeId)new PlanNodeId("test"), (List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), (List)ImmutableList.of((Object)VarcharType.VARCHAR), (List)ImmutableList.of((Object)1), (AggregationNode.Step)AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)COUNT.bind((List)ImmutableList.of((Object)0), Optional.empty()), (Object)LONG_SUM.bind((List)ImmutableList.of((Object)2), Optional.empty())), (JoinCompiler)new JoinCompiler(new TypeOperators()));
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void test() {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(new Type[]{BooleanType.BOOLEAN, VarcharType.VARCHAR, BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(3, 0, 0, 1).row(true, "3", 4).row(false, "3", 5).pageBreak().row(true, "3", 6).row(false, "4", 7).row(true, "4", 8).row(false, "4", 9).row(true, "4", 10).pageBreak().row(false, "5", 11).row(true, "5", 12).row(false, "5", 13).row(true, "5", 14).row(false, "5", 15).pageBreak().addSequencePage(3, 0, 6, 16).build();
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{"0", 1L, 1L}).row(new Object[]{"1", 1L, 2L}).row(new Object[]{"2", 1L, 3L}).row(new Object[]{"3", 3L, 15L}).row(new Object[]{"4", 4L, 34L}).row(new Object[]{"5", 5L, 65L}).row(new Object[]{"6", 1L, 16L}).row(new Object[]{"7", 1L, 17L}).row(new Object[]{"8", 1L, 18L}).build();
        OperatorAssertion.assertOperatorEquals(this.operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testLargeInputPage() {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(new Type[]{BooleanType.BOOLEAN, VarcharType.VARCHAR, BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(1000000, 0, 0, 1).build();
        MaterializedResult.Builder expectedBuilder = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT});
        for (int i = 0; i < 1000000; ++i) {
            expectedBuilder.row(new Object[]{String.valueOf(i), 1L, (long)i + 1L});
        }
        OperatorAssertion.assertOperatorEquals(this.operatorFactory, this.driverContext, input, expectedBuilder.build());
    }

    @Test
    public void testEmptyInput() {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(new Type[]{BooleanType.BOOLEAN, VarcharType.VARCHAR, BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.build();
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).build();
        OperatorAssertion.assertOperatorEquals(this.operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testSinglePage() {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(new Type[]{BooleanType.BOOLEAN, VarcharType.VARCHAR, BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.row(false, "a", 5).build();
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{"a", 1L, 5L}).build();
        OperatorAssertion.assertOperatorEquals(this.operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testUniqueGroupingValues() {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(new Type[]{BooleanType.BOOLEAN, VarcharType.VARCHAR, BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(10, 0, 0, 0).addSequencePage(10, 0, 10, 10).build();
        MaterializedResult.Builder builder = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT});
        for (int i = 0; i < 20; ++i) {
            builder.row(new Object[]{String.format("%s", i), 1L, (long)i});
        }
        OperatorAssertion.assertOperatorEquals(this.operatorFactory, this.driverContext, input, builder.build());
    }

    @Test
    public void testSingleGroupingValue() {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(new Type[]{BooleanType.BOOLEAN, VarcharType.VARCHAR, BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.row(true, "a", 1).row(false, "a", 2).row(true, "a", 3).row(false, "a", 4).row(true, "a", 5).pageBreak().row(false, "a", 6).row(true, "a", 7).row(false, "a", 8).pageBreak().pageBreak().row(true, "a", 9).row(false, "a", 10).build();
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{"a", 10L, 55L}).build();
        OperatorAssertion.assertOperatorEquals(this.operatorFactory, this.driverContext, input, expected);
    }
}

