/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Splitter;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.testing.TestingHttpClient;
import io.airlift.http.client.testing.TestingResponse;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceOutput;
import io.prestosql.execution.buffer.PagesSerde;
import io.prestosql.execution.buffer.PagesSerdeUtil;
import io.prestosql.execution.buffer.SerializedPage;
import io.prestosql.execution.buffer.TestingPagesSerdeFactory;
import io.prestosql.operator.TestingTaskBuffer;
import io.prestosql.spi.Page;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.testng.Assert;

public class TestingExchangeHttpClientHandler
implements TestingHttpClient.Processor {
    private static final PagesSerde PAGES_SERDE = TestingPagesSerdeFactory.testingPagesSerde();
    private final LoadingCache<String, TestingTaskBuffer> taskBuffers;

    public TestingExchangeHttpClientHandler(LoadingCache<String, TestingTaskBuffer> taskBuffers) {
        this.taskBuffers = Objects.requireNonNull(taskBuffers, "taskBuffers is null");
    }

    public Response handle(Request request) {
        ImmutableList parts = ImmutableList.copyOf((Iterable)Splitter.on((String)"/").omitEmptyStrings().split((CharSequence)request.getUri().getPath()));
        if (request.getMethod().equals("DELETE")) {
            Assert.assertEquals((int)parts.size(), (int)1);
            return new TestingResponse(HttpStatus.OK, (ListMultimap)ImmutableListMultimap.of(), new byte[0]);
        }
        Assert.assertEquals((int)parts.size(), (int)2);
        String taskId = (String)parts.get(0);
        int pageToken = Integer.parseInt((String)parts.get(1));
        ImmutableListMultimap.Builder headers = ImmutableListMultimap.builder();
        headers.put((Object)"X-Presto-Task-Instance-Id", (Object)"task-instance-id");
        headers.put((Object)"X-Presto-Page-Sequence-Id", (Object)String.valueOf(pageToken));
        TestingTaskBuffer taskBuffer = (TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)taskId);
        Page page = taskBuffer.getPage(pageToken);
        headers.put((Object)"Content-Type", (Object)"application/X-presto-pages");
        if (page != null) {
            SerializedPage serializedPage;
            headers.put((Object)"X-Presto-Page-End-Sequence-Id", (Object)String.valueOf(pageToken + 1));
            headers.put((Object)"X-Presto-Buffer-Complete", (Object)String.valueOf(false));
            try (PagesSerde.PagesSerdeContext context = PAGES_SERDE.newContext();){
                serializedPage = PAGES_SERDE.serialize(context, page);
            }
            DynamicSliceOutput output = new DynamicSliceOutput(256);
            output.writeInt(-22745087);
            output.writeLong(PagesSerdeUtil.calculateChecksum((List)ImmutableList.of((Object)serializedPage)));
            output.writeInt(1);
            PagesSerdeUtil.writeSerializedPage((SliceOutput)output, (SerializedPage)serializedPage);
            return new TestingResponse(HttpStatus.OK, (ListMultimap)headers.build(), (InputStream)output.slice().getInput());
        }
        if (taskBuffer.isFinished()) {
            headers.put((Object)"X-Presto-Page-End-Sequence-Id", (Object)String.valueOf(pageToken));
            headers.put((Object)"X-Presto-Buffer-Complete", (Object)String.valueOf(true));
            DynamicSliceOutput output = new DynamicSliceOutput(8);
            output.writeInt(-22745087);
            output.writeLong(PagesSerdeUtil.calculateChecksum((List)ImmutableList.of()));
            output.writeInt(0);
            return new TestingResponse(HttpStatus.OK, (ListMultimap)headers.build(), (InputStream)output.slice().getInput());
        }
        headers.put((Object)"X-Presto-Page-End-Sequence-Id", (Object)String.valueOf(pageToken));
        headers.put((Object)"X-Presto-Buffer-Complete", (Object)String.valueOf(false));
        return new TestingResponse(HttpStatus.NO_CONTENT, (ListMultimap)headers.build(), new byte[0]);
    }
}

