/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.prestosql.block.BlockAssertions;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.aggregation.AggregationTestUtils;
import io.prestosql.operator.aggregation.GroupedAccumulator;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.groupby.AggregationTestInput;
import io.prestosql.operator.aggregation.groupby.AggregationTestInputBuilder;
import io.prestosql.operator.aggregation.groupby.AggregationTestOutput;
import io.prestosql.operator.aggregation.groupby.GroupByAggregationTestUtils;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.SqlDate;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.tree.QualifiedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestArrayAggregation {
    private static final Metadata metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testEmpty() {
        InternalAggregationFunction bigIntAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(bigIntAgg, null, BlockAssertions.createLongsBlock(new Long[0]));
    }

    @Test
    public void testNullOnly() {
        InternalAggregationFunction bigIntAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(bigIntAgg, Arrays.asList(null, null, null), BlockAssertions.createLongsBlock(null, null, null));
    }

    @Test
    public void testNullPartial() {
        InternalAggregationFunction bigIntAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(bigIntAgg, Arrays.asList(null, 2L, null, 3L, null), BlockAssertions.createLongsBlock(null, 2L, null, 3L, null));
    }

    @Test
    public void testBoolean() {
        InternalAggregationFunction booleanAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BooleanType.BOOLEAN})));
        AggregationTestUtils.assertAggregation(booleanAgg, Arrays.asList(true, false), BlockAssertions.createBooleansBlock(true, false));
    }

    @Test
    public void testBigInt() {
        InternalAggregationFunction bigIntAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(bigIntAgg, Arrays.asList(2L, 1L, 2L), BlockAssertions.createLongsBlock(2L, 1L, 2L));
    }

    @Test
    public void testVarchar() {
        InternalAggregationFunction varcharAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})));
        AggregationTestUtils.assertAggregation(varcharAgg, Arrays.asList("hello", "world"), BlockAssertions.createStringsBlock("hello", "world"));
    }

    @Test
    public void testDate() {
        InternalAggregationFunction varcharAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DateType.DATE})));
        AggregationTestUtils.assertAggregation(varcharAgg, Arrays.asList(new SqlDate(1), new SqlDate(2), new SqlDate(4)), BlockAssertions.createTypedLongsBlock((Type)DateType.DATE, (Iterable<Long>)ImmutableList.of((Object)1L, (Object)2L, (Object)4L)));
    }

    @Test
    public void testArray() {
        InternalAggregationFunction varcharAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT)})));
        AggregationTestUtils.assertAggregation(varcharAgg, Arrays.asList(Arrays.asList(1L), Arrays.asList(1L, 2L), Arrays.asList(1L, 2L, 3L)), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)1L), (Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L))));
    }

    @Test
    public void testEmptyStateOutputsNull() {
        InternalAggregationFunction bigIntAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
        GroupedAccumulator groupedAccumulator = bigIntAgg.bind(Ints.asList((int[])new int[0]), Optional.empty()).createGroupedAccumulator();
        BlockBuilder blockBuilder = groupedAccumulator.getFinalType().createBlockBuilder(null, 1000);
        groupedAccumulator.evaluateFinal(0, blockBuilder);
        Assert.assertTrue((boolean)blockBuilder.isNull(0));
    }

    @Test
    public void testWithMultiplePages() {
        InternalAggregationFunction varcharAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})));
        AggregationTestInputBuilder testInputBuilder = new AggregationTestInputBuilder(new Block[]{BlockAssertions.createStringsBlock("hello", "world", "hello2", "world2", "hello3", "world3", "goodbye")}, varcharAgg);
        AggregationTestOutput testOutput = new AggregationTestOutput(ImmutableList.of((Object)"hello", (Object)"world", (Object)"hello2", (Object)"world2", (Object)"hello3", (Object)"world3", (Object)"goodbye"));
        AggregationTestInput testInput = testInputBuilder.build();
        testInput.runPagesOnAccumulatorWithAssertion(0L, testInput.createGroupedAccumulator(), testOutput);
    }

    @Test
    public void testMultipleGroupsWithMultiplePages() {
        InternalAggregationFunction varcharAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})));
        Block block1 = BlockAssertions.createStringsBlock("a", "b", "c", "d", "e");
        Block block2 = BlockAssertions.createStringsBlock("f", "g", "h", "i", "j");
        AggregationTestOutput aggregationTestOutput1 = new AggregationTestOutput(ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e"));
        AggregationTestInputBuilder testInputBuilder1 = new AggregationTestInputBuilder(new Block[]{block1}, varcharAgg);
        AggregationTestInput test1 = testInputBuilder1.build();
        GroupedAccumulator groupedAccumulator = test1.createGroupedAccumulator();
        test1.runPagesOnAccumulatorWithAssertion(0L, groupedAccumulator, aggregationTestOutput1);
        AggregationTestOutput aggregationTestOutput2 = new AggregationTestOutput(ImmutableList.of((Object)"f", (Object)"g", (Object)"h", (Object)"i", (Object)"j"));
        AggregationTestInputBuilder testBuilder2 = new AggregationTestInputBuilder(new Block[]{block2}, varcharAgg);
        AggregationTestInput test2 = testBuilder2.build();
        test2.runPagesOnAccumulatorWithAssertion(255L, groupedAccumulator, aggregationTestOutput2);
    }

    @Test
    public void testManyValues() {
        InternalAggregationFunction varcharAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})));
        int numGroups = 50000;
        int arraySize = 30;
        Random random = new Random();
        GroupedAccumulator groupedAccumulator = this.createGroupedAccumulator(varcharAgg);
        for (int j = 0; j < numGroups; ++j) {
            ArrayList<String> expectedValues = new ArrayList<String>();
            ArrayList<String> valueList = new ArrayList<String>();
            for (int i = 0; i < arraySize; ++i) {
                String str = String.valueOf(random.nextInt());
                valueList.add(str);
                expectedValues.add(str);
            }
            Block block = BlockAssertions.createStringsBlock(valueList);
            AggregationTestInputBuilder testInputBuilder = new AggregationTestInputBuilder(new Block[]{block}, varcharAgg);
            AggregationTestInput test1 = testInputBuilder.build();
            test1.runPagesOnAccumulatorWithAssertion(j, groupedAccumulator, new AggregationTestOutput(expectedValues));
        }
    }

    private GroupedAccumulator createGroupedAccumulator(InternalAggregationFunction function) {
        int[] args = GroupByAggregationTestUtils.createArgs(function);
        return function.bind(Ints.asList((int[])args), Optional.empty()).createGroupedAccumulator();
    }
}

