/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.airlift.slice.Slices;
import io.prestosql.block.BlockAssertions;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.aggregation.AggregationTestUtils;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.SqlVarbinary;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.type.BlockTypeOperators;
import java.util.Arrays;
import org.testng.annotations.Test;

public class TestChecksumAggregation {
    private static final Metadata metadata = MetadataManager.createTestMetadataManager();
    private static BlockTypeOperators blockTypeOperators = new BlockTypeOperators();

    @Test
    public void testEmpty() {
        InternalAggregationFunction booleanAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"checksum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BooleanType.BOOLEAN})));
        AggregationTestUtils.assertAggregation(booleanAgg, null, BlockAssertions.createBooleansBlock(new Boolean[0]));
    }

    @Test
    public void testBoolean() {
        InternalAggregationFunction booleanAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"checksum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BooleanType.BOOLEAN})));
        Block block = BlockAssertions.createBooleansBlock(null, null, true, false, false);
        AggregationTestUtils.assertAggregation(booleanAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)BooleanType.BOOLEAN, block), block);
    }

    @Test
    public void testLong() {
        InternalAggregationFunction longAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"checksum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
        Block block = BlockAssertions.createLongsBlock(null, 1L, 2L, 100L, null, Long.MAX_VALUE, Long.MIN_VALUE);
        AggregationTestUtils.assertAggregation(longAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)BigintType.BIGINT, block), block);
    }

    @Test
    public void testDouble() {
        InternalAggregationFunction doubleAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"checksum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE})));
        Block block = BlockAssertions.createDoublesBlock(null, 2.0, null, 3.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NaN);
        AggregationTestUtils.assertAggregation(doubleAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)DoubleType.DOUBLE, block), block);
    }

    @Test
    public void testString() {
        InternalAggregationFunction stringAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"checksum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})));
        Block block = BlockAssertions.createStringsBlock("a", "a", null, "b", "c");
        AggregationTestUtils.assertAggregation(stringAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)VarcharType.VARCHAR, block), block);
    }

    @Test
    public void testShortDecimal() {
        InternalAggregationFunction decimalAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"checksum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DecimalType.createDecimalType((int)10, (int)2)})));
        Block block = BlockAssertions.createShortDecimalsBlock("11.11", "22.22", null, "33.33", "44.44");
        DecimalType shortDecimalType = DecimalType.createDecimalType((int)1);
        AggregationTestUtils.assertAggregation(decimalAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)shortDecimalType, block), block);
    }

    @Test
    public void testLongDecimal() {
        InternalAggregationFunction decimalAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"checksum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DecimalType.createDecimalType((int)19, (int)2)})));
        Block block = BlockAssertions.createLongDecimalsBlock("11.11", "22.22", null, "33.33", "44.44");
        DecimalType longDecimalType = DecimalType.createDecimalType((int)19);
        AggregationTestUtils.assertAggregation(decimalAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)longDecimalType, block), block);
    }

    @Test
    public void testArray() {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        InternalAggregationFunction stringAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"checksum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{arrayType})));
        Block block = BlockAssertions.createArrayBigintBlock(Arrays.asList(null, Arrays.asList(1L, 2L), Arrays.asList(3L, 4L), Arrays.asList(5L, 6L)));
        AggregationTestUtils.assertAggregation(stringAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)arrayType, block), block);
    }

    private static SqlVarbinary expectedChecksum(Type type, Block block) {
        BlockTypeOperators.BlockPositionXxHash64 xxHash64Operator = blockTypeOperators.getXxHash64Operator(type);
        long result = 0L;
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                result += -7046029288634856825L;
                continue;
            }
            result += xxHash64Operator.xxHash64(block, i) * -7046029288634856825L;
        }
        return new SqlVarbinary(Slices.wrappedLongArray((long[])new long[]{result}).getBytes());
    }
}

