/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import io.prestosql.type.IntervalYearMonthType;
import io.prestosql.type.SqlIntervalYearMonth;
import java.util.List;

public class TestIntervalYearToMonthAverageAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = IntervalYearMonthType.INTERVAL_YEAR_MONTH.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            IntervalYearMonthType.INTERVAL_YEAR_MONTH.writeLong(blockBuilder, (long)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    protected SqlIntervalYearMonth getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        double sum = 0.0;
        for (int i = start; i < start + length; ++i) {
            sum += (double)i;
        }
        return new SqlIntervalYearMonth(Math.toIntExact(Math.round(sum / (double)length)));
    }

    @Override
    protected String getFunctionName() {
        return "avg";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)IntervalYearMonthType.INTERVAL_YEAR_MONTH);
    }
}

